/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.annotation.DoNotUse;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int cb = 6000;
    public int bY;
    @Nullable
    public UUID bZ;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> entityType, World level) {
        super((EntityTypes<? extends EntityAgeable>)entityType, level);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    public static AttributeProvider.Builder gx() {
        return EntityInsentient.F().a(GenericAttributes.E, 10.0);
    }

    @Override
    protected void a(WorldServer level) {
        if (this.Y_() != 0) {
            this.bY = 0;
        }
        super.a(level);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.Y_() != 0) {
            this.bY = 0;
        }
        if (this.bY > 0) {
            --this.bY;
            if (this.bY % 10 == 0) {
                double d2 = this.ae.k() * 0.02;
                double d1 = this.ae.k() * 0.02;
                double d22 = this.ae.k() * 0.02;
                this.dV().a(Particles.R, this.d(1.0), this.dD() + 0.5, this.g(1.0), d2, d1, d22);
            }
        }
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        this.gD();
        return true;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.a_(pos.e()).a(Blocks.i) ? 10.0f : level.w(pos);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("InLove", this.bY);
        if (this.bZ != null) {
            compound.a("LoveCause", this.bZ);
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.bY = compound.h("InLove");
        this.bZ = compound.b("LoveCause") ? compound.a("LoveCause") : null;
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        boolean flag = EntitySpawnReason.b(spawnReason) || EntityAnimal.a(level, pos);
        return level.a_(pos.e()).a(TagsBlock.bY) && flag;
    }

    protected static boolean a(IBlockLightAccess level, BlockPosition pos) {
        return level.b(pos, 0) > 8;
    }

    @Override
    public int T() {
        return 120;
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected int e(WorldServer level) {
        return 1 + this.ae.a(3);
    }

    public abstract boolean j(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (this.j(itemInHand)) {
            int age = this.Y_();
            if (!this.dV().C && age == 0 && this.gz()) {
                ItemStack breedCopy = itemInHand.v();
                this.a(player, hand, itemInHand);
                this.setInLove(player, breedCopy);
                this.gy();
                return EnumInteractionResult.b;
            }
            if (this.e_()) {
                this.a(player, hand, itemInHand);
                this.a(EntityAnimal.d_(-age), true);
                this.gy();
                return EnumInteractionResult.a;
            }
            if (this.dV().C) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(player, hand);
    }

    protected void gy() {
    }

    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        int count = stack.M();
        UseRemainder useRemainder = stack.a(DataComponents.y);
        stack.a(1, (EntityLiving)player);
        if (useRemainder != null) {
            ItemStack itemStack = useRemainder.a(stack, count, player.fV(), player::b);
            player.a(hand, itemStack);
        }
    }

    public boolean gz() {
        return this.bY <= 0;
    }

    @Deprecated
    @DoNotUse
    public void f(@Nullable EntityHuman player) {
        this.setInLove(player, null);
    }

    public void setInLove(@Nullable EntityHuman player, @Nullable ItemStack breedItemCopy) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent;
        if (breedItemCopy != null) {
            this.breedItem = breedItemCopy;
        }
        if ((entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(player, this, 600)).isCancelled()) {
            this.breedItem = null;
            return;
        }
        this.bY = entityEnterLoveModeEvent.getTicksInLove();
        if (player != null) {
            this.bZ = player.cG();
        }
        this.dV().a((Entity)this, (byte)18);
    }

    public void r(int inLove) {
        this.bY = inLove;
    }

    public int gA() {
        return this.bY;
    }

    @Nullable
    public EntityPlayer gB() {
        if (this.bZ == null) {
            return null;
        }
        EntityHuman playerByUuid = this.dV().b(this.bZ);
        return playerByUuid instanceof EntityPlayer ? (EntityPlayer)playerByUuid : null;
    }

    public boolean gC() {
        return this.bY > 0;
    }

    public void gD() {
        this.bY = 0;
    }

    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && otherAnimal.getClass() == this.getClass() && this.gC() && otherAnimal.gC();
    }

    public void a(WorldServer level, EntityAnimal mate) {
        EntityAgeable breedOffspring = this.a(level, (EntityAgeable)mate);
        if (breedOffspring != null) {
            breedOffspring.a(true);
            breedOffspring.b(this.dA(), this.dC(), this.dG(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.gB()).or(() -> Optional.ofNullable(mate.gB())).orElse(null);
            int experience = this.dY().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(breedOffspring, this, mate, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                this.gD();
                mate.gD();
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(level, mate, breedOffspring, experience);
            level.addFreshEntityWithPassengers(breedOffspring, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer level, EntityAnimal animal, @Nullable EntityAgeable baby) {
        this.finalizeSpawnChildFromBreeding(level, animal, baby, this.dY().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer level, EntityAnimal animal, @Nullable EntityAgeable baby, int experience) {
        EntityPlayer player = this.gB();
        if (player == null) {
            player = animal.gB();
        }
        if (player != null) {
            player.a(StatisticList.P);
            CriterionTriggers.p.a(player, this, animal, baby);
        }
        this.c_(6000);
        animal.c_(6000);
        this.gD();
        animal.gD();
        level.a((Entity)this, (byte)18);
        if (experience > 0 && level.O().b(GameRules.f)) {
            level.b(new EntityExperienceOrb(level, this.dA(), this.dC(), this.dG(), experience, ExperienceOrb.SpawnReason.BREED, player, baby));
        }
    }

    @Override
    public void b(byte id) {
        if (id == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d2 = this.ae.k() * 0.02;
                double d1 = this.ae.k() * 0.02;
                double d22 = this.ae.k() * 0.02;
                this.dV().a(Particles.R, this.d(1.0), this.dD() + 0.5, this.g(1.0), d2, d1, d22);
            }
        } else {
            super.b(id);
        }
    }
}

