/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import ca.spottedleaf.moonrise.common.set.OptimizedSmallEnumSet;
import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;

public class PathfinderGoalSelector {
    private static final PathfinderGoalWrapped a = new PathfinderGoalWrapped(Integer.MAX_VALUE, new PathfinderGoal(){

        @Override
        public boolean b() {
            return false;
        }
    }){

        @Override
        public boolean h() {
            return false;
        }
    };
    private final Map<PathfinderGoal.Type, PathfinderGoalWrapped> b = new EnumMap<PathfinderGoal.Type, PathfinderGoalWrapped>(PathfinderGoal.Type.class);
    private final Set<PathfinderGoalWrapped> c = new ObjectLinkedOpenHashSet();
    private static final PathfinderGoal.Type[] GOAL_FLAG_VALUES = PathfinderGoal.Type.values();
    private final OptimizedSmallEnumSet<PathfinderGoal.Type> goalTypes = new OptimizedSmallEnumSet<PathfinderGoal.Type>(PathfinderGoal.Type.class);
    private int curRate;

    public void a(int priority, PathfinderGoal goal) {
        this.c.add(new PathfinderGoalWrapped(priority, goal));
    }

    @VisibleForTesting
    public void a(Predicate<PathfinderGoal> filter) {
        this.c.removeIf(wrappedGoal -> filter.test(wrappedGoal.k()));
    }

    public boolean inactiveTick() {
        ++this.curRate;
        return this.curRate % 3 == 0;
    }

    public boolean hasTasks() {
        for (PathfinderGoalWrapped task : this.c) {
            if (!task.h()) continue;
            return true;
        }
        return false;
    }

    public void a(PathfinderGoal goal) {
        for (PathfinderGoalWrapped wrappedGoal : this.c) {
            if (wrappedGoal.k() != goal || !wrappedGoal.h()) continue;
            wrappedGoal.e();
        }
        this.c.removeIf(wrappedGoal1 -> wrappedGoal1.k() == goal);
    }

    private static boolean goalContainsAnyFlags(PathfinderGoalWrapped goal, OptimizedSmallEnumSet<PathfinderGoal.Type> flags) {
        return goal.getFlags().hasCommonElements(flags);
    }

    private static boolean a(PathfinderGoalWrapped goal, Map<PathfinderGoal.Type, PathfinderGoalWrapped> flag) {
        long flagIterator = goal.getFlags().getBackingSet();
        int wrappedGoalSize = goal.getFlags().size();
        for (int i2 = 0; i2 < wrappedGoalSize; ++i2) {
            PathfinderGoal.Type flag1 = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
            flagIterator ^= IntegerUtil.getTrailingBit((long)flagIterator);
            if (flag.getOrDefault((Object)flag1, a).a(goal)) continue;
            return false;
        }
        return true;
    }

    public void a() {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("goalCleanup");
        for (PathfinderGoalWrapped wrappedGoal : this.c) {
            if (!wrappedGoal.h() || !PathfinderGoalSelector.goalContainsAnyFlags(wrappedGoal, this.goalTypes) && wrappedGoal.c()) continue;
            wrappedGoal.e();
        }
        this.b.entrySet().removeIf(entry -> !((PathfinderGoalWrapped)entry.getValue()).h());
        profilerFiller.c();
        profilerFiller.a("goalUpdate");
        for (PathfinderGoalWrapped wrappedGoalx : this.c) {
            if (wrappedGoalx.h() || PathfinderGoalSelector.goalContainsAnyFlags(wrappedGoalx, this.goalTypes) || !PathfinderGoalSelector.a(wrappedGoalx, this.b) || !wrappedGoalx.b()) continue;
            long flagIterator = wrappedGoalx.getFlags().getBackingSet();
            int wrappedGoalSize = wrappedGoalx.getFlags().size();
            for (int i2 = 0; i2 < wrappedGoalSize; ++i2) {
                PathfinderGoal.Type flag = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
                flagIterator ^= IntegerUtil.getTrailingBit((long)flagIterator);
                PathfinderGoalWrapped wrappedGoal1 = this.b.getOrDefault((Object)flag, a);
                wrappedGoal1.e();
                this.b.put(flag, wrappedGoalx);
            }
            wrappedGoalx.d();
        }
        profilerFiller.c();
        this.a(true);
    }

    public void a(boolean tickAllRunning) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("goalTick");
        for (PathfinderGoalWrapped wrappedGoal : this.c) {
            if (!wrappedGoal.h() || !tickAllRunning && !wrappedGoal.V_()) continue;
            wrappedGoal.a();
        }
        profilerFiller.c();
    }

    public Set<PathfinderGoalWrapped> b() {
        return this.c;
    }

    public void a(PathfinderGoal.Type flag) {
        this.goalTypes.addUnchecked(flag);
    }

    public void b(PathfinderGoal.Type flag) {
        this.goalTypes.removeUnchecked(flag);
    }

    public void a(PathfinderGoal.Type flag, boolean enabled) {
        if (enabled) {
            this.b(flag);
        } else {
            this.a(flag);
        }
    }
}

