/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalMoveThroughVillage
extends PathfinderGoal {
    protected final EntityCreature a;
    private final double b;
    @Nullable
    private PathEntity c;
    private BlockPosition d;
    private final boolean e;
    private final List<BlockPosition> f = Lists.newArrayList();
    private final int g;
    private final BooleanSupplier h;

    public PathfinderGoalMoveThroughVillage(EntityCreature mob, double speedModifier, boolean onlyAtNight, int distanceToPoi, BooleanSupplier canDealWithDoors) {
        this.a = mob;
        this.b = speedModifier;
        this.e = onlyAtNight;
        this.g = distanceToPoi;
        this.h = canDealWithDoors;
        this.a(EnumSet.of(PathfinderGoal.Type.a));
        if (!PathfinderGoalUtil.a(mob)) {
            throw new IllegalArgumentException("Unsupported mob for MoveThroughVillageGoal");
        }
    }

    @Override
    public boolean b() {
        BlockPosition blockPos;
        if (!PathfinderGoalUtil.a(this.a)) {
            return false;
        }
        this.h();
        if (this.e && this.a.dV().V()) {
            return false;
        }
        WorldServer serverLevel = (WorldServer)this.a.dV();
        if (!serverLevel.a(blockPos = this.a.dv(), 6)) {
            return false;
        }
        Vec3D pos = LandRandomPos.a(this.a, 15, 7, blockPos2 -> {
            if (!serverLevel.c((BlockPosition)blockPos2)) {
                return Double.NEGATIVE_INFINITY;
            }
            Optional<BlockPosition> optional1 = serverLevel.A().d(holder -> holder.a(PoiTypeTags.b), this::a, (BlockPosition)blockPos2, 10, VillagePlace.Occupancy.b);
            return optional1.map(blockPos3 -> -blockPos3.j(blockPos)).orElse(Double.NEGATIVE_INFINITY);
        });
        if (pos == null) {
            return false;
        }
        Optional<BlockPosition> optional = serverLevel.A().d(holder -> holder.a(PoiTypeTags.b), this::a, BlockPosition.a(pos), 10, VillagePlace.Occupancy.b);
        if (optional.isEmpty()) {
            return false;
        }
        this.d = optional.get().j();
        Navigation groundPathNavigation = (Navigation)this.a.P();
        groundPathNavigation.b(this.h.getAsBoolean());
        this.c = groundPathNavigation.a(this.d, 0);
        groundPathNavigation.b(true);
        if (this.c == null) {
            Vec3D posTowards = DefaultRandomPos.a(this.a, 10, 7, Vec3D.c(this.d), 1.5707963705062866);
            if (posTowards == null) {
                return false;
            }
            groundPathNavigation.b(this.h.getAsBoolean());
            this.c = this.a.P().a(posTowards.d, posTowards.e, posTowards.f, 0);
            groundPathNavigation.b(true);
            if (this.c == null) {
                return false;
            }
        }
        for (int i2 = 0; i2 < this.c.e(); ++i2) {
            PathPoint node = this.c.a(i2);
            BlockPosition blockPos1 = new BlockPosition(node.a, node.b + 1, node.c);
            if (!BlockDoor.a(this.a.dV(), blockPos1)) continue;
            this.c = this.a.P().a((double)node.a, (double)node.b, (double)node.c, 0);
            break;
        }
        return this.c != null;
    }

    @Override
    public boolean c() {
        return !this.a.P().k() && !this.d.a(this.a.dt(), (double)(this.a.dq() + (float)this.g));
    }

    @Override
    public void d() {
        this.a.P().a(this.c, this.b);
    }

    @Override
    public void e() {
        if (this.a.P().k() || this.d.a(this.a.dt(), (double)this.g)) {
            this.f.add(this.d);
        }
    }

    private boolean a(BlockPosition pos) {
        for (BlockPosition blockPos : this.f) {
            if (!Objects.equals(pos, blockPos)) continue;
            return false;
        }
        return true;
    }

    private void h() {
        if (this.f.size() > 15) {
            this.f.remove(0);
        }
    }
}

