/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class PrepareRamNearestTarget<E extends EntityCreature>
extends Behavior<E> {
    public static final int c = 160;
    private final ToIntFunction<E> d;
    private final int e;
    private final int f;
    private final float g;
    private final PathfinderTargetCondition h;
    private final int i;
    private final Function<E, SoundEffect> j;
    private Optional<Long> k = Optional.empty();
    private Optional<a> l = Optional.empty();

    public PrepareRamNearestTarget(ToIntFunction<E> getCooldownOnFall, int minRamDistance, int maxRamDistance, float walkSpeed, PathfinderTargetCondition ramTargeting, int ramPrepareTime, Function<E, SoundEffect> getPrepareRamSound) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.n, (Object)((Object)MemoryStatus.c), MemoryModuleType.V, (Object)((Object)MemoryStatus.b), MemoryModuleType.h, (Object)((Object)MemoryStatus.a), MemoryModuleType.W, (Object)((Object)MemoryStatus.b)), 160);
        this.d = getCooldownOnFall;
        this.e = minRamDistance;
        this.f = maxRamDistance;
        this.g = walkSpeed;
        this.h = ramTargeting;
        this.i = ramPrepareTime;
        this.j = getPrepareRamSound;
    }

    protected void a(WorldServer level, EntityCreature entity, long gameTime) {
        BehaviorController<?> brain = entity.eb();
        brain.c(MemoryModuleType.h).flatMap(nearestVisibleLivingEntities -> nearestVisibleLivingEntities.a(livingEntity -> this.h.a(level, entity, (EntityLiving)livingEntity))).map(livingEntity -> {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entity, livingEntity, livingEntity instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled() || event.getTarget() == null) {
                return null;
            }
            livingEntity = ((CraftLivingEntity)event.getTarget()).getHandle();
            return livingEntity;
        }).ifPresent(entity1 -> this.b(entity, (EntityLiving)entity1));
    }

    @Override
    protected void b(WorldServer level, E entity, long gameTime) {
        BehaviorController<Vec3D> brain = ((EntityLiving)entity).eb();
        if (!brain.a(MemoryModuleType.W)) {
            level.a((Entity)entity, (byte)59);
            brain.a(MemoryModuleType.V, Integer.valueOf(this.d.applyAsInt(entity)));
        }
    }

    protected boolean c(WorldServer level, EntityCreature entity, long gameTime) {
        return this.l.isPresent() && this.l.get().c().bL();
    }

    @Override
    protected void d(WorldServer level, E owner, long gameTime) {
        if (!this.l.isEmpty()) {
            boolean flag;
            ((EntityLiving)owner).eb().a(MemoryModuleType.m, new MemoryTarget(this.l.get().a(), this.g, 0));
            ((EntityLiving)owner).eb().a(MemoryModuleType.n, new BehaviorPositionEntity(this.l.get().c(), true));
            boolean bl = flag = !this.l.get().c().dv().equals(this.l.get().b());
            if (flag) {
                level.a((Entity)owner, (byte)59);
                ((EntityInsentient)owner).P().m();
                this.b((EntityCreature)owner, this.l.get().c);
            } else {
                BlockPosition blockPos = ((Entity)owner).dv();
                if (blockPos.equals(this.l.get().a())) {
                    level.a((Entity)owner, (byte)58);
                    if (this.k.isEmpty()) {
                        this.k = Optional.of(gameTime);
                    }
                    if (gameTime - this.k.get() >= (long)this.i) {
                        ((EntityLiving)owner).eb().a(MemoryModuleType.W, this.a(blockPos, this.l.get().b()));
                        level.a(null, (Entity)owner, this.j.apply(owner), SoundCategory.g, 1.0f, ((EntityLiving)owner).fh());
                        this.l = Optional.empty();
                    }
                }
            }
        }
    }

    private Vec3D a(BlockPosition pos, BlockPosition other) {
        double d2 = 0.5;
        double d1 = 0.5 * (double)MathHelper.j((double)(other.u() - pos.u()));
        double d22 = 0.5 * (double)MathHelper.j((double)(other.w() - pos.w()));
        return Vec3D.c(other).b(d1, 0.0, d22);
    }

    private Optional<BlockPosition> a(EntityCreature pathfinder, EntityLiving entity) {
        BlockPosition blockPos = entity.dv();
        if (!this.a(pathfinder, blockPos)) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList();
        BlockPosition.MutableBlockPosition mutableBlockPos = blockPos.k();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            mutableBlockPos.g(blockPos);
            for (int i2 = 0; i2 < this.f; ++i2) {
                if (this.a(pathfinder, (BlockPosition)mutableBlockPos.c(direction))) continue;
                mutableBlockPos.c(direction.g());
                break;
            }
            if (mutableBlockPos.k(blockPos) < this.e) continue;
            list.add(mutableBlockPos.j());
        }
        NavigationAbstract navigation = pathfinder.P();
        return list.stream().sorted(Comparator.comparingDouble(pathfinder.dv()::j)).filter(pos -> {
            PathEntity path = navigation.a((BlockPosition)pos, 0);
            return path != null && path.j();
        }).findFirst();
    }

    private boolean a(EntityCreature pathfinder, BlockPosition pos) {
        return pathfinder.P().a(pos) && pathfinder.a(PathfinderNormal.b(pathfinder, pos)) == 0.0f;
    }

    private void b(EntityCreature pathfinder, EntityLiving entity) {
        this.k = Optional.empty();
        this.l = this.a(pathfinder, entity).map(blockPos -> new a((BlockPosition)blockPos, entity.dv(), entity));
    }

    public static class a {
        private final BlockPosition a;
        private final BlockPosition b;
        final EntityLiving c;

        public a(BlockPosition startPosition, BlockPosition targetPosition, EntityLiving target) {
            this.a = startPosition;
            this.b = targetPosition;
            this.c = target;
        }

        public BlockPosition a() {
            return this.a;
        }

        public BlockPosition b() {
            return this.b;
        }

        public EntityLiving c() {
            return this.c;
        }
    }
}

