/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class BehaviorUtil {
    private BehaviorUtil() {
    }

    public static void a(EntityLiving firstEntity, EntityLiving secondEntity, float speed, int distance) {
        BehaviorUtil.c(firstEntity, secondEntity);
        BehaviorUtil.b(firstEntity, secondEntity, speed, distance);
    }

    public static boolean a(BehaviorController<?> brain, EntityLiving target) {
        Optional<NearestVisibleLivingEntities> memory = brain.c(MemoryModuleType.h);
        return memory.isPresent() && memory.get().a(target);
    }

    public static boolean a(BehaviorController<?> brains, MemoryModuleType<? extends EntityLiving> memorymodule, EntityTypes<?> entityType) {
        return BehaviorUtil.a(brains, memorymodule, (EntityLiving entity) -> entity.aq() == entityType);
    }

    private static boolean a(BehaviorController<?> brain, MemoryModuleType<? extends EntityLiving> memoryType, Predicate<EntityLiving> livingPredicate) {
        return brain.c(memoryType).filter(livingPredicate).filter(EntityLiving::bL).filter(entity -> BehaviorUtil.a(brain, entity)).isPresent();
    }

    private static void c(EntityLiving firstEntity, EntityLiving secondEntity) {
        BehaviorUtil.a(firstEntity, secondEntity);
        BehaviorUtil.a(secondEntity, firstEntity);
    }

    public static void a(EntityLiving entity, EntityLiving target) {
        entity.eb().a(MemoryModuleType.n, new BehaviorPositionEntity(target, true));
    }

    private static void b(EntityLiving firstEntity, EntityLiving secondEntity, float speed, int distance) {
        BehaviorUtil.a(firstEntity, (Entity)secondEntity, speed, distance);
        BehaviorUtil.a(secondEntity, (Entity)firstEntity, speed, distance);
    }

    public static void a(EntityLiving livingEntity, Entity target, float speed, int distance) {
        BehaviorUtil.a(livingEntity, new BehaviorPositionEntity(target, true), speed, distance);
    }

    public static void a(EntityLiving livingEntity, BlockPosition pos, float speed, int distance) {
        BehaviorUtil.a(livingEntity, new BehaviorTarget(pos), speed, distance);
    }

    public static void a(EntityLiving entity, BehaviorPosition positionTracker, float speedModifier, int closeEnoughDist) {
        MemoryTarget walkTarget = new MemoryTarget(positionTracker, speedModifier, closeEnoughDist);
        entity.eb().a(MemoryModuleType.n, positionTracker);
        entity.eb().a(MemoryModuleType.m, walkTarget);
    }

    public static void a(EntityLiving livingEntity, ItemStack stack, Vec3D offset) {
        Vec3D vec3 = new Vec3D(0.3f, 0.3f, 0.3f);
        BehaviorUtil.a(livingEntity, stack, offset, vec3, 0.3f);
    }

    public static void a(EntityLiving entity, ItemStack stack, Vec3D offset, Vec3D speedMultiplier, float yOffset) {
        if (stack.f()) {
            return;
        }
        double d2 = entity.dE() - (double)yOffset;
        EntityItem itemEntity = new EntityItem(entity.dV(), entity.dA(), d2, entity.dG(), stack);
        itemEntity.b((Entity)entity);
        Vec3D vec3 = offset.d(entity.dt());
        vec3 = vec3.d().d(speedMultiplier.d, speedMultiplier.e, speedMultiplier.f);
        itemEntity.i(vec3);
        itemEntity.s();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Item)itemEntity.getBukkitEntity());
        itemEntity.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        entity.dV().b(itemEntity);
    }

    public static SectionPosition a(WorldServer serverLevel, SectionPosition sectionPos, int radius) {
        int i2 = serverLevel.b(sectionPos);
        return SectionPosition.a(sectionPos, radius).filter(pos -> serverLevel.b((SectionPosition)pos) < i2).min(Comparator.comparingInt(serverLevel::b)).orElse(sectionPos);
    }

    public static boolean a(EntityInsentient mob, EntityLiving target, int cooldown) {
        ItemProjectileWeapon projectileWeaponItem;
        Item item = mob.eZ().h();
        if (item instanceof ItemProjectileWeapon && mob.a(projectileWeaponItem = (ItemProjectileWeapon)item)) {
            int i2 = projectileWeaponItem.c() - cooldown;
            return mob.a((Entity)target, (double)i2);
        }
        return mob.i(target);
    }

    public static boolean a(EntityLiving livingEntity, EntityLiving target, double distance) {
        Optional<EntityLiving> memory = livingEntity.eb().c(MemoryModuleType.o);
        if (memory.isEmpty()) {
            return false;
        }
        double d2 = livingEntity.g(memory.get().dt());
        double d1 = livingEntity.g(target.dt());
        return d1 > d2 + distance * distance;
    }

    public static boolean b(EntityLiving livingEntity, EntityLiving target) {
        BehaviorController<NearestVisibleLivingEntities> brain = livingEntity.eb();
        return brain.a(MemoryModuleType.h) && brain.c(MemoryModuleType.h).get().a(target);
    }

    public static EntityLiving a(EntityLiving centerEntity, Optional<EntityLiving> optionalEntity, EntityLiving livingEntity) {
        return optionalEntity.isEmpty() ? livingEntity : BehaviorUtil.a(centerEntity, optionalEntity.get(), livingEntity);
    }

    public static EntityLiving a(EntityLiving centerEntity, EntityLiving livingEntity1, EntityLiving livingEntity2) {
        Vec3D vec3 = livingEntity1.dt();
        Vec3D vec31 = livingEntity2.dt();
        return centerEntity.g(vec3) < centerEntity.g(vec31) ? livingEntity1 : livingEntity2;
    }

    public static Optional<EntityLiving> a(EntityLiving livingEntity, MemoryModuleType<UUID> targetMemory) {
        Optional<UUID> memory = livingEntity.eb().c(targetMemory);
        return memory.map(identifier -> ((WorldServer)livingEntity.dV()).a((UUID)identifier)).map(entity -> {
            EntityLiving livingEntity1;
            return entity instanceof EntityLiving ? (livingEntity1 = (EntityLiving)entity) : null;
        });
    }

    @Nullable
    public static Vec3D a(EntityCreature pathfinder, int radius, int verticalDistance) {
        Vec3D pos = DefaultRandomPos.a(pathfinder, radius, verticalDistance);
        int i2 = 0;
        while (pos != null && !pathfinder.dV().a_(BlockPosition.a(pos)).a(PathMode.b) && i2++ < 10) {
            pos = DefaultRandomPos.a(pathfinder, radius, verticalDistance);
        }
        return pos;
    }

    public static boolean a(EntityLiving entity) {
        return entity.eb().a(MemoryModuleType.r);
    }
}

