/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.phys.Vec3D;

public class AnimalPanic<E extends EntityCreature>
extends Behavior<E> {
    private static final int c = 100;
    private static final int d = 120;
    private static final int e = 5;
    private static final int f = 4;
    private final float g;
    private final Function<EntityCreature, TagKey<DamageType>> h;

    public AnimalPanic(float speedMultiplier) {
        this(speedMultiplier, pathfinderMob -> DamageTypeTags.F);
    }

    public AnimalPanic(float speedMultiplier, Function<EntityCreature, TagKey<DamageType>> panicCausingDamageTypes) {
        super(Map.of(MemoryModuleType.Z, MemoryStatus.c, MemoryModuleType.x, MemoryStatus.c), 100, 120);
        this.g = speedMultiplier;
        this.h = panicCausingDamageTypes;
    }

    @Override
    protected boolean a(WorldServer level, E owner) {
        return ((EntityLiving)owner).eb().c(MemoryModuleType.x).map(damageSource -> damageSource.a(this.h.apply((EntityCreature)owner))).orElse(false) != false || ((EntityLiving)owner).eb().a(MemoryModuleType.Z);
    }

    @Override
    protected boolean a(WorldServer level, E entity, long gameTime) {
        return true;
    }

    @Override
    protected void b(WorldServer level, E entity, long gameTime) {
        ((EntityLiving)entity).eb().a(MemoryModuleType.Z, true);
        ((EntityLiving)entity).eb().b(MemoryModuleType.m);
    }

    @Override
    protected void c(WorldServer level, E entity, long gameTime) {
        BehaviorController<?> brain = ((EntityLiving)entity).eb();
        brain.b(MemoryModuleType.Z);
    }

    @Override
    protected void d(WorldServer level, E owner, long gameTime) {
        Vec3D panicPos;
        if (((EntityInsentient)owner).P().k() && (panicPos = this.a(owner, level)) != null) {
            ((EntityLiving)owner).eb().a(MemoryModuleType.m, new MemoryTarget(panicPos, this.g, 0));
        }
    }

    @Nullable
    private Vec3D a(E pathfinder, WorldServer level) {
        Optional<Vec3D> optional;
        if (((Entity)pathfinder).bY() && (optional = this.a((IBlockAccess)level, (Entity)pathfinder).map(Vec3D::c)).isPresent()) {
            return optional.get();
        }
        return LandRandomPos.a(pathfinder, 5, 4);
    }

    private Optional<BlockPosition> a(IBlockAccess level, Entity entity) {
        BlockPosition blockPos = entity.dv();
        if (!level.a_(blockPos).g(level, blockPos).c()) {
            return Optional.empty();
        }
        Predicate<BlockPosition> predicate = MathHelper.f(entity.dq()) == 2 ? blockPos1 -> BlockPosition.a(blockPos1).allMatch(blockPos2 -> level.b_((BlockPosition)blockPos2).a(TagsFluid.a)) : blockPos1 -> level.b_((BlockPosition)blockPos1).a(TagsFluid.a);
        return BlockPosition.a(blockPos, 5, 1, predicate);
    }
}

