/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.attributes.AttributeBase;

public class AttributeRanged
extends AttributeBase {
    private final double c;
    public double d;

    public AttributeRanged(String descriptionId, double defaultValue, double min, double max) {
        super(descriptionId, defaultValue);
        this.c = min;
        this.d = max;
        if (min > max) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (defaultValue < min) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (defaultValue > max) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
    }

    public double d() {
        return this.c;
    }

    public double e() {
        return this.d;
    }

    @Override
    public double a(double value) {
        return Double.isNaN(value) ? this.c : MathHelper.a(value, this.c, this.d);
    }
}

