/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import org.slf4j.Logger;

public class AttributeMapBase {
    private static final Logger a = LogUtils.getLogger();
    private final Map<Holder<AttributeBase>, AttributeModifiable> b = new Object2ObjectOpenHashMap();
    private final Set<AttributeModifiable> c = new ObjectOpenHashSet();
    private final Set<AttributeModifiable> d = new ObjectOpenHashSet();
    private final AttributeProvider e;

    public AttributeMapBase(AttributeProvider supplier) {
        this.e = supplier;
    }

    private void a(AttributeModifiable instance) {
        this.d.add(instance);
        if (instance.a().a().b()) {
            this.c.add(instance);
        }
    }

    public Set<AttributeModifiable> a() {
        return this.c;
    }

    public Set<AttributeModifiable> b() {
        return this.d;
    }

    public Collection<AttributeModifiable> c() {
        return this.b.values().stream().filter(instance -> instance.a().a().b()).collect(Collectors.toList());
    }

    @Nullable
    public AttributeModifiable a(Holder<AttributeBase> attribute) {
        return this.b.computeIfAbsent(attribute, holder -> this.e.a(this::a, (Holder<AttributeBase>)holder));
    }

    public boolean b(Holder<AttributeBase> attribute) {
        return this.b.get(attribute) != null || this.e.c(attribute);
    }

    public boolean a(Holder<AttributeBase> attribute, MinecraftKey id) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.a(id) != null : this.e.b(attribute, id);
    }

    public double c(Holder<AttributeBase> attribute) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.g() : this.e.a(attribute);
    }

    public double d(Holder<AttributeBase> attribute) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.b() : this.e.b(attribute);
    }

    public double b(Holder<AttributeBase> attribute, MinecraftKey id) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.a(id).c() : this.e.a(attribute, id);
    }

    public void a(Multimap<Holder<AttributeBase>, AttributeModifier> modifiers) {
        modifiers.forEach((attribute, modifier) -> {
            AttributeModifiable instance = this.a((Holder<AttributeBase>)attribute);
            if (instance != null) {
                instance.c(modifier.b());
                instance.b((AttributeModifier)modifier);
            }
        });
    }

    public void b(Multimap<Holder<AttributeBase>, AttributeModifier> modifiers) {
        modifiers.asMap().forEach((holder, collection) -> {
            AttributeModifiable attributeInstance = this.b.get(holder);
            if (attributeInstance != null) {
                collection.forEach(attributeModifier -> attributeInstance.c(attributeModifier.b()));
            }
        });
    }

    public void a(AttributeMapBase map) {
        map.b.values().forEach(attribute -> {
            AttributeModifiable instance = this.a(attribute.a());
            if (instance != null) {
                instance.a((AttributeModifiable)attribute);
            }
        });
    }

    public void b(AttributeMapBase map) {
        map.b.values().forEach(attribute -> {
            AttributeModifiable instance = this.a(attribute.a());
            if (instance != null) {
                instance.a(attribute.b());
            }
        });
    }

    public void c(AttributeMapBase map) {
        map.b.values().forEach(attribute -> {
            AttributeModifiable instance = this.a(attribute.a());
            if (instance != null) {
                instance.a(attribute.d());
            }
        });
    }

    public boolean e(Holder<AttributeBase> attribute) {
        if (!this.e.c(attribute)) {
            return false;
        }
        AttributeModifiable attributeInstance = this.b.get(attribute);
        if (attributeInstance != null) {
            attributeInstance.a(this.e.b(attribute));
        }
        return true;
    }

    public NBTTagList d() {
        NBTTagList listTag = new NBTTagList();
        for (AttributeModifiable attributeInstance : this.b.values()) {
            listTag.add(attributeInstance.h());
        }
        return listTag;
    }

    public void a(NBTTagList nbt) {
        for (int i2 = 0; i2 < nbt.size(); ++i2) {
            NBTTagCompound compound = nbt.a(i2);
            String string = compound.l("id");
            MinecraftKey resourceLocation = MinecraftKey.c(string);
            if (resourceLocation != null) {
                SystemUtils.a(BuiltInRegistries.s.c(resourceLocation), reference -> {
                    AttributeModifiable instance = this.a((Holder<AttributeBase>)reference);
                    if (instance != null) {
                        instance.a(compound);
                    }
                }, () -> a.warn("Ignoring unknown attribute '{}'", (Object)resourceLocation));
                continue;
            }
            a.warn("Ignoring malformed attribute '{}'", (Object)string);
        }
    }

    public void registerAttribute(Holder<AttributeBase> attributeBase) {
        AttributeModifiable attributeModifiable = new AttributeModifiable(attributeBase, AttributeModifiable::a);
        this.b.put(attributeBase, attributeModifiable);
    }
}

