/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityUnleashEvent;

public interface Leashable {
    public static final String o_ = "leash";
    public static final double p_ = 10.0;
    public static final double q_ = 6.0;

    @Nullable
    public a T_();

    public void a(@Nullable a var1);

    default public boolean P_() {
        return this.T_() != null && this.T_().a != null;
    }

    default public boolean q() {
        return this.T_() != null;
    }

    default public boolean Q_() {
        return this.y() && !this.P_();
    }

    default public boolean y() {
        return true;
    }

    default public void e_(int delayedLeashHolderId) {
        this.a(new a(delayedLeashHolderId));
        Leashable.a((Entity)((Object)this), false, false);
    }

    default public void c(NBTTagCompound tag) {
        a leashDataInternal = Leashable.a(tag);
        if (this.T_() != null && leashDataInternal == null) {
            this.A();
        }
        this.a(leashDataInternal);
    }

    @Nullable
    private static a a(NBTTagCompound tag) {
        Either either;
        if (tag.b(o_, 10)) {
            NBTTagCompound leashTag = tag.p(o_);
            if (!leashTag.b("UUID")) {
                return null;
            }
            return new a(Either.left(leashTag.a("UUID")));
        }
        if (tag.b(o_, 11) && (either = (Either)GameProfileSerializer.a(tag, o_).map(Either::right).orElse(null)) != null) {
            return new a(either);
        }
        return null;
    }

    default public void a(NBTTagCompound tag, @Nullable a leashData) {
        if (leashData != null) {
            Either<UUID, BlockPosition> either = leashData.b;
            if (leashData.a != null && leashData.a.pluginRemoved) {
                return;
            }
            Entity entity = leashData.a;
            if (entity instanceof EntityLeash) {
                EntityLeash leashFenceKnotEntity = (EntityLeash)entity;
                either = Either.right(leashFenceKnotEntity.p());
            } else if (leashData.a != null) {
                either = Either.left(leashData.a.cG());
            }
            if (either != null) {
                tag.a(o_, either.map(uuid -> {
                    NBTTagCompound compoundTag = new NBTTagCompound();
                    compoundTag.a("UUID", (UUID)uuid);
                    return compoundTag;
                }, GameProfileSerializer::a));
            }
        }
    }

    private static <E extends Entity> void a(E entity, a leashData) {
        World world;
        if (leashData.b != null && (world = entity.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional<UUID> optional = leashData.b.left();
            Optional<BlockPosition> optional1 = leashData.b.right();
            if (optional.isPresent()) {
                Entity entity1 = serverLevel.a(optional.get());
                if (entity1 != null) {
                    Leashable.a(entity, entity1, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.a(entity, (Entity)EntityLeash.a(serverLevel, optional1.get()), true);
                return;
            }
            if (entity.af > 100) {
                entity.forceDrops = true;
                entity.a(serverLevel, Items.vK);
                entity.forceDrops = false;
                ((Leashable)((Object)entity)).a((a)null);
            }
        }
    }

    default public void z() {
        Leashable.a((Entity)((Object)this), true, true);
    }

    default public void A() {
        Leashable.a((Entity)((Object)this), true, false);
    }

    default public void B() {
    }

    private static <E extends Entity> void a(E entity, boolean broadcastPacket, boolean dropItem) {
        a leashData = ((Leashable)((Object)entity)).T_();
        if (leashData != null && leashData.a != null) {
            ((Leashable)((Object)entity)).a((a)null);
            ((Leashable)((Object)entity)).B();
            World world = entity.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (dropItem) {
                    entity.forceDrops = true;
                    entity.a(serverLevel, Items.vK);
                    entity.forceDrops = false;
                }
                if (broadcastPacket) {
                    serverLevel.m().b(entity, new PacketPlayOutAttachEntity(entity, null));
                }
            }
        }
    }

    public static <E extends Entity> void a_(WorldServer level, E entity) {
        a leashData = ((Leashable)((Object)entity)).T_();
        if (leashData != null && leashData.b != null) {
            Leashable.a(entity, leashData);
        }
        if (leashData != null && leashData.a != null) {
            Entity leashHolder;
            if (!entity.bL() || !leashData.a.bL()) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), !entity.bL() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, level.O().b(GameRules.i) && !entity.pluginRemoved);
                event.callEvent();
                if (event.isDropLeash()) {
                    ((Leashable)((Object)entity)).z();
                } else {
                    ((Leashable)((Object)entity)).A();
                }
            }
            if ((leashHolder = ((Leashable)((Object)entity)).D()) != null && leashHolder.dV() == entity.dV()) {
                float f2 = entity.f(leashHolder);
                if (!((Leashable)((Object)entity)).a(leashHolder, f2)) {
                    return;
                }
                if ((double)f2 > entity.dV().paperConfig().misc.maxLeashDistance.or(10.0)) {
                    ((Leashable)((Object)entity)).C();
                } else if ((double)f2 > 6.0) {
                    ((Leashable)((Object)entity)).b(leashHolder, f2);
                    entity.cy();
                } else {
                    ((Leashable)((Object)entity)).a(leashHolder);
                }
            }
        }
    }

    default public boolean a(Entity leashHolder, float distance) {
        return true;
    }

    default public void C() {
        boolean dropLeash = true;
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
            if (!event.callEvent()) {
                return;
            }
            dropLeash = event.isDropLeash();
        }
        if (dropLeash) {
            this.z();
        } else {
            this.A();
        }
    }

    default public void a(Entity entity) {
    }

    default public void b(Entity leashHolder, float distance) {
        Leashable.a((Entity)((Object)this), leashHolder, distance);
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, float distance) {
        double d2 = (leashHolder.dA() - entity.dA()) / (double)distance;
        double d1 = (leashHolder.dC() - entity.dC()) / (double)distance;
        double d22 = (leashHolder.dG() - entity.dG()) / (double)distance;
        entity.i(entity.dy().b(Math.copySign(d2 * d2 * 0.4, d2), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d22 * d22 * 0.4, d22)));
    }

    default public void b(Entity leashHolder, boolean broadcastPacket) {
        Leashable.a((Entity)((Object)this), leashHolder, broadcastPacket);
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, boolean broadcastPacket) {
        World world;
        a leashData = ((Leashable)((Object)entity)).T_();
        if (leashData == null) {
            leashData = new a(leashHolder);
            ((Leashable)((Object)entity)).a(leashData);
        } else {
            leashData.a(leashHolder);
        }
        if (broadcastPacket && (world = entity.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.m().b(entity, new PacketPlayOutAttachEntity(entity, leashHolder));
        }
        if (entity.bZ()) {
            entity.ae();
        }
    }

    @Nullable
    default public Entity D() {
        return Leashable.b((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity b(E entity) {
        Entity var3;
        a leashData = ((Leashable)((Object)entity)).T_();
        if (leashData == null) {
            return null;
        }
        if (leashData.c != 0 && entity.dV().C && (var3 = entity.dV().a(leashData.c)) instanceof Entity) {
            leashData.a(var3);
        }
        return leashData.a;
    }

    public static final class a {
        int c;
        @Nullable
        public Entity a;
        @Nullable
        public Either<UUID, BlockPosition> b;

        a(Either<UUID, BlockPosition> delayedLeashInfo) {
            this.b = delayedLeashInfo;
        }

        a(Entity leashHolder) {
            this.a = leashHolder;
        }

        a(int delayedLeashInfoId) {
            this.c = delayedLeashInfoId;
        }

        public void a(Entity leashHolder) {
            this.a = leashHolder;
            this.b = null;
            this.c = 0;
        }
    }
}

