/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.level.storage.loot.LootTable;

public final class EquipmentTable
extends Record {
    private final ResourceKey<LootTable> c;
    private final Map<EnumItemSlot, Float> d;
    public static final Codec<Map<EnumItemSlot, Float>> a = Codec.either((Codec)Codec.FLOAT, (Codec)Codec.unboundedMap(EnumItemSlot.k, (Codec)Codec.FLOAT)).xmap(either -> either.map(EquipmentTable::a, Function.identity()), map -> {
        boolean flag = map.values().stream().distinct().count() == 1L;
        boolean flag1 = map.keySet().containsAll(EnumItemSlot.i);
        return flag && flag1 ? Either.left(map.values().stream().findFirst().orElse(Float.valueOf(0.0f))) : Either.right(map);
    });
    public static final Codec<EquipmentTable> b = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.a(Registries.bg).fieldOf("loot_table").forGetter(EquipmentTable::a), (App)a.optionalFieldOf("slot_drop_chances", Map.of()).forGetter(EquipmentTable::b)).apply((Applicative)instance, EquipmentTable::new));

    public EquipmentTable(ResourceKey<LootTable> lootTable, float dropChance) {
        this(lootTable, EquipmentTable.a(dropChance));
    }

    public EquipmentTable(ResourceKey<LootTable> lootTable, Map<EnumItemSlot, Float> slotDropChances) {
        this.c = lootTable;
        this.d = slotDropChances;
    }

    private static Map<EnumItemSlot, Float> a(float dropChance) {
        return EquipmentTable.a(List.of(EnumItemSlot.values()), dropChance);
    }

    private static Map<EnumItemSlot, Float> a(List<EnumItemSlot> equipmentSlots, float dropChance) {
        HashMap map = Maps.newHashMap();
        for (EnumItemSlot equipmentSlot : equipmentSlots) {
            map.put(equipmentSlot, Float.valueOf(dropChance));
        }
        return map;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{EquipmentTable.class, "lootTable;slotDropChances", "c", "d"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EquipmentTable.class, "lootTable;slotDropChances", "c", "d"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EquipmentTable.class, "lootTable;slotDropChances", "c", "d"}, this, o2);
    }

    public ResourceKey<LootTable> a() {
        return this.c;
    }

    public Map<EnumItemSlot, Float> b() {
        return this.d;
    }
}

