/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.MCUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.ChestRaft;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.entity.vehicle.Raft;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class EntityTypes<T extends Entity>
implements FeatureElement,
EntityTypeTest<Entity, T> {
    private static final Logger bU = LogUtils.getLogger();
    private final Holder.c<EntityTypes<?>> bV = BuiltInRegistries.f.f(this);
    private static final float bW = 1.3964844f;
    private static final int bX = 10;
    public static final EntityTypes<EntityBoat> a = EntityTypes.a("acacia_boat", Builder.a(EntityTypes.a(() -> Items.oF), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> b = EntityTypes.a("acacia_chest_boat", Builder.a(EntityTypes.b(() -> Items.oG), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Allay> c = EntityTypes.a("allay", Builder.a(Allay::new, EnumCreatureType.b).a(0.35f, 0.6f).b(0.36f).c(0.04f).a(8).b(2));
    public static final EntityTypes<EntityAreaEffectCloud> d = EntityTypes.a("area_effect_cloud", Builder.a(EntityAreaEffectCloud::new, EnumCreatureType.h).e().c().a(6.0f, 0.5f).a(10).b(10));
    public static final EntityTypes<Armadillo> e = EntityTypes.a("armadillo", Builder.a(Armadillo::new, EnumCreatureType.b).a(0.7f, 0.65f).b(0.26f).a(10));
    public static final EntityTypes<EntityArmorStand> f = EntityTypes.a("armor_stand", Builder.a(EntityArmorStand::new, EnumCreatureType.h).a(0.5f, 1.975f).b(1.7775f).a(10));
    public static final EntityTypes<EntityTippedArrow> g = EntityTypes.a("arrow", Builder.a(EntityTippedArrow::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<Axolotl> h = EntityTypes.a("axolotl", Builder.a(Axolotl::new, EnumCreatureType.d).a(0.75f, 0.42f).b(0.2751f).a(10));
    public static final EntityTypes<ChestRaft> i = EntityTypes.a("bamboo_chest_raft", Builder.a(EntityTypes.d(() -> Items.oQ), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Raft> j = EntityTypes.a("bamboo_raft", Builder.a(EntityTypes.c(() -> Items.oP), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityBat> k = EntityTypes.a("bat", Builder.a(EntityBat::new, EnumCreatureType.c).a(0.5f, 0.9f).b(0.45f).a(5));
    public static final EntityTypes<EntityBee> l = EntityTypes.a("bee", Builder.a(EntityBee::new, EnumCreatureType.b).a(0.7f, 0.6f).b(0.3f).a(8));
    public static final EntityTypes<EntityBoat> m = EntityTypes.a("birch_boat", Builder.a(EntityTypes.a(() -> Items.oB), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> n = EntityTypes.a("birch_chest_boat", Builder.a(EntityTypes.b(() -> Items.oC), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityBlaze> o = EntityTypes.a("blaze", Builder.a(EntityBlaze::new, EnumCreatureType.a).c().a(0.6f, 1.8f).a(8));
    public static final EntityTypes<Display.BlockDisplay> p = EntityTypes.a("block_display", Builder.a(Display.BlockDisplay::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<Bogged> q = EntityTypes.a("bogged", Builder.a(Bogged::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(8));
    public static final EntityTypes<Breeze> r = EntityTypes.a("breeze", Builder.a(Breeze::new, EnumCreatureType.a).a(0.6f, 1.77f).b(1.3452f).a(10));
    public static final EntityTypes<BreezeWindCharge> s = EntityTypes.a("breeze_wind_charge", Builder.a(BreezeWindCharge::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).b(0.0f).a(4).b(10));
    public static final EntityTypes<Camel> t = EntityTypes.a("camel", Builder.a(Camel::new, EnumCreatureType.b).a(1.7f, 2.375f).b(2.275f).a(10));
    public static final EntityTypes<EntityCat> u = EntityTypes.a("cat", Builder.a(EntityCat::new, EnumCreatureType.b).a(0.6f, 0.7f).b(0.35f).a(new float[]{0.5125f}).a(8));
    public static final EntityTypes<EntityCaveSpider> v = EntityTypes.a("cave_spider", Builder.a(EntityCaveSpider::new, EnumCreatureType.a).a(0.7f, 0.5f).b(0.45f).a(8));
    public static final EntityTypes<EntityBoat> w = EntityTypes.a("cherry_boat", Builder.a(EntityTypes.a(() -> Items.oH), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> x = EntityTypes.a("cherry_chest_boat", Builder.a(EntityTypes.b(() -> Items.oI), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityMinecartChest> y = EntityTypes.a("chest_minecart", Builder.a(EntityMinecartChest::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityChicken> z = EntityTypes.a("chicken", Builder.a(EntityChicken::new, EnumCreatureType.b).a(0.4f, 0.7f).b(0.644f).a(new Vec3D[]{new Vec3D(0.0, 0.7, -0.1)}).a(10));
    public static final EntityTypes<EntityCod> A = EntityTypes.a("cod", Builder.a(EntityCod::new, EnumCreatureType.g).a(0.5f, 0.3f).b(0.195f).a(4));
    public static final EntityTypes<EntityMinecartCommandBlock> B = EntityTypes.a("command_block_minecart", Builder.a(EntityMinecartCommandBlock::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityCow> C = EntityTypes.a("cow", Builder.a(EntityCow::new, EnumCreatureType.b).a(0.9f, 1.4f).b(1.3f).a(new float[]{1.36875f}).a(10));
    public static final EntityTypes<Creaking> D = EntityTypes.a("creaking", Builder.a(Creaking::new, EnumCreatureType.a).a(0.9f, 2.7f).b(2.3f).a(8));
    public static final EntityTypes<EntityCreeper> E = EntityTypes.a("creeper", Builder.a(EntityCreeper::new, EnumCreatureType.a).a(0.6f, 1.7f).a(8));
    public static final EntityTypes<EntityBoat> F = EntityTypes.a("dark_oak_boat", Builder.a(EntityTypes.a(() -> Items.oJ), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> G = EntityTypes.a("dark_oak_chest_boat", Builder.a(EntityTypes.b(() -> Items.oK), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityDolphin> H = EntityTypes.a("dolphin", Builder.a(EntityDolphin::new, EnumCreatureType.f).a(0.9f, 0.6f).b(0.3f));
    public static final EntityTypes<EntityHorseDonkey> I = EntityTypes.a("donkey", Builder.a(EntityHorseDonkey::new, EnumCreatureType.b).a(1.3964844f, 1.5f).b(1.425f).a(new float[]{1.1125f}).a(10));
    public static final EntityTypes<EntityDragonFireball> J = EntityTypes.a("dragon_fireball", Builder.a(EntityDragonFireball::new, EnumCreatureType.h).e().a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityDrowned> K = EntityTypes.a("drowned", Builder.a(EntityDrowned::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityEgg> L = EntityTypes.a("egg", Builder.a(EntityEgg::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityGuardianElder> M = EntityTypes.a("elder_guardian", Builder.a(EntityGuardianElder::new, EnumCreatureType.a).a(1.9975f, 1.9975f).b(0.99875f).a(new float[]{2.350625f}).a(10));
    public static final EntityTypes<EntityEnderman> N = EntityTypes.a("enderman", Builder.a(EntityEnderman::new, EnumCreatureType.a).a(0.6f, 2.9f).b(2.55f).a(new float[]{2.80625f}).a(8));
    public static final EntityTypes<EntityEndermite> O = EntityTypes.a("endermite", Builder.a(EntityEndermite::new, EnumCreatureType.a).a(0.4f, 0.3f).b(0.13f).a(new float[]{0.2375f}).a(8));
    public static final EntityTypes<EntityEnderDragon> P = EntityTypes.a("ender_dragon", Builder.a(EntityEnderDragon::new, EnumCreatureType.a).c().a(16.0f, 8.0f).a(new float[]{3.0f}).a(10));
    public static final EntityTypes<EntityEnderPearl> Q = EntityTypes.a("ender_pearl", Builder.a(EntityEnderPearl::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityEnderCrystal> R = EntityTypes.a("end_crystal", Builder.a(EntityEnderCrystal::new, EnumCreatureType.h).e().c().a(2.0f, 2.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityEvoker> S = EntityTypes.a("evoker", Builder.a(EntityEvoker::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityEvokerFangs> T = EntityTypes.a("evoker_fangs", Builder.a(EntityEvokerFangs::new, EnumCreatureType.h).e().a(0.5f, 0.8f).a(6).b(2));
    public static final EntityTypes<EntityThrownExpBottle> U = EntityTypes.a("experience_bottle", Builder.a(EntityThrownExpBottle::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityExperienceOrb> V = EntityTypes.a("experience_orb", Builder.a(EntityExperienceOrb::new, EnumCreatureType.h).e().a(0.5f, 0.5f).a(6).b(20));
    public static final EntityTypes<EntityEnderSignal> W = EntityTypes.a("eye_of_ender", Builder.a(EntityEnderSignal::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(4));
    public static final EntityTypes<EntityFallingBlock> X = EntityTypes.a("falling_block", Builder.a(EntityFallingBlock::new, EnumCreatureType.h).e().a(0.98f, 0.98f).a(10).b(20));
    public static final EntityTypes<EntityLargeFireball> Y = EntityTypes.a("fireball", Builder.a(EntityLargeFireball::new, EnumCreatureType.h).e().a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityFireworks> Z = EntityTypes.a("firework_rocket", Builder.a(EntityFireworks::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityFox> aa = EntityTypes.a("fox", Builder.a(EntityFox::new, EnumCreatureType.b).a(0.6f, 0.7f).b(0.4f).a(new Vec3D[]{new Vec3D(0.0, 0.6375, -0.25)}).a(8).a(Blocks.oK));
    public static final EntityTypes<Frog> ab = EntityTypes.a("frog", Builder.a(Frog::new, EnumCreatureType.b).a(0.5f, 0.5f).a(new Vec3D[]{new Vec3D(0.0, 0.375, -0.25)}).a(10));
    public static final EntityTypes<EntityMinecartFurnace> ac = EntityTypes.a("furnace_minecart", Builder.a(EntityMinecartFurnace::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityGhast> ad = EntityTypes.a("ghast", Builder.a(EntityGhast::new, EnumCreatureType.a).c().a(4.0f, 4.0f).b(2.6f).a(new float[]{4.0625f}).c(0.5f).a(10));
    public static final EntityTypes<EntityGiantZombie> ae = EntityTypes.a("giant", Builder.a(EntityGiantZombie::new, EnumCreatureType.a).a(3.6f, 12.0f).b(10.44f).c(-3.75f).a(10));
    public static final EntityTypes<GlowItemFrame> af = EntityTypes.a("glow_item_frame", Builder.a(GlowItemFrame::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.0f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<GlowSquid> ag = EntityTypes.a("glow_squid", Builder.a(GlowSquid::new, EnumCreatureType.e).a(0.8f, 0.8f).b(0.4f).a(10));
    public static final EntityTypes<Goat> ah = EntityTypes.a("goat", Builder.a(Goat::new, EnumCreatureType.b).a(0.9f, 1.3f).a(new float[]{1.1125f}).a(10));
    public static final EntityTypes<EntityGuardian> ai = EntityTypes.a("guardian", Builder.a(EntityGuardian::new, EnumCreatureType.a).a(0.85f, 0.85f).b(0.425f).a(new float[]{0.975f}).a(8));
    public static final EntityTypes<EntityHoglin> aj = EntityTypes.a("hoglin", Builder.a(EntityHoglin::new, EnumCreatureType.a).a(1.3964844f, 1.4f).a(new float[]{1.49375f}).a(8));
    public static final EntityTypes<EntityMinecartHopper> ak = EntityTypes.a("hopper_minecart", Builder.a(EntityMinecartHopper::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityHorse> al = EntityTypes.a("horse", Builder.a(EntityHorse::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.44375f}).a(10));
    public static final EntityTypes<EntityZombieHusk> am = EntityTypes.a("husk", Builder.a(EntityZombieHusk::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.075f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityIllagerIllusioner> an = EntityTypes.a("illusioner", Builder.a(EntityIllagerIllusioner::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<Interaction> ao = EntityTypes.a("interaction", Builder.a(Interaction::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10));
    public static final EntityTypes<EntityIronGolem> ap = EntityTypes.a("iron_golem", Builder.a(EntityIronGolem::new, EnumCreatureType.h).a(1.4f, 2.7f).a(10));
    public static final EntityTypes<EntityItem> aq = EntityTypes.a("item", Builder.a(EntityItem::new, EnumCreatureType.h).e().a(0.25f, 0.25f).b(0.2125f).a(6).b(20));
    public static final EntityTypes<Display.ItemDisplay> ar = EntityTypes.a("item_display", Builder.a(Display.ItemDisplay::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityItemFrame> as = EntityTypes.a("item_frame", Builder.a(EntityItemFrame::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.0f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityBoat> at = EntityTypes.a("jungle_boat", Builder.a(EntityTypes.a(() -> Items.oD), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> au = EntityTypes.a("jungle_chest_boat", Builder.a(EntityTypes.b(() -> Items.oE), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityLeash> av = EntityTypes.a("leash_knot", Builder.a(EntityLeash::new, EnumCreatureType.h).e().b().a(0.375f, 0.5f).b(0.0625f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLightning> aw = EntityTypes.a("lightning_bolt", Builder.a(EntityLightning::new, EnumCreatureType.h).e().b().a(0.0f, 0.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLlama> ax = EntityTypes.a("llama", Builder.a(EntityLlama::new, EnumCreatureType.b).a(0.9f, 1.87f).b(1.7765f).a(new Vec3D[]{new Vec3D(0.0, 1.37, -0.3)}).a(10));
    public static final EntityTypes<EntityLlamaSpit> ay = EntityTypes.a("llama_spit", Builder.a(EntityLlamaSpit::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityMagmaCube> az = EntityTypes.a("magma_cube", Builder.a(EntityMagmaCube::new, EnumCreatureType.a).c().a(0.52f, 0.52f).b(0.325f).a(4.0f).a(8));
    public static final EntityTypes<EntityBoat> aA = EntityTypes.a("mangrove_boat", Builder.a(EntityTypes.a(() -> Items.oN), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> aB = EntityTypes.a("mangrove_chest_boat", Builder.a(EntityTypes.b(() -> Items.oO), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Marker> aC = EntityTypes.a("marker", Builder.a(Marker::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(0));
    public static final EntityTypes<EntityMinecartRideable> aD = EntityTypes.a("minecart", Builder.a(EntityMinecartRideable::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityMushroomCow> aE = EntityTypes.a("mooshroom", Builder.a(EntityMushroomCow::new, EnumCreatureType.b).a(0.9f, 1.4f).b(1.3f).a(new float[]{1.36875f}).a(10));
    public static final EntityTypes<EntityHorseMule> aF = EntityTypes.a("mule", Builder.a(EntityHorseMule::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.2125f}).a(8));
    public static final EntityTypes<EntityBoat> aG = EntityTypes.a("oak_boat", Builder.a(EntityTypes.a(() -> Items.ox), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> aH = EntityTypes.a("oak_chest_boat", Builder.a(EntityTypes.b(() -> Items.oy), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityOcelot> aI = EntityTypes.a("ocelot", Builder.a(EntityOcelot::new, EnumCreatureType.b).a(0.6f, 0.7f).a(new float[]{0.6375f}).a(10));
    public static final EntityTypes<OminousItemSpawner> aJ = EntityTypes.a("ominous_item_spawner", Builder.a(OminousItemSpawner::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(8));
    public static final EntityTypes<EntityPainting> aK = EntityTypes.a("painting", Builder.a(EntityPainting::new, EnumCreatureType.h).e().a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityBoat> aL = EntityTypes.a("pale_oak_boat", Builder.a(EntityTypes.a(() -> Items.oL), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> aM = EntityTypes.a("pale_oak_chest_boat", Builder.a(EntityTypes.b(() -> Items.oM), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityPanda> aN = EntityTypes.a("panda", Builder.a(EntityPanda::new, EnumCreatureType.b).a(1.3f, 1.25f).a(10));
    public static final EntityTypes<EntityParrot> aO = EntityTypes.a("parrot", Builder.a(EntityParrot::new, EnumCreatureType.b).a(0.5f, 0.9f).b(0.54f).a(new float[]{0.4625f}).a(8));
    public static final EntityTypes<EntityPhantom> aP = EntityTypes.a("phantom", Builder.a(EntityPhantom::new, EnumCreatureType.a).a(0.9f, 0.5f).b(0.175f).a(new float[]{0.3375f}).c(-0.125f).a(8));
    public static final EntityTypes<EntityPig> aQ = EntityTypes.a("pig", Builder.a(EntityPig::new, EnumCreatureType.b).a(0.9f, 0.9f).a(new float[]{0.86875f}).a(10));
    public static final EntityTypes<EntityPiglin> aR = EntityTypes.a("piglin", Builder.a(EntityPiglin::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityPiglinBrute> aS = EntityTypes.a("piglin_brute", Builder.a(EntityPiglinBrute::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityPillager> aT = EntityTypes.a("pillager", Builder.a(EntityPillager::new, EnumCreatureType.a).d().a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityPolarBear> aU = EntityTypes.a("polar_bear", Builder.a(EntityPolarBear::new, EnumCreatureType.b).a(Blocks.rr).a(1.4f, 1.4f).a(10));
    public static final EntityTypes<EntityPotion> aV = EntityTypes.a("potion", Builder.a(EntityPotion::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityPufferFish> aW = EntityTypes.a("pufferfish", Builder.a(EntityPufferFish::new, EnumCreatureType.g).a(0.7f, 0.7f).b(0.455f).a(4));
    public static final EntityTypes<EntityRabbit> aX = EntityTypes.a("rabbit", Builder.a(EntityRabbit::new, EnumCreatureType.b).a(0.4f, 0.5f).a(8));
    public static final EntityTypes<EntityRavager> aY = EntityTypes.a("ravager", Builder.a(EntityRavager::new, EnumCreatureType.a).a(1.95f, 2.2f).a(new Vec3D[]{new Vec3D(0.0, 2.2625, -0.0625)}).a(10));
    public static final EntityTypes<EntitySalmon> aZ = EntityTypes.a("salmon", Builder.a(EntitySalmon::new, EnumCreatureType.g).a(0.7f, 0.4f).b(0.26f).a(4));
    public static final EntityTypes<EntitySheep> ba = EntityTypes.a("sheep", Builder.a(EntitySheep::new, EnumCreatureType.b).a(0.9f, 1.3f).b(1.235f).a(new float[]{1.2375f}).a(10));
    public static final EntityTypes<EntityShulker> bb = EntityTypes.a("shulker", Builder.a(EntityShulker::new, EnumCreatureType.a).c().d().a(1.0f, 1.0f).b(0.5f).a(10));
    public static final EntityTypes<EntityShulkerBullet> bc = EntityTypes.a("shulker_bullet", Builder.a(EntityShulkerBullet::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).a(8));
    public static final EntityTypes<EntitySilverfish> bd = EntityTypes.a("silverfish", Builder.a(EntitySilverfish::new, EnumCreatureType.a).a(0.4f, 0.3f).b(0.13f).a(new float[]{0.2375f}).a(8));
    public static final EntityTypes<EntitySkeleton> be = EntityTypes.a("skeleton", Builder.a(EntitySkeleton::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(8));
    public static final EntityTypes<EntityHorseSkeleton> bf = EntityTypes.a("skeleton_horse", Builder.a(EntityHorseSkeleton::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.31875f}).a(10));
    public static final EntityTypes<EntitySlime> bg = EntityTypes.a("slime", Builder.a(EntitySlime::new, EnumCreatureType.a).a(0.52f, 0.52f).b(0.325f).a(4.0f).a(10));
    public static final EntityTypes<EntitySmallFireball> bh = EntityTypes.a("small_fireball", Builder.a(EntitySmallFireball::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<Sniffer> bi = EntityTypes.a("sniffer", Builder.a(Sniffer::new, EnumCreatureType.b).a(1.9f, 1.75f).b(1.05f).a(new float[]{2.09375f}).d(2.05f).a(10));
    public static final EntityTypes<EntitySnowball> bj = EntityTypes.a("snowball", Builder.a(EntitySnowball::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntitySnowman> bk = EntityTypes.a("snow_golem", Builder.a(EntitySnowman::new, EnumCreatureType.h).a(Blocks.rr).a(0.7f, 1.9f).b(1.7f).a(8));
    public static final EntityTypes<EntityMinecartMobSpawner> bl = EntityTypes.a("spawner_minecart", Builder.a(EntityMinecartMobSpawner::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntitySpectralArrow> bm = EntityTypes.a("spectral_arrow", Builder.a(EntitySpectralArrow::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<EntitySpider> bn = EntityTypes.a("spider", Builder.a(EntitySpider::new, EnumCreatureType.a).a(1.4f, 0.9f).b(0.65f).a(new float[]{0.765f}).a(8));
    public static final EntityTypes<EntityBoat> bo = EntityTypes.a("spruce_boat", Builder.a(EntityTypes.a(() -> Items.oz), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> bp = EntityTypes.a("spruce_chest_boat", Builder.a(EntityTypes.b(() -> Items.oA), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntitySquid> bq = EntityTypes.a("squid", Builder.a(EntitySquid::new, EnumCreatureType.f).a(0.8f, 0.8f).b(0.4f).a(8));
    public static final EntityTypes<EntitySkeletonStray> br = EntityTypes.a("stray", Builder.a(EntitySkeletonStray::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(Blocks.rr).a(8));
    public static final EntityTypes<EntityStrider> bs = EntityTypes.a("strider", Builder.a(EntityStrider::new, EnumCreatureType.b).c().a(0.9f, 1.7f).a(10));
    public static final EntityTypes<Tadpole> bt = EntityTypes.a("tadpole", Builder.a(Tadpole::new, EnumCreatureType.b).a(0.4f, 0.3f).b(0.19500001f).a(10));
    public static final EntityTypes<Display.TextDisplay> bu = EntityTypes.a("text_display", Builder.a(Display.TextDisplay::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityTNTPrimed> bv = EntityTypes.a("tnt", Builder.a(EntityTNTPrimed::new, EnumCreatureType.h).e().c().a(0.98f, 0.98f).b(0.15f).a(10).b(10));
    public static final EntityTypes<EntityMinecartTNT> bw = EntityTypes.a("tnt_minecart", Builder.a(EntityMinecartTNT::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityLlamaTrader> bx = EntityTypes.a("trader_llama", Builder.a(EntityLlamaTrader::new, EnumCreatureType.b).a(0.9f, 1.87f).b(1.7765f).a(new Vec3D[]{new Vec3D(0.0, 1.37, -0.3)}).a(10));
    public static final EntityTypes<EntityThrownTrident> by = EntityTypes.a("trident", Builder.a(EntityThrownTrident::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<EntityTropicalFish> bz = EntityTypes.a("tropical_fish", Builder.a(EntityTropicalFish::new, EnumCreatureType.g).a(0.5f, 0.4f).b(0.26f).a(4));
    public static final EntityTypes<EntityTurtle> bA = EntityTypes.a("turtle", Builder.a(EntityTurtle::new, EnumCreatureType.b).a(1.2f, 0.4f).a(new Vec3D[]{new Vec3D(0.0, 0.55625, -0.25)}).a(10));
    public static final EntityTypes<EntityVex> bB = EntityTypes.a("vex", Builder.a(EntityVex::new, EnumCreatureType.a).c().a(0.4f, 0.8f).b(0.51875f).a(new float[]{0.7375f}).c(0.04f).a(8));
    public static final EntityTypes<EntityVillager> bC = EntityTypes.a("villager", Builder.a(EntityVillager::new, EnumCreatureType.h).a(0.6f, 1.95f).b(1.62f).a(10));
    public static final EntityTypes<EntityVindicator> bD = EntityTypes.a("vindicator", Builder.a(EntityVindicator::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityVillagerTrader> bE = EntityTypes.a("wandering_trader", Builder.a(EntityVillagerTrader::new, EnumCreatureType.b).a(0.6f, 1.95f).b(1.62f).a(10));
    public static final EntityTypes<Warden> bF = EntityTypes.a("warden", Builder.a(Warden::new, EnumCreatureType.a).a(0.9f, 2.9f).a(new float[]{3.15f}).a(EntityAttachment.d, 0.0f, 1.6f, 0.0f).a(16).c());
    public static final EntityTypes<WindCharge> bG = EntityTypes.a("wind_charge", Builder.a(WindCharge::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).b(0.0f).a(4).b(10));
    public static final EntityTypes<EntityWitch> bH = EntityTypes.a("witch", Builder.a(EntityWitch::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.62f).a(new float[]{2.2625f}).a(8));
    public static final EntityTypes<EntityWither> bI = EntityTypes.a("wither", Builder.a(EntityWither::new, EnumCreatureType.a).c().a(Blocks.ck).a(0.9f, 3.5f).a(10));
    public static final EntityTypes<EntitySkeletonWither> bJ = EntityTypes.a("wither_skeleton", Builder.a(EntitySkeletonWither::new, EnumCreatureType.a).c().a(Blocks.ck).a(0.7f, 2.4f).b(2.1f).c(-0.875f).a(8));
    public static final EntityTypes<EntityWitherSkull> bK = EntityTypes.a("wither_skull", Builder.a(EntityWitherSkull::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<EntityWolf> bL = EntityTypes.a("wolf", Builder.a(EntityWolf::new, EnumCreatureType.b).a(0.6f, 0.85f).b(0.68f).a(new Vec3D[]{new Vec3D(0.0, 0.81875, -0.0625)}).a(10));
    public static final EntityTypes<EntityZoglin> bM = EntityTypes.a("zoglin", Builder.a(EntityZoglin::new, EnumCreatureType.a).c().a(1.3964844f, 1.4f).a(new float[]{1.49375f}).a(8));
    public static final EntityTypes<EntityZombie> bN = EntityTypes.a("zombie", Builder.a(EntityZombie::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityHorseZombie> bO = EntityTypes.a("zombie_horse", Builder.a(EntityHorseZombie::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.31875f}).a(10));
    public static final EntityTypes<EntityZombieVillager> bP = EntityTypes.a("zombie_villager", Builder.a(EntityZombieVillager::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.125f}).c(-0.7f).b(1.74f).a(8));
    public static final EntityTypes<EntityPigZombie> bQ = EntityTypes.a("zombified_piglin", Builder.a(EntityPigZombie::new, EnumCreatureType.a).c().a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityHuman> bR = EntityTypes.a("player", Builder.a(EnumCreatureType.h).b().a().a(0.6f, 1.8f).b(1.62f).a(EntityHuman.bU).a(32).b(2));
    public static final EntityTypes<EntityFishingHook> bS = EntityTypes.a("fishing_bobber", Builder.a(EntityFishingHook::new, EnumCreatureType.h).e().b().a().a(0.25f, 0.25f).a(4).b(5));
    private static final Set<EntityTypes<?>> bY = Set.of(X, B, bl);
    private final b<T> bZ;
    private final EnumCreatureType ca;
    private final ImmutableSet<Block> cb;
    private final boolean cc;
    private final boolean cd;
    private final boolean ce;
    private final boolean cf;
    private final int cg;
    private final int ch;
    private final String ci;
    @Nullable
    private IChatBaseComponent cj;
    private final Optional<ResourceKey<LootTable>> ck;
    private final EntitySize cl;
    private final float cm;
    private final FeatureFlagSet cn;

    private static <T extends Entity> EntityTypes<T> a(ResourceKey<EntityTypes<?>> key, Builder<T> builder) {
        return IRegistry.a(BuiltInRegistries.f, key, builder.a(key));
    }

    private static ResourceKey<EntityTypes<?>> b(String name) {
        return ResourceKey.a(Registries.z, MinecraftKey.b(name));
    }

    private static <T extends Entity> EntityTypes<T> a(String key, Builder<T> builder) {
        return EntityTypes.a(EntityTypes.b(key), builder);
    }

    public static MinecraftKey a(EntityTypes<?> entityType) {
        return BuiltInRegistries.f.b(entityType);
    }

    public static Optional<EntityTypes<?>> a(String key) {
        return BuiltInRegistries.f.b(MinecraftKey.c(key));
    }

    public EntityTypes(b<T> factory, EnumCreatureType category, boolean serialize, boolean summon, boolean fireImmune, boolean canSpawnFarFromPlayer, ImmutableSet<Block> immuneTo, EntitySize dimensions, float spawnDimensionsScale, int clientTrackingRange, int updateInterval, String descriptionId, Optional<ResourceKey<LootTable>> lootTable, FeatureFlagSet requiredFeatures) {
        this.bZ = factory;
        this.ca = category;
        this.cf = canSpawnFarFromPlayer;
        this.cc = serialize;
        this.cd = summon;
        this.ce = fireImmune;
        this.cb = immuneTo;
        this.cl = dimensions;
        this.cm = spawnDimensionsScale;
        this.cg = clientTrackingRange;
        this.ch = updateInterval;
        this.ci = descriptionId;
        this.ck = lootTable;
        this.cn = requiredFeatures;
    }

    @Nullable
    public T a(WorldServer level, @Nullable ItemStack spawnedFrom, @Nullable EntityHuman player, BlockPosition pos, EntitySpawnReason reason, boolean shouldOffsetY, boolean shouldOffsetYMore) {
        return this.spawn(level, spawnedFrom, player, pos, reason, shouldOffsetY, shouldOffsetYMore, reason == EntitySpawnReason.o ? CreatureSpawnEvent.SpawnReason.DISPENSE_EGG : CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
    }

    @Nullable
    public T spawn(WorldServer level, @Nullable ItemStack spawnedFrom, @Nullable EntityHuman player, BlockPosition pos, EntitySpawnReason reason, boolean shouldOffsetY, boolean shouldOffsetYMore, CreatureSpawnEvent.SpawnReason createSpawnReason) {
        Consumer<Entity> consumer = spawnedFrom != null ? EntityTypes.a(level, spawnedFrom, player) : entity -> {};
        return (T)this.spawn(level, consumer, pos, reason, shouldOffsetY, shouldOffsetYMore, createSpawnReason);
    }

    public static <T extends Entity> Consumer<T> a(World level, ItemStack spawnedFrom, @Nullable EntityHuman player) {
        return EntityTypes.a((T entity) -> {}, level, spawnedFrom, player);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> consumer, World level, ItemStack spawnedFrom, @Nullable EntityHuman player) {
        return EntityTypes.b(EntityTypes.a(consumer, spawnedFrom), level, spawnedFrom, player);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> consumer, ItemStack stack) {
        IChatBaseComponent component = stack.a(DataComponents.g);
        return component != null ? consumer.andThen(entity -> entity.b(component)) : consumer;
    }

    public static <T extends Entity> Consumer<T> b(Consumer<T> consumer, World level, ItemStack spawnedFrom, @Nullable EntityHuman player) {
        CustomData customData = spawnedFrom.a(DataComponents.W, CustomData.a);
        return !customData.c() ? consumer.andThen(entity -> {
            try {
                EntityTypes.a(level, player, entity, customData);
            }
            catch (Throwable t2) {
                bU.warn("Error loading spawn egg NBT", t2);
            }
        }) : consumer;
    }

    @Nullable
    public T a(WorldServer level, BlockPosition pos, EntitySpawnReason reason) {
        return this.spawn(level, pos, reason, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer level, BlockPosition pos, EntitySpawnReason reason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return this.spawn(level, null, pos, reason, false, false, creatureSpawnReason);
    }

    @Nullable
    public T a(WorldServer level, @Nullable Consumer<T> consumer, BlockPosition pos, EntitySpawnReason reason, boolean shouldOffsetY, boolean shouldOffsetYMore) {
        return this.spawn(level, consumer, pos, reason, shouldOffsetY, shouldOffsetYMore, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer level, @Nullable Consumer<T> consumer, BlockPosition pos, EntitySpawnReason reason, boolean shouldOffsetY, boolean shouldOffsetYMore, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        PreCreatureSpawnEvent event = new PreCreatureSpawnEvent(MCUtil.toLocation(level, pos), CraftEntityType.minecraftToBukkit(this), creatureSpawnReason);
        if (!event.callEvent()) {
            return null;
        }
        T entity = this.b(level, consumer, pos, reason, shouldOffsetY, shouldOffsetYMore);
        if (entity != null) {
            level.addFreshEntityWithPassengers((Entity)entity, creatureSpawnReason);
            if (((Entity)entity).dQ()) {
                return null;
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)entity;
                mob.U();
            }
        }
        return entity;
    }

    @Nullable
    public T b(WorldServer level, @Nullable Consumer<T> consumer, BlockPosition pos, EntitySpawnReason reason, boolean shoulOffsetY, boolean shouldOffsetYMore) {
        double yOffset;
        T entity = this.a(level, reason);
        if (entity == null) {
            return null;
        }
        if (shoulOffsetY) {
            ((Entity)entity).a_((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5);
            yOffset = EntityTypes.a((IWorldReader)level, pos, shouldOffsetYMore, ((Entity)entity).cR());
        } else {
            yOffset = 0.0;
        }
        ((Entity)entity).b((double)pos.u() + 0.5, (double)pos.v() + yOffset, (double)pos.w() + 0.5, MathHelper.h(level.A.i() * 360.0f), 0.0f);
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            mob.aZ = mob.dL();
            mob.aX = mob.dL();
            mob.a((WorldAccess)level, level.d_(mob.dv()), reason, null);
        }
        if (consumer != null) {
            consumer.accept(entity);
        }
        return entity;
    }

    protected static double a(IWorldReader level, BlockPosition pos, boolean shouldOffsetYMore, AxisAlignedBB box) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos);
        if (shouldOffsetYMore) {
            aabb = aabb.b(0.0, -1.0, 0.0);
        }
        Iterable<VoxelShape> collisions = level.d(null, aabb);
        return 1.0 + VoxelShapes.a(EnumDirection.EnumAxis.b, box, collisions, shouldOffsetYMore ? -2.0 : -1.0);
    }

    public static void a(World level, @Nullable EntityHuman player, @Nullable Entity entity, CustomData customData) {
        MinecraftServer server = level.p();
        if (server != null && entity != null) {
            EntityTypes<?> entityType = customData.a(server.ba(), Registries.z);
            if (entity.aq() == entityType && (level.C || !entity.aq().s() || player != null && server.ag().f(player.gh()))) {
                if (player == null || !player.getBukkitEntity().hasPermission("minecraft.nbt.place")) {
                    customData = customData.a((NBTTagCompound compound) -> {
                        for (ArgumentNBTKey.g tag : level.paperConfig().entities.spawning.filteredEntityTagNbtPaths) {
                            tag.c((NBTBase)compound);
                        }
                    });
                }
                customData.a(entity);
            }
        }
    }

    public boolean b() {
        return this.cc;
    }

    public boolean c() {
        return this.cd;
    }

    public boolean d() {
        return this.ce;
    }

    public boolean e() {
        return this.cf;
    }

    public EnumCreatureType f() {
        return this.ca;
    }

    public String g() {
        return this.ci;
    }

    public IChatBaseComponent h() {
        if (this.cj == null) {
            this.cj = IChatBaseComponent.c(this.g());
        }
        return this.cj;
    }

    public String toString() {
        return this.g();
    }

    public String j() {
        int index = this.g().lastIndexOf(46);
        return index == -1 ? this.g() : this.g().substring(index + 1);
    }

    public Optional<ResourceKey<LootTable>> k() {
        return this.ck;
    }

    public float l() {
        return this.cl.a();
    }

    public float m() {
        return this.cl.b();
    }

    @Override
    public FeatureFlagSet i() {
        return this.cn;
    }

    @Nullable
    public T a(World level, EntitySpawnReason spawnReason) {
        return !this.a(level.K()) ? null : (T)this.bZ.create(this, level);
    }

    public static Optional<Entity> a(NBTTagCompound tag, World level, EntitySpawnReason spawnReason) {
        return EntityTypes.create(tag, level, spawnReason, false);
    }

    public static Optional<Entity> create(NBTTagCompound tag, World level, EntitySpawnReason spawnReason, boolean generation) {
        return SystemUtils.a(EntityTypes.a(tag).map(entityType -> entityType.a(level, spawnReason)), (T entity) -> {
            if (generation) {
                entity.generation = true;
            }
            entity.g(tag);
        }, () -> bU.warn("Skipping Entity with id {}", (Object)tag.l("id")));
    }

    public AxisAlignedBB a(double x2, double y2, double z2) {
        float f2 = this.cm * this.l() / 2.0f;
        float f1 = this.cm * this.m();
        return new AxisAlignedBB(x2 - (double)f2, y2, z2 - (double)f2, x2 + (double)f2, y2 + (double)f1, z2 + (double)f2);
    }

    @Override
    public boolean a(IBlockData state) {
        return !this.cb.contains((Object)state.b()) && (!this.ce && PathfinderAbstract.a(state) || state.a(Blocks.ck) || state.a(Blocks.oK) || state.a(Blocks.ed) || state.a(Blocks.rr));
    }

    public EntitySize n() {
        return this.cl;
    }

    public static Optional<EntityTypes<?>> a(NBTTagCompound tag) {
        return BuiltInRegistries.f.b(MinecraftKey.c(tag.l("id")));
    }

    @Nullable
    public static Entity a(NBTTagCompound entityTag, World level, EntitySpawnReason spawnReason, Function<Entity, Entity> adapter) {
        return EntityTypes.b(entityTag, level, spawnReason).map(adapter).map(entity -> {
            if (entityTag.b("Passengers", 9)) {
                NBTTagList list = entityTag.c("Passengers", 10);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Entity entity1 = EntityTypes.a(list.a(i2), level, spawnReason, adapter);
                    if (entity1 == null) continue;
                    entity1.a((Entity)entity, true);
                }
            }
            return entity;
        }).orElse(null);
    }

    public static Stream<Entity> a(final List<? extends NBTBase> entityTags, final World level, final EntitySpawnReason spawnReason) {
        final Spliterator<? extends NBTBase> spliterator = entityTags.spliterator();
        return StreamSupport.stream(new Spliterator<Entity>(){
            final Map<EntityTypes<?>, Integer> loadedEntityCounts = new HashMap();

            @Override
            public boolean tryAdvance(Consumer<? super Entity> consumer) {
                return spliterator.tryAdvance((? super T tag) -> EntityTypes.a((NBTTagCompound)tag, level, spawnReason, entity -> {
                    EntityTypes<?> entityType = entity.aq();
                    int saveLimit = level2.paperConfig().chunks.entityPerChunkSaveLimit.getOrDefault(entityType, -1);
                    if (saveLimit > -1) {
                        if (this.loadedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) {
                            return null;
                        }
                        this.loadedEntityCounts.merge(entityType, 1, Integer::sum);
                    }
                    consumer.accept((Entity)entity);
                    return entity;
                }));
            }

            @Override
            public Spliterator<Entity> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return entityTags.size();
            }

            @Override
            public int characteristics() {
                return 1297;
            }
        }, false);
    }

    private static Optional<Entity> b(NBTTagCompound entityTag, World level, EntitySpawnReason spawnReason) {
        try {
            return EntityTypes.a(entityTag, level, spawnReason);
        }
        catch (RuntimeException var4) {
            bU.warn("Exception loading entity: ", (Throwable)var4);
            return Optional.empty();
        }
    }

    public int o() {
        return this.cg;
    }

    public int p() {
        return this.ch;
    }

    public boolean q() {
        return this != bR && this != ay && this != bI && this != k && this != as && this != af && this != av && this != aK && this != R && this != T;
    }

    @Override
    public boolean a(TagKey<EntityTypes<?>> tag) {
        return this.bV.a(tag);
    }

    @Override
    public boolean a(HolderSet<EntityTypes<?>> entityType) {
        return entityType.a(this.bV);
    }

    @Override
    @Nullable
    public T a(Entity entity) {
        return (T)(entity.aq() == this ? entity : null);
    }

    @Override
    public Class<? extends Entity> a() {
        return Entity.class;
    }

    @Deprecated
    public Holder.c<EntityTypes<?>> r() {
        return this.bV;
    }

    private static b<EntityBoat> a(Supplier<Item> boatItemGetter) {
        return (entityType, level) -> new EntityBoat(entityType, level, boatItemGetter);
    }

    private static b<ChestBoat> b(Supplier<Item> boatItemGetter) {
        return (entityType, level) -> new ChestBoat(entityType, level, boatItemGetter);
    }

    private static b<Raft> c(Supplier<Item> raftItemGetter) {
        return (entityType, level) -> new Raft(entityType, level, raftItemGetter);
    }

    private static b<ChestRaft> d(Supplier<Item> raftItemGetter) {
        return (entityType, level) -> new ChestRaft(entityType, level, raftItemGetter);
    }

    public boolean s() {
        return bY.contains(this);
    }

    public static class Builder<T extends Entity> {
        private final b<T> a;
        private final EnumCreatureType b;
        private ImmutableSet<Block> c = ImmutableSet.of();
        private boolean d = true;
        private boolean e = true;
        private boolean f;
        private boolean g;
        private int h = 5;
        private int i = 3;
        private EntitySize j = EntitySize.b(0.6f, 1.8f);
        private float k = 1.0f;
        private EntityAttachments.a l = EntityAttachments.a();
        private FeatureFlagSet m = FeatureFlags.g;
        private DependantName<EntityTypes<?>, Optional<ResourceKey<LootTable>>> n = key -> Optional.of(ResourceKey.a(Registries.bg, key.a().f("entities/")));
        private DependantName<EntityTypes<?>, String> o = key -> SystemUtils.a("entity", key.a());

        private Builder(b<T> factory, EnumCreatureType category) {
            this.a = factory;
            this.b = category;
            this.g = category == EnumCreatureType.b || category == EnumCreatureType.h;
        }

        public static <T extends Entity> Builder<T> a(b<T> factory, EnumCreatureType category) {
            return new Builder<T>(factory, category);
        }

        public static <T extends Entity> Builder<T> a(EnumCreatureType category) {
            return new Builder<Entity>((entityType, level) -> null, category);
        }

        public Builder<T> a(float width, float height) {
            this.j = EntitySize.b(width, height);
            return this;
        }

        public Builder<T> a(float spawnDimensionsScale) {
            this.k = spawnDimensionsScale;
            return this;
        }

        public Builder<T> b(float eyeHeight) {
            this.j = this.j.b(eyeHeight);
            return this;
        }

        public Builder<T> a(float ... attachPoints) {
            for (float f2 : attachPoints) {
                this.l = this.l.a(EntityAttachment.a, 0.0f, f2, 0.0f);
            }
            return this;
        }

        public Builder<T> a(Vec3D ... attachPoints) {
            for (Vec3D vec3 : attachPoints) {
                this.l = this.l.a(EntityAttachment.a, vec3);
            }
            return this;
        }

        public Builder<T> a(Vec3D attachPoint) {
            return this.a(EntityAttachment.b, attachPoint);
        }

        public Builder<T> c(float ridingOffset) {
            return this.a(EntityAttachment.b, 0.0f, -ridingOffset, 0.0f);
        }

        public Builder<T> d(float nameTagOffset) {
            return this.a(EntityAttachment.c, 0.0f, nameTagOffset, 0.0f);
        }

        public Builder<T> a(EntityAttachment attachment, float x2, float y2, float z2) {
            this.l = this.l.a(attachment, x2, y2, z2);
            return this;
        }

        public Builder<T> a(EntityAttachment attachment, Vec3D pos) {
            this.l = this.l.a(attachment, pos);
            return this;
        }

        public Builder<T> a() {
            this.e = false;
            return this;
        }

        public Builder<T> b() {
            this.d = false;
            return this;
        }

        public Builder<T> c() {
            this.f = true;
            return this;
        }

        public Builder<T> a(Block ... blocks) {
            this.c = ImmutableSet.copyOf((Object[])blocks);
            return this;
        }

        public Builder<T> d() {
            this.g = true;
            return this;
        }

        public Builder<T> a(int clientTrackingRange) {
            this.h = clientTrackingRange;
            return this;
        }

        public Builder<T> b(int updateInterval) {
            this.i = updateInterval;
            return this;
        }

        public Builder<T> a(FeatureFlag ... requiredFeatures) {
            this.m = FeatureFlags.e.a(requiredFeatures);
            return this;
        }

        public Builder<T> e() {
            this.n = DependantName.fixed(Optional.empty());
            return this;
        }

        public EntityTypes<T> a(ResourceKey<EntityTypes<?>> entityType) {
            if (this.d) {
                SystemUtils.a(DataConverterTypes.A, entityType.a().toString());
            }
            return new EntityTypes<T>(this.a, this.b, this.d, this.e, this.f, this.g, this.c, this.j.a(this.l), this.k, this.h, this.i, this.o.get(entityType), this.n.get(entityType), this.m);
        }
    }

    @FunctionalInterface
    public static interface b<T extends Entity> {
        public T create(EntityTypes<T> var1, World var2);
    }
}

