/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Tameable;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    public static final int bY = 144;
    private static final int cc = 2;
    private static final int cd = 3;
    private static final int ce = 1;
    protected static final DataWatcherObject<Byte> bZ = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Optional<UUID>> ca = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.r);
    private boolean cf;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, (byte)0);
        builder.a(ca, Optional.empty());
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        if (this.aa_() != null) {
            compound.a("Owner", this.aa_());
        }
        compound.a("Sitting", this.cf);
    }

    @Override
    public void a(NBTTagCompound compound) {
        UUID uuid;
        super.a(compound);
        if (compound.b("Owner")) {
            uuid = compound.a("Owner");
        } else {
            String string = compound.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cV(), string);
        }
        if (uuid != null) {
            try {
                this.b(uuid);
                this.a(true, false);
            }
            catch (Throwable var4) {
                this.a(false, true);
            }
        } else {
            this.b((UUID)null);
            this.a(false, true);
        }
        this.cf = compound.q("Sitting");
        this.setInSittingPose(this.cf, false);
    }

    @Override
    public boolean y() {
        return true;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (this.x()) {
            if (distance > (float)this.dV().paperConfig().misc.maxLeashDistance.or(10.0)) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
                if (!event.callEvent()) {
                    return false;
                }
                if (event.isDropLeash()) {
                    this.z();
                } else {
                    this.A();
                }
            }
            return false;
        }
        return super.a(leashHolder, distance);
    }

    protected void x(boolean tamed) {
        ParticleType particleOptions = Particles.R;
        if (!tamed) {
            particleOptions = Particles.ag;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d22 = this.ae.k() * 0.02;
            this.dV().a(particleOptions, this.d(1.0), this.dD() + 0.5, this.g(1.0), d2, d1, d22);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 7) {
            this.x(true);
        } else if (id == 6) {
            this.x(false);
        } else {
            super.b(id);
        }
    }

    public boolean p() {
        return (this.al.a(bZ) & 4) != 0;
    }

    public void a(boolean tame, boolean applyTamingSideEffects) {
        byte b2 = this.al.a(bZ);
        if (tame) {
            this.al.a(bZ, (byte)(b2 | 4));
        } else {
            this.al.a(bZ, (byte)(b2 & 0xFFFFFFFB));
        }
        if (applyTamingSideEffects) {
            this.t();
        }
    }

    protected void t() {
    }

    public boolean x() {
        return (this.al.a(bZ) & 1) != 0;
    }

    public void y(boolean sitting) {
        this.setInSittingPose(sitting, true);
    }

    public void setInSittingPose(boolean sitting, boolean callEvent) {
        if (callEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        byte b2 = this.al.a(bZ);
        if (sitting) {
            this.al.a(bZ, (byte)(b2 | 1));
        } else {
            this.al.a(bZ, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public UUID aa_() {
        return this.al.a(ca).orElse(null);
    }

    public void b(@Nullable UUID uuid) {
        this.al.a(ca, Optional.ofNullable(uuid));
    }

    public void a(EntityHuman player) {
        this.a(true, true);
        this.b(player.cG());
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            CriterionTriggers.y.a(serverPlayer, this);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return !this.j(target) && super.c(target);
    }

    public boolean j(EntityLiving entity) {
        return entity == this.ag_();
    }

    public boolean a(EntityLiving target, EntityLiving owner) {
        return true;
    }

    @Override
    public ScoreboardTeam cr() {
        EntityLiving owner;
        if (this.p() && (owner = this.ag_()) != null) {
            return owner.cr();
        }
        return super.cr();
    }

    @Override
    protected boolean t(Entity entity) {
        if (this.p()) {
            EntityLiving owner = this.ag_();
            if (entity == owner) {
                return true;
            }
            if (owner != null) {
                return owner.t(entity);
            }
        }
        return super.t(entity);
    }

    @Override
    public void a(DamageSource cause) {
        WorldServer serverLevel;
        Object object = this.dV();
        if (object instanceof WorldServer && (serverLevel = (WorldServer)object).O().b(GameRules.n) && (object = this.ag_()) instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)object;
            TameableDeathMessageEvent event = new TameableDeathMessageEvent((Tameable)this.getBukkitEntity(), PaperAdventure.asAdventure(this.eQ().a()));
            if (event.callEvent()) {
                serverPlayer.a(PaperAdventure.asVanilla(event.deathMessage()));
            }
        }
        super.a(cause);
    }

    public boolean gs() {
        return this.cf;
    }

    public void z(boolean orderedToSit) {
        this.cf = orderedToSit;
    }

    public void gt() {
        EntityLiving owner = this.ag_();
        if (owner != null) {
            this.h(owner.dv());
        }
    }

    public boolean gu() {
        EntityLiving owner = this.ag_();
        return owner != null && this.g((Entity)this.ag_()) >= 144.0;
    }

    private void h(BlockPosition pos) {
        for (int i2 = 0; i2 < 10; ++i2) {
            int randomInt = this.ae.a(-3, 3);
            int randomInt1 = this.ae.a(-3, 3);
            if (Math.abs(randomInt) < 2 && Math.abs(randomInt1) < 2) continue;
            int randomInt2 = this.ae.a(-1, 1);
            if (!this.a(pos.u() + randomInt, pos.v() + randomInt2, pos.w() + randomInt1)) continue;
            return;
        }
    }

    private boolean a(int x2, int y2, int z2) {
        if (!this.i(new BlockPosition(x2, y2, z2))) {
            return false;
        }
        EntityTeleportEvent event = CraftEventFactory.callEntityTeleportEvent(this, (double)x2 + 0.5, y2, (double)z2 + 0.5);
        if (event.isCancelled() || event.getTo() == null) {
            return false;
        }
        Location to = event.getTo();
        this.b(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
        this.bR.m();
        return true;
    }

    private boolean i(BlockPosition pos) {
        PathType pathTypeStatic = PathfinderNormal.b(this, pos);
        if (pathTypeStatic != PathType.c) {
            return false;
        }
        IBlockData blockState = this.dV().a_(pos.e());
        if (!this.gw() && blockState.b() instanceof BlockLeaves) {
            return false;
        }
        BlockPosition blockPos = pos.b(this.dv());
        return this.dV().a((Entity)this, this.cR().a(blockPos));
    }

    public final boolean gv() {
        return this.gs() || this.bZ() || this.q() || this.ag_() != null && this.ag_().Z_();
    }

    protected boolean gw() {
        return false;
    }

    public class a
    extends PathfinderGoalPanic {
        public a(double speedModifier, TagKey<DamageType> panicCausingDamageTypes) {
            super((EntityCreature)EntityTameableAnimal.this, speedModifier, panicCausingDamageTypes);
        }

        public a(double speedModifier) {
            super(EntityTameableAnimal.this, speedModifier);
        }

        @Override
        public void a() {
            if (!EntityTameableAnimal.this.gv() && EntityTameableAnimal.this.gu()) {
                EntityTameableAnimal.this.gt();
            }
            super.a();
        }
    }
}

