/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.HeightMap;

public class EntityPositionTypes {
    private static final Map<EntityTypes<?>, a> a = Maps.newHashMap();

    private static <T extends EntityInsentient> void a(EntityTypes<T> entityType, SpawnPlacementType spawnPlacementType, HeightMap.Type heightmapType, b<T> predicate) {
        a data = a.put(entityType, new a(heightmapType, spawnPlacementType, predicate));
        if (data != null) {
            throw new IllegalStateException("Duplicate registration for type " + String.valueOf(BuiltInRegistries.f.b(entityType)));
        }
    }

    public static SpawnPlacementType a(EntityTypes<?> entityType) {
        a data = a.get(entityType);
        return data == null ? SpawnPlacementTypes.a : data.b;
    }

    public static boolean a(EntityTypes<?> entityType, IWorldReader level, BlockPosition pos) {
        return EntityPositionTypes.a(entityType).isSpawnPositionOk(level, pos, entityType);
    }

    public static HeightMap.Type b(@Nullable EntityTypes<?> entityType) {
        a data = a.get(entityType);
        return data == null ? HeightMap.Type.f : data.a;
    }

    public static <T extends Entity> boolean a(EntityTypes<T> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        a data = a.get(entityType);
        return data == null || data.c.test(entityType, level, spawnReason, pos, random);
    }

    static {
        EntityPositionTypes.a(EntityTypes.h, SpawnPlacementTypes.b, HeightMap.Type.f, Axolotl::a);
        EntityPositionTypes.a(EntityTypes.A, SpawnPlacementTypes.b, HeightMap.Type.f, EntityWaterAnimal::c);
        EntityPositionTypes.a(EntityTypes.H, SpawnPlacementTypes.b, HeightMap.Type.f, AgeableWaterCreature::b);
        EntityPositionTypes.a(EntityTypes.K, SpawnPlacementTypes.b, HeightMap.Type.f, EntityDrowned::a);
        EntityPositionTypes.a(EntityTypes.ai, SpawnPlacementTypes.b, HeightMap.Type.f, EntityGuardian::b);
        EntityPositionTypes.a(EntityTypes.aW, SpawnPlacementTypes.b, HeightMap.Type.f, EntityWaterAnimal::c);
        EntityPositionTypes.a(EntityTypes.aZ, SpawnPlacementTypes.b, HeightMap.Type.f, EntityWaterAnimal::c);
        EntityPositionTypes.a(EntityTypes.bq, SpawnPlacementTypes.b, HeightMap.Type.f, AgeableWaterCreature::b);
        EntityPositionTypes.a(EntityTypes.bz, SpawnPlacementTypes.b, HeightMap.Type.f, EntityTropicalFish::b);
        EntityPositionTypes.a(EntityTypes.e, SpawnPlacementTypes.d, HeightMap.Type.f, Armadillo::c);
        EntityPositionTypes.a(EntityTypes.k, SpawnPlacementTypes.d, HeightMap.Type.f, EntityBat::b);
        EntityPositionTypes.a(EntityTypes.o, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::c);
        EntityPositionTypes.a(EntityTypes.q, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.r, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::c);
        EntityPositionTypes.a(EntityTypes.v, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.z, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.C, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.E, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.I, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.N, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.O, SpawnPlacementTypes.d, HeightMap.Type.f, EntityEndermite::b);
        EntityPositionTypes.a(EntityTypes.P, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.ab, SpawnPlacementTypes.d, HeightMap.Type.f, Frog::c);
        EntityPositionTypes.a(EntityTypes.ad, SpawnPlacementTypes.d, HeightMap.Type.f, EntityGhast::b);
        EntityPositionTypes.a(EntityTypes.ae, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.ag, SpawnPlacementTypes.b, HeightMap.Type.f, GlowSquid::a);
        EntityPositionTypes.a(EntityTypes.ah, SpawnPlacementTypes.d, HeightMap.Type.f, Goat::c);
        EntityPositionTypes.a(EntityTypes.al, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.am, SpawnPlacementTypes.d, HeightMap.Type.f, EntityZombieHusk::a);
        EntityPositionTypes.a(EntityTypes.ap, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.ax, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.az, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMagmaCube::b);
        EntityPositionTypes.a(EntityTypes.aE, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMushroomCow::c);
        EntityPositionTypes.a(EntityTypes.aF, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.aI, SpawnPlacementTypes.d, HeightMap.Type.e, EntityOcelot::c);
        EntityPositionTypes.a(EntityTypes.aO, SpawnPlacementTypes.d, HeightMap.Type.e, EntityParrot::c);
        EntityPositionTypes.a(EntityTypes.aQ, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.aj, SpawnPlacementTypes.d, HeightMap.Type.f, EntityHoglin::c);
        EntityPositionTypes.a(EntityTypes.aR, SpawnPlacementTypes.d, HeightMap.Type.f, EntityPiglin::b);
        EntityPositionTypes.a(EntityTypes.aT, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonsterPatrolling::b);
        EntityPositionTypes.a(EntityTypes.aU, SpawnPlacementTypes.d, HeightMap.Type.f, EntityPolarBear::c);
        EntityPositionTypes.a(EntityTypes.aX, SpawnPlacementTypes.d, HeightMap.Type.f, EntityRabbit::c);
        EntityPositionTypes.a(EntityTypes.ba, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.bd, SpawnPlacementTypes.d, HeightMap.Type.f, EntitySilverfish::b);
        EntityPositionTypes.a(EntityTypes.be, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bf, SpawnPlacementTypes.d, HeightMap.Type.f, EntityHorseSkeleton::c);
        EntityPositionTypes.a(EntityTypes.bg, SpawnPlacementTypes.d, HeightMap.Type.f, EntitySlime::c);
        EntityPositionTypes.a(EntityTypes.bk, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.bn, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.br, SpawnPlacementTypes.d, HeightMap.Type.f, EntitySkeletonStray::a);
        EntityPositionTypes.a(EntityTypes.bs, SpawnPlacementTypes.c, HeightMap.Type.f, EntityStrider::c);
        EntityPositionTypes.a(EntityTypes.bA, SpawnPlacementTypes.d, HeightMap.Type.f, EntityTurtle::c);
        EntityPositionTypes.a(EntityTypes.bC, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.bH, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bI, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bJ, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bL, SpawnPlacementTypes.d, HeightMap.Type.f, EntityWolf::c);
        EntityPositionTypes.a(EntityTypes.bM, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::c);
        EntityPositionTypes.a(EntityTypes.D, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bN, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bO, SpawnPlacementTypes.d, HeightMap.Type.f, EntityHorseZombie::c);
        EntityPositionTypes.a(EntityTypes.bQ, SpawnPlacementTypes.d, HeightMap.Type.f, EntityPigZombie::b);
        EntityPositionTypes.a(EntityTypes.bP, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.u, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.M, SpawnPlacementTypes.b, HeightMap.Type.f, EntityGuardian::b);
        EntityPositionTypes.a(EntityTypes.S, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.aa, SpawnPlacementTypes.a, HeightMap.Type.f, EntityFox::c);
        EntityPositionTypes.a(EntityTypes.an, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.aN, SpawnPlacementTypes.a, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.aP, SpawnPlacementTypes.a, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.aY, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bb, SpawnPlacementTypes.a, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.bx, SpawnPlacementTypes.a, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.bB, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bD, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bE, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.bF, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::b);
    }

    record a(HeightMap.Type a, SpawnPlacementType b, b<?> c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "heightMap;placement;predicate", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "heightMap;placement;predicate", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "heightMap;placement;predicate", "a", "b", "c"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface b<T extends Entity> {
        public boolean test(EntityTypes<T> var1, WorldAccess var2, EntitySpawnReason var3, BlockPosition var4, RandomSource var5);
    }
}

