/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityEquipmentChangedEvent;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemShield;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "active_effects";
    private static final MinecraftKey c = MinecraftKey.b("powder_snow");
    private static final MinecraftKey d = MinecraftKey.b("sprinting");
    private static final AttributeModifier k = new AttributeModifier(d, 0.3f, AttributeModifier.Operation.c);
    public static final int l = 2;
    public static final int m = 4;
    public static final int n = 98;
    public static final int o = 100;
    public static final int p = 105;
    public static final int q = 6;
    public static final int r = 100;
    private static final int bG = 40;
    public static final double s = 0.003;
    public static final double t = 0.08;
    public static final int u = 20;
    private static final int bH = 10;
    private static final int bI = 2;
    public static final float ay = 0.42f;
    private static final double bJ = 128.0;
    protected static final int az = 1;
    protected static final int aA = 2;
    public static final int aB = 4;
    protected static final DataWatcherObject<Byte> aC = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> bK = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<List<ParticleParam>> bL = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> bM = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> bN = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bO = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bP = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.p);
    private static final int bQ = 15;
    protected static final EntitySize aD = EntitySize.c(0.2f, 0.2f).b(0.2f);
    public static final float aE = 0.5f;
    public static final float aF = 0.5f;
    public static final String aG = "attributes";
    public static final Predicate<EntityLiving> aH = entity -> {
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            ItemStack itemBySlot = player.a(EnumItemSlot.f);
            return !itemBySlot.a(TagsItem.cq);
        }
        return true;
    };
    private final AttributeMapBase bR;
    public CombatTracker bS = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> bT = Maps.newHashMap();
    private final NonNullList<ItemStack> bU = NonNullList.a(2, ItemStack.j);
    private final NonNullList<ItemStack> bV = NonNullList.a(4, ItemStack.j);
    private ItemStack bW = ItemStack.j;
    public boolean aI;
    private boolean bX = false;
    public EnumHand aJ;
    public int aK;
    public int aL;
    public int aM;
    public int aN;
    public int aO;
    public int aP;
    public float aQ;
    public float aR;
    protected int aS;
    public final WalkAnimationState aT = new WalkAnimationState();
    public int aU = 20;
    public final float aV;
    public final float aW;
    public float aX;
    public float aY;
    public float aZ;
    public float ba;
    public final ElytraAnimationState bb = new ElytraAnimationState(this);
    @Nullable
    public EntityHuman bc;
    public int bd;
    protected boolean be;
    protected int bf;
    protected float bg;
    protected float bh;
    protected float bi;
    protected float bj;
    protected float bk;
    public float bl;
    public boolean bm;
    public float bn;
    public float bo;
    public float bp;
    protected int bq;
    protected double br;
    protected double bs;
    protected double bt;
    protected double bu;
    protected double bv;
    protected double bw;
    protected int bx;
    public boolean bY = true;
    @Nullable
    public EntityLiving bZ;
    public int ca;
    @Nullable
    private EntityLiving cb;
    private int cc;
    private float cd;
    private int ce;
    private float cf;
    protected ItemStack by = ItemStack.j;
    public int bz;
    protected int bA;
    private BlockPosition cg;
    private Optional<BlockPosition> ch = Optional.empty();
    @Nullable
    private DamageSource ci;
    private long cj;
    protected int bB;
    protected float bC;
    @Nullable
    protected ItemStack bD;
    private float ck;
    private float cl;
    protected BehaviorController<?> bE;
    protected boolean cm;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> cn = new EnumMap(EnumItemSlot.class);
    protected float bF = 1.0f;
    public int expToDrop;
    public ArrayList<Entity.DefaultDrop> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EnumItemSlot> clearedEquipmentSlots = new HashSet<EnumItemSlot>();
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;
    public int shieldBlockingDelay;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    @Override
    public float getBukkitYaw() {
        return this.cA();
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> entityType, net.minecraft.world.level.World level) {
        super(entityType, level);
        this.shieldBlockingDelay = this.dV().paperConfig().misc.shieldBlockingDelay;
        this.bR = new AttributeMapBase(AttributeDefaults.a(entityType));
        this.craftAttributes = new CraftAttributeMap(this.bR);
        this.al.a(bK, Float.valueOf(this.eS()));
        this.I = true;
        this.aW = (float)((Math.random() + 1.0) * (double)0.01f);
        this.ay();
        this.aV = (float)Math.random() * 12398.0f;
        this.v((float)(Math.random() * 6.2831854820251465));
        this.aZ = this.dL();
        DynamicOpsNBT nbtOps = DynamicOpsNBT.a;
        this.bE = this.a(new Dynamic<NBTBase>(nbtOps, (NBTBase)nbtOps.createMap((Map)ImmutableMap.of((Object)nbtOps.a("memories"), (Object)((NBTBase)nbtOps.emptyMap())))));
    }

    public BehaviorController<?> eb() {
        return this.bE;
    }

    protected BehaviorController.b<?> ec() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.ec().a(dynamic);
    }

    @Override
    public void c(WorldServer level) {
        this.a(level, this.dW().y(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> entityType) {
        return true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(aC, (byte)0);
        builder.a(bL, List.of());
        builder.a(bM, false);
        builder.a(bN, 0);
        builder.a(bO, 0);
        builder.a(bK, Float.valueOf(1.0f));
        builder.a(bP, Optional.empty());
    }

    public static AttributeProvider.Builder ed() {
        return AttributeProvider.a().a(GenericAttributes.s).a(GenericAttributes.p).a(GenericAttributes.v).a(GenericAttributes.a).a(GenericAttributes.b).a(GenericAttributes.r).a(GenericAttributes.B).a(GenericAttributes.y).a(GenericAttributes.n).a(GenericAttributes.x).a(GenericAttributes.k).a(GenericAttributes.o).a(GenericAttributes.w).a(GenericAttributes.h).a(GenericAttributes.i).a(GenericAttributes.F).a(GenericAttributes.u).a(GenericAttributes.d);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        net.minecraft.world.level.World world;
        if (!this.bj()) {
            this.br();
        }
        if ((world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (onGround && this.Z > 0.0f) {
                this.b(serverLevel, pos);
                double attributeValue = this.h(GenericAttributes.x);
                if ((double)this.Z > attributeValue && !state.l()) {
                    double x2 = this.dA();
                    double y1 = this.dC();
                    double z2 = this.dG();
                    BlockPosition blockPos = this.dv();
                    if (pos.u() != blockPos.u() || pos.w() != blockPos.w()) {
                        double d2 = x2 - (double)pos.u() - 0.5;
                        double d1 = z2 - (double)pos.w() - 0.5;
                        double max = Math.max(Math.abs(d2), Math.abs(d1));
                        x2 = (double)pos.u() + 0.5 + d2 / max * 0.5;
                        z2 = (double)pos.w() + 0.5 + d1 / max * 0.5;
                    }
                    float f2 = MathHelper.c((double)this.Z - attributeValue);
                    double min = Math.min((double)(0.2f + f2 / 15.0f), 2.5);
                    int i2 = (int)(150.0 * min);
                    if (this instanceof EntityPlayer) {
                        serverLevel.sendParticlesSource((EntityPlayer)this, new ParticleParamBlock(Particles.b, state), false, false, x2, y1, z2, i2, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        serverLevel.a(new ParticleParamBlock(Particles.b, state), x2, y1, z2, i2, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                }
            }
        }
        super.a(y2, onGround, state, pos);
        if (onGround) {
            this.ch = Optional.empty();
        }
    }

    public final boolean ee() {
        return this.aq().a(TagsEntity.m);
    }

    public float a(float partialTicks) {
        return MathHelper.h(partialTicks, this.cl, this.ck);
    }

    public boolean ef() {
        return this.dy().b() < (double)1.0E-5f && this.bn();
    }

    @Override
    public void az() {
        net.minecraft.world.level.World world;
        this.aQ = this.aR;
        if (this.ak) {
            this.fP().ifPresent(this::a);
        }
        if ((world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            EnchantmentManager.b(serverLevel, this);
        }
        super.az();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("livingEntityBaseTick");
        if (this.bi() || this.dV().C) {
            this.aH();
        }
        if (this.bL()) {
            Object deltaMovement;
            double damagePerBlock;
            boolean flag = this instanceof EntityHuman;
            net.minecraft.world.level.World world2 = this.dV();
            if (world2 instanceof WorldServer) {
                double d2;
                WorldServer serverLevel1 = (WorldServer)world2;
                if (this.bM()) {
                    this.a(serverLevel1, this.dW().g(), 1.0f);
                } else if (flag && !this.dV().F_().a(this.cR()) && (d2 = this.dV().F_().a(this) + this.dV().F_().n()) < 0.0 && (damagePerBlock = this.dV().F_().o()) > 0.0) {
                    this.a(serverLevel1, this.dW().x(), (float)Math.max(1, MathHelper.a(-d2 * damagePerBlock)));
                }
            }
            if (((Entity)this).a(TagsFluid.a) && !this.dV().a_(BlockPosition.a(this.dA(), this.dE(), this.dG())).a(Blocks.nF)) {
                boolean flag1;
                boolean bl = flag1 = !this.ee() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).gj().a);
                if (flag1) {
                    this.j(this.l(this.ct()));
                    if (this.ct() == -20) {
                        this.j(0);
                        deltaMovement = this.dy();
                        for (int i2 = 0; i2 < 8; ++i2) {
                            damagePerBlock = this.ae.j() - this.ae.j();
                            double d1 = this.ae.j() - this.ae.j();
                            double d2 = this.ae.j() - this.ae.j();
                            this.dV().a(Particles.d, this.dA() + damagePerBlock, this.dC() + d1, this.dG() + d2, ((Vec3D)deltaMovement).d, ((Vec3D)deltaMovement).e, ((Vec3D)deltaMovement).f);
                        }
                        this.a(this.dW().i(), 2.0f);
                    }
                } else if (this.ct() < this.cs()) {
                    this.j(this.m(this.ct()));
                }
                if (!this.dV().C && this.bZ() && this.dk() != null && this.dk().cb()) {
                    this.ae();
                }
            } else if (this.ct() < this.cs()) {
                this.j(this.m(this.ct()));
            }
            deltaMovement = this.dV();
            if (deltaMovement instanceof WorldServer) {
                WorldServer serverLevel1x = (WorldServer)deltaMovement;
                BlockPosition blockPos = this.dv();
                if (!Objects.equal((Object)this.cg, (Object)blockPos)) {
                    this.cg = blockPos;
                    this.b(serverLevel1x, blockPos);
                }
            }
        }
        if (this.bL() && (this.bl() || this.av)) {
            this.aN();
        }
        if (this.aN > 0) {
            --this.aN;
        }
        if (this.aj > 0 && !(this instanceof EntityPlayer)) {
            --this.aj;
        }
        if (this.eE() && this.dV().h(this)) {
            this.el();
        }
        if (this.bd > 0) {
            --this.bd;
        } else {
            this.bc = null;
        }
        if (this.cb != null && !this.cb.bL()) {
            this.cb = null;
        }
        if (this.bZ != null) {
            if (!this.bZ.bL()) {
                this.a((EntityLiving)null);
            } else if (this.af - this.ca > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.ev();
        this.bj = this.bi;
        this.aY = this.aX;
        this.ba = this.aZ;
        this.N = this.dL();
        this.O = this.dN();
        profilerFiller.c();
    }

    @Override
    protected float aT() {
        return MathHelper.h((float)this.h(GenericAttributes.u), super.aT(), 1.0f);
    }

    protected void eg() {
        AttributeModifiable attribute = this.g(GenericAttributes.v);
        if (attribute != null && attribute.a(c) != null) {
            attribute.c(c);
        }
    }

    protected void eh() {
        int ticksFrozen;
        if (!this.bt().l() && (ticksFrozen = this.cu()) > 0) {
            AttributeModifiable attribute = this.g(GenericAttributes.v);
            if (attribute == null) {
                return;
            }
            float f2 = -0.05f * this.cv();
            attribute.b(new AttributeModifier(c, f2, AttributeModifier.Operation.a));
        }
    }

    protected void b(WorldServer level, BlockPosition pos) {
        EnchantmentManager.a(level, this);
    }

    public boolean e_() {
        return false;
    }

    public float ei() {
        return this.e_() ? 0.5f : 1.0f;
    }

    public final float ej() {
        AttributeMapBase attributes = this.eY();
        return attributes == null ? 1.0f : this.b((float)attributes.c(GenericAttributes.y));
    }

    protected float b(float scale) {
        return scale;
    }

    protected boolean ek() {
        return true;
    }

    protected void el() {
        ++this.aP;
        if (this.aP >= 20 && !this.dV().B_() && !this.dQ()) {
            this.dV().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean em() {
        return !this.e_();
    }

    protected boolean en() {
        return !this.e_();
    }

    protected int l(int currentAir) {
        AttributeModifiable attribute = this.g(GenericAttributes.w);
        double value = attribute != null ? attribute.g() : 0.0;
        return value > 0.0 && this.ae.j() >= 1.0 / (value + 1.0) ? currentAir : currentAir - 1;
    }

    protected int m(int currentAir) {
        return Math.min(currentAir + 4, this.cs());
    }

    public final int a(WorldServer level, @Nullable Entity killer) {
        return EnchantmentManager.a(level, killer, (Entity)this, this.e(level));
    }

    protected int e(WorldServer level) {
        return 0;
    }

    protected boolean eo() {
        return false;
    }

    @Nullable
    public EntityLiving ep() {
        return this.bZ;
    }

    @Override
    public EntityLiving am() {
        return this.ep();
    }

    public int eq() {
        return this.ca;
    }

    public void c(@Nullable EntityHuman player) {
        this.bc = player;
        this.bd = this.af;
    }

    public void a(@Nullable EntityLiving livingEntity) {
        this.bZ = livingEntity;
        this.ca = this.af;
    }

    @Nullable
    public EntityLiving er() {
        return this.cb;
    }

    public int es() {
        return this.cc;
    }

    public void B(Entity entity) {
        this.cb = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.cc = this.af;
    }

    public int et() {
        return this.bf;
    }

    public void n(int idleTime) {
        this.bf = idleTime;
    }

    public boolean eu() {
        return !this.frictionState.toBooleanOrElse(!this.bX);
    }

    public void r(boolean discardFriction) {
        this.bX = discardFriction;
    }

    protected boolean b(EnumItemSlot slot) {
        return true;
    }

    public void a(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem) {
        this.onEquipItem(slot, oldItem, newItem, false);
    }

    public void onEquipItem(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem, boolean silent) {
        if (!this.dV().B_() && !this.Z_()) {
            boolean flag;
            boolean bl = flag = newItem.f() && oldItem.f();
            if (!(flag || ItemStack.c(oldItem, newItem) || this.ak)) {
                Equippable equippable = newItem.a(DataComponents.D);
                if (!this.bb() && equippable != null && slot == equippable.a() && !silent) {
                    this.dV().a(null, this.dA(), this.dC(), this.dG(), equippable.b(), this.dm(), 1.0f, 1.0f, this.ae.g());
                }
                if (this.b(slot)) {
                    ((Entity)this).a(equippable != null ? GameEvent.v : GameEvent.S);
                }
            }
        }
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason reason, EntityRemoveEvent.Cause eventCause) {
        net.minecraft.world.level.World world;
        if ((reason == Entity.RemovalReason.a || reason == Entity.RemovalReason.b) && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, reason);
        }
        super.remove(reason, eventCause);
        this.bE.a();
    }

    protected void a(WorldServer level, Entity.RemovalReason removalReason) {
        for (MobEffect mobEffectInstance : this.eA()) {
            mobEffectInstance.a(level, this, removalReason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.bT.clear();
    }

    @Override
    public void b(NBTTagCompound compound) {
        if (this.frictionState != TriState.NOT_SET) {
            compound.a("Paper.FrictionState", this.frictionState.toString());
        }
        compound.a("Health", this.eD());
        compound.a("HurtTime", (short)this.aN);
        compound.a("HurtByTimestamp", this.ca);
        compound.a("DeathTime", (short)this.aP);
        compound.a("AbsorptionAmount", this.fw());
        compound.a(aG, this.eY().d());
        if (!this.bT.isEmpty()) {
            NBTTagList listTag = new NBTTagList();
            for (MobEffect mobEffectInstance : this.bT.values()) {
                listTag.add(mobEffectInstance.j());
            }
            compound.a(b, listTag);
        }
        compound.a("FallFlying", this.fJ());
        this.fP().ifPresent(pos -> {
            compound.a("SleepingX", pos.u());
            compound.a("SleepingY", pos.v());
            compound.a("SleepingZ", pos.w());
        });
        DataResult<NBTBase> dataResult = this.bE.a(DynamicOpsNBT.a);
        dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(brain -> compound.a("Brain", (NBTBase)brain));
    }

    @Override
    public void a(NBTTagCompound compound) {
        float absorptionAmount = compound.j("AbsorptionAmount");
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.F(absorptionAmount);
        if (compound.e("Paper.FrictionState")) {
            String frictionState = compound.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)frictionState);
            }
            catch (Exception ignored) {
                a.error("Unknown friction state " + frictionState + " for " + String.valueOf(this));
            }
        }
        if (compound.b(aG, 9) && this.dV() != null && !this.dV().C) {
            this.eY().a(compound.c(aG, 10));
        }
        if (compound.b(b, 9)) {
            NBTTagList list = compound.c(b, 10);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                NBTTagCompound compound1 = list.a(i2);
                MobEffect mobEffectInstance = MobEffect.a(compound1);
                if (mobEffectInstance == null) continue;
                this.bT.put(mobEffectInstance.c(), mobEffectInstance);
            }
        }
        if (compound.e("Bukkit.MaxHealth")) {
            NBTBase maxHealthTag = compound.c("Bukkit.MaxHealth");
            if (maxHealthTag.b() == 5) {
                this.g(GenericAttributes.s).a(((NBTTagFloat)maxHealthTag).j());
            } else if (maxHealthTag.b() == 3) {
                this.g(GenericAttributes.s).a(((NBTTagInt)maxHealthTag).j());
            }
        }
        if (compound.b("Health", 99)) {
            this.x(compound.j("Health"));
        }
        this.aN = compound.g("HurtTime");
        this.aP = compound.g("DeathTime");
        this.ca = compound.h("HurtByTimestamp");
        if (compound.b("Team", 8)) {
            boolean flag;
            String string = compound.l("Team");
            Scoreboard scoreboard = this.dV().R();
            ScoreboardTeam playerTeam = scoreboard.b(string);
            if (!this.dV().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
                playerTeam = null;
            }
            boolean bl = flag = playerTeam != null && scoreboard.a(this.cH(), playerTeam);
            if (!flag) {
                a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)string);
            }
        }
        if (compound.q("FallFlying")) {
            this.b(7, true);
        }
        if (compound.b("SleepingX", 99) && compound.b("SleepingY", 99) && compound.b("SleepingZ", 99)) {
            BlockPosition blockPos = new BlockPosition(compound.h("SleepingX"), compound.h("SleepingY"), compound.h("SleepingZ"));
            if (this.dt().c(blockPos.u(), blockPos.v(), blockPos.w()) < 256.0) {
                this.g(blockPos);
                this.al.a(Entity.aq, EntityPose.c);
                if (!this.ak) {
                    this.a(blockPos);
                }
            }
        }
        if (compound.b("Brain", 10)) {
            this.bE = this.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, compound.c("Brain")));
        }
    }

    protected void ev() {
        List<ParticleParam> list;
        Iterator<Holder<MobEffectList>> iterator = this.bT.keySet().iterator();
        this.isTickingEffects = true;
        try {
            while (iterator.hasNext()) {
                Holder<MobEffectList> holder = iterator.next();
                MobEffect mobEffectInstance = this.bT.get(holder);
                if (!mobEffectInstance.a(this, () -> this.a(mobEffectInstance, true, null))) {
                    EntityPotionEffectEvent event;
                    if (this.dV().C || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.c(List.of(mobEffectInstance));
                    continue;
                }
                if (mobEffectInstance.d() % 600 != 0) continue;
                this.a(mobEffectInstance, false, null);
            }
        }
        catch (ConcurrentModificationException holder) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (ProcessableEffect effect : this.effectsToProcess) {
            if (effect.effect != null) {
                this.addEffect(effect.effect, effect.cause);
                continue;
            }
            this.removeEffect(effect.type, effect.cause);
        }
        this.effectsToProcess.clear();
        if (this.bY) {
            if (!this.dV().C) {
                this.K();
                this.u();
            }
            this.bY = false;
        }
        if (!(list = this.al.a(bL)).isEmpty()) {
            int i1;
            boolean flag = this.al.a(bM);
            int i2 = this.cp() ? 15 : 4;
            int n2 = i1 = flag ? 5 : 1;
            if (this.ae.a(i2 * i1) == 0) {
                this.dV().a(SystemUtils.a(list, this.ae), this.d(0.5), this.dD(), this.g(0.5), 1.0, 1.0, 1.0);
            }
        }
    }

    protected void K() {
        if (this.bT.isEmpty()) {
            this.ey();
            this.k(false);
        } else {
            this.k(this.b(MobEffects.n));
            this.m();
        }
    }

    private void m() {
        List<ParticleParam> list = this.bT.values().stream().filter(MobEffect::g).map(MobEffect::a).toList();
        this.al.a(bL, list);
        this.al.a(bM, EntityLiving.d(this.bT.values()));
    }

    private void u() {
        boolean isCurrentlyGlowing = this.co();
        if (this.i(6) != isCurrentlyGlowing) {
            this.b(6, isCurrentlyGlowing);
        }
    }

    public double C(@Nullable Entity lookingEntity) {
        double d2 = 1.0;
        if (this.cg()) {
            d2 *= 0.8;
        }
        if (this.cp()) {
            float armorCoverPercentage = this.ff();
            if (armorCoverPercentage < 0.1f) {
                armorCoverPercentage = 0.1f;
            }
            d2 *= 0.7 * (double)armorCoverPercentage;
        }
        if (lookingEntity != null) {
            ItemStack itemBySlot = this.a(EnumItemSlot.f);
            EntityTypes<?> type = lookingEntity.aq();
            if (type == EntityTypes.be && itemBySlot.a(Items.vk) || type == EntityTypes.bN && itemBySlot.a(Items.vn) || type == EntityTypes.aR && itemBySlot.a(Items.vq) || type == EntityTypes.aS && itemBySlot.a(Items.vq) || type == EntityTypes.E && itemBySlot.a(Items.vo)) {
                d2 *= 0.5;
            }
        }
        return d2;
    }

    public boolean c(EntityLiving target) {
        return (!(target instanceof EntityHuman) || this.dV().am() != EnumDifficulty.a) && target.ew();
    }

    public boolean ew() {
        return !this.cC() && this.ex();
    }

    public boolean ex() {
        return !this.Z_() && this.bL();
    }

    public static boolean d(Collection<MobEffect> potionEffects) {
        for (MobEffect mobEffectInstance : potionEffects) {
            if (!mobEffectInstance.g() || mobEffectInstance.f()) continue;
            return false;
        }
        return true;
    }

    protected void ey() {
        this.al.a(bL, List.of());
    }

    public boolean ez() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.dV().C) {
            return false;
        }
        if (this.bT.isEmpty()) {
            return false;
        }
        LinkedList<MobEffect> toRemove = new LinkedList<MobEffect>();
        Iterator<MobEffect> iterator = this.bT.values().iterator();
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.c(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffect> eA() {
        return this.bT.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> eB() {
        return this.bT;
    }

    public boolean b(Holder<MobEffectList> effect) {
        return this.bT.containsKey(effect);
    }

    @Nullable
    public MobEffect c(Holder<MobEffectList> effect) {
        return this.bT.get(effect);
    }

    public final boolean a(MobEffect effectInstance) {
        return this.b(effectInstance, (Entity)null);
    }

    public boolean addEffect(MobEffect effectInstance, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, null, cause);
    }

    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return this.addEffect(effectInstance, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, entity, cause, true);
    }

    public boolean addEffect(MobEffect effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause, boolean fireEvent) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effectInstance, cause));
            return true;
        }
        if (!this.b(effectInstance)) {
            return false;
        }
        MobEffect mobEffectInstance = this.bT.get(effectInstance.c());
        boolean flag = false;
        boolean override = false;
        if (mobEffectInstance != null) {
            override = new MobEffect(mobEffectInstance).b(effectInstance);
        }
        if (fireEvent) {
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, effectInstance, cause, override);
            override = event.isOverride();
            if (event.isCancelled()) {
                return false;
            }
        }
        if (mobEffectInstance == null) {
            this.bT.put(effectInstance.c(), effectInstance);
            this.a(effectInstance, entity);
            flag = true;
            effectInstance.b(this);
        } else if (override) {
            mobEffectInstance.b(effectInstance);
            this.a(mobEffectInstance, true, entity);
            flag = true;
        }
        effectInstance.a(this);
        return flag;
    }

    public boolean b(MobEffect effectInstance) {
        if (this.aq().a(TagsEntity.G)) {
            return !effectInstance.a(MobEffects.M);
        }
        return this.aq().a(TagsEntity.F) ? !effectInstance.a(MobEffects.L) : !this.aq().a(TagsEntity.w) || !effectInstance.a(MobEffects.j) && !effectInstance.a(MobEffects.s);
    }

    public void c(MobEffect instance, @Nullable Entity entity) {
        if (this.b(instance)) {
            MobEffect mobEffectInstance = this.bT.put(instance.c(), instance);
            if (mobEffectInstance == null) {
                this.a(instance, entity);
            } else {
                instance.d(mobEffectInstance);
                this.a(instance, true, entity);
            }
        }
    }

    public boolean eC() {
        return this.aq().a(TagsEntity.x);
    }

    @Nullable
    public MobEffect d(Holder<MobEffectList> effect) {
        return this.removeEffectNoUpdate(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect removeEffectNoUpdate(Holder<MobEffectList> effect, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effect, cause));
            return null;
        }
        MobEffect effectInstance = this.bT.get(effect);
        if (effectInstance == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effectInstance, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.bT.remove(effect);
    }

    public boolean e(Holder<MobEffectList> effect) {
        return this.removeEffect(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> effect, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobEffectInstance = this.removeEffectNoUpdate(effect, cause);
        if (mobEffectInstance != null) {
            this.c(List.of(mobEffectInstance));
            return true;
        }
        return false;
    }

    protected void a(MobEffect effectInstance, @Nullable Entity entity) {
        this.bY = true;
        if (!this.dV().C) {
            effectInstance.c().a().a(this.eY(), effectInstance.e());
            this.c(effectInstance);
        }
    }

    public void c(MobEffect effectInstance) {
        for (Entity entity : this.cY()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            serverPlayer.f.b(new PacketPlayOutEntityEffect(this.ar(), effectInstance, false));
        }
    }

    protected void a(MobEffect effectInstance, boolean forced, @Nullable Entity entity) {
        this.bY = true;
        if (forced && !this.dV().C) {
            MobEffectList mobEffect = effectInstance.c().a();
            mobEffect.a(this.eY());
            mobEffect.a(this.eY(), effectInstance.e());
            this.E();
        }
        if (!this.dV().C) {
            this.c(effectInstance);
        }
    }

    protected void c(Collection<MobEffect> effects) {
        this.bY = true;
        if (!this.dV().C) {
            for (MobEffect mobEffectInstance : effects) {
                mobEffectInstance.c().a().a(this.eY());
                for (Entity entity : this.cY()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer serverPlayer = (EntityPlayer)entity;
                    serverPlayer.f.b(new PacketPlayOutRemoveEntityEffect(this.ar(), mobEffectInstance.c()));
                }
            }
            this.E();
        }
    }

    private void E() {
        Set<AttributeModifiable> attributesToUpdate = this.eY().b();
        for (AttributeModifiable attributeInstance : attributesToUpdate) {
            this.f(attributeInstance.a());
        }
        attributesToUpdate.clear();
    }

    protected void f(Holder<AttributeBase> attribute) {
        if (attribute.a(GenericAttributes.s)) {
            float maxHealth = this.eS();
            if (this.eD() > maxHealth) {
                this.x(maxHealth);
            }
        } else if (attribute.a(GenericAttributes.r)) {
            float maxHealth = this.eT();
            if (this.fw() > maxHealth) {
                this.E(maxHealth);
            }
        }
    }

    public void c(float healAmount) {
        this.heal(healAmount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float healAmount, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(healAmount, regainReason, false);
    }

    public void heal(float healAmount, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float health = this.eD();
        if (health > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)healAmount, regainReason, isFastRegen);
            if (this.valid) {
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.x((float)((double)this.eD() + event.getAmount()));
            }
        }
    }

    public float eD() {
        EntityLiving entityLiving = this;
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
            return (float)serverPlayer.getBukkitEntity().getHealth();
        }
        return this.al.a(bK).floatValue();
    }

    public void x(float health) {
        if (Float.isNaN(health)) {
            health = this.eS();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.cI() + " had NaN health set");
            }
        }
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.al.a(bK, Float.valueOf(MathHelper.a(health, 0.0f, this.eS())));
    }

    public boolean eE() {
        return this.eD() <= 0.0f;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag2;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.dQ() || this.be || this.eD() <= 0.0f) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.i) && this.b(MobEffects.l)) {
            return false;
        }
        if (this.fR()) {
            this.fS();
        }
        this.bf = 0;
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        float f2 = amount;
        float originalAmount = amount;
        boolean flag = amount > 0.0f && this.i(damageSource);
        float f1 = 0.0f;
        this.aT.a(1.5f);
        if (Float.isNaN(amount) || Float.isInfinite(amount)) {
            amount = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.aj > (float)this.aU / 2.0f && !damageSource.a(DamageTypeTags.e)) {
            if (amount <= this.bl) {
                return false;
            }
            event = this.handleEntityDamage(damageSource, amount, this.bl);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originalAmount == 0.0f) {
                return false;
            }
            this.bl = amount;
            flag1 = false;
        } else {
            event = this.handleEntityDamage(damageSource, amount, 0.0f);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originalAmount == 0.0f) {
                return false;
            }
            this.bl = amount;
            this.aj = this.aU;
            this.aN = this.aO = 10;
        }
        this.f(damageSource);
        this.g(damageSource);
        if (flag1) {
            if (flag) {
                level.a((Entity)this, (byte)29);
            } else {
                level.a((Entity)this, damageSource);
            }
            if (!damageSource.a(DamageTypeTags.r) && !flag) {
                this.bD();
            }
            if (!damageSource.a(DamageTypeTags.z)) {
                double d2 = 0.0;
                double d1 = 0.0;
                Entity entity2 = damageSource.c();
                if (entity2 instanceof IProjectile) {
                    IProjectile projectile = (IProjectile)entity2;
                    DoubleDoubleImmutablePair doubleDoubleImmutablePair = projectile.a_(this, damageSource);
                    d2 = -doubleDoubleImmutablePair.leftDouble();
                    d1 = -doubleDoubleImmutablePair.rightDouble();
                } else if (damageSource.i() != null) {
                    d2 = damageSource.i().a() - this.dA();
                    d1 = damageSource.i().c() - this.dG();
                }
                if (Math.abs(d2) > 200.0) {
                    d2 = Math.random() - Math.random();
                }
                if (Math.abs(d1) > 200.0) {
                    d1 = Math.random() - Math.random();
                }
                this.knockback(0.4f, d2, d1, damageSource.c(), damageSource.c() == null ? EntityKnockbackEvent.Cause.DAMAGE : EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d2, d1);
                }
            }
        }
        if (this.eE()) {
            if (!this.j(damageSource)) {
                this.silentDeath = !flag1;
                this.a(damageSource);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.h(damageSource);
        }
        boolean bl = flag2 = !flag;
        if (flag2) {
            this.ci = damageSource;
            this.cj = this.dV().ad();
            for (MobEffect mobEffectInstance : this.eA()) {
                mobEffectInstance.a(level, this, damageSource, amount);
            }
        }
        if ((entity = this) instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            CriterionTriggers.i.a(serverPlayer, damageSource, f2, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                serverPlayer.a(StatisticList.K, Math.round(f1 * 10.0f));
            }
        }
        if ((entity = damageSource.d()) instanceof EntityPlayer) {
            EntityPlayer serverPlayerx = (EntityPlayer)entity;
            CriterionTriggers.h.a(serverPlayerx, this, damageSource, f2, amount, flag);
        }
        return flag2;
    }

    protected void f(DamageSource damageSource) {
        Entity entity = damageSource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            if (!(damageSource.a(DamageTypeTags.q) || damageSource.a(DamageTypes.I) && this.aq().a(TagsEntity.E))) {
                this.a(livingEntity);
            }
        }
    }

    @Nullable
    protected EntityHuman g(DamageSource damageSource) {
        EntityWolf wolf;
        Entity entity = damageSource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            this.bd = 100;
            this.bc = player;
            return player;
        }
        if (entity instanceof EntityWolf && (wolf = (EntityWolf)entity).p()) {
            EntityHuman player1;
            this.bd = 100;
            EntityLiving entityLiving = wolf.ag_();
            this.bc = entityLiving instanceof EntityHuman ? (player1 = (EntityHuman)entityLiving) : null;
            return this.bc;
        }
        return null;
    }

    private float computeAmountFromEntityDamageEvent(EntityDamageEvent event) {
        float amount = 0.0f;
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        return amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
    }

    protected void d(EntityLiving attacker) {
        attacker.e(this);
    }

    protected void e(EntityLiving defender) {
        defender.knockback(0.5, defender.dA() - this.dA(), defender.dG() - this.dG(), this, EntityKnockbackEvent.Cause.SHIELD_BLOCK);
    }

    private boolean j(DamageSource damageSource) {
        if (damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemStack = null;
        DeathProtection deathProtection = null;
        EnumHand hand = null;
        ItemStack itemInHand = ItemStack.j;
        for (EnumHand interactionHand : EnumHand.values()) {
            itemInHand = this.b(interactionHand);
            deathProtection = itemInHand.a(DataComponents.H);
            if (deathProtection == null) continue;
            hand = interactionHand;
            itemStack = itemInHand.v();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemStack == null);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            deathProtection = null;
        } else {
            EntityLiving entityLiving;
            if (!itemInHand.f() && itemStack != null) {
                itemInHand.h(1);
            }
            if (deathProtection == null) {
                deathProtection = DeathProtection.c;
            }
            if (itemStack != null && (entityLiving = this) instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                serverPlayer.b(StatisticList.c.b(itemStack.h()));
                CriterionTriggers.C.a(serverPlayer, itemStack);
                ((Entity)this).a(GameEvent.C);
            }
            this.x(1.0f);
            deathProtection.a(itemStack, this);
            this.dV().a((Entity)this, (byte)35);
        }
        return deathProtection != null;
    }

    @Nullable
    public DamageSource eF() {
        if (this.dV().ad() - this.cj > 40L) {
            this.ci = null;
        }
        return this.ci;
    }

    protected void h(DamageSource source) {
        this.b(this.e(source));
    }

    public void b(@Nullable SoundEffect sound) {
        if (sound != null) {
            this.a(sound, this.fg(), this.fh());
        }
    }

    public boolean i(DamageSource damageSource) {
        Vec3D sourcePosition;
        EntityArrow abstractArrow;
        Entity directEntity = damageSource.c();
        boolean flag = false;
        if (directEntity instanceof EntityArrow && (abstractArrow = (EntityArrow)directEntity).z() > 0) {
            flag = true;
        }
        ItemStack itemBlockingWith = this.fH();
        if (!damageSource.a(DamageTypeTags.c) && itemBlockingWith != null && itemBlockingWith.h() instanceof ItemShield && !flag && (sourcePosition = damageSource.i()) != null) {
            Vec3D vec3 = this.d(0.0f, this.cA());
            Vec3D vec31 = sourcePosition.a(this.dt());
            vec31 = new Vec3D(vec31.d, 0.0, vec31.f).d();
            return vec31.b(vec3) < 0.0;
        }
        return false;
    }

    private void g(ItemStack stack) {
        if (!stack.f()) {
            if (!this.bb()) {
                this.dV().a(this.dA(), this.dC(), this.dG(), stack.N(), this.dm(), 0.8f, 0.8f + this.dV().A.i() * 0.4f, false);
            }
            this.b(stack, 5);
        }
    }

    public void a(DamageSource damageSource) {
        if (!this.dQ() && !this.be) {
            Entity entity = damageSource.d();
            EntityLiving killCredit = this.eR();
            this.be = true;
            net.minecraft.world.level.World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                EntityDeathEvent deathEvent = this.dropAllDeathLoot(serverLevel, damageSource);
                if (deathEvent == null || !deathEvent.isCancelled()) {
                    if (this instanceof EntityInsentient) {
                        for (EnumItemSlot slot : this.clearedEquipmentSlots) {
                            this.a(slot, ItemStack.j);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.fR()) {
                        this.fS();
                    }
                    if (!this.dV().C && this.l_() && SpigotConfig.logNamedDeaths) {
                        a.info("Named entity {} died: {}", (Object)this, (Object)this.eQ().a().getString());
                    }
                    this.eQ().c();
                    if (entity != null) {
                        entity.a((WorldServer)this.dV(), this);
                    }
                    ((Entity)this).a(GameEvent.p);
                } else {
                    this.be = false;
                    this.x((float)deathEvent.getReviveHealth());
                }
                this.f(killCredit);
            }
            if (this.be) {
                this.dV().a((Entity)this, (byte)3);
                this.b(EntityPose.h);
            }
        }
    }

    protected void f(@Nullable EntityLiving entitySource) {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            boolean var6 = false;
            if (this.be && entitySource instanceof EntityWither) {
                if (serverLevel.O().b(GameRules.c)) {
                    BlockPosition blockPos = this.dv();
                    IBlockData blockState = Blocks.ck.m();
                    if (this.dV().a_(blockPos).l() && blockState.a((IWorldReader)this.dV(), blockPos)) {
                        var6 = CraftEventFactory.handleBlockFormEvent(this.dV(), blockPos, blockState, 3, this);
                    }
                }
                if (!var6) {
                    EntityItem itemEntity = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), new ItemStack(Items.dF));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.dV().b(itemEntity);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(WorldServer level, DamageSource damageSource) {
        boolean flag = this.bd > 0;
        this.f(level);
        if (this.en() && level.O().b(GameRules.f)) {
            this.b(level, damageSource, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.a(level, damageSource, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, damageSource, this.drops, () -> {
            EntityLiving entityliving = this.eR();
            if (entityliving != null) {
                entityliving.a((Entity)this, damageSource);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList();
        this.b(level, damageSource.d());
        return deathEvent;
    }

    protected void f(WorldServer level) {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward(WorldServer level, @Nullable Entity entity) {
        if (!this.eI() && (this.eo() || this.bd > 0 && this.em() && level.O().b(GameRules.f))) {
            return this.a(level, entity);
        }
        return 0;
    }

    protected void b(WorldServer level, @Nullable Entity entity) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.award(level, this.dt(), this.expToDrop, this instanceof EntityPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, entity, this);
            this.expToDrop = 0;
        }
    }

    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
    }

    public long eG() {
        return 0L;
    }

    protected float b(Entity attacker, DamageSource damageSource) {
        float f2;
        float f3 = (float)this.h(GenericAttributes.d);
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            f2 = EnchantmentManager.d(serverLevel, this.dZ(), attacker, damageSource, f3);
        } else {
            f2 = f3;
        }
        return f2;
    }

    protected void b(WorldServer level, DamageSource damageSource, boolean playerKill) {
        Optional<ResourceKey<LootTable>> lootTable = this.ea();
        if (!lootTable.isEmpty()) {
            LootTable lootTable1 = level.p().bc().b(lootTable.get());
            LootParams.a builder = new LootParams.a(level).a(LootContextParameters.a, this).a(LootContextParameters.f, this.dt()).a(LootContextParameters.c, damageSource).b(LootContextParameters.d, damageSource.d()).b(LootContextParameters.e, damageSource.c());
            if (playerKill && this.bc != null) {
                builder = builder.a(LootContextParameters.b, this.bc).a(this.bc.gF());
            }
            LootParams lootParams = builder.a(LootContextParameterSets.g);
            lootTable1.a(lootParams, this.eG(), (ItemStack stack) -> this.a(level, (ItemStack)stack));
        }
    }

    public boolean a(WorldServer level, ResourceKey<LootTable> lootTable, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        return this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.f, this.dt()).a(LootContextParameters.a, this).a(LootContextParameterSets.j), dropConsumer);
    }

    protected void a(WorldServer level, ResourceKey<LootTable> lootTable, ItemStack shears, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.f, this.dt()).a(LootContextParameters.a, this).a(LootContextParameters.i, shears).a(LootContextParameterSets.s), dropConsumer);
    }

    protected boolean a(WorldServer level, ResourceKey<LootTable> lootTable, Function<LootParams.a, LootParams> paramsBuilder, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        LootParams lootParams;
        LootTable lootTable1 = level.p().bc().b(lootTable);
        ObjectArrayList<ItemStack> randomItems = lootTable1.a(lootParams = paramsBuilder.apply(new LootParams.a(level)));
        if (!randomItems.isEmpty()) {
            randomItems.forEach(stack -> dropConsumer.accept(level, (ItemStack)stack));
            return true;
        }
        return false;
    }

    public void p(double strength, double x2, double z2) {
        this.knockback(strength, x2, z2, null, EntityKnockbackEvent.Cause.UNKNOWN);
    }

    public void knockback(double strength, double x2, double z2, @Nullable Entity attacker, EntityKnockbackEvent.Cause eventCause) {
        strength *= 1.0 - this.h(GenericAttributes.p);
        Vec3D deltaMovement = this.dy();
        while (x2 * x2 + z2 * z2 < (double)1.0E-5f) {
            x2 = (Math.random() - Math.random()) * 0.01;
            z2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3D vec3 = new Vec3D(x2, 0.0, z2).d().c(strength);
        Vec3D finalVelocity = new Vec3D(deltaMovement.d / 2.0 - vec3.d, this.aJ() ? Math.min(0.4, deltaMovement.e / 2.0 + strength) : deltaMovement.e, deltaMovement.f / 2.0 - vec3.f);
        Vec3D diff = finalVelocity.d(deltaMovement);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, attacker, eventCause, strength, diff);
        if (event.isCancelled()) {
            return;
        }
        this.ar = true;
        this.i(deltaMovement.b(event.getKnockback().getX(), event.getKnockback().getY(), event.getKnockback().getZ()));
    }

    public void a(double xDistance, double zDistance) {
    }

    @Nullable
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.kG;
    }

    @Nullable
    public SoundEffect o_() {
        return SoundEffects.kB;
    }

    private SoundEffect q(int height) {
        return height > 4 ? this.eM().b() : this.eM().a();
    }

    public void eH() {
        this.cm = true;
    }

    public boolean eI() {
        return this.cm;
    }

    public float eJ() {
        return 0.0f;
    }

    protected AxisAlignedBB eK() {
        AxisAlignedBB boundingBox = this.cR();
        Entity vehicle = this.dk();
        if (vehicle != null) {
            Vec3D passengerRidingPosition = vehicle.m(this);
            return boundingBox.b(Math.max(passengerRidingPosition.e, boundingBox.b));
        }
        return boundingBox;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> c(EnumItemSlot slot) {
        return (Map)this.cn.computeIfAbsent(slot, equipmentSlot -> new Reference2ObjectArrayMap());
    }

    public boolean eL() {
        return true;
    }

    public a eM() {
        return new a(SoundEffects.kH, SoundEffects.kz);
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.e(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.o_();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.q(fallHeight);
    }

    public Optional<BlockPosition> eN() {
        return this.ch;
    }

    public boolean q_() {
        if (this.Z_()) {
            return false;
        }
        BlockPosition blockPos = this.dv();
        IBlockData inBlockState = this.dw();
        if (inBlockState.a(TagsBlock.aS)) {
            this.ch = Optional.of(blockPos);
            return true;
        }
        if (inBlockState.b() instanceof BlockTrapdoor && this.c(blockPos, inBlockState)) {
            this.ch = Optional.of(blockPos);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition pos, IBlockData state) {
        if (!state.c(BlockTrapdoor.b).booleanValue()) {
            return false;
        }
        IBlockData blockState = this.dV().a_(pos.e());
        return blockState.a(Blocks.cX) && blockState.c(BlockLadder.b) == state.c(BlockFacingHorizontal.aF);
    }

    @Override
    public boolean bL() {
        return !this.dQ() && this.eD() > 0.0f && !this.be;
    }

    public boolean a(EntityLiving entity, double tolerance, boolean scaleByDistance, boolean visual, double ... yValues) {
        Vec3D vec3 = entity.g(1.0f).d();
        for (double d2 : yValues) {
            Vec3D vec31 = new Vec3D(this.dA() - entity.dA(), d2 - entity.dE(), this.dG() - entity.dG());
            double len = vec31.g();
            vec31 = vec31.d();
            double d1 = vec3.b(vec31);
            double d3 = scaleByDistance ? len : 1.0;
            if (!(d1 > 1.0 - tolerance / d3) || !entity.a(this, visual ? RayTrace.BlockCollisionOption.c : RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, d2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cE() {
        return this.y(0.0f);
    }

    protected final int y(float health) {
        return MathHelper.d(health + 3.0f);
    }

    @Override
    public boolean a(float fallDistance, float multiplier, DamageSource source) {
        boolean flag = super.a(fallDistance, multiplier, source);
        int i2 = this.f(fallDistance, multiplier);
        if (i2 > 0) {
            if (!this.a((WorldServer)this.dV(), source, (float)i2)) {
                return true;
            }
            this.a(this.q(i2), 1.0f, 1.0f);
            this.eO();
            return true;
        }
        return flag;
    }

    protected int f(float fallDistance, float damageMultiplier) {
        if (this.aq().a(TagsEntity.o)) {
            return 0;
        }
        float f2 = (float)this.h(GenericAttributes.x);
        float f1 = fallDistance - f2;
        return MathHelper.c((double)(f1 * damageMultiplier) * this.h(GenericAttributes.k));
    }

    protected void eO() {
        if (!this.bb()) {
            int floor = MathHelper.a(this.dA());
            int floor1 = MathHelper.a(this.dC() - (double)0.2f);
            int floor2 = MathHelper.a(this.dG());
            IBlockData blockState = this.dV().a_(new BlockPosition(floor, floor1, floor2));
            if (!blockState.l()) {
                SoundEffectType soundType = blockState.A();
                this.a(soundType.g(), soundType.a() * 0.5f, soundType.b() * 0.75f);
            }
        }
    }

    @Override
    public void p(float yaw) {
        this.aN = this.aO = 10;
    }

    public int eP() {
        return MathHelper.a(this.h(GenericAttributes.a));
    }

    protected void c(DamageSource damageSource, float damageAmount) {
    }

    protected void d(DamageSource damageSource, float damageAmount) {
    }

    protected void z(float damageAmount) {
    }

    protected void a(DamageSource damageSource, float damageAmount, EnumItemSlot ... slots) {
        if (!(damageAmount <= 0.0f)) {
            int i2 = (int)Math.max(1.0f, damageAmount / 4.0f);
            for (EnumItemSlot equipmentSlot : slots) {
                ItemStack itemBySlot = this.a(equipmentSlot);
                Equippable equippable = itemBySlot.a(DataComponents.D);
                if (equippable == null || !equippable.h() || !itemBySlot.m() || !itemBySlot.a(damageSource)) continue;
                itemBySlot.a(i2, this, equipmentSlot);
            }
        }
    }

    protected float e(DamageSource damageSource, float damageAmount) {
        if (!damageSource.a(DamageTypeTags.b)) {
            damageAmount = CombatMath.a(this, damageAmount, damageSource, this.eP(), (float)this.h(GenericAttributes.b));
        }
        return damageAmount;
    }

    protected float f(DamageSource damageSource, float damageAmount) {
        float damageProtection;
        if (damageSource.a(DamageTypeTags.f)) {
            return damageAmount;
        }
        if (damageAmount <= 0.0f) {
            return 0.0f;
        }
        if (damageSource.a(DamageTypeTags.h)) {
            return damageAmount;
        }
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            damageProtection = EnchantmentManager.b(serverLevel, this, damageSource);
        } else {
            damageProtection = 0.0f;
        }
        if (damageProtection > 0.0f) {
            damageAmount = CombatMath.a(damageAmount, damageProtection);
        }
        return damageAmount;
    }

    private EntityDamageEvent handleEntityDamage(final DamageSource damagesource, float amount, float invulnerabilityRelatedLastDamage) {
        float originalDamage = amount;
        com.google.common.base.Function invulnerabilityReductionEquation = d2 -> {
            if (invulnerabilityRelatedLastDamage == 0.0f) {
                return 0.0;
            }
            if (d2.floatValue() < invulnerabilityRelatedLastDamage) {
                return 0.0;
            }
            return -invulnerabilityRelatedLastDamage;
        };
        float originalInvulnerabilityReduction = ((Double)invulnerabilityReductionEquation.apply((Object)amount)).floatValue();
        com.google.common.base.Function<Double, Double> freezing = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.o) && EntityLiving.this.aq().a(TagsEntity.l)) {
                    return -(f2 - f2 * 5.0);
                }
                return -0.0;
            }
        };
        float freezingModifier = ((Double)freezing.apply((Object)(amount += originalInvulnerabilityReduction))).floatValue();
        com.google.common.base.Function<Double, Double> hardHat = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.a(EnumItemSlot.f).f()) {
                    return -(f2 - f2 * 0.75);
                }
                return -0.0;
            }
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(amount += freezingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> blocking = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(EntityLiving.this.i(damagesource) ? f2 : 0.0);
            }
        };
        float blockingModifier = ((Double)blocking.apply((Object)(amount += hardHatModifier))).floatValue();
        com.google.common.base.Function<Double, Double> armor = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
            }
        };
        float armorModifier = ((Double)armor.apply((Object)(amount += blockingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> resistance = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (!damagesource.a(DamageTypeTags.f) && EntityLiving.this.b(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                    int i2 = (EntityLiving.this.c(MobEffects.k).e() + 1) * 5;
                    int j2 = 25 - i2;
                    float f1 = f2.floatValue() * (float)j2;
                    return -(f2 - (double)Math.max(f1 / 25.0f, 0.0f));
                }
                return -0.0;
            }
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(amount += armorModifier))).floatValue();
        com.google.common.base.Function<Double, Double> magic = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.f(damagesource, f2.floatValue()));
            }
        };
        float magicModifier = ((Double)magic.apply((Object)(amount += resistanceModifier))).floatValue();
        com.google.common.base.Function<Double, Double> absorption = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.fw(), 0.0), 0.0);
            }
        };
        float absorptionModifier = ((Double)absorption.apply((Object)(amount += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption, (damageModifierDoubleMap, damageModifierFunctionMap) -> {
            damageModifierFunctionMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, invulnerabilityReductionEquation);
            damageModifierDoubleMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, Double.valueOf(originalInvulnerabilityReduction));
        });
    }

    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.a(level, damageSource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damageSource.d() instanceof EntityHuman) {
                if (damageSource.d() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)damageSource.d();
                    if (new PlayerAttackEntityCooldownResetEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.H(0.0f)).callEvent()) {
                        player.gD();
                    }
                } else {
                    ((EntityHuman)damageSource.d()).gD();
                }
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.M, Math.round(f3 * 10.0f));
                } else if (damageSource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damageSource.d()).a(StatisticList.I, Math.round(f3 * 10.0f));
                }
            }
            if (damageSource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                this.d(damageSource, amount);
            }
            if (!damageSource.a(DamageTypeTags.b)) {
                float armorDamage = (float)event.getDamage();
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION);
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
                this.c(damageSource, armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.z((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity2 = damageSource.c();
                if (!damageSource.a(DamageTypeTags.j) && entity2 instanceof EntityLiving && entity2.g(this) <= 40000.0) {
                    this.d((EntityLiving)entity2);
                }
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.E(Math.max(this.fw() - absorptionModifier, 0.0f));
            float f1 = absorptionModifier;
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = this) instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                player.a(StatisticList.L, Math.round(f1 * 10.0f));
            }
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = damageSource.d()) instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                serverPlayer.a(StatisticList.H, Math.round(f1 * 10.0f));
            }
            if (amount > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damageSource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (amount < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.J, Math.round(amount * 10.0f));
                    }
                }
                this.eQ().a(damageSource, amount);
                this.x(this.eD() - amount);
                if (!human) {
                    this.E(this.fw() - amount);
                }
                ((Entity)this).a(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damageSource, originalDamage, amount, true);
                    f1 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f1 > 0.0f && f1 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.K, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damageSource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damageSource.d(), this, damageSource, originalDamage, amount, true);
                }
                return !GlobalConfiguration.get().unsupportedSettings.skipVanillaDamageTickWhenShieldBlocked;
            }
            return true;
        }
        return true;
    }

    public CombatTracker eQ() {
        return this.bS;
    }

    @Nullable
    public EntityLiving eR() {
        if (this.bc != null) {
            return this.bc;
        }
        return this.bZ != null ? this.bZ : null;
    }

    public final float eS() {
        return (float)this.h(GenericAttributes.s);
    }

    public final float eT() {
        return (float)this.h(GenericAttributes.r);
    }

    public final int eU() {
        return this.al.a(bN);
    }

    public final void o(int count) {
        this.setArrowCount(count, false);
    }

    public final void setArrowCount(int count, boolean reset) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.eU(), count, reset);
        if (event.isCancelled()) {
            return;
        }
        this.al.a(bN, event.getNewAmount());
    }

    public final int eV() {
        return this.al.a(bO);
    }

    public final void p(int stingerCount) {
        this.al.a(bO, stingerCount);
    }

    private int F() {
        if (MobEffectUtil.a(this)) {
            return 6 - (1 + MobEffectUtil.b(this));
        }
        return this.b(MobEffects.d) ? 6 + (1 + this.c(MobEffects.d).e()) * 2 : 6;
    }

    public void a(EnumHand hand) {
        this.a(hand, false);
    }

    public void a(EnumHand hand, boolean updateSelf) {
        if (!this.aI || this.aK >= this.F() / 2 || this.aK < 0) {
            this.aK = -1;
            this.aI = true;
            this.aJ = hand;
            if (this.dV() instanceof WorldServer) {
                PacketPlayOutAnimation clientboundAnimatePacket = new PacketPlayOutAnimation(this, hand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkSource = ((WorldServer)this.dV()).m();
                if (updateSelf) {
                    chunkSource.a(this, clientboundAnimatePacket);
                } else {
                    chunkSource.b(this, clientboundAnimatePacket);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damageSource) {
        this.aT.a(1.5f);
        this.aj = 20;
        this.aN = this.aO = 10;
        SoundEffect hurtSound = this.e(damageSource);
        if (hurtSound != null) {
            this.a(hurtSound, this.fg(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
        }
        this.ci = damageSource;
        this.cj = this.dV().ad();
    }

    @Override
    public void b(byte id) {
        switch (id) {
            case 3: {
                SoundEffect deathSound = this.o_();
                if (deathSound != null) {
                    this.a(deathSound, this.fg(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.x(0.0f);
                this.a(this.dW().p());
                break;
            }
            case 29: {
                this.a(SoundEffects.xd, 1.0f, 0.8f + this.dV().A.i() * 0.4f);
                break;
            }
            case 30: {
                this.a(SoundEffects.xe, 0.8f, 0.8f + this.dV().A.i() * 0.4f);
                break;
            }
            case 46: {
                int i2 = 128;
                for (int i1 = 0; i1 < 128; ++i1) {
                    double d2 = (double)i1 / 127.0;
                    float f2 = (this.ae.i() - 0.5f) * 0.2f;
                    float f1 = (this.ae.i() - 0.5f) * 0.2f;
                    float f22 = (this.ae.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d2, this.K, this.dA()) + (this.ae.j() - 0.5) * (double)this.dq() * 2.0;
                    double d22 = MathHelper.d(d2, this.L, this.dC()) + this.ae.j() * (double)this.dr();
                    double d3 = MathHelper.d(d2, this.M, this.dG()) + (this.ae.j() - 0.5) * (double)this.dq() * 2.0;
                    this.dV().a(Particles.ae, d1, d22, d3, (double)f2, (double)f1, f22);
                }
                break;
            }
            case 47: {
                this.g(this.a(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.g(this.a(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.g(this.a(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.g(this.a(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.g(this.a(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.g(this.a(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.G();
                break;
            }
            case 60: {
                this.eW();
                break;
            }
            case 65: {
                this.g(this.a(EnumItemSlot.g));
                break;
            }
            default: {
                super.b(id);
            }
        }
    }

    public void eW() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d22 = this.ae.k() * 0.02;
            double d3 = 10.0;
            this.dV().a(Particles.ad, this.d(1.0) - d2 * 10.0, this.dD() - d1 * 10.0, this.g(1.0) - d22 * 10.0, d2, d1, d22);
        }
    }

    private void G() {
        ItemStack itemBySlot = this.a(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.a(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemBySlot);
    }

    @Override
    protected void aI() {
        this.a(this.dW().o(), this.dV().getWorld().getVoidDamageAmount());
    }

    protected void eX() {
        int currentSwingDuration = this.F();
        if (this.aI) {
            ++this.aK;
            if (this.aK >= currentSwingDuration) {
                this.aK = 0;
                this.aI = false;
            }
        } else {
            this.aK = 0;
        }
        this.aR = (float)this.aK / (float)currentSwingDuration;
    }

    @Nullable
    public AttributeModifiable g(Holder<AttributeBase> attribute) {
        return this.eY().a(attribute);
    }

    public double h(Holder<AttributeBase> attribute) {
        return this.eY().c(attribute);
    }

    public double i(Holder<AttributeBase> attribute) {
        return this.eY().d(attribute);
    }

    public AttributeMapBase eY() {
        return this.bR;
    }

    public ItemStack eZ() {
        return this.a(EnumItemSlot.a);
    }

    public ItemStack fa() {
        return this.a(EnumItemSlot.b);
    }

    public ItemStack a(EnumMainHand arm) {
        return this.fy() == arm ? this.eZ() : this.fa();
    }

    @Override
    @Nonnull
    public ItemStack dZ() {
        return this.eZ();
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack stack) -> stack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.eZ()) || predicate.test(this.fa());
    }

    public ItemStack b(EnumHand hand) {
        if (hand == EnumHand.a) {
            return this.a(EnumItemSlot.a);
        }
        if (hand == EnumHand.b) {
            return this.a(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
    }

    public void a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.a) {
            this.a(EnumItemSlot.a, stack);
        } else {
            if (hand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
            }
            this.a(EnumItemSlot.b, stack);
        }
    }

    public boolean d(EnumItemSlot slot) {
        return !this.a(slot).f();
    }

    public boolean e(EnumItemSlot slot) {
        return false;
    }

    public abstract Iterable<ItemStack> fb();

    public abstract ItemStack a(EnumItemSlot var1);

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.a(enumitemslot, itemstack);
    }

    public abstract void a(EnumItemSlot var1, ItemStack var2);

    public Iterable<ItemStack> fc() {
        return List.of();
    }

    public Iterable<ItemStack> fd() {
        return this.fb();
    }

    public Iterable<ItemStack> fe() {
        return Iterables.concat(this.fc(), this.fd());
    }

    protected void c(ItemStack stack) {
        stack.h().l(stack);
    }

    public float ff() {
        Iterable<ItemStack> armorSlots = this.fb();
        int i2 = 0;
        int i1 = 0;
        for (ItemStack itemStack : armorSlots) {
            if (!itemStack.f()) {
                ++i1;
            }
            ++i2;
        }
        return i2 > 0 ? (float)i1 / (float)i2 : 0.0f;
    }

    @Override
    public void h(boolean sprinting) {
        super.h(sprinting);
        AttributeModifiable attribute = this.g(GenericAttributes.v);
        attribute.c(k.b());
        if (sprinting) {
            attribute.b(k);
        }
    }

    public float fg() {
        return 1.0f;
    }

    public float fh() {
        return this.e_() ? (this.ae.i() - this.ae.i()) * 0.2f + 1.5f : (this.ae.i() - this.ae.i()) * 0.2f + 1.0f;
    }

    protected boolean fi() {
        return this.eE();
    }

    @Override
    public void h(Entity entity) {
        if (!this.fR()) {
            super.h(entity);
        }
    }

    private void c(Entity vehicle) {
        Vec3D vec3;
        if (this.dQ()) {
            vec3 = this.dt();
        } else if (!vehicle.dQ() && !this.dV().a_(vehicle.dv()).a(TagsBlock.aM)) {
            vec3 = vehicle.b(this);
        } else {
            boolean flag;
            double max = Math.max(this.dC(), vehicle.dC());
            vec3 = new Vec3D(this.dA(), max, this.dG());
            boolean bl = flag = this.dq() <= 4.0f && this.dr() <= 4.0f;
            if (flag) {
                double d2 = (double)this.dr() / 2.0;
                Vec3D vec31 = vec3.b(0.0, d2, 0.0);
                VoxelShape voxelShape = VoxelShapes.a(AxisAlignedBB.a(vec31, this.dq(), this.dr(), this.dq()));
                vec3 = this.dV().a((Entity)this, voxelShape, vec31, (double)this.dq(), (double)this.dr(), (double)this.dq()).map(vec32 -> vec32.b(0.0, -d2, 0.0)).orElse(vec3);
            }
        }
        this.a(vec3.d, vec3.e, vec3.f);
    }

    @Override
    public boolean cM() {
        return this.cL();
    }

    protected float fj() {
        return this.A(1.0f);
    }

    protected float A(float multiplier) {
        return (float)this.h(GenericAttributes.o) * multiplier * this.aS() + this.fk();
    }

    public float fk() {
        return this.b(MobEffects.h) ? 0.1f * ((float)this.c(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void s() {
        float jumpPower = this.fj();
        if (!(jumpPower <= 1.0E-5f)) {
            Vec3D deltaMovement = this.dy();
            long time = System.nanoTime();
            boolean canCrit = true;
            if (this instanceof EntityHuman) {
                canCrit = false;
                if (time - this.lastJumpTime > 250000000L) {
                    this.lastJumpTime = time;
                    canCrit = true;
                }
            }
            this.n(deltaMovement.d, Math.max((double)jumpPower, deltaMovement.e), deltaMovement.f);
            if (this.cj()) {
                float f2 = this.dL() * ((float)Math.PI / 180);
                if (canCrit) {
                    this.j(new Vec3D((double)(-MathHelper.a(f2)) * 0.2, 0.0, (double)MathHelper.b(f2) * 0.2));
                }
            }
            this.ar = true;
        }
    }

    protected void fl() {
        this.i(this.dy().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> fluidTag) {
        this.i(this.dy().b(0.0, 0.04f, 0.0));
    }

    protected float fm() {
        return 0.8f;
    }

    public boolean a(Fluid fluidState) {
        return false;
    }

    @Override
    protected double bd() {
        return this.h(GenericAttributes.n);
    }

    protected double fn() {
        boolean flag = this.dy().e <= 0.0;
        return flag && this.b(MobEffects.B) ? Math.min(this.be(), 0.01) : this.be();
    }

    public void a_(Vec3D travelVector) {
        if (this.dh()) {
            Fluid fluidState = this.dV().b_(this.dv());
            if ((this.bj() || this.bx()) && this.ek() && !this.a(fluidState)) {
                this.m(travelVector);
            } else if (this.fJ()) {
                this.H();
            } else {
                this.l(travelVector);
            }
        }
    }

    private void l(Vec3D travelVector) {
        BlockPosition blockPosBelowThatAffectsMyMovement = this.aQ();
        float f2 = this.aJ() ? this.dV().a_(blockPosBelowThatAffectsMyMovement).b().g() : 1.0f;
        float f1 = f2 * 0.91f;
        Vec3D vec3 = this.a(travelVector, f2);
        double d2 = vec3.e;
        MobEffect effect = this.c(MobEffects.y);
        d2 = effect != null ? (d2 += (0.05 * (double)(effect.e() + 1) - vec3.e) * 0.2) : (!this.dV().C || this.dV().B(blockPosBelowThatAffectsMyMovement) ? (d2 -= this.fn()) : (this.dC() > (double)this.dV().L_() ? -0.1 : 0.0));
        if (this.eu()) {
            this.n(vec3.d, d2, vec3.f);
        } else {
            float f22 = this instanceof EntityBird ? f1 : 0.98f;
            this.n(vec3.d * (double)f1, d2 * (double)f22, vec3.f * (double)f1);
        }
    }

    private void m(Vec3D travelVector) {
        boolean flag = this.dy().e <= 0.0;
        double y2 = this.dC();
        double effectiveGravity = this.fn();
        if (this.bj()) {
            float f2 = this.cj() ? 0.9f : this.fm();
            float f1 = 0.02f;
            float f22 = (float)this.h(GenericAttributes.F);
            if (!this.aJ()) {
                f22 *= 0.5f;
            }
            if (f22 > 0.0f) {
                f2 += (0.54600006f - f2) * f22;
                f1 += (this.fp() - f1) * f22;
            }
            if (this.b(MobEffects.D)) {
                f2 = 0.96f;
            }
            this.a(f1, travelVector);
            this.a(EnumMoveType.a, this.dy());
            Vec3D deltaMovement = this.dy();
            if (this.P && this.q_()) {
                deltaMovement = new Vec3D(deltaMovement.d, 0.2, deltaMovement.f);
            }
            deltaMovement = deltaMovement.d(f2, 0.8f, f2);
            this.i(this.a(effectiveGravity, flag, deltaMovement));
        } else {
            this.a(0.02f, travelVector);
            this.a(EnumMoveType.a, this.dy());
            if (this.b(TagsFluid.b) <= this.dp()) {
                this.i(this.dy().d(0.5, 0.8f, 0.5));
                Vec3D fluidFallingAdjustedMovement = this.a(effectiveGravity, flag, this.dy());
                this.i(fluidFallingAdjustedMovement);
            } else {
                this.i(this.dy().c(0.5));
            }
            if (effectiveGravity != 0.0) {
                this.i(this.dy().b(0.0, -effectiveGravity / 4.0, 0.0));
            }
        }
        Vec3D fluidFallingAdjustedMovement = this.dy();
        if (this.P && this.g(fluidFallingAdjustedMovement.d, fluidFallingAdjustedMovement.e + (double)0.6f - this.dC() + y2, fluidFallingAdjustedMovement.f)) {
            this.n(fluidFallingAdjustedMovement.d, 0.3f, fluidFallingAdjustedMovement.f);
        }
    }

    @Override
    private void H() {
        Vec3D deltaMovement = this.dy();
        double d2 = deltaMovement.i();
        this.i(this.n(deltaMovement));
        this.a(EnumMoveType.a, this.dy());
        if (!this.dV().C) {
            double d1 = this.dy().i();
            this.c(d2, d1);
        }
    }

    private Vec3D n(Vec3D deltaMovement) {
        double d1;
        Vec3D lookAngle = this.bT();
        float f2 = this.dN() * ((float)Math.PI / 180);
        double squareRoot = Math.sqrt(lookAngle.d * lookAngle.d + lookAngle.f * lookAngle.f);
        double d2 = deltaMovement.i();
        double effectiveGravity = this.fn();
        double squared = MathHelper.k(Math.cos(f2));
        deltaMovement = deltaMovement.b(0.0, effectiveGravity * (-1.0 + squared * 0.75), 0.0);
        if (deltaMovement.e < 0.0 && squareRoot > 0.0) {
            d1 = deltaMovement.e * -0.1 * squared;
            deltaMovement = deltaMovement.b(lookAngle.d * d1 / squareRoot, d1, lookAngle.f * d1 / squareRoot);
        }
        if (f2 < 0.0f && squareRoot > 0.0) {
            d1 = d2 * (double)(-MathHelper.a(f2)) * 0.04;
            deltaMovement = deltaMovement.b(-lookAngle.d * d1 / squareRoot, d1 * 3.2, -lookAngle.f * d1 / squareRoot);
        }
        if (squareRoot > 0.0) {
            deltaMovement = deltaMovement.b((lookAngle.d / squareRoot * d2 - deltaMovement.d) * 0.1, 0.0, (lookAngle.f / squareRoot * d2 - deltaMovement.f) * 0.1);
        }
        return deltaMovement.d(0.99f, 0.98f, 0.99f);
    }

    private void c(double oldSpeed, double newSpeed) {
        double d2;
        float f2;
        if (this.P && (f2 = (float)((d2 = oldSpeed - newSpeed) * 10.0 - 3.0)) > 0.0f) {
            this.a(this.q((int)f2), 1.0f, 1.0f);
            this.a(this.dW().n(), f2);
        }
    }

    private void c(EntityHuman player, Vec3D travelVector) {
        Vec3D riddenInput = this.b(player, travelVector);
        this.a(player, riddenInput);
        if (this.dh()) {
            this.C(this.e(player));
            this.a_(riddenInput);
        } else {
            this.i(Vec3D.c);
        }
    }

    protected void a(EntityHuman player, Vec3D travelVector) {
    }

    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return travelVector;
    }

    protected float e(EntityHuman player) {
        return this.fp();
    }

    public void s(boolean includeHeight) {
        float f2 = (float)MathHelper.g(this.dA() - this.K, includeHeight ? this.dC() - this.L : 0.0, this.dG() - this.M);
        if (!this.bZ() && this.bL()) {
            this.B(f2);
        } else {
            this.aT.a();
        }
    }

    protected void B(float partialTick) {
        float min = Math.min(partialTick * 4.0f, 1.0f);
        this.aT.a(min, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    private Vec3D a(Vec3D deltaMovement, float friction) {
        this.a(this.G(friction), deltaMovement);
        this.i(this.o(this.dy()));
        this.a(EnumMoveType.a, this.dy());
        Vec3D deltaMovement1 = this.dy();
        if ((this.P || this.bm) && (this.q_() || this.dw().a(Blocks.rr) && PowderSnowBlock.a(this))) {
            deltaMovement1 = new Vec3D(deltaMovement1.d, 0.2, deltaMovement1.f);
        }
        return deltaMovement1;
    }

    public Vec3D a(double gravity, boolean isFalling, Vec3D deltaMovement) {
        if (gravity != 0.0 && !this.cj()) {
            double d2 = isFalling && Math.abs(deltaMovement.e - 0.005) >= 0.003 && Math.abs(deltaMovement.e - gravity / 16.0) < 0.003 ? -0.003 : deltaMovement.e - gravity / 16.0;
            return new Vec3D(deltaMovement.d, d2, deltaMovement.f);
        }
        return deltaMovement;
    }

    private Vec3D o(Vec3D deltaMovement) {
        if (this.q_()) {
            this.k();
            float f2 = 0.15f;
            double d2 = MathHelper.a(deltaMovement.d, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(deltaMovement.f, (double)-0.15f, (double)0.15f);
            double max = Math.max(deltaMovement.e, (double)-0.15f);
            if (max < 0.0 && !this.dw().a(Blocks.ou) && this.fI() && this instanceof EntityHuman) {
                max = 0.0;
            }
            deltaMovement = new Vec3D(d2, max, d1);
        }
        return deltaMovement;
    }

    private float G(float friction) {
        return this.aJ() ? this.fp() * (0.21600002f / (friction * friction * friction)) : this.fo();
    }

    protected float fo() {
        return this.cW() instanceof EntityHuman ? this.fp() * 0.1f : 0.02f;
    }

    public float fp() {
        return this.cd;
    }

    public void C(float speed) {
        this.cd = speed;
    }

    public boolean c(WorldServer level, Entity source) {
        this.B(source);
        return false;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bf;
    }

    @Override
    public void h() {
        float abs;
        super.h();
        this.L();
        this.N();
        if (!this.dV().C) {
            int stingerCount;
            int arrowCount = this.eU();
            if (arrowCount > 0) {
                if (this.aL <= 0) {
                    this.aL = 20 * (30 - arrowCount);
                }
                --this.aL;
                if (this.aL <= 0) {
                    this.o(arrowCount - 1);
                }
            }
            if ((stingerCount = this.eV()) > 0) {
                if (this.aM <= 0) {
                    this.aM = 20 * (30 - stingerCount);
                }
                --this.aM;
                if (this.aM <= 0) {
                    this.p(stingerCount - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.af % 20 == 0) {
                this.eQ().c();
            }
            if (this.fR() && !this.O()) {
                this.fS();
            }
        }
        if (!this.dQ()) {
            this.d_();
        }
        double d2 = this.dA() - this.K;
        double d1 = this.dG() - this.M;
        float f2 = (float)(d2 * d2 + d1 * d1);
        float f1 = this.aX;
        float f22 = 0.0f;
        this.bg = this.bh;
        float f3 = 0.0f;
        if (f2 > 0.0025000002f) {
            f3 = 1.0f;
            f22 = (float)Math.sqrt(f2) * 3.0f;
            float f4 = (float)MathHelper.d(d1, d2) * 57.295776f - 90.0f;
            abs = MathHelper.e(MathHelper.h(this.dL()) - f4);
            f1 = 95.0f < abs && abs < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.aR > 0.0f) {
            f1 = this.dL();
        }
        if (!this.aJ()) {
            f3 = 0.0f;
        }
        this.bh += (f3 - this.bh) * 0.3f;
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("headTurn");
        f22 = this.g(f1, f22);
        profilerFiller.c();
        profilerFiller.a("rangeChecks");
        this.N += (float)Math.round((this.dL() - this.N) / 360.0f) * 360.0f;
        this.aY += (float)Math.round((this.aX - this.aY) / 360.0f) * 360.0f;
        this.O += (float)Math.round((this.dN() - this.O) / 360.0f) * 360.0f;
        this.ba += (float)Math.round((this.aZ - this.ba) / 360.0f) * 360.0f;
        profilerFiller.c();
        this.bi += f22;
        this.bA = this.fJ() ? ++this.bA : 0;
        if (this.fR()) {
            this.w(0.0f);
        }
        this.E();
        abs = this.ej();
        if (abs != this.bF) {
            this.bF = abs;
            this.m_();
        }
        this.bb.a();
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EnumItemSlot, ItemStack> map = this.J();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> J() {
        ItemStack itemBySlot;
        Map map = null;
        EnumMap equipmentChanges = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.i) {
            ItemStack itemStack;
            if (!this.a(itemStack = (switch (enumItemSlot.a()) {
                default -> throw new MatchException(null, null);
                case EnumItemSlot.Function.a -> this.h(enumItemSlot);
                case EnumItemSlot.Function.b -> this.g(enumItemSlot);
                case EnumItemSlot.Function.c -> this.bW;
            }), itemBySlot = this.a(enumItemSlot))) continue;
            org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemStack);
            org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemBySlot);
            if (this instanceof EntityPlayer && enumItemSlot.a() == EnumItemSlot.Function.b) {
                new PlayerArmorChangeEvent((Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumItemSlot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
                equipmentChanges = Maps.newEnumMap(EquipmentSlot.class);
            }
            map.put(enumItemSlot, itemBySlot);
            record EquipmentChangeImpl(org.bukkit.inventory.ItemStack oldItem, org.bukkit.inventory.ItemStack newItem) implements EntityEquipmentChangedEvent.EquipmentChange
            {
                private final org.bukkit.inventory.ItemStack oldItem;
                private final org.bukkit.inventory.ItemStack newItem;

                public org.bukkit.inventory.ItemStack oldItem() {
                    return this.oldItem.clone();
                }

                public org.bukkit.inventory.ItemStack newItem() {
                    return this.newItem.clone();
                }
            }
            equipmentChanges.put(CraftEquipmentSlot.getSlot(enumItemSlot), new EquipmentChangeImpl(oldItem, newItem));
            AttributeMapBase attributes = this.eY();
            if (itemStack.f()) continue;
            this.a(itemStack, enumItemSlot, attributes);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot equipmentSlot1 = (EnumItemSlot)entry.getKey();
                itemBySlot = (ItemStack)entry.getValue();
                if (itemBySlot.f() || itemBySlot.q()) continue;
                itemBySlot.a(equipmentSlot1, (Holder<AttributeBase> attribute, AttributeModifier modifier) -> {
                    AttributeModifiable instance = this.bR.a((Holder<AttributeBase>)attribute);
                    if (instance != null) {
                        instance.c(modifier.b());
                        instance.b((AttributeModifier)modifier);
                    }
                });
                net.minecraft.world.level.World world = this.dV();
                if (!(world instanceof WorldServer)) continue;
                WorldServer serverLevel = (WorldServer)world;
                EnchantmentManager.a(serverLevel, itemBySlot, this, equipmentSlot1);
            }
            new EntityEquipmentChangedEvent((LivingEntity)this.getBukkitLivingEntity(), equipmentChanges).callEvent();
        }
        return map;
    }

    public boolean a(ItemStack oldItem, ItemStack newItem) {
        return !ItemStack.a(newItem, oldItem);
    }

    private void a(Map<EnumItemSlot, ItemStack> hands) {
        ItemStack itemStack = hands.get(EnumItemSlot.a);
        ItemStack itemStack1 = hands.get(EnumItemSlot.b);
        if (itemStack != null && itemStack1 != null && ItemStack.a(itemStack, this.h(EnumItemSlot.b)) && ItemStack.a(itemStack1, this.h(EnumItemSlot.a))) {
            ((WorldServer)this.dV()).m().b(this, new PacketPlayOutEntityStatus(this, 55));
            hands.remove(EnumItemSlot.a);
            hands.remove(EnumItemSlot.b);
            this.c(EnumItemSlot.a, itemStack.v());
            this.c(EnumItemSlot.b, itemStack1.v());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> equipments) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipments.size());
        equipments.forEach((slot, stack) -> {
            ItemStack itemStack = stack.v();
            list.add(Pair.of((Object)slot, (Object)itemStack));
            switch (slot.a()) {
                case a: {
                    this.c((EnumItemSlot)slot, itemStack);
                    break;
                }
                case b: {
                    this.b((EnumItemSlot)slot, itemStack);
                    break;
                }
                case c: {
                    this.bW = itemStack;
                }
            }
        });
        ((WorldServer)this.dV()).m().b(this, new PacketPlayOutEntityEquipment(this.ar(), list, true));
    }

    private ItemStack g(EnumItemSlot slot) {
        return this.bV.get(slot.b());
    }

    private void b(EnumItemSlot slot, ItemStack stack) {
        this.bV.set(slot.b(), stack);
    }

    private ItemStack h(EnumItemSlot slot) {
        return this.bU.get(slot.b());
    }

    private void c(EnumItemSlot slot, ItemStack stack) {
        this.bU.set(slot.b(), stack);
    }

    protected float g(float yRot, float animStep) {
        boolean flag;
        float f2 = MathHelper.h(yRot - this.aX);
        this.aX += f2 * 0.3f;
        float f1 = MathHelper.h(this.dL() - this.aX);
        float maxHeadRotationRelativeToBody = this.fq();
        if (Math.abs(f1) > maxHeadRotationRelativeToBody) {
            this.aX += f1 - (float)MathHelper.j((double)f1) * maxHeadRotationRelativeToBody;
        }
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (flag) {
            animStep *= -1.0f;
        }
        return animStep;
    }

    protected float fq() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void d_() {
        if (this.ce > 0) {
            --this.ce;
        }
        if (this.bq > 0) {
            this.a(this.bq, this.br, this.bs, this.bt, this.bu, this.bv);
            --this.bq;
        } else if (!this.dj()) {
            this.i(this.dy().c(0.98));
        }
        if (this.bx > 0) {
            this.a(this.bx, this.bw);
            --this.bx;
        }
        deltaMovement = this.dy();
        d = deltaMovement.d;
        d1 = deltaMovement.e;
        d2 = deltaMovement.f;
        if (Math.abs(deltaMovement.d) < 0.003) {
            d = 0.0;
        }
        if (Math.abs(deltaMovement.e) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(deltaMovement.f) < 0.003) {
            d2 = 0.0;
        }
        this.n(d, d1, d2);
        profilerFiller = Profiler.a();
        profilerFiller.a("ai");
        if (this.fi()) {
            this.bm = false;
            this.bn = 0.0f;
            this.bp = 0.0f;
        } else if (this.dj()) {
            profilerFiller.a("newAi");
            this.fu();
            profilerFiller.c();
        }
        profilerFiller.c();
        profilerFiller.a("jump");
        if (this.bm && this.ek()) {
            fluidHeight = this.bx() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.bj() != false && fluidHeight > 0.0;
            fluidJumpThreshold = this.dp();
            if (!flag || this.aJ() && !(fluidHeight > fluidJumpThreshold)) {
                if (!this.bx() || this.aJ() && !(fluidHeight > fluidJumpThreshold)) {
                    if ((this.aJ() || flag && fluidHeight <= fluidJumpThreshold) && this.ce == 0) {
                        if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                            this.s();
                            this.ce = 10;
                        } else {
                            this.t(false);
                        }
                    }
                } else {
                    this.c(TagsFluid.b);
                }
            } else {
                this.c(TagsFluid.a);
            }
        } else {
            this.ce = 0;
        }
        profilerFiller.c();
        profilerFiller.a("travel");
        this.bn *= 0.98f;
        this.bp *= 0.98f;
        if (this.fJ()) {
            this.fs();
        }
        boundingBox = this.cR();
        vec3 = new Vec3D(this.bn, this.bo, this.bp);
        if (this.b(MobEffects.B) || this.b(MobEffects.y)) {
            this.k();
        }
        if (!((fluidJumpThreshold = this.cW()) instanceof EntityHuman)) ** GOTO lbl-1000
        player = (EntityHuman)fluidJumpThreshold;
        if (this.bL()) {
            this.c(player, vec3);
        } else lbl-1000:
        // 2 sources

        {
            this.a_(vec3);
        }
        if (!this.dV().B_() || this.dh()) {
            this.aK();
        }
        this.s(this instanceof EntityBird);
        profilerFiller.c();
        profilerFiller.a("freezing");
        if (!(this.dV().C || this.eE() || this.freezeLocked)) {
            ticksFrozen = this.cu();
            if (this.av && this.dJ()) {
                this.k(Math.min(this.cx(), ticksFrozen + 1));
            } else {
                this.k(Math.max(0, ticksFrozen - 2));
            }
        }
        this.eg();
        this.eh();
        fluidJumpThreshold = this.dV();
        if (fluidJumpThreshold instanceof WorldServer) {
            serverLevel = (WorldServer)fluidJumpThreshold;
            if (this.af % 40 == 0 && this.cw() && this.dJ()) {
                this.a(serverLevel, this.dW().v(), 1.0f);
            }
        }
        profilerFiller.c();
        profilerFiller.a("push");
        if (this.bB > 0) {
            --this.bB;
            this.a(boundingBox, this.cR());
        }
        this.o();
        profilerFiller.c();
        if (((WorldServer)this.dV()).hasEntityMoveEvent && !(this instanceof EntityHuman) && (this.K != this.dA() || this.L != this.dC() || this.M != this.dG() || this.N != this.dL() || this.O != this.dN())) {
            from = new Location((World)this.dV().getWorld(), this.K, this.L, this.M, this.N, this.O);
            to = new Location((World)this.dV().getWorld(), this.dA(), this.dC(), this.dG(), this.dL(), this.dN());
            event = new EntityMoveEvent((LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if ((var12_15 = this.dV()) instanceof WorldServer) {
            serverLevel = (WorldServer)var12_15;
            if (this.fr() && this.bl()) {
                this.a(serverLevel, this.dW().i(), 1.0f);
            }
        }
    }

    public boolean fr() {
        return false;
    }

    protected void fs() {
        this.cy();
        if (!this.dV().C) {
            if (!this.ft()) {
                if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
                return;
            }
            int i2 = this.bA + 1;
            if (i2 % 10 == 0) {
                int i1 = i2 / 10;
                if (i1 % 2 == 0) {
                    List<EnumItemSlot> list = EnumItemSlot.i.stream().filter(slot -> EntityLiving.b(this.a((EnumItemSlot)slot), slot)).toList();
                    EnumItemSlot equipmentSlot = SystemUtils.a(list, this.ae);
                    this.a(equipmentSlot).a(1, this, equipmentSlot);
                }
                ((Entity)this).a(GameEvent.n);
            }
        }
    }

    protected boolean ft() {
        if (!(this.aJ() || this.bZ() || this.b(MobEffects.y))) {
            for (EnumItemSlot equipmentSlot : EnumItemSlot.i) {
                if (!EntityLiving.b(this.a(equipmentSlot), equipmentSlot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fu() {
    }

    protected void o() {
        net.minecraft.world.level.World world = this.dV();
        if (!(world instanceof WorldServer)) {
            this.dV().a(EntityTypeTest.a(EntityHuman.class), this.cR(), IEntitySelector.a(this)).forEach(this::D);
        } else {
            WorldServer serverLevel = (WorldServer)world;
            if (!this.bI()) {
                return;
            }
            ScoreboardTeam team = this.cr();
            if (team != null && ((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumTeamPush.b) {
                return;
            }
            int _int = serverLevel.O().c(GameRules.v);
            if (_int <= 0 && this.dV().paperConfig().collisions.maxEntityCollisions <= 0) {
                return;
            }
            List<Entity> entities = this.dV().a((Entity)this, this.cR(), IEntitySelector.pushable(this, this.dV().paperConfig().collisions.fixClimbingBypassingCrammingRule));
            if (!entities.isEmpty()) {
                if (_int > 0 && entities.size() > _int - 1 && this.ae.a(4) == 0) {
                    int i2 = 0;
                    for (Entity entity : entities) {
                        if (entity.bZ()) continue;
                        ++i2;
                    }
                    if (i2 > _int - 1) {
                        this.a(serverLevel, this.dW().h(), 6.0f);
                    }
                }
                this.numCollisions = Math.max(0, this.numCollisions - this.dV().paperConfig().collisions.maxEntityCollisions);
                for (Entity entity1 : entities) {
                    if (this.numCollisions >= this.dV().paperConfig().collisions.maxEntityCollisions) break;
                    ++entity1.numCollisions;
                    ++this.numCollisions;
                    this.D(entity1);
                }
            }
        }
    }

    protected void a(AxisAlignedBB boundingBoxBeforeSpin, AxisAlignedBB boundingBoxAfterSpin) {
        AxisAlignedBB aabb = boundingBoxBeforeSpin.b(boundingBoxAfterSpin);
        List<Entity> entities = this.dV().a_(this, aabb);
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                if (!(entity instanceof EntityLiving)) continue;
                this.g((EntityLiving)entity);
                this.bB = 0;
                this.i(this.dy().c(-0.2));
                break;
            }
        } else if (this.P) {
            this.bB = 0;
        }
        if (!this.dV().C && this.bB <= 0) {
            this.c(4, false);
            this.bC = 0.0f;
            this.bD = null;
        }
    }

    protected void D(Entity entity) {
        entity.h(this);
    }

    protected void g(EntityLiving target) {
    }

    public boolean fv() {
        return (this.al.a(aC) & 4) != 0;
    }

    @Override
    public void ae() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity vehicle = this.dk();
        super.stopRiding(suppressCancellation);
        if (vehicle != null && vehicle != this.dk() && !this.dV().C && vehicle.valid) {
            this.c(vehicle);
        }
    }

    @Override
    public void r() {
        super.r();
        this.bg = this.bh;
        this.bh = 0.0f;
        this.k();
    }

    @Override
    public void f_() {
        this.bq = 0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yRot, float xRot, int steps) {
        this.br = x2;
        this.bs = y2;
        this.bt = z2;
        this.bu = yRot;
        this.bv = xRot;
        this.bq = steps;
    }

    @Override
    public double R_() {
        return this.bq > 0 ? this.br : this.dA();
    }

    @Override
    public double S_() {
        return this.bq > 0 ? this.bs : this.dC();
    }

    @Override
    public double g_() {
        return this.bq > 0 ? this.bt : this.dG();
    }

    @Override
    public float r_() {
        return this.bq > 0 ? (float)this.bv : this.dN();
    }

    @Override
    public float h_() {
        return this.bq > 0 ? (float)this.bu : this.dL();
    }

    @Override
    public void a(float yaw, int pitch) {
        this.bw = yaw;
        this.bx = pitch;
    }

    public void t(boolean jumping) {
        this.bm = jumping;
    }

    public void a(EntityItem itemEntity) {
        EntityHuman owner;
        EntityHuman entityHuman = owner = itemEntity.k != null ? this.dV().getGlobalPlayerByUUID(itemEntity.k) : null;
        if (owner instanceof EntityPlayer) {
            CriterionTriggers.R.a((EntityPlayer)owner, itemEntity.l(), this);
        }
    }

    public void a(Entity entity, int amount) {
        if (!entity.dQ() && !this.dV().C && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.dV()).m().a(this, new PacketPlayOutCollect(entity.ar(), this.ar(), amount));
        }
    }

    public boolean E(Entity entity) {
        return this.a(entity, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity.dE());
    }

    public boolean a(Entity entity, RayTrace.BlockCollisionOption block, RayTrace.FluidCollisionOption fluid, double y2) {
        if (entity.dV() != this.dV()) {
            return false;
        }
        Vec3D vec3 = new Vec3D(this.dA(), this.dE(), this.dG());
        Vec3D vec31 = new Vec3D(entity.dA(), y2, entity.dG());
        return !(vec31.g(vec3) > 16384.0) && this.dV().a(new RayTrace(vec3, vec31, block, fluid, this)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float i(float partialTicks) {
        return partialTicks == 1.0f ? this.aZ : MathHelper.i(partialTicks, this.ba, this.aZ);
    }

    public float D(float partialTick) {
        float f2 = this.aR - this.aQ;
        if (f2 < 0.0f) {
            f2 += 1.0f;
        }
        return this.aQ + f2 * partialTick;
    }

    @Override
    public boolean bH() {
        return !this.dQ() && this.collides;
    }

    @Override
    public boolean bI() {
        return this.isCollidable(this.dV().paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.bL() && !this.Z_() && (ignoreClimbing || !this.q_()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bI() && this.collides != this.collidableExemptions.contains(entity.cG());
    }

    @Override
    public float cA() {
        return this.aZ;
    }

    @Override
    public void q(float rotation) {
        this.aZ = rotation;
    }

    @Override
    public void r(float offset) {
        this.aX = offset;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return EntityLiving.k(super.a(axis, portal));
    }

    public static Vec3D k(Vec3D relativePortalPosition) {
        return new Vec3D(relativePortalPosition.d, relativePortalPosition.e, 0.0);
    }

    public float fw() {
        return this.cf;
    }

    public final void E(float absorptionAmount) {
        this.F(!Float.isNaN(absorptionAmount) ? MathHelper.a(absorptionAmount, 0.0f, this.eT()) : 0.0f);
    }

    protected void F(float absorptionAmount) {
        this.cf = absorptionAmount;
    }

    public void i_() {
    }

    public void j_() {
    }

    protected void fx() {
        this.bY = true;
    }

    public abstract EnumMainHand fy();

    public boolean fz() {
        return (this.al.a(aC) & 1) > 0;
    }

    public EnumHand fA() {
        return (this.al.a(aC) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    public void resyncUsingItem(EntityPlayer serverPlayer) {
        this.resendPossiblyDesyncedDataValues(List.of(aC), serverPlayer);
    }

    private void L() {
        if (this.fz()) {
            if (ItemStack.b(this.b(this.fA()), this.by)) {
                this.by = this.b(this.fA());
                this.a(this.by);
            } else {
                this.fF();
            }
        }
    }

    protected void a(ItemStack usingItem) {
        boolean shouldLagCompensate;
        usingItem.b(this.dV(), this, this.fC());
        boolean bl = shouldLagCompensate = this.by.b(DataComponents.w) && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (1L + (long)this.totalEatTimeTicks) * 50L * 1000000L;
        if (!(--this.bz != 0 && !shouldLagCompensate || this.dV().C || usingItem.x())) {
            this.bz = 0;
            this.w();
        }
    }

    private void N() {
        this.cl = this.ck;
        this.ck = this.cl() ? Math.min(1.0f, this.ck + 0.09f) : Math.max(0.0f, this.ck - 0.09f);
    }

    public void c(int key, boolean value) {
        int i2 = this.al.a(aC).byteValue();
        i2 = value ? (i2 |= key) : (i2 &= ~key);
        this.al.a(aC, (byte)i2);
    }

    public void c(EnumHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(EnumHand hand, boolean forceUpdate) {
        ItemStack itemInHand = this.b(hand);
        if (!itemInHand.f() && !this.fz() || forceUpdate) {
            this.by = itemInHand;
            this.bz = this.totalEatTimeTicks = itemInHand.a(this);
            this.eatStartTime = System.nanoTime();
            if (!this.dV().C) {
                this.c(1, true);
                this.c(2, hand == EnumHand.b);
                ((Entity)this).a(GameEvent.D);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (bP.equals(key)) {
            if (this.dV().C) {
                this.fP().ifPresent(this::a);
            }
        } else if (aC.equals(key) && this.dV().C) {
            if (this.fz() && this.by.f()) {
                this.by = this.b(this.fA());
                if (!this.by.f()) {
                    this.bz = this.by.a(this);
                }
            } else if (!this.fz() && !this.by.f()) {
                this.by = ItemStack.j;
                this.totalEatTimeTicks = 0;
                this.bz = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        super.a(anchor, target);
        this.ba = this.aZ;
        this.aY = this.aX = this.aZ;
    }

    @Override
    public float t(float partialTick) {
        return MathHelper.h(partialTick, this.aY, this.aX);
    }

    public void b(ItemStack stack, int amount) {
        for (int i2 = 0; i2 < amount; ++i2) {
            Vec3D vec3 = new Vec3D(((double)this.ae.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.a(-this.dN() * ((float)Math.PI / 180));
            vec3 = vec3.b(-this.dL() * ((float)Math.PI / 180));
            double d2 = (double)(-this.ae.i()) * 0.6 - 0.3;
            Vec3D vec31 = new Vec3D(((double)this.ae.i() - 0.5) * 0.3, d2, 0.6);
            vec31 = vec31.a(-this.dN() * ((float)Math.PI / 180));
            vec31 = vec31.b(-this.dL() * ((float)Math.PI / 180));
            vec31 = vec31.b(this.dA(), this.dE(), this.dG());
            this.dV().a(new ParticleParamItem(Particles.T, stack), vec31.d, vec31.e, vec31.f, vec3.d, vec3.e + 0.05, vec3.f);
        }
    }

    public void w() {
        if (!this.dV().C || this.fz()) {
            EnumHand usedItemHand = this.fA();
            if (!this.by.equals(this.b(usedItemHand))) {
                this.fE();
            } else if (!this.by.f() && this.fz()) {
                ItemStack itemStack;
                this.startUsingItem(this.fA(), true);
                PlayerItemConsumeEvent event = null;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.by);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(usedItemHand);
                    event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.by.a(DataComponents.x);
                        if (consumable != null) {
                            consumable.cancelUsingItem(serverPlayer, this.by);
                        }
                        serverPlayer.getBukkitEntity().updateInventory();
                        serverPlayer.getBukkitEntity().updateScaledHealth();
                        this.fF();
                        return;
                    }
                    itemStack = craftItem.equals((Object)event.getItem()) ? this.by.a(this.dV(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.dV(), this);
                } else {
                    itemStack = this.by.a(this.dV(), this);
                }
                ItemStack defaultReplacement = itemStack;
                if (event != null && event.getReplacement() != null) {
                    itemStack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemStack != this.by) {
                    this.a(usedItemHand, itemStack);
                }
                this.fF();
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).getBukkitEntity().updateInventory();
                }
            }
        }
    }

    public void b(ItemStack stack) {
    }

    public ItemStack fB() {
        return this.by;
    }

    public int fC() {
        return this.bz;
    }

    public int fD() {
        return this.fz() ? this.by.a(this) - this.fC() : 0;
    }

    public void fE() {
        if (!this.by.f()) {
            if (this instanceof EntityPlayer) {
                new PlayerStopUsingItemEvent((Player)this.getBukkitEntity(), this.by.asBukkitMirror(), this.fD()).callEvent();
            }
            this.by.a(this.dV(), this, this.fC());
            if (this.by.x()) {
                this.L();
            }
        }
        this.fF();
    }

    public void fF() {
        if (!this.dV().C) {
            boolean isUsingItem = this.fz();
            this.c(1, false);
            if (isUsingItem) {
                ((Entity)this).a(GameEvent.C);
            }
        }
        this.by = ItemStack.j;
        this.totalEatTimeTicks = 0;
        this.bz = 0;
        this.eatStartTime = -1L;
    }

    public boolean fG() {
        return this.fH() != null;
    }

    @Nullable
    public ItemStack fH() {
        if (this.fz() && !this.by.f()) {
            net.minecraft.world.item.Item item = this.by.h();
            if (item.b(this.by) != ItemUseAnimation.d) {
                return null;
            }
            return item.a(this.by, this) - this.bz < this.getShieldBlockingDelay() ? null : this.by;
        }
        return null;
    }

    public MovingObjectPosition getRayTrace(int maxDistance, RayTrace.FluidCollisionOption fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = new Vec3D(this.dA(), this.dC() + (double)this.cS(), this.dG());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3D end = new Vec3D(start.d + dir.getX(), start.e + dir.getY(), start.f + dir.getZ());
        RayTrace raytrace = new RayTrace(start, end, RayTrace.BlockCollisionOption.b, fluidCollisionOption, this);
        return this.dV().a(raytrace);
    }

    @Nullable
    public MovingObjectPositionEntity getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = this.m(1.0f);
        Vec3D direction = this.bT();
        Vec3D end = start.b(direction.d * (double)maxDistance, direction.e * (double)maxDistance, direction.f * (double)maxDistance);
        List<Entity> entityList = this.dV().a((Entity)this, this.cR().b(direction.d * (double)maxDistance, direction.e * (double)maxDistance, direction.f * (double)maxDistance).c(1.0, 1.0, 1.0), IEntitySelector.f.and(Entity::bH));
        double distance = 0.0;
        MovingObjectPositionEntity result = null;
        for (Entity entity : entityList) {
            Vec3D rayTrace;
            double distanceTo;
            double inflationAmount = entity.bS();
            AxisAlignedBB aabb = entity.cR().c(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3D> rayTraceResult = aabb.b(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.g(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new MovingObjectPositionEntity(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public int getShieldBlockingDelay() {
        return this.shieldBlockingDelay;
    }

    public void setShieldBlockingDelay(int shieldBlockingDelay) {
        this.shieldBlockingDelay = shieldBlockingDelay;
    }

    public boolean fI() {
        return this.cd();
    }

    public boolean fJ() {
        return this.i(7);
    }

    @Override
    public boolean cl() {
        return super.cl() || !this.fJ() && this.c(EntityPose.b);
    }

    public int fK() {
        return this.bA;
    }

    public boolean b(double x2, double y2, double z2, boolean broadcastTeleport) {
        return this.randomTeleport(x2, y2, z2, broadcastTeleport, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double x2, double y2, double z2, boolean broadcastTeleport, PlayerTeleportEvent.TeleportCause cause) {
        EntityLiving entityLiving;
        double x1 = this.dA();
        double y1 = this.dC();
        double z1 = this.dG();
        double d2 = y2;
        boolean flag = false;
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        net.minecraft.world.level.World level = this.dV();
        if (level.B(blockPos)) {
            boolean flag1 = false;
            while (!flag1 && blockPos.v() > level.L_()) {
                BlockPosition blockPos1 = blockPos.e();
                IBlockData blockState = level.a_(blockPos1);
                if (blockState.d()) {
                    flag1 = true;
                    continue;
                }
                d2 -= 1.0;
                blockPos = blockPos1;
            }
            if (flag1) {
                this.a_(x2, d2, z2);
                if (level.g(this) && !level.d(this.cR())) {
                    flag = true;
                }
                this.a_(x1, y1, z1);
                if (flag) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.dV().getWorld(), x1, y1, z1), new Location((World)this.dV().getWorld(), x2, d2, z2));
                        this.dV().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled() || teleport.getTo() == null) return Optional.empty();
                        Location to = teleport.getTo();
                        this.c(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).f.teleport(x2, d2, z2, this.dL(), this.dN(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag) {
            return Optional.of(false);
        }
        if (broadcastTeleport) {
            level.a((Entity)this, (byte)46);
        }
        if (!((entityLiving = this) instanceof EntityCreature)) return Optional.of(true);
        EntityCreature pathfinderMob = (EntityCreature)entityLiving;
        pathfinderMob.P().m();
        return Optional.of(true);
    }

    public boolean fL() {
        return !this.eE();
    }

    public boolean fM() {
        return true;
    }

    public void a(BlockPosition jukebox, boolean partyParrot) {
    }

    public boolean fN() {
        return false;
    }

    @Override
    public final EntitySize a(EntityPose pose) {
        return pose == EntityPose.c ? aD : this.e(pose).a(this.ej());
    }

    protected EntitySize e(EntityPose pose) {
        return this.aq().n().a(this.ei());
    }

    public ImmutableList<EntityPose> fO() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB f(EntityPose pose) {
        EntitySize dimensions = this.a(pose);
        return new AxisAlignedBB(-dimensions.a() / 2.0f, 0.0, -dimensions.a() / 2.0f, dimensions.a() / 2.0f, dimensions.b(), dimensions.a() / 2.0f);
    }

    protected boolean g(EntityPose pose) {
        AxisAlignedBB aabb = this.a(pose).a(this.dt());
        return this.dV().b(this, aabb);
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return super.o(allowPassengers) && !this.fR();
    }

    public Optional<BlockPosition> fP() {
        return this.al.a(bP);
    }

    public void g(BlockPosition pos) {
        this.al.a(bP, Optional.of(pos));
    }

    public void fQ() {
        this.al.a(bP, Optional.empty());
    }

    public boolean fR() {
        return this.fP().isPresent();
    }

    public void b(BlockPosition pos) {
        IBlockData blockState;
        if (this.bZ()) {
            this.ae();
        }
        if ((blockState = this.dV().a_(pos)).b() instanceof BlockBed) {
            this.dV().a(pos, (IBlockData)blockState.b(BlockBed.c, true), 3);
        }
        this.b(EntityPose.c);
        this.a(pos);
        this.g(pos);
        this.i(Vec3D.c);
        this.ar = true;
    }

    private void a(BlockPosition pos) {
        this.a_((double)pos.u() + 0.5, (double)pos.v() + 0.6875, (double)pos.w() + 0.5);
    }

    private boolean O() {
        return this.fP().map(pos -> this.dV().a_((BlockPosition)pos).b() instanceof BlockBed).orElse(false);
    }

    public void fS() {
        this.fP().filter(this.dV()::B).ifPresent(blockPos -> {
            IBlockData blockState = this.dV().a_((BlockPosition)blockPos);
            if (blockState.b() instanceof BlockBed) {
                EnumDirection direction = blockState.c(BlockFacingHorizontal.aF);
                this.dV().a((BlockPosition)blockPos, (IBlockData)blockState.b(BlockBed.c, false), 3);
                Vec3D vec31 = BlockBed.a(this.aq(), (ICollisionAccess)this.dV(), blockPos, direction, this.dL()).orElseGet(() -> {
                    BlockPosition blockPos1 = blockPos.d();
                    return new Vec3D((double)blockPos1.u() + 0.5, (double)blockPos1.v() + 0.1, (double)blockPos1.w() + 0.5);
                });
                Vec3D vec32 = Vec3D.c(blockPos).d(vec31).d();
                float f2 = (float)MathHelper.d(MathHelper.d(vec32.f, vec32.d) * 180.0 / 3.1415927410125732 - 90.0);
                this.a_(vec31.d, vec31.e, vec31.f);
                this.v(f2);
                this.w(0.0f);
            }
        });
        Vec3D vec3 = this.dt();
        this.b(EntityPose.a);
        this.a_(vec3.d, vec3.e, vec3.f);
        this.fQ();
    }

    @Nullable
    public EnumDirection fT() {
        BlockPosition blockPos = this.fP().orElse(null);
        return blockPos != null ? BlockBed.a(this.dV(), blockPos) : null;
    }

    @Override
    public boolean bM() {
        return !this.fR() && super.bM();
    }

    public ItemStack d(ItemStack weaponStack) {
        return ItemStack.j;
    }

    public static byte i(EnumItemSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.a -> 47;
            case EnumItemSlot.b -> 48;
            case EnumItemSlot.f -> 49;
            case EnumItemSlot.e -> 50;
            case EnumItemSlot.c -> 52;
            case EnumItemSlot.d -> 51;
            case EnumItemSlot.g -> 65;
        };
    }

    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        this.dV().a((Entity)this, EntityLiving.i(slot));
        this.a(this.a(slot), slot, this.bR);
    }

    private void a(ItemStack stack, EnumItemSlot slot, AttributeMapBase attributeMap) {
        stack.a(slot, (Holder<AttributeBase> attribute, AttributeModifier modifier) -> {
            AttributeModifiable instance = attributeMap.a((Holder<AttributeBase>)attribute);
            if (instance != null) {
                instance.e((AttributeModifier)modifier);
            }
        });
        EnchantmentManager.a(stack, this, slot);
    }

    public static EnumItemSlot d(EnumHand hand) {
        return hand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b;
    }

    public final boolean e(ItemStack stack) {
        if (this.bL() && !this.Z_()) {
            Equippable equippable = stack.a(DataComponents.D);
            if (equippable != null && equippable.f()) {
                EnumItemSlot equipmentSlot = equippable.a();
                return this.e(equipmentSlot) && equippable.a(this.aq()) && this.a(equipmentSlot).f() && this.f(equipmentSlot);
            }
            return false;
        }
        return false;
    }

    protected boolean f(EnumItemSlot slot) {
        return true;
    }

    public final EnumItemSlot f(ItemStack stack) {
        Equippable equippable = stack.a(DataComponents.D);
        return equippable != null && this.e(equippable.a()) ? equippable.a() : EnumItemSlot.a;
    }

    public final boolean a(ItemStack stack, EnumItemSlot slot) {
        Equippable equippable = stack.a(DataComponents.D);
        return equippable == null ? slot == EnumItemSlot.a && this.e(EnumItemSlot.a) : slot == equippable.a() && this.e(equippable.a()) && equippable.a(this.aq());
    }

    private static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return slot != EnumItemSlot.f && slot != EnumItemSlot.a && slot != EnumItemSlot.b ? SlotAccess.a(entity, slot, (ItemStack stack) -> stack.f() || entity.f((ItemStack)stack) == slot) : SlotAccess.a(entity, slot);
    }

    @Nullable
    private static EnumItemSlot r(int index) {
        if (index == 100 + EnumItemSlot.f.b()) {
            return EnumItemSlot.f;
        }
        if (index == 100 + EnumItemSlot.e.b()) {
            return EnumItemSlot.e;
        }
        if (index == 100 + EnumItemSlot.d.b()) {
            return EnumItemSlot.d;
        }
        if (index == 100 + EnumItemSlot.c.b()) {
            return EnumItemSlot.c;
        }
        if (index == 98) {
            return EnumItemSlot.a;
        }
        if (index == 99) {
            return EnumItemSlot.b;
        }
        return index == 105 ? EnumItemSlot.g : null;
    }

    @Override
    public SlotAccess a_(int slot) {
        EnumItemSlot equipmentSlot = EntityLiving.r(slot);
        return equipmentSlot != null ? EntityLiving.a(this, equipmentSlot) : super.a_(slot);
    }

    @Override
    public boolean dJ() {
        if (this.Z_()) {
            return false;
        }
        boolean flag = !this.a(EnumItemSlot.f).a(TagsItem.bq) && !this.a(EnumItemSlot.e).a(TagsItem.bq) && !this.a(EnumItemSlot.d).a(TagsItem.bq) && !this.a(EnumItemSlot.c).a(TagsItem.bq) && !this.a(EnumItemSlot.g).a(TagsItem.bq);
        return flag && super.dJ();
    }

    @Override
    public boolean co() {
        return !this.dV().B_() && this.b(MobEffects.x) || super.co();
    }

    @Override
    public float dM() {
        return this.aX;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        float yRot = packet.n();
        float xRot = packet.m();
        this.f(x2, y2, z2);
        this.aX = packet.o();
        this.aZ = packet.o();
        this.aY = this.aX;
        this.ba = this.aZ;
        this.e(packet.b());
        this.a_(packet.e());
        this.a(x2, y2, z2, yRot, xRot);
        this.n(packet.j(), packet.k(), packet.l());
    }

    public boolean fU() {
        return this.dZ().h() instanceof ItemAxe;
    }

    @Override
    public float dP() {
        float f2 = (float)this.h(GenericAttributes.B);
        return this.cW() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D m(Entity entity) {
        return this.dt().e(this.a(entity, this.a(this.aw()), this.ej() * this.ei()));
    }

    protected void a(int lerpHeadSteps, double lerpYHeadRot) {
        this.aZ = (float)MathHelper.e(1.0 / (double)lerpHeadSteps, (double)this.aZ, lerpYHeadRot);
    }

    @Override
    public void g(int ticks) {
        super.g(MathHelper.c((double)ticks * this.h(GenericAttributes.h)));
    }

    public boolean fV() {
        return false;
    }

    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.d(damageSource) || EnchantmentManager.a(level, this, damageSource);
    }

    public static boolean b(ItemStack stack, EnumItemSlot slot) {
        if (!stack.b(DataComponents.F)) {
            return false;
        }
        Equippable equippable = stack.a(DataComponents.D);
        return equippable != null && slot == equippable.a() && !stack.r();
    }

    @VisibleForTesting
    public int fW() {
        return this.bd;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

