/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityLightning
extends Entity {
    private static final int b = 2;
    private static final double c = 3.0;
    private static final double d = 15.0;
    public int e = 2;
    public long a;
    public int f;
    public boolean g;
    @Nullable
    private EntityPlayer h;
    private final Set<Entity> i = Sets.newHashSet();
    private int j;
    public boolean isEffect;

    public EntityLightning(EntityTypes<? extends EntityLightning> entityType, World level) {
        super(entityType, level);
        this.a = this.ae.g();
        this.f = this.ae.a(3) + 1;
    }

    public void a(boolean visualOnly) {
        this.g = visualOnly;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.d;
    }

    @Nullable
    public EntityPlayer l() {
        return this.h;
    }

    public void b(@Nullable EntityPlayer cause) {
        this.h = cause;
    }

    private void s() {
        BlockPosition strikePosition = this.t();
        IBlockData blockState = this.dV().a_(strikePosition);
        if (blockState.a(Blocks.sU)) {
            ((LightningRodBlock)blockState.b()).e(blockState, this.dV(), strikePosition);
        }
    }

    @Override
    public void h() {
        List<Entity> entities;
        super.h();
        if (!this.isEffect && this.e == 2) {
            if (this.dV().B_()) {
                this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.ou, SoundCategory.d, 10000.0f, 0.8f + this.ae.i() * 0.2f, false);
                this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.ot, SoundCategory.d, 2.0f, 0.5f + this.ae.i() * 0.2f, false);
            } else {
                EnumDifficulty difficulty = this.dV().am();
                if (difficulty == EnumDifficulty.c || difficulty == EnumDifficulty.d) {
                    this.b(4);
                }
                this.s();
                EntityLightning.clearCopperOnLightningStrike(this.dV(), this.t(), this);
                this.a(GameEvent.G);
            }
        }
        --this.e;
        if (this.e < 0) {
            if (this.f == 0) {
                if (this.dV() instanceof WorldServer) {
                    entities = this.dV().a((Entity)this, new AxisAlignedBB(this.dA() - 15.0, this.dC() - 15.0, this.dG() - 15.0, this.dA() + 15.0, this.dC() + 6.0 + 15.0, this.dG() + 15.0), (? super Entity entity1) -> entity1.bL() && !this.i.contains(entity1));
                    for (EntityPlayer serverPlayer : ((WorldServer)this.dV()).a((? super EntityPlayer player) -> player.f(this) < 256.0f)) {
                        CriterionTriggers.V.a(serverPlayer, this, entities);
                    }
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            } else if (this.e < -this.ae.a(10)) {
                --this.f;
                this.e = 1;
                this.a = this.ae.g();
                this.b(0);
            }
        }
        if (this.e >= 0 && !this.isEffect) {
            if (!(this.dV() instanceof WorldServer)) {
                this.dV().c(2);
            } else if (!this.g && !this.isEffect) {
                entities = this.dV().a((Entity)this, new AxisAlignedBB(this.dA() - 3.0, this.dC() - 3.0, this.dG() - 3.0, this.dA() + 3.0, this.dC() + 6.0 + 3.0, this.dG() + 3.0), Entity::bL);
                for (Entity entity : entities) {
                    entity.a((WorldServer)this.dV(), this);
                }
                this.i.addAll(entities);
                if (this.h != null) {
                    CriterionTriggers.F.a(this.h, entities);
                }
            }
        }
    }

    private BlockPosition t() {
        Vec3D vec3 = this.dt();
        return BlockPosition.a(vec3.d, vec3.e - 1.0E-6, vec3.f);
    }

    private void b(int extraIgnitions) {
        WorldServer serverLevel;
        World world;
        if (!this.g && !this.isEffect && (world = this.dV()) instanceof WorldServer && (serverLevel = (WorldServer)world).O().b(GameRules.b)) {
            BlockPosition blockPos = this.dv();
            IBlockData state = BlockFireAbstract.a(this.dV(), blockPos);
            if (this.dV().a_(blockPos).l() && state.a((IWorldReader)this.dV(), blockPos) && !this.g && !CraftEventFactory.callBlockIgniteEvent(this.dV(), blockPos, this).isCancelled()) {
                this.dV().b(blockPos, state);
                ++this.j;
            }
            for (int i2 = 0; i2 < extraIgnitions; ++i2) {
                BlockPosition blockPos1 = blockPos.b(this.ae.a(3) - 1, this.ae.a(3) - 1, this.ae.a(3) - 1);
                state = BlockFireAbstract.a(this.dV(), blockPos1);
                if (!this.dV().a_(blockPos1).l() || !state.a((IWorldReader)this.dV(), blockPos1) || this.g || CraftEventFactory.callBlockIgniteEvent(this.dV(), blockPos1, this).isCancelled()) continue;
                this.dV().b(blockPos1, state);
                ++this.j;
            }
        }
    }

    private static void clearCopperOnLightningStrike(World level, BlockPosition pos, Entity lightning) {
        IBlockData blockState1;
        BlockPosition blockPos;
        IBlockData blockState = level.a_(pos);
        if (blockState.a(Blocks.sU)) {
            blockPos = pos.a(blockState.c(BlockDirectional.a).g());
            blockState1 = level.a_(blockPos);
        } else {
            blockPos = pos;
            blockState1 = blockState;
        }
        if (blockState1.b() instanceof WeatheringCopper) {
            IBlockData newBlockState = WeatheringCopper.c(level.a_(blockPos));
            if (CraftEventFactory.callEntityChangeBlockEvent(lightning, blockPos, newBlockState)) {
                level.b(blockPos, newBlockState);
            }
            BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
            int i2 = level.A.a(3) + 3;
            for (int i1 = 0; i1 < i2; ++i1) {
                int i22 = level.A.a(8) + 1;
                EntityLightning.randomWalkCleaningCopper(level, blockPos, mutableBlockPos, i22, lightning);
            }
        }
    }

    private static void randomWalkCleaningCopper(World level, BlockPosition pos, BlockPosition.MutableBlockPosition mutable, int steps, Entity lightning) {
        Optional<BlockPosition> optional;
        mutable.g(pos);
        for (int i2 = 0; i2 < steps && !(optional = EntityLightning.randomStepCleaningCopper(level, mutable, lightning)).isEmpty(); ++i2) {
            mutable.g(optional.get());
        }
    }

    private static Optional<BlockPosition> randomStepCleaningCopper(World level, BlockPosition pos, Entity lightning) {
        for (BlockPosition blockPos : BlockPosition.a(level.A, 10, pos, 1)) {
            IBlockData blockState = level.a_(blockPos);
            if (!(blockState.b() instanceof WeatheringCopper)) continue;
            WeatheringCopper.b(blockState).ifPresent(blockState1 -> {
                if (CraftEventFactory.callEntityChangeBlockEvent(lightning, blockPos, blockState1)) {
                    level.b(blockPos, (IBlockData)blockState1);
                }
            });
            level.c(3002, blockPos, -1);
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    @Override
    public boolean a(double distance) {
        double d2 = 64.0 * EntityLightning.cK();
        return distance < d2 * d2;
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    protected void a(NBTTagCompound compound) {
    }

    @Override
    protected void b(NBTTagCompound compound) {
    }

    public int m() {
        return this.j;
    }

    public Stream<Entity> p() {
        return this.i.stream().filter(Entity::bL);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }
}

