/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DespawnRange;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    protected static final int h = 1;
    private static final BaseBlockPosition bX = new BaseBlockPosition(1, 0, 1);
    private static final List<EnumItemSlot> bY = List.of(EnumItemSlot.f, EnumItemSlot.e, EnumItemSlot.d, EnumItemSlot.c);
    public static final float i = 0.15f;
    public static final float j = 0.55f;
    public static final float k = 0.5f;
    public static final float bG = 0.25f;
    public static final float bH = 0.085f;
    public static final float bI = 1.0f;
    public static final int bJ = 2;
    public static final int bK = 2;
    private static final double bZ = Math.sqrt(2.04f) - (double)0.6f;
    protected static final MinecraftKey bL = MinecraftKey.b("random_spawn_bonus");
    public int bM;
    protected int bN;
    protected ControllerLook bO;
    protected ControllerMove bP;
    protected ControllerJump bQ;
    private final EntityAIBodyControl ca;
    protected NavigationAbstract bR;
    public PathfinderGoalSelector bS;
    @Nullable
    public PathfinderGoalFloat goalFloat;
    public PathfinderGoalSelector bT;
    @Nullable
    private EntityLiving cb;
    private final EntitySenses cc;
    private final NonNullList<ItemStack> cd = NonNullList.a(2, ItemStack.j);
    public final float[] bU = new float[2];
    private final NonNullList<ItemStack> ce = NonNullList.a(4, ItemStack.j);
    public final float[] bV = new float[4];
    private ItemStack cf = ItemStack.j;
    protected float bW;
    private boolean cg;
    private boolean ch;
    private final Map<PathType, Float> ci = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> cj = Optional.empty();
    public long ck;
    @Nullable
    private Leashable.a cl;
    private BlockPosition cm = BlockPosition.c;
    private float cn = -1.0f;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> entityType, World level) {
        super((EntityTypes<? extends EntityLiving>)entityType, level);
        this.bS = new PathfinderGoalSelector();
        this.bT = new PathfinderGoalSelector();
        this.bO = new ControllerLook(this);
        this.bP = new ControllerMove(this);
        this.bQ = new ControllerJump(this);
        this.ca = this.J();
        this.bR = this.b(level);
        this.cc = new EntitySenses(this);
        Arrays.fill(this.bV, 0.085f);
        Arrays.fill(this.bU, 0.085f);
        this.bW = 0.085f;
        if (level instanceof WorldServer) {
            this.E();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.ch = persistenceRequired;
    }

    protected void E() {
    }

    public static AttributeProvider.Builder F() {
        return EntityLiving.ed().a(GenericAttributes.m, 16.0);
    }

    protected NavigationAbstract b(World level) {
        return new Navigation(this, level);
    }

    protected boolean G() {
        return false;
    }

    public float a(PathType pathType) {
        EntityInsentient mob;
        Entity entity = this.dl();
        EntityInsentient mob1 = entity instanceof EntityInsentient && (mob = (EntityInsentient)entity).G() ? mob : this;
        Float _float = mob1.ci.get((Object)pathType);
        return _float == null ? pathType.a() : _float.floatValue();
    }

    public void a(PathType pathType, float malus) {
        this.ci.put(pathType, Float.valueOf(malus));
    }

    @Override
    public void H() {
    }

    public void I() {
    }

    protected EntityAIBodyControl J() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook L() {
        return this.bO;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.bS.inactiveTick()) {
            this.bS.a();
        }
        if (this.bT.inactiveTick()) {
            this.bT.a();
        }
    }

    public ControllerMove N() {
        ControllerMove controllerMove;
        Entity entity = this.dl();
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            controllerMove = mob.N();
        } else {
            controllerMove = this.bP;
        }
        return controllerMove;
    }

    public ControllerJump O() {
        return this.bQ;
    }

    public NavigationAbstract P() {
        NavigationAbstract navigationAbstract;
        Entity entity = this.dl();
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            navigationAbstract = mob.P();
        } else {
            navigationAbstract = this.bR;
        }
        return navigationAbstract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public EntityLiving cW() {
        Entity firstPassenger = this.cZ();
        if (this.gf()) return null;
        if (!(firstPassenger instanceof EntityInsentient)) return null;
        EntityInsentient mob = (EntityInsentient)firstPassenger;
        if (!firstPassenger.cc()) return null;
        EntityInsentient entityInsentient = mob;
        return entityInsentient;
    }

    public EntitySenses Q() {
        return this.cc;
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.cb;
    }

    @Nullable
    protected final EntityLiving R() {
        return this.eb().c(MemoryModuleType.o).orElse(null);
    }

    public void h(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving target, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.O_() == target) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.O_() != null && target == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.O_().bL() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.dV().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (target != null) {
                ctarget = (CraftLivingEntity)target.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            target = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.cb = target;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return type != EntityTypes.ad;
    }

    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return false;
    }

    public void S() {
        ((Entity)this).a(GameEvent.m);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)0);
    }

    public int T() {
        return 80;
    }

    public void U() {
        this.b(this.u());
    }

    @Override
    public void az() {
        super.az();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("mobBaseTick");
        if (this.bL() && this.ae.a(1000) < this.bM++) {
            this.m();
            this.U();
        }
        profilerFiller.c();
    }

    @Override
    protected void h(DamageSource source) {
        this.m();
        super.h(source);
    }

    private void m() {
        this.bM = -this.T();
    }

    @Override
    protected int e(WorldServer level) {
        if (this.bN > 0) {
            int i2 = this.bN;
            for (int i1 = 0; i1 < this.ce.size(); ++i1) {
                if (this.ce.get(i1).f() || !(this.bV[i1] <= 1.0f)) continue;
                i2 += 1 + this.ae.a(3);
            }
            for (int i1x = 0; i1x < this.cd.size(); ++i1x) {
                if (this.cd.get(i1x).f() || !(this.bU[i1x] <= 1.0f)) continue;
                i2 += 1 + this.ae.a(3);
            }
            if (!this.cf.f() && this.bW <= 1.0f) {
                i2 += 1 + this.ae.a(3);
            }
            return i2;
        }
        return this.bN;
    }

    public void V() {
        if (this.dV().C) {
            this.eW();
        } else {
            this.dV().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 20) {
            this.V();
        } else {
            super.b(id);
        }
    }

    @Override
    public void h() {
        super.h();
        if (!this.dV().C && this.af % 5 == 0) {
            this.W();
        }
    }

    protected void W() {
        boolean flag = !(this.cW() instanceof EntityInsentient);
        boolean flag1 = !(this.dk() instanceof AbstractBoat);
        this.bS.a(PathfinderGoal.Type.a, flag);
        this.bS.a(PathfinderGoal.Type.c, flag && flag1);
        this.bS.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected float g(float yRot, float animStep) {
        this.ca.a();
        return animStep;
    }

    @Nullable
    protected SoundEffect u() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.u();
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("CanPickUpLoot", this.fN());
        compound.a("PersistenceRequired", this.ch);
        NBTTagList listTag = new NBTTagList();
        for (ItemStack itemStack : this.ce) {
            if (!itemStack.f()) {
                listTag.add(itemStack.a(this.dX()));
                continue;
            }
            listTag.add(new NBTTagCompound());
        }
        compound.a("ArmorItems", listTag);
        NBTTagList listTag1 = new NBTTagList();
        for (float f2 : this.bV) {
            listTag1.add(NBTTagFloat.a(f2));
        }
        compound.a("ArmorDropChances", listTag1);
        NBTTagList nBTTagList = new NBTTagList();
        for (ItemStack itemStack1 : this.cd) {
            if (!itemStack1.f()) {
                nBTTagList.add(itemStack1.a(this.dX()));
                continue;
            }
            nBTTagList.add(new NBTTagCompound());
        }
        compound.a("HandItems", nBTTagList);
        NBTTagList listTag3 = new NBTTagList();
        for (float f1 : this.bU) {
            listTag3.add(NBTTagFloat.a(f1));
        }
        compound.a("HandDropChances", listTag3);
        if (!this.cf.f()) {
            compound.a("body_armor_item", this.cf.a(this.dX()));
            compound.a("body_armor_drop_chance", this.bW);
        }
        this.a(compound, this.cl);
        compound.a("LeftHanded", this.gg());
        if (this.cj.isPresent()) {
            compound.a("DeathLootTable", this.cj.get().a().toString());
        }
        if (this.ck != 0L) {
            compound.a("DeathLootTableSeed", this.ck);
        }
        if (this.gf()) {
            compound.a("NoAI", this.gf());
        }
        compound.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound compound) {
        NBTTagCompound compound1;
        int i2;
        NBTTagList list;
        boolean data;
        super.a(compound);
        if (compound.b("CanPickUpLoot", 99)) {
            data = compound.q("CanPickUpLoot");
            if (EntityInsentient.isLevelAtLeast(compound, 1) || data) {
                this.a_(data);
            }
        }
        data = compound.q("PersistenceRequired");
        if (EntityInsentient.isLevelAtLeast(compound, 1) || data) {
            this.ch = data;
        }
        if (compound.b("ArmorItems", 9)) {
            list = compound.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.ce.size(); ++i2) {
                compound1 = list.a(i2);
                this.ce.set(i2, ItemStack.a((HolderLookup.a)this.dX(), compound1));
            }
        } else {
            this.ce.replaceAll(itemStack -> ItemStack.j);
        }
        if (compound.b("ArmorDropChances", 9)) {
            list = compound.c("ArmorDropChances", 5);
            for (i2 = 0; i2 < list.size(); ++i2) {
                this.bV[i2] = list.i(i2);
            }
        } else {
            Arrays.fill(this.bV, 0.0f);
        }
        if (compound.b("HandItems", 9)) {
            list = compound.c("HandItems", 10);
            for (i2 = 0; i2 < this.cd.size(); ++i2) {
                compound1 = list.a(i2);
                this.cd.set(i2, ItemStack.a((HolderLookup.a)this.dX(), compound1));
            }
        } else {
            this.cd.replaceAll(itemStack -> ItemStack.j);
        }
        if (compound.b("HandDropChances", 9)) {
            list = compound.c("HandDropChances", 5);
            for (i2 = 0; i2 < list.size(); ++i2) {
                this.bU[i2] = list.i(i2);
            }
        } else {
            Arrays.fill(this.bU, 0.0f);
        }
        if (compound.b("body_armor_item", 10)) {
            this.cf = ItemStack.a((HolderLookup.a)this.dX(), (NBTBase)compound.p("body_armor_item")).orElse(ItemStack.j);
            this.bW = compound.j("body_armor_drop_chance");
        } else {
            this.cf = ItemStack.j;
        }
        this.c(compound);
        this.v(compound.q("LeftHanded"));
        this.cj = compound.b("DeathLootTable", 8) ? Optional.ofNullable(MinecraftKey.c(compound.l("DeathLootTable"))).map(rs -> ResourceKey.a(Registries.bg, rs)) : Optional.empty();
        this.ck = compound.i("DeathLootTableSeed");
        this.u(compound.q("NoAI"));
        if (compound.e("Bukkit.Aware")) {
            this.aware = compound.q("Bukkit.Aware");
        }
    }

    @Override
    protected void b(WorldServer level, DamageSource damageSource, boolean playerKill) {
        super.b(level, damageSource, playerKill);
        this.cj = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> ea() {
        return this.cj.isPresent() ? this.cj : super.ea();
    }

    @Override
    public long eG() {
        return this.ck;
    }

    public void G(float amount) {
        this.bp = amount;
    }

    public void H(float amount) {
        this.bo = amount;
    }

    public void I(float amount) {
        this.bn = amount;
    }

    @Override
    public void C(float speed) {
        super.C(speed);
        this.G(speed);
    }

    public void X() {
        this.P().m();
        this.I(0.0f);
        this.H(0.0f);
        this.C(0.0f);
    }

    @Override
    public void d_() {
        super.d_();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("looting");
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.fN() && this.bL() && !this.be && serverLevel.O().b(GameRules.c)) {
                BaseBlockPosition pickupReach = this.Y();
                for (EntityItem itemEntity : this.dV().a(EntityItem.class, this.cR().c(pickupReach.u(), pickupReach.v(), pickupReach.w()))) {
                    if (itemEntity.dQ() || itemEntity.l().f() || itemEntity.v() || !this.c(serverLevel, itemEntity.l()) || !itemEntity.canMobPickup) continue;
                    this.a(serverLevel, itemEntity);
                }
            }
        }
        profilerFiller.c();
    }

    protected BaseBlockPosition Y() {
        return bX;
    }

    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.l();
        ItemStack itemStack = this.equipItemIfPossible(level, item.v(), entity);
        if (!itemStack.f()) {
            this.a(entity);
            this.a((Entity)entity, itemStack.M());
            item.h(itemStack.M());
            if (item.f()) {
                entity.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack b(WorldServer level, ItemStack stack) {
        return this.equipItemIfPossible(level, stack, null);
    }

    public ItemStack equipItemIfPossible(WorldServer level, ItemStack stack, EntityItem entity) {
        boolean canPickup;
        EnumItemSlot equipmentSlotForItem = this.f(stack);
        ItemStack itemBySlot = this.a(equipmentSlotForItem);
        boolean canReplaceCurrentItem = this.a(stack, itemBySlot, equipmentSlotForItem);
        if (equipmentSlotForItem.f() && !canReplaceCurrentItem) {
            equipmentSlotForItem = EnumItemSlot.a;
            itemBySlot = this.a(equipmentSlotForItem);
            canReplaceCurrentItem = itemBySlot.f();
        }
        boolean bl = canPickup = canReplaceCurrentItem && this.g(stack);
        if (entity != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d2 = this.h(equipmentSlotForItem);
            if (!itemBySlot.f() && (double)Math.max(this.ae.i() - 0.1f, 0.0f) < d2) {
                this.forceDrops = true;
                this.a(level, itemBySlot);
                this.forceDrops = false;
            }
            ItemStack itemStack = equipmentSlotForItem.a(stack);
            this.b(equipmentSlotForItem, itemStack);
            return itemStack;
        }
        return ItemStack.j;
    }

    protected void b(EnumItemSlot slot, ItemStack stack) {
        this.a(slot, stack);
        this.g(slot);
        this.ch = true;
    }

    public void g(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                this.bU[slot.b()] = 2.0f;
                break;
            }
            case b: {
                this.bV[slot.b()] = 2.0f;
                break;
            }
            case c: {
                this.bW = 2.0f;
            }
        }
    }

    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (currentItem.f()) {
            return true;
        }
        return slot.f() ? this.b(newItem, currentItem, slot) : slot == EnumItemSlot.a && this.c(newItem, currentItem, slot);
    }

    private boolean b(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (EnchantmentManager.a(currentItem, EnchantmentEffectComponents.E)) {
            return false;
        }
        double approximateAttributeWith = this.a(newItem, GenericAttributes.a, slot);
        double approximateAttributeWith1 = this.a(currentItem, GenericAttributes.a, slot);
        double approximateAttributeWith2 = this.a(newItem, GenericAttributes.b, slot);
        double approximateAttributeWith3 = this.a(currentItem, GenericAttributes.b, slot);
        if (approximateAttributeWith != approximateAttributeWith1) {
            return approximateAttributeWith > approximateAttributeWith1;
        }
        return approximateAttributeWith2 != approximateAttributeWith3 ? approximateAttributeWith2 > approximateAttributeWith3 : this.b(newItem, currentItem);
    }

    private boolean c(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        double approximateAttributeWith1;
        double approximateAttributeWith;
        TagKey<Item> preferredWeaponType = this.Z();
        if (preferredWeaponType != null) {
            if (currentItem.a(preferredWeaponType) && !newItem.a(preferredWeaponType)) {
                return false;
            }
            if (!currentItem.a(preferredWeaponType) && newItem.a(preferredWeaponType)) {
                return true;
            }
        }
        return (approximateAttributeWith = this.a(newItem, GenericAttributes.c, slot)) != (approximateAttributeWith1 = this.a(currentItem, GenericAttributes.c, slot)) ? approximateAttributeWith > approximateAttributeWith1 : this.b(newItem, currentItem);
    }

    private double a(ItemStack item, Holder<AttributeBase> attribute, EnumItemSlot slot) {
        double d2 = this.eY().b(attribute) ? this.i(attribute) : 0.0;
        ItemAttributeModifiers itemAttributeModifiers = item.a(DataComponents.o, ItemAttributeModifiers.a);
        return itemAttributeModifiers.a(d2, slot);
    }

    public boolean b(ItemStack candidate, ItemStack existing) {
        int damageValue1;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set = existing.a(DataComponents.l, ItemEnchantments.a).b();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set1 = candidate.a(DataComponents.l, ItemEnchantments.a).b();
        if (set1.size() != set.size()) {
            return set1.size() > set.size();
        }
        int damageValue = candidate.o();
        return damageValue != (damageValue1 = existing.o()) ? damageValue < damageValue1 : candidate.b(DataComponents.g) && !existing.b(DataComponents.g);
    }

    public boolean g(ItemStack stack) {
        return true;
    }

    public boolean c(WorldServer level, ItemStack stack) {
        return this.g(stack);
    }

    @Nullable
    public TagKey<Item> Z() {
        return null;
    }

    public boolean h(double distanceToClosestPlayer) {
        return true;
    }

    public boolean aa() {
        return this.bZ();
    }

    protected boolean ab() {
        return false;
    }

    @Override
    public void dH() {
        if (this.dV().am() == EnumDifficulty.a && this.ab()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.fZ() && !this.aa()) {
            EntityHuman nearestPlayer = this.dV().findNearbyPlayer(this, -1.0, IEntitySelector.PLAYER_AFFECTS_SPAWNING);
            if (nearestPlayer != null) {
                WorldConfiguration.Entities.Spawning.DespawnRangePair despawnRangePair = this.dV().paperConfig().entities.spawning.despawnRanges.get(this.aq().f());
                DespawnRange.Shape shape = this.dV().paperConfig().entities.spawning.despawnRangeShape;
                double dy = Math.abs(nearestPlayer.dC() - this.dC());
                double dySqr = Math.pow(dy, 2.0);
                double dxSqr = Math.pow(nearestPlayer.dA() - this.dA(), 2.0);
                double dzSqr = Math.pow(nearestPlayer.dG() - this.dG(), 2.0);
                double distanceSquared = dxSqr + dzSqr + dySqr;
                if (despawnRangePair.hard().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy) && this.h(distanceSquared)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                if (despawnRangePair.soft().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy)) {
                    if (this.bf > 600 && this.ae.a(800) == 0 && this.h(distanceSquared)) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    }
                } else {
                    this.bf = 0;
                }
            }
        } else {
            this.bf = 0;
        }
    }

    @Override
    protected final void fu() {
        ++this.bf;
        if (!this.aware) {
            if (this.goalFloat != null) {
                if (this.goalFloat.b()) {
                    this.goalFloat.a();
                }
                this.O().b();
            }
            return;
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("sensing");
        this.cc.a();
        profilerFiller.c();
        int i2 = this.af + this.ar();
        if (i2 % 2 != 0 && this.af > 1) {
            profilerFiller.a("targetSelector");
            this.bT.a(false);
            profilerFiller.c();
            profilerFiller.a("goalSelector");
            this.bS.a(false);
            profilerFiller.c();
        } else {
            profilerFiller.a("targetSelector");
            this.bT.a();
            profilerFiller.c();
            profilerFiller.a("goalSelector");
            this.bS.a();
            profilerFiller.c();
        }
        profilerFiller.a("navigation");
        this.bR.c();
        profilerFiller.c();
        profilerFiller.a("mob tick");
        this.a((WorldServer)this.dV());
        profilerFiller.c();
        profilerFiller.a("controls");
        profilerFiller.a("move");
        this.bP.a();
        profilerFiller.b("look");
        this.bO.a();
        profilerFiller.b("jump");
        this.bQ.b();
        profilerFiller.c();
        profilerFiller.c();
        this.ac();
    }

    protected void ac() {
        PacketDebug.a(this.dV(), this, this.bS);
    }

    protected void a(WorldServer level) {
    }

    public int ad() {
        return 40;
    }

    public int af() {
        return 75;
    }

    protected void ag() {
        float f2 = this.af();
        float yHeadRot = this.cA();
        float f1 = MathHelper.h(this.aX - yHeadRot);
        float f22 = MathHelper.a(MathHelper.h(this.aX - yHeadRot), -f2, f2);
        float f3 = yHeadRot + f1 - f22;
        this.q(f3);
    }

    public int ai() {
        return 10;
    }

    public void a(Entity entity, float maxYRotIncrease, float maxXRotIncrease) {
        double d2;
        double d3 = entity.dA() - this.dA();
        double d1 = entity.dG() - this.dG();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            d2 = livingEntity.dE() - this.dE();
        } else {
            d2 = (entity.cR().b + entity.cR().e) / 2.0 - this.dE();
        }
        double squareRoot = Math.sqrt(d3 * d3 + d1 * d1);
        float f2 = (float)(MathHelper.d(d1, d3) * 180.0 / 3.1415927410125732) - 90.0f;
        float f1 = (float)(-(MathHelper.d(d2, squareRoot) * 180.0 / 3.1415927410125732));
        this.w(this.a(this.dN(), f1, maxXRotIncrease));
        this.v(this.a(this.dL(), f2, maxYRotIncrease));
    }

    private float a(float angle, float targetAngle, float maxIncrease) {
        float f2 = MathHelper.h(targetAngle - angle);
        if (f2 > maxIncrease) {
            f2 = maxIncrease;
        }
        if (f2 < -maxIncrease) {
            f2 = -maxIncrease;
        }
        return angle + f2;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition blockPos = pos.e();
        return EntitySpawnReason.a(spawnReason) || level.a_(blockPos).a((IBlockAccess)level, blockPos, entityType);
    }

    public boolean a(GeneratorAccess level, EntitySpawnReason spawnReason) {
        return true;
    }

    public boolean a(IWorldReader level) {
        return !level.d(this.cR()) && level.f(this);
    }

    public int aj() {
        return 4;
    }

    public boolean q(int size) {
        return false;
    }

    @Override
    public int cE() {
        if (this.O_() == null) {
            return this.y(0.0f);
        }
        int i2 = (int)(this.eD() - this.eS() * 0.33f);
        if ((i2 -= (3 - this.dV().am().a()) * 4) < 0) {
            i2 = 0;
        }
        return this.y(i2);
    }

    @Override
    public Iterable<ItemStack> fc() {
        return this.cd;
    }

    @Override
    public Iterable<ItemStack> fb() {
        return this.ce;
    }

    public ItemStack ak() {
        return this.cf;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g;
    }

    public boolean fX() {
        return !this.a(EnumItemSlot.g).f();
    }

    public void h(ItemStack stack) {
        this.b(EnumItemSlot.g, stack);
    }

    @Override
    public Iterable<ItemStack> fd() {
        return this.cf.f() ? this.ce : Iterables.concat(this.ce, List.of(this.cf));
    }

    @Override
    public ItemStack a(EnumItemSlot slot) {
        return switch (slot.a()) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.Function.a -> this.cd.get(slot.b());
            case EnumItemSlot.Function.b -> this.ce.get(slot.b());
            case EnumItemSlot.Function.c -> this.cf;
        };
    }

    @Override
    public void a(EnumItemSlot slot, ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, ItemStack stack, boolean silent) {
        this.c(stack);
        switch (slot.a()) {
            case a: {
                this.onEquipItem(slot, this.cd.set(slot.b(), stack), stack, silent);
                break;
            }
            case b: {
                this.onEquipItem(slot, this.ce.set(slot.b(), stack), stack, silent);
                break;
            }
            case c: {
                ItemStack itemStack = this.cf;
                this.cf = stack;
                this.onEquipItem(slot, itemStack, stack, silent);
            }
        }
    }

    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return false;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.i) {
            if (this.shouldSkipLoot(equipmentSlot)) continue;
            ItemStack itemBySlot = this.a(equipmentSlot);
            float equipmentDropChance = this.h(equipmentSlot);
            if (equipmentDropChance == 0.0f) continue;
            boolean flag = equipmentDropChance > 1.0f;
            Entity var11 = damageSource.d();
            if (var11 instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)var11;
                World world = this.dV();
                if (world instanceof WorldServer) {
                    WorldServer serverLevel = (WorldServer)world;
                    equipmentDropChance = EnchantmentManager.a(serverLevel, livingEntity, damageSource, equipmentDropChance);
                }
            }
            if (itemBySlot.f() || EnchantmentManager.a(itemBySlot, EnchantmentEffectComponents.D) || !recentlyHit && !flag || !(this.ae.i() < equipmentDropChance)) continue;
            if (!flag && itemBySlot.m()) {
                itemBySlot.b(itemBySlot.p() - this.ae.a(1 + this.ae.a(Math.max(itemBySlot.p() - 3, 1))));
            }
            this.a(level, itemBySlot);
            if (this.clearEquipmentSlots) {
                this.a(equipmentSlot, ItemStack.j);
                continue;
            }
            this.clearedEquipmentSlots.add(equipmentSlot);
        }
    }

    public float h(EnumItemSlot slot) {
        return switch (slot.a()) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.Function.a -> this.bU[slot.b()];
            case EnumItemSlot.Function.b -> this.bV[slot.b()];
            case EnumItemSlot.Function.c -> this.bW;
        };
    }

    public void b(WorldServer level) {
        this.a(level, (ItemStack itemStack) -> true);
    }

    public Set<EnumItemSlot> a(WorldServer level, Predicate<ItemStack> filter) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.i) {
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (itemBySlot.f()) continue;
            if (!filter.test(itemBySlot)) {
                set.add(equipmentSlot);
                continue;
            }
            double d2 = this.h(equipmentSlot);
            if (!(d2 > 1.0)) continue;
            this.a(equipmentSlot, ItemStack.j);
            this.a(level, itemBySlot);
        }
        return set;
    }

    private LootParams g(WorldServer level) {
        return new LootParams.a(level).a(LootContextParameters.f, this.dt()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
    }

    public void a(EquipmentTable equipmentTable) {
        this.a(equipmentTable.a(), equipmentTable.b());
    }

    public void a(ResourceKey<LootTable> equipmentLootTable, Map<EnumItemSlot, Float> slotDropChances) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(equipmentLootTable, this.g(serverLevel), slotDropChances);
        }
    }

    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (random.i() < 0.15f * difficulty.d()) {
            float f2;
            int randomInt = random.a(2);
            float f3 = f2 = this.dV().am() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (random.i() < 0.095f) {
                ++randomInt;
            }
            if (random.i() < 0.095f) {
                ++randomInt;
            }
            if (random.i() < 0.095f) {
                ++randomInt;
            }
            boolean flag = true;
            for (EnumItemSlot equipmentSlot : bY) {
                Item equipmentForSlot;
                ItemStack itemBySlot = this.a(equipmentSlot);
                if (!flag && random.i() < f2) break;
                flag = false;
                if (!itemBySlot.f() || (equipmentForSlot = EntityInsentient.a(equipmentSlot, randomInt)) == null) continue;
                this.a(equipmentSlot, new ItemStack(equipmentForSlot));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot slot, int chance) {
        switch (slot) {
            case f: {
                if (chance == 0) {
                    return Items.qd;
                }
                if (chance == 1) {
                    return Items.qt;
                }
                if (chance == 2) {
                    return Items.qh;
                }
                if (chance == 3) {
                    return Items.ql;
                }
                if (chance == 4) {
                    return Items.qp;
                }
            }
            case e: {
                if (chance == 0) {
                    return Items.qe;
                }
                if (chance == 1) {
                    return Items.qu;
                }
                if (chance == 2) {
                    return Items.qi;
                }
                if (chance == 3) {
                    return Items.qm;
                }
                if (chance == 4) {
                    return Items.qq;
                }
            }
            case d: {
                if (chance == 0) {
                    return Items.qf;
                }
                if (chance == 1) {
                    return Items.qv;
                }
                if (chance == 2) {
                    return Items.qj;
                }
                if (chance == 3) {
                    return Items.qn;
                }
                if (chance == 4) {
                    return Items.qr;
                }
            }
            case c: {
                if (chance == 0) {
                    return Items.qg;
                }
                if (chance == 1) {
                    return Items.qw;
                }
                if (chance == 2) {
                    return Items.qk;
                }
                if (chance == 3) {
                    return Items.qo;
                }
                if (chance != 4) break;
                return Items.qs;
            }
        }
        return null;
    }

    protected void a(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        this.b(level, random, difficulty);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.i) {
            if (equipmentSlot.a() != EnumItemSlot.Function.b) continue;
            this.a(level, random, equipmentSlot, difficulty);
        }
    }

    protected void b(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(level, EnumItemSlot.a, random, 0.25f, difficulty);
    }

    protected void a(WorldAccess level, RandomSource random, EnumItemSlot slot, DifficultyDamageScaler difficulty) {
        this.a(level, slot, random, 0.5f, difficulty);
    }

    private void a(WorldAccess level, EnumItemSlot slot, RandomSource random, float enchantChance, DifficultyDamageScaler difficulty) {
        ItemStack itemBySlot = this.a(slot);
        if (!itemBySlot.f() && random.i() < enchantChance * difficulty.d()) {
            EnchantmentManager.a(itemBySlot, level.K_(), VanillaEnchantmentProviders.a, difficulty, random);
            this.a(slot, itemBySlot);
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.H_();
        AttributeModifiable attributeInstance = Objects.requireNonNull(this.g(GenericAttributes.m));
        if (!attributeInstance.b(bL)) {
            attributeInstance.d(new AttributeModifier(bL, random.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        }
        this.v(random.i() < 0.05f);
        return spawnGroupData;
    }

    public void fY() {
        this.ch = true;
    }

    @Override
    public void a(EnumItemSlot slot, float chance) {
        switch (slot.a()) {
            case a: {
                this.bU[slot.b()] = chance;
                break;
            }
            case b: {
                this.bV[slot.b()] = chance;
                break;
            }
            case c: {
                this.bW = chance;
            }
        }
    }

    @Override
    public boolean fN() {
        return this.cg;
    }

    public void a_(boolean canPickUpLoot) {
        this.cg = canPickUpLoot;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return this.fN();
    }

    public boolean fZ() {
        return this.ch;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (!this.bL()) {
            return EnumInteractionResult.e;
        }
        EnumInteractionResult interactionResult = this.c(player, hand);
        if (interactionResult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return interactionResult;
        }
        EnumInteractionResult interactionResult1 = super.a(player, hand);
        if (interactionResult1 != EnumInteractionResult.e) {
            return interactionResult1;
        }
        interactionResult = this.b(player, hand);
        if (interactionResult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return interactionResult;
        }
        return EnumInteractionResult.e;
    }

    private EnumInteractionResult c(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult;
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.vL) && (interactionResult = itemInHand.a(player, (EntityLiving)this, hand)).a()) {
            return interactionResult;
        }
        if (itemInHand.h() instanceof ItemMonsterEgg) {
            if (this.dV() instanceof WorldServer) {
                ItemMonsterEgg spawnEggItem = (ItemMonsterEgg)itemInHand.h();
                Optional<EntityInsentient> optional = spawnEggItem.a(player, this, this.aq(), (WorldServer)this.dV(), this.dt(), itemInHand);
                optional.ifPresent(mob -> this.a(player, (EntityInsentient)mob));
                if (optional.isEmpty()) {
                    return EnumInteractionResult.e;
                }
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman player, EntityInsentient child) {
    }

    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    public boolean ga() {
        return this.a(this.dv());
    }

    public boolean a(BlockPosition pos) {
        return this.cn == -1.0f || this.cm.j(pos) < (double)(this.cn * this.cn);
    }

    public void a(BlockPosition pos, int distance) {
        this.cm = pos;
        this.cn = distance;
    }

    public BlockPosition gb() {
        return this.cm;
    }

    public float gc() {
        return this.cn;
    }

    public void gd() {
        this.cn = -1.0f;
    }

    public boolean ge() {
        return this.cn != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.a<T> afterConversion) {
        return this.convertTo(entityType, conversionParams, spawnReason, afterConversion, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.a<T> afterConversion, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)this.convertTo(entityType, conversionParams, spawnReason, (T e2) -> {
            afterConversion.finalizeConversion(e2);
            return true;
        }, transformReason, creatureSpawnReason);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.CancellingAfterConversion<T> afterConversion, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        if (this.dQ()) {
            return null;
        }
        EntityInsentient mob = (EntityInsentient)entityType.a(this.dV(), spawnReason);
        if (mob == null) {
            return null;
        }
        conversionParams.a().a(this, mob, conversionParams);
        if (!afterConversion.finalizeConversionOrCancel(mob)) {
            return null;
        }
        if (transformReason == null) {
            return (T)mob;
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, mob, transformReason).isCancelled()) {
            return null;
        }
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.addFreshEntity(mob, creatureSpawnReason);
        }
        if (conversionParams.a().a()) {
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        }
        return (T)mob;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, ConversionParams coversionParams, ConversionParams.a<T> afterConversion) {
        return this.convertTo(entityType, coversionParams, afterConversion, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams coversionParams, ConversionParams.a<T> afterConversion, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)this.convertTo(entityType, coversionParams, (T e2) -> {
            afterConversion.finalizeConversion(e2);
            return true;
        }, transformReason, creatureSpawnReason);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams coversionParams, ConversionParams.CancellingAfterConversion<T> afterConversion, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return this.convertTo(entityType, coversionParams, EntitySpawnReason.i, afterConversion, transformReason, creatureSpawnReason);
    }

    @Override
    @Nullable
    public Leashable.a T_() {
        return this.cl;
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.cl = leashData;
    }

    @Override
    public void B() {
        if (this.T_() == null) {
            this.gd();
        }
    }

    @Override
    public void C() {
        Leashable.super.C();
        this.bS.a(PathfinderGoal.Type.a);
    }

    @Override
    public boolean y() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        boolean flag = super.a(entity, force);
        if (flag && this.P_()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, true);
            if (!event.callEvent()) {
                return flag;
            }
            if (event.isDropLeash()) {
                this.z();
            } else {
                this.A();
            }
        }
        return flag;
    }

    @Override
    public boolean dj() {
        return super.dj() && !this.gf();
    }

    public void u(boolean noAi) {
        byte b2 = this.al.a(a);
        this.al.a(a, noAi ? (byte)(b2 | 1) : (byte)(b2 & 0xFFFFFFFE));
    }

    public void v(boolean leftHanded) {
        byte b2 = this.al.a(a);
        this.al.a(a, leftHanded ? (byte)(b2 | 2) : (byte)(b2 & 0xFFFFFFFD));
    }

    public void w(boolean aggressive) {
        byte b2 = this.al.a(a);
        this.al.a(a, aggressive ? (byte)(b2 | 4) : (byte)(b2 & 0xFFFFFFFB));
    }

    public boolean gf() {
        return (this.al.a(a) & 1) != 0;
    }

    public boolean gg() {
        return (this.al.a(a) & 2) != 0;
    }

    public boolean gh() {
        return (this.al.a(a) & 4) != 0;
    }

    public void a(boolean baby) {
    }

    @Override
    public EnumMainHand fy() {
        return this.gg() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean i(EntityLiving entity) {
        return this.gi().c(entity.eK());
    }

    protected AxisAlignedBB gi() {
        AxisAlignedBB aabb;
        Entity vehicle = this.dk();
        if (vehicle != null) {
            AxisAlignedBB boundingBox = vehicle.cR();
            AxisAlignedBB boundingBox1 = this.cR();
            aabb = new AxisAlignedBB(Math.min(boundingBox1.a, boundingBox.a), boundingBox1.b, Math.min(boundingBox1.c, boundingBox.c), Math.max(boundingBox1.d, boundingBox.d), boundingBox1.e, Math.max(boundingBox1.f, boundingBox.f));
        } else {
            aabb = this.cR();
        }
        return aabb.c(bZ, 0.0, bZ);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        boolean flag;
        float f2 = (float)this.h(GenericAttributes.c);
        ItemStack weaponItem = this.dZ();
        DamageSource damageSource = Optional.ofNullable(weaponItem.h().a(this)).orElse(this.dW().b(this));
        f2 = EnchantmentManager.a(level, weaponItem, source, damageSource, f2);
        if (flag = source.a(level, damageSource, f2 += weaponItem.h().a(source, f2, damageSource))) {
            EntityLiving livingEntity;
            float knockback = this.b(source, damageSource);
            if (knockback > 0.0f && source instanceof EntityLiving) {
                livingEntity = (EntityLiving)source;
                livingEntity.knockback(knockback * 0.5f, MathHelper.a(this.dL() * ((float)Math.PI / 180)), -MathHelper.b(this.dL() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                this.i(this.dy().d(0.6, 1.0, 0.6));
            }
            if (source instanceof EntityLiving) {
                livingEntity = (EntityLiving)source;
                weaponItem.a(livingEntity, (EntityLiving)this);
            }
            EnchantmentManager.a(level, source, damageSource);
            this.B(source);
            this.gj();
        }
        return flag;
    }

    protected void gj() {
    }

    public boolean gk() {
        if (this.dV().V() && !this.dV().C) {
            boolean flag;
            float lightLevelDependentMagicValue = this.by();
            BlockPosition blockPos = BlockPosition.a(this.dA(), this.dE(), this.dG());
            boolean bl = flag = this.bl() || this.av || this.aw;
            if (lightLevelDependentMagicValue > 0.5f && this.ae.i() * 30.0f < (lightLevelDependentMagicValue - 0.4f) * 2.0f && !flag && this.dV().h(blockPos)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> fluidTag) {
        if (this.P().o()) {
            super.c(fluidTag);
        } else {
            this.i(this.dy().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void gl() {
        this.c((PathfinderGoal goal) -> true);
        this.eb().h();
    }

    public void c(Predicate<PathfinderGoal> filter) {
        this.bS.a(filter);
    }

    @Override
    protected void cD() {
        super.cD();
        this.fe().forEach(itemStack -> {
            if (!itemStack.f()) {
                itemStack.e(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack dI() {
        ItemMonsterEgg spawnEggItem = ItemMonsterEgg.a(this.aq());
        return spawnEggItem == null ? null : new ItemStack(spawnEggItem);
    }

    @Override
    protected void f(Holder<AttributeBase> attribute) {
        super.f(attribute);
        if (attribute.a(GenericAttributes.m) || attribute.a(GenericAttributes.E)) {
            this.P().e();
        }
    }

    @VisibleForTesting
    public float[] gm() {
        return this.bU;
    }

    @VisibleForTesting
    public float[] gn() {
        return this.bV;
    }
}

