/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.ExperienceOrbMergeEvent;
import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import io.papermc.paper.annotation.DoNotUse;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class EntityExperienceOrb
extends Entity {
    private static final int a = 6000;
    private static final int b = 20;
    private static final int c = 8;
    private static final int d = 40;
    private static final double e = 0.5;
    private int f;
    private int g = 5;
    public int h;
    public int i = 1;
    private EntityHuman j;
    @Nullable
    public UUID sourceEntityId;
    @Nullable
    public UUID triggerEntityId;
    public ExperienceOrb.SpawnReason spawnReason = ExperienceOrb.SpawnReason.UNKNOWN;

    private void loadPaperNBT(NBTTagCompound tag) {
        if (!tag.b("Paper.ExpData", 10)) {
            return;
        }
        NBTTagCompound comp = tag.p("Paper.ExpData");
        if (comp.b("source")) {
            this.sourceEntityId = comp.a("source");
        }
        if (comp.b("trigger")) {
            this.triggerEntityId = comp.a("trigger");
        }
        if (comp.e("reason")) {
            String reason = comp.l("reason");
            try {
                this.spawnReason = ExperienceOrb.SpawnReason.valueOf((String)reason);
            }
            catch (Exception e2) {
                this.dV().getCraftServer().getLogger().warning("Invalid spawnReason set for experience orb: " + e2.getMessage() + " - " + reason);
            }
        }
    }

    private void savePaperNBT(NBTTagCompound tag) {
        NBTTagCompound comp = new NBTTagCompound();
        if (this.sourceEntityId != null) {
            comp.a("source", this.sourceEntityId);
        }
        if (this.triggerEntityId != null) {
            comp.a("trigger", this.triggerEntityId);
        }
        if (this.spawnReason != null && this.spawnReason != ExperienceOrb.SpawnReason.UNKNOWN) {
            comp.a("reason", this.spawnReason.name());
        }
        tag.a("Paper.ExpData", comp);
    }

    @DoNotUse
    @Deprecated
    public EntityExperienceOrb(World level, double x2, double y2, double z2, int value) {
        this(level, x2, y2, z2, value, null, null);
    }

    public EntityExperienceOrb(World level, double x2, double y2, double z2, int value, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId) {
        this(level, x2, y2, z2, value, reason, triggerId, null);
    }

    public EntityExperienceOrb(World level, double x2, double y2, double z2, int value, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId, @Nullable Entity sourceId) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.V, level);
        this.sourceEntityId = sourceId != null ? sourceId.cG() : null;
        this.triggerEntityId = triggerId != null ? triggerId.cG() : null;
        this.spawnReason = reason != null ? reason : ExperienceOrb.SpawnReason.UNKNOWN;
        this.a_(x2, y2, z2);
        this.v((float)(this.ae.j() * 360.0));
        this.n((this.ae.j() * (double)0.2f - (double)0.1f) * 2.0, this.ae.j() * 0.2 * 2.0, (this.ae.j() * (double)0.2f - (double)0.1f) * 2.0);
        this.h = value;
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> entityType, World level) {
        super(entityType, level);
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    protected double bd() {
        return 0.03;
    }

    @Override
    public void h() {
        Vec3D vec3;
        double d2;
        super.h();
        EntityHuman prevTarget = this.j;
        this.K = this.dA();
        this.L = this.dC();
        this.M = this.dG();
        if (this.a(TagsFluid.a)) {
            this.s();
        } else {
            this.bf();
        }
        if (this.dV().b_(this.dv()).a(TagsFluid.b)) {
            this.n((this.ae.i() - this.ae.i()) * 0.2f, 0.2f, (this.ae.i() - this.ae.i()) * 0.2f);
        }
        if (!this.dV().b(this.cR())) {
            this.m(this.dA(), (this.cR().b + this.cR().e) / 2.0, this.dG());
        }
        if (this.af % 20 == 1) {
            this.p();
        }
        if (this.j != null && (this.j.Z_() || this.j.eE())) {
            this.j = null;
        }
        boolean cancelled = false;
        if (this.j != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.j, this.j != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            EntityLiving target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.j = prevTarget;
            } else {
                EntityHuman entityHuman = this.j = target instanceof EntityHuman ? (EntityHuman)target : null;
            }
        }
        if (this.j != null && !cancelled && (d2 = (vec3 = new Vec3D(this.j.dA() - this.dA(), this.j.dC() + (double)this.j.cS() / 2.0 - this.dC(), this.j.dG() - this.dG())).h()) < 64.0) {
            double d1 = 1.0 - Math.sqrt(d2) / 8.0;
            this.i(this.dy().e(vec3.d().c(d1 * d1 * 0.1)));
        }
        double d22 = this.dy().e;
        this.a(EnumMoveType.a, this.dy());
        this.aK();
        float f2 = 0.98f;
        if (this.aJ()) {
            f2 = this.dV().a_(this.aQ()).b().g() * 0.98f;
        }
        this.i(this.dy().d(f2, 0.98, f2));
        if (this.aJ()) {
            this.i(new Vec3D(this.dy().d, -d22 * 0.4, this.dy().f));
        }
        ++this.f;
        if (this.f >= 6000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition aQ() {
        return this.e(0.999999f);
    }

    private void p() {
        if (this.j == null || this.j.g(this) > 64.0) {
            this.j = this.dV().a((Entity)this, 8.0);
        }
        if (this.dV() instanceof WorldServer) {
            for (EntityExperienceOrb experienceOrb : this.dV().a(EntityTypeTest.a(EntityExperienceOrb.class), this.cR().g(0.5), this::a)) {
                this.b(experienceOrb);
            }
        }
    }

    public static void a(WorldServer level, Vec3D pos, int amount) {
        EntityExperienceOrb.award(level, pos, amount, null, null, null);
    }

    public static void award(WorldServer level, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId) {
        EntityExperienceOrb.award(level, pos, amount, reason, triggerId, null);
    }

    public static void award(WorldServer level, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId, Entity sourceId) {
        while (amount > 0) {
            int experienceValue = EntityExperienceOrb.b(amount);
            amount -= experienceValue;
            if (EntityExperienceOrb.b(level, pos, experienceValue)) continue;
            level.b(new EntityExperienceOrb(level, pos.a(), pos.b(), pos.c(), experienceValue, reason, triggerId, sourceId));
        }
    }

    private static boolean b(WorldServer level, Vec3D pos, int amount) {
        AxisAlignedBB aabb = AxisAlignedBB.a(pos, 1.0, 1.0, 1.0);
        int randomInt = level.H_().a(40);
        List<EntityExperienceOrb> entities = level.a(EntityTypeTest.a(EntityExperienceOrb.class), aabb, (? super T orb) -> EntityExperienceOrb.a(orb, randomInt, amount));
        if (!entities.isEmpty()) {
            EntityExperienceOrb experienceOrb = entities.get(0);
            ++experienceOrb.i;
            experienceOrb.f = 0;
            return true;
        }
        return false;
    }

    private boolean a(EntityExperienceOrb orb) {
        return orb != this && EntityExperienceOrb.a(orb, this.ar(), this.h);
    }

    private static boolean a(EntityExperienceOrb orb, int amount, int other) {
        return !orb.dQ() && (orb.ar() - amount) % 40 == 0 && orb.h == other;
    }

    private void b(EntityExperienceOrb orb) {
        if (!new ExperienceOrbMergeEvent((ExperienceOrb)this.getBukkitEntity(), (ExperienceOrb)orb.getBukkitEntity()).callEvent()) {
            return;
        }
        this.i += orb.i;
        this.f = Math.min(this.f, orb.f);
        orb.discard(EntityRemoveEvent.Cause.MERGE);
    }

    private void s() {
        Vec3D deltaMovement = this.dy();
        this.n(deltaMovement.d * (double)0.99f, Math.min(deltaMovement.e + (double)5.0E-4f, (double)0.06f), deltaMovement.f * (double)0.99f);
    }

    @Override
    protected void bs() {
    }

    @Override
    public final boolean b(DamageSource damageSource) {
        return !this.d(damageSource);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.d(damageSource)) {
            return false;
        }
        this.bD();
        this.g = (int)((float)this.g - amount);
        if (this.g <= 0) {
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound compound) {
        compound.a("Health", (short)this.g);
        compound.a("Age", (short)this.f);
        compound.a("Value", this.h);
        compound.a("Count", this.i);
        this.savePaperNBT(compound);
    }

    @Override
    public void a(NBTTagCompound compound) {
        this.g = compound.g("Health");
        this.f = compound.g("Age");
        this.h = compound.h("Value");
        this.i = Math.max(compound.h("Count"), 1);
        this.loadPaperNBT(compound);
    }

    @Override
    public void a_(EntityHuman entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (entity.cj == 0 && new PlayerPickupExperienceEvent((Player)serverPlayer.getBukkitEntity(), (ExperienceOrb)this.getBukkitEntity()).callEvent()) {
                entity.cj = CraftEventFactory.callPlayerXpCooldownEvent(entity, 2, PlayerExpCooldownChangeEvent.ChangeReason.PICKUP_ORB).getNewCooldown();
                entity.a((Entity)this, 1);
                int i2 = this.a(serverPlayer, this.h);
                if (i2 > 0) {
                    entity.d(CraftEventFactory.callPlayerExpChangeEvent(entity, this).getAmount());
                }
                --this.i;
                if (this.i == 0) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                }
            }
        }
    }

    private int a(EntityPlayer player, int value) {
        Optional<EnchantedItemInUse> randomItemWith = EnchantmentManager.a(EnchantmentEffectComponents.z, (EntityLiving)player, ItemStack::n);
        if (randomItemWith.isPresent()) {
            int i1;
            ItemStack itemStack = randomItemWith.get().a();
            int i2 = EnchantmentManager.c(player.y(), itemStack, value);
            int min = Math.min(i2, itemStack.o());
            int consumedExperience = min > 0 ? min * value / i2 : 0;
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(player, this, itemStack, randomItemWith.get().b(), min, consumedExperience);
            min = event.getRepairAmount();
            if (event.isCancelled()) {
                return value;
            }
            itemStack.b(itemStack.o() - min);
            if (min > 0 && (i1 = value - min * value / i2) > 0) {
                return this.a(player, i1);
            }
            return 0;
        }
        return value;
    }

    public int l() {
        return this.h;
    }

    public int m() {
        if (this.h >= 2477) {
            return 10;
        }
        if (this.h >= 1237) {
            return 9;
        }
        if (this.h >= 617) {
            return 8;
        }
        if (this.h >= 307) {
            return 7;
        }
        if (this.h >= 149) {
            return 6;
        }
        if (this.h >= 73) {
            return 5;
        }
        if (this.h >= 37) {
            return 4;
        }
        if (this.h >= 17) {
            return 3;
        }
        if (this.h >= 7) {
            return 2;
        }
        return this.h >= 3 ? 1 : 0;
    }

    public static int b(int expValue) {
        if (expValue > 162670129) {
            return expValue - 100000;
        }
        if (expValue > 81335063) {
            return 81335063;
        }
        if (expValue > 40667527) {
            return 40667527;
        }
        if (expValue > 20333759) {
            return 20333759;
        }
        if (expValue > 10166857) {
            return 10166857;
        }
        if (expValue > 5083423) {
            return 5083423;
        }
        if (expValue > 2541701) {
            return 2541701;
        }
        if (expValue > 1270849) {
            return 1270849;
        }
        if (expValue > 635413) {
            return 635413;
        }
        if (expValue > 317701) {
            return 317701;
        }
        if (expValue > 158849) {
            return 158849;
        }
        if (expValue > 79423) {
            return 79423;
        }
        if (expValue > 39709) {
            return 39709;
        }
        if (expValue > 19853) {
            return 19853;
        }
        if (expValue > 9923) {
            return 9923;
        }
        if (expValue > 4957) {
            return 4957;
        }
        if (expValue >= 2477) {
            return 2477;
        }
        if (expValue >= 1237) {
            return 1237;
        }
        if (expValue >= 617) {
            return 617;
        }
        if (expValue >= 307) {
            return 307;
        }
        if (expValue >= 149) {
            return 149;
        }
        if (expValue >= 73) {
            return 73;
        }
        if (expValue >= 37) {
            return 37;
        }
        if (expValue >= 17) {
            return 17;
        }
        if (expValue >= 7) {
            return 7;
        }
        return expValue >= 3 ? 3 : 1;
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntityExperienceOrb(this, entity);
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.i;
    }
}

