/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.phys.Vec3D;

public class EntityAttachments {
    private final Map<EntityAttachment, List<Vec3D>> a;

    EntityAttachments(Map<EntityAttachment, List<Vec3D>> attachments) {
        this.a = attachments;
    }

    public static EntityAttachments a(float width, float height) {
        return EntityAttachments.a().a(width, height);
    }

    public static a a() {
        return new a();
    }

    public EntityAttachments a(float xScale, float yScale, float zScale) {
        EnumMap<EntityAttachment, List<Vec3D>> map = new EnumMap<EntityAttachment, List<Vec3D>>(EntityAttachment.class);
        for (Map.Entry<EntityAttachment, List<Vec3D>> entry : this.a.entrySet()) {
            map.put(entry.getKey(), EntityAttachments.a(entry.getValue(), xScale, yScale, zScale));
        }
        return new EntityAttachments(map);
    }

    private static List<Vec3D> a(List<Vec3D> attachmentPoints, float xScale, float yScale, float zScale) {
        ArrayList<Vec3D> list = new ArrayList<Vec3D>(attachmentPoints.size());
        for (Vec3D vec3 : attachmentPoints) {
            list.add(vec3.d(xScale, yScale, zScale));
        }
        return list;
    }

    @Nullable
    public Vec3D a(EntityAttachment attachment, int index, float yRot) {
        List<Vec3D> list = this.a.get((Object)attachment);
        return index >= 0 && index < list.size() ? EntityAttachments.a(list.get(index), yRot) : null;
    }

    public Vec3D b(EntityAttachment attachment, int index, float yRot) {
        Vec3D nullable = this.a(attachment, index, yRot);
        if (nullable == null) {
            throw new IllegalStateException("Had no attachment point of type: " + String.valueOf((Object)attachment) + " for index: " + index);
        }
        return nullable;
    }

    public Vec3D c(EntityAttachment attachment, int index, float yRot) {
        List<Vec3D> list = this.a.get((Object)attachment);
        if (list.isEmpty()) {
            throw new IllegalStateException("Had no attachment points of type: " + String.valueOf((Object)attachment));
        }
        Vec3D vec3 = list.get(MathHelper.a(index, 0, list.size() - 1));
        return EntityAttachments.a(vec3, yRot);
    }

    private static Vec3D a(Vec3D point, float yRot) {
        return point.b(-yRot * ((float)Math.PI / 180));
    }

    public static class a {
        private final Map<EntityAttachment, List<Vec3D>> a = new EnumMap<EntityAttachment, List<Vec3D>>(EntityAttachment.class);

        a() {
        }

        public a a(EntityAttachment attachment, float x2, float y2, float z2) {
            return this.a(attachment, new Vec3D(x2, y2, z2));
        }

        public a a(EntityAttachment attachment, Vec3D poas) {
            this.a.computeIfAbsent(attachment, entityAttachment -> new ArrayList(1)).add(poas);
            return this;
        }

        public EntityAttachments a(float width, float height) {
            EnumMap<EntityAttachment, List<Vec3D>> map = new EnumMap<EntityAttachment, List<Vec3D>>(EntityAttachment.class);
            EntityAttachment[] entityAttachmentArray = EntityAttachment.values();
            int n2 = entityAttachmentArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                EntityAttachment entityAttachment;
                List<Vec3D> list = this.a.get((Object)(entityAttachment = entityAttachmentArray[i2]));
                map.put(entityAttachment, list != null ? List.copyOf(list) : entityAttachment.a(width, height));
            }
            return new EntityAttachments(map);
        }
    }
}

