/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final Logger c = LogUtils.getLogger();
    private static final int d = 5;
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Boolean> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float h = 32.0f;
    private static final float i = 0.5f;
    private static final float j = 3.0f;
    public static final float a = 6.0f;
    public static final float b = 0.5f;
    public PotionContents k = PotionContents.a;
    private final Map<Entity, Integer> l = Maps.newHashMap();
    private int m = 600;
    public int n = 20;
    public int o = 20;
    public int p;
    public float q;
    public float r;
    @Nullable
    private EntityLiving s;
    @Nullable
    public UUID t;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> entityType, World level) {
        super(entityType, level);
        this.ad = true;
    }

    public EntityAreaEffectCloud(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.d, level);
        this.a_(x2, y2, z2);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, Float.valueOf(3.0f));
        builder.a(f, false);
        builder.a(g, ColorParticleOption.a(Particles.u, -1));
    }

    public void a(float radius) {
        if (!this.dV().C) {
            this.au().a(e, Float.valueOf(MathHelper.a(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void m_() {
        double x2 = this.dA();
        double y2 = this.dC();
        double z2 = this.dG();
        super.m_();
        this.a_(x2, y2, z2);
    }

    public float c() {
        return this.au().a(e).floatValue();
    }

    public void a(PotionContents potionContents) {
        this.k = potionContents;
        this.s();
    }

    public void s() {
        ParticleParam particleOptions = this.al.a(g);
        if (particleOptions instanceof ColorParticleOption) {
            ColorParticleOption colorParticleOption = (ColorParticleOption)particleOptions;
            int i2 = this.k.equals(PotionContents.a) ? 0 : this.k.b();
            this.al.a(g, ColorParticleOption.a(colorParticleOption.a(), ARGB.f(i2)));
        }
    }

    public void a(MobEffect effectInstance) {
        this.a(this.k.a(effectInstance));
    }

    public ParticleParam e() {
        return this.au().a(g);
    }

    public void a(ParticleParam particleOption) {
        this.au().a(g, particleOption);
    }

    protected void a(boolean waiting) {
        this.au().a(f, waiting);
    }

    public boolean f() {
        return this.au().a(f);
    }

    public int g() {
        return this.m;
    }

    public void a(int duration) {
        this.m = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.af >= this.n + this.m) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void h() {
        super.h();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel);
        } else {
            this.t();
        }
    }

    private void t() {
        boolean isWaiting = this.f();
        float radius = this.c();
        if (!isWaiting || !this.ae.h()) {
            float f2;
            int i2;
            ParticleParam particle = this.e();
            if (isWaiting) {
                i2 = 2;
                f2 = 0.2f;
            } else {
                i2 = MathHelper.f((float)Math.PI * radius * radius);
                f2 = radius;
            }
            for (int i1 = 0; i1 < i2; ++i1) {
                float f1 = this.ae.i() * ((float)Math.PI * 2);
                float f22 = MathHelper.c(this.ae.i()) * f2;
                double d2 = this.dA() + (double)(MathHelper.b(f1) * f22);
                double y2 = this.dC();
                double d1 = this.dG() + (double)(MathHelper.a(f1) * f22);
                if (particle.a() == Particles.u) {
                    if (isWaiting && this.ae.h()) {
                        this.dV().b(ColorParticleOption.a(Particles.u, -1), d2, y2, d1, 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.dV().b(particle, d2, y2, d1, 0.0, 0.0, 0.0);
                    continue;
                }
                if (isWaiting) {
                    this.dV().b(particle, d2, y2, d1, 0.0, 0.0, 0.0);
                    continue;
                }
                this.dV().b(particle, d2, y2, d1, (0.5 - this.ae.j()) * 0.15, 0.01f, (0.5 - this.ae.j()) * 0.15);
            }
        }
    }

    private void a(WorldServer level) {
        if (this.af >= this.n + this.m) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            boolean flag;
            boolean isWaiting = this.f();
            boolean bl = flag = this.af < this.n;
            if (isWaiting != flag) {
                this.a(flag);
            }
            if (!flag) {
                float radius = this.c();
                if (this.r != 0.0f) {
                    if ((radius += this.r) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.a(radius);
                }
                if (this.af % 5 == 0) {
                    this.l.entrySet().removeIf(victim -> this.af >= (Integer)victim.getValue());
                    if (!this.k.c()) {
                        this.l.clear();
                    } else {
                        ArrayList list = Lists.newArrayList();
                        if (this.k.e().isPresent()) {
                            for (MobEffect mobEffectInstance : this.k.e().get().a().a()) {
                                list.add(new MobEffect(mobEffectInstance.c(), mobEffectInstance.a(duration -> duration / 4), mobEffectInstance.e(), mobEffectInstance.f(), mobEffectInstance.g()));
                            }
                        }
                        list.addAll(this.k.d());
                        List<EntityLiving> entitiesOfClass = this.dV().a(EntityLiving.class, this.cR());
                        if (!entitiesOfClass.isEmpty()) {
                            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
                            for (EntityLiving livingEntity : entitiesOfClass) {
                                double d1;
                                double d2;
                                double d22;
                                if (this.l.containsKey(livingEntity) || !livingEntity.fL()) continue;
                                if (list.stream().noneMatch(livingEntity::b) || !((d22 = (d2 = livingEntity.dA() - this.dA()) * d2 + (d1 = livingEntity.dG() - this.dG()) * d1) <= (double)(radius * radius))) continue;
                                entities.add((LivingEntity)livingEntity.getBukkitEntity());
                            }
                            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
                            if (!event.isCancelled()) {
                                for (LivingEntity entity : event.getAffectedEntities()) {
                                    if (!(entity instanceof CraftLivingEntity)) continue;
                                    EntityLiving livingEntity = ((CraftLivingEntity)entity).getHandle();
                                    this.l.put(livingEntity, this.af + this.o);
                                    for (MobEffect mobEffectInstance1 : list) {
                                        if (mobEffectInstance1.c().a().a()) {
                                            mobEffectInstance1.c().a().a(level, this, this.n(), livingEntity, mobEffectInstance1.e(), 0.5);
                                            continue;
                                        }
                                        livingEntity.addEffect(new MobEffect(mobEffectInstance1), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                    }
                                    if (this.q != 0.0f) {
                                        if ((radius += this.q) < 0.5f) {
                                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                            return;
                                        }
                                        this.a(radius);
                                    }
                                    if (this.p == 0) continue;
                                    this.m += this.p;
                                    if (this.m > 0) continue;
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public float i() {
        return this.q;
    }

    public void b(float radiusOnUse) {
        this.q = radiusOnUse;
    }

    public float j() {
        return this.r;
    }

    public void c(float radiusPerTick) {
        this.r = radiusPerTick;
    }

    public int l() {
        return this.p;
    }

    public void b(int durationOnUse) {
        this.p = durationOnUse;
    }

    public int m() {
        return this.n;
    }

    public void c(int waitTime) {
        this.n = waitTime;
    }

    public void a(@Nullable EntityLiving owner) {
        this.s = owner;
        this.t = owner == null ? null : owner.cG();
    }

    @Nullable
    public EntityLiving n() {
        World world;
        if (this.s != null && !this.s.dQ()) {
            return this.s;
        }
        if (this.t != null && (world = this.dV()) instanceof WorldServer) {
            EntityLiving livingEntity;
            WorldServer serverLevel = (WorldServer)world;
            Entity entity = serverLevel.a(this.t);
            this.s = entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : null;
        }
        return this.s;
    }

    @Override
    protected void a(NBTTagCompound compound) {
        this.af = compound.h("Age");
        this.m = compound.h("Duration");
        this.n = compound.h("WaitTime");
        this.o = compound.h("ReapplicationDelay");
        this.p = compound.h("DurationOnUse");
        this.q = compound.j("RadiusOnUse");
        this.r = compound.j("RadiusPerTick");
        this.a(compound.j("Radius"));
        if (compound.b("Owner")) {
            this.t = compound.a("Owner");
        }
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        if (compound.b("Particle", 10)) {
            Particles.bi.parse(registryOps, (Object)compound.c("Particle")).resultOrPartial(string -> c.warn("Failed to parse area effect cloud particle options: '{}'", string)).ifPresent(this::a);
        }
        if (compound.e("potion_contents")) {
            PotionContents.c.parse(registryOps, (Object)compound.c("potion_contents")).resultOrPartial(string -> c.warn("Failed to parse area effect cloud potions: '{}'", string)).ifPresent(this::a);
        }
    }

    @Override
    protected void b(NBTTagCompound compound) {
        compound.a("Age", this.af);
        compound.a("Duration", this.m);
        compound.a("WaitTime", this.n);
        compound.a("ReapplicationDelay", this.o);
        compound.a("DurationOnUse", this.p);
        compound.a("RadiusOnUse", this.q);
        compound.a("RadiusPerTick", this.r);
        compound.a("Radius", this.c());
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        compound.a("Particle", (NBTBase)Particles.bi.encodeStart(registryOps, (Object)this.e()).getOrThrow());
        if (this.t != null) {
            compound.a("Owner", this.t);
        }
        if (!this.k.equals(PotionContents.a)) {
            NBTBase tag = (NBTBase)PotionContents.c.encodeStart(registryOps, (Object)this.k).getOrThrow();
            compound.a("potion_contents", tag);
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (e.equals(key)) {
            this.m_();
        }
        super.a(key);
    }

    @Override
    public EnumPistonReaction n_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return EntitySize.b(this.c() * 2.0f, 0.5f);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }
}

