/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import ca.spottedleaf.moonrise.common.util.ThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerEntity;
import com.destroystokyo.paper.event.entity.EntityTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.entity.activation.ActivationRange;
import io.papermc.paper.entity.activation.ActivationType;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import io.papermc.paper.util.SizeLimitedSet;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftVector;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements SyncedDataHolder,
INamableTileEntity,
EntityAccess,
ScoreHolder,
ChunkSystemEntity,
EntityTrackerEntity {
    private static final int CURRENT_LEVEL = 2;
    public boolean preserveMotion = true;
    public static RandomSource SHARED_RANDOM = new RandomRandomSource();
    public CreatureSpawnEvent.SpawnReason spawnReason;
    public boolean collisionLoadChunks = false;
    @Nullable
    private CraftEntity bukkitEntity;
    private static final Logger b = LogUtils.getLogger();
    public static final String v = "id";
    public static final String w = "Passengers";
    private static final AtomicInteger c = new AtomicInteger();
    public static final int x = 0;
    public static final int y = 60;
    public static final int z = 300;
    public static final int A = 1024;
    public static final float B = 0.2f;
    public static final double C = 0.500001;
    public static final double D = 0.999999;
    public static final int E = 140;
    public static final int F = 40;
    public static final int G = 3;
    private static final AxisAlignedBB d = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double k = 0.014;
    private static final double l = 0.007;
    private static final double m = 0.0023333333333333335;
    public static final String H = "UUID";
    private static double n = 1.0;
    private final EntityTypes<?> o;
    private int p = c.incrementAndGet();
    public boolean I;
    public ImmutableList<Entity> q = ImmutableList.of();
    protected int J;
    @Nullable
    private Entity r;
    private net.minecraft.world.level.World s;
    public double K;
    public double L;
    public double M;
    private Vec3D t;
    private BlockPosition u;
    private ChunkCoordIntPair ay;
    private Vec3D az = Vec3D.c;
    private float aA;
    private float aB;
    public float N;
    public float O;
    private AxisAlignedBB aC = d;
    public boolean aD;
    public boolean P;
    public boolean Q;
    public boolean R;
    public boolean S;
    public boolean T;
    protected Vec3D U = Vec3D.c;
    @Nullable
    private RemovalReason aE;
    public static final float V = 0.6f;
    public static final float W = 1.8f;
    public float X;
    public float Y;
    public float Z;
    private float aF = 1.0f;
    public double aa;
    public double ab;
    public double ac;
    public boolean ad;
    private boolean aG;
    public final RandomSource ae = SHARED_RANDOM;
    public int af;
    private int aH = -this.dn();
    public boolean ag;
    protected Object2DoubleMap<TagKey<FluidType>> ah = new Object2DoubleArrayMap(2);
    protected boolean ai;
    private final Set<TagKey<FluidType>> aI = new HashSet<TagKey<FluidType>>();
    public int aj;
    protected boolean ak = true;
    protected final DataWatcher al;
    protected static final DataWatcherObject<Byte> am = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int an = 0;
    private static final int aJ = 1;
    private static final int aK = 3;
    private static final int aL = 4;
    public static final int aM = 5;
    protected static final int ao = 6;
    protected static final int ap = 7;
    private static final DataWatcherObject<Integer> aN = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aO = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> aP = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aQ = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aR = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> aq = DataWatcher.a(Entity.class, DataWatcherRegistry.w);
    private static final DataWatcherObject<Integer> aS = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aT = EntityInLevelCallback.a;
    private final VecDeltaCodec aU = new VecDeltaCodec();
    public boolean ar;
    @Nullable
    public PortalProcessor as;
    public int aV;
    private boolean aW;
    protected UUID at = MathHelper.a(this.ae);
    protected String au = this.at.toString();
    private boolean aX;
    private final Set<String> aY = new SizeLimitedSet(new ObjectOpenHashSet(), 1024);
    private final double[] aZ = new double[]{0.0, 0.0, 0.0};
    private long ba;
    private EntitySize bb;
    private float bc;
    public boolean av;
    public boolean aw;
    public Optional<BlockPosition> ax = Optional.empty();
    private boolean bd = false;
    private float be;
    private int bf;
    public boolean bg;
    @Nullable
    private IBlockData bh = null;
    private final List<b> bi = new ArrayList<b>();
    private final Set<IBlockData> bj = new ReferenceArraySet();
    private final LongSet bk = new LongOpenHashSet();
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    @Nullable
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public boolean pluginRemoved = false;
    protected int numCollisions = 0;
    public boolean fromNetherPortal;
    public boolean spawnedViaMobSpawner;
    @Nullable
    private Vector origin;
    @Nullable
    private UUID originWorld;
    public boolean freezeLocked = false;
    public boolean fixedPose = false;
    private final int despawnTime;
    public int totalEntityAge;
    public final ActivationType activationType = ActivationType.activationTypeFor(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    private final boolean isHardColliding = this.moonrise$isHardCollidingUncached();
    private FullChunkStatus chunkStatus;
    private ChunkData chunkData;
    private int sectionX = Integer.MIN_VALUE;
    private int sectionY = Integer.MIN_VALUE;
    private int sectionZ = Integer.MIN_VALUE;
    private boolean updatingSectionStatus;
    private PlayerChunkMap.EntityTracker trackedEntity;
    public final Object posLock = new Object();
    private Vec3D moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return Entity.this.getBukkitEntity();
        }

        @Override
        public boolean y_() {
            return ((WorldServer)Entity.this.dV()).O().b(GameRules.p);
        }

        @Override
        public boolean z_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }
    };

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.e("Bukkit.updateLevel") && tag.h("Bukkit.updateLevel") >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            Entity entity = this;
            synchronized (entity) {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = CraftEntity.getEntity(this.s.getCraftServer(), this);
                    return this.bukkitEntity;
                }
            }
        }
        return this.bukkitEntity;
    }

    @Nullable
    public CraftEntity getBukkitEntityRaw() {
        return this.bukkitEntity;
    }

    public void inactiveTick() {
    }

    public void setOrigin(@Nonnull Location location) {
        this.origin = location.toVector();
        this.originWorld = location.getWorld().getUID();
    }

    @Nullable
    public Vector getOriginVector() {
        return this.origin != null ? this.origin.clone() : null;
    }

    @Nullable
    public UUID getOriginWorld() {
        return this.originWorld;
    }

    public float getBukkitYaw() {
        return this.aA;
    }

    public final AxisAlignedBB getBoundingBoxAt(double x2, double y2, double z2) {
        return this.bb.a(x2, y2, z2);
    }

    @Override
    public final boolean moonrise$isHardColliding() {
        return this.isHardColliding;
    }

    @Override
    public final FullChunkStatus moonrise$getChunkStatus() {
        return this.chunkStatus;
    }

    @Override
    public final void moonrise$setChunkStatus(FullChunkStatus status) {
        this.chunkStatus = status;
    }

    @Override
    public final ChunkData moonrise$getChunkData() {
        return this.chunkData;
    }

    @Override
    public final void moonrise$setChunkData(ChunkData chunkData) {
        this.chunkData = chunkData;
    }

    @Override
    public final int moonrise$getSectionX() {
        return this.sectionX;
    }

    @Override
    public final void moonrise$setSectionX(int x2) {
        this.sectionX = x2;
    }

    @Override
    public final int moonrise$getSectionY() {
        return this.sectionY;
    }

    @Override
    public final void moonrise$setSectionY(int y2) {
        this.sectionY = y2;
    }

    @Override
    public final int moonrise$getSectionZ() {
        return this.sectionZ;
    }

    @Override
    public final void moonrise$setSectionZ(int z2) {
        this.sectionZ = z2;
    }

    @Override
    public final boolean moonrise$isUpdatingSectionStatus() {
        return this.updatingSectionStatus;
    }

    @Override
    public final void moonrise$setUpdatingSectionStatus(boolean to) {
        this.updatingSectionStatus = to;
    }

    @Override
    public final boolean moonrise$hasAnyPlayerPassengers() {
        if (this.q.isEmpty()) {
            return false;
        }
        return this.I().anyMatch(entity -> entity instanceof EntityHuman);
    }

    private static float[] calculateStepHeights(AxisAlignedBB box, List<VoxelShape> voxels, List<AxisAlignedBB> aabbs, float stepHeight, float collidedY) {
        Object shape;
        int i2;
        FloatArraySet ret = new FloatArraySet();
        int len = voxels.size();
        for (i2 = 0; i2 < len; ++i2) {
            double yUnoffset;
            double y2;
            float step;
            shape = voxels.get(i2);
            double[] yCoords = shape.moonrise$rootCoordinatesY();
            double yOffset = shape.moonrise$offsetY();
            double[] dArray = yCoords;
            int n2 = dArray.length;
            for (int i3 = 0; i3 < n2 && !((step = (float)((y2 = (yUnoffset = dArray[i3]) + yOffset) - box.b)) > stepHeight); ++i3) {
                if (step < 0.0f || step == collidedY) continue;
                ret.add(step);
            }
        }
        len = aabbs.size();
        for (i2 = 0; i2 < len; ++i2) {
            shape = aabbs.get(i2);
            float step1 = (float)(((AxisAlignedBB)shape).b - box.b);
            float step2 = (float)(((AxisAlignedBB)shape).e - box.b);
            if (!(step1 < 0.0f) && step1 != collidedY && !(step1 > stepHeight)) {
                ret.add(step1);
            }
            if (step2 < 0.0f || step2 == collidedY || step2 > stepHeight) continue;
            ret.add(step2);
        }
        float[] steps = ret.toFloatArray();
        FloatArrays.unstableSort((float[])steps);
        return steps;
    }

    @Override
    public final PlayerChunkMap.EntityTracker moonrise$getTrackedEntity() {
        return this.trackedEntity;
    }

    @Override
    public final void moonrise$setTrackedEntity(PlayerChunkMap.EntityTracker trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    private static void collectIndirectPassengers(List<Entity> into, List<Entity> from) {
        for (Entity passenger : from) {
            into.add(passenger);
            Entity.collectIndirectPassengers(into, passenger.q);
        }
    }

    public Entity(EntityTypes<?> entityType, net.minecraft.world.level.World level) {
        this.o = entityType;
        this.s = level;
        this.bb = entityType.n();
        this.t = Vec3D.c;
        this.u = BlockPosition.c;
        this.ay = ChunkCoordIntPair.e;
        this.defaultActivationState = level != null ? ActivationRange.initializeEntityActivationState(this, level.spigotConfig) : false;
        DataWatcher.a builder = new DataWatcher.a(this);
        builder.a(am, (byte)0);
        builder.a(aN, this.cs());
        builder.a(aP, false);
        builder.a(aO, Optional.empty());
        builder.a(aQ, false);
        builder.a(aR, false);
        builder.a(aq, EntityPose.a);
        builder.a(aS, 0);
        this.a(builder);
        this.al = builder.a();
        this.a_(0.0, 0.0, 0.0);
        this.bc = this.bb.c();
        this.despawnTime = level == null || this.o == EntityTypes.bR ? -1 : ((IntOr.Disabled)level.paperConfig().entities.spawning.despawnTime.getOrDefault(this.o, (Object)IntOr.Disabled.DISABLED)).or(-1);
    }

    public boolean a(BlockPosition pos, IBlockData state) {
        VoxelShape collisionShape = state.b((IBlockAccess)this.dV(), pos, VoxelShapeCollision.a(this));
        VoxelShape voxelShape = collisionShape.a(pos.u(), (double)pos.v(), (double)pos.w());
        return VoxelShapes.c(voxelShape, VoxelShapes.a(this.cR()), OperatorBoolean.i);
    }

    public int k_() {
        ScoreboardTeam team = this.cr();
        return team != null && ((ScoreboardTeamBase)team).n().f() != null ? ((ScoreboardTeamBase)team).n().f() : 0xFFFFFF;
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public boolean Z_() {
        return false;
    }

    public final void ao() {
        if (this.ca()) {
            this.bP();
        }
        if (this.bZ()) {
            this.ae();
        }
    }

    public void f(double x2, double y2, double z2) {
        this.aU.e(new Vec3D(x2, y2, z2));
    }

    public VecDeltaCodec ap() {
        return this.aU;
    }

    public EntityTypes<?> aq() {
        return this.o;
    }

    @Override
    public int ar() {
        return this.p;
    }

    public void e(int id) {
        this.p = id;
    }

    public Set<String> as() {
        return this.aY;
    }

    public boolean a(String tag) {
        return this.aY.add(tag);
    }

    public boolean b(String tag) {
        return this.aY.remove(tag);
    }

    public void c(WorldServer level) {
        this.remove(RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.a(GameEvent.p);
    }

    public final void at() {
        this.discard(null);
    }

    public final void discard(EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.b, cause);
    }

    protected abstract void a(DataWatcher.a var1);

    public DataWatcher au() {
        return this.al;
    }

    public void refreshEntityData(EntityPlayer to) {
        List<DataWatcher.c<?>> list = this.al.packAll();
        if (list != null && to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            to.f.b(new PacketPlayOutEntityMetadata(this.ar(), list));
        }
    }

    public void resendPossiblyDesyncedEntityData(EntityPlayer player) {
        if (player.getBukkitEntity().canSee(this.getBukkitEntity())) {
            PlayerChunkMap.EntityTracker tracker;
            WorldServer world = (WorldServer)this.dV();
            PlayerChunkMap.EntityTracker entityTracker = tracker = world == null ? null : (PlayerChunkMap.EntityTracker)world.m().a.K.get(this.ar());
            if (tracker == null) {
                return;
            }
            EntityTrackerEntry serverEntity = tracker.b;
            ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
            serverEntity.a(player, list::add);
            player.f.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        }
    }

    public void resendPossiblyDesyncedDataValues(List<DataWatcherObject<?>> keys, EntityPlayer to) {
        if (!to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            return;
        }
        ArrayList values = new ArrayList(keys.size());
        for (DataWatcherObject<?> key : keys) {
            DataWatcher.Item<?> synchedValue = this.al.b(key);
            values.add(synchedValue.e());
        }
        to.f.b(new PacketPlayOutEntityMetadata(this.p, values));
    }

    public boolean equals(Object object) {
        return object instanceof Entity && ((Entity)object).p == this.p;
    }

    public int hashCode() {
        return this.p;
    }

    public void a(RemovalReason reason) {
        this.setRemoved(reason, null);
    }

    public void remove(RemovalReason reason, EntityRemoveEvent.Cause eventCause) {
        this.setRemoved(reason, eventCause);
    }

    public void av() {
    }

    public void b(RemovalReason reason) {
    }

    public void b(EntityPose pose) {
        if (this.fixedPose) {
            return;
        }
        if (pose == this.aw()) {
            return;
        }
        if (!this.generation) {
            this.s.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[pose.ordinal()]));
        }
        this.al.a(aq, pose);
    }

    public EntityPose aw() {
        return this.al.a(aq);
    }

    public boolean c(EntityPose pose) {
        return this.aw() == pose;
    }

    public boolean a(Entity entity, double distance) {
        return this.dt().a((IPosition)entity.dt(), distance);
    }

    public boolean a(Entity entity, double horizontalDistance, double verticalDistance) {
        double d2 = entity.dA() - this.dA();
        double d1 = entity.dC() - this.dC();
        double d22 = entity.dG() - this.dG();
        return MathHelper.e(d2, d22) < MathHelper.k(horizontalDistance) && MathHelper.k(d1) < MathHelper.k(verticalDistance);
    }

    public void b(float yRot, float xRot) {
        if (Float.isNaN(yRot)) {
            yRot = 0.0f;
        }
        if (yRot == Float.POSITIVE_INFINITY || yRot == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.s.getCraftServer().getLogger().warning(this.cI() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yRot = 0.0f;
        }
        if (Float.isNaN(xRot)) {
            xRot = 0.0f;
        }
        if (xRot == Float.POSITIVE_INFINITY || xRot == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.s.getCraftServer().getLogger().warning(this.cI() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            xRot = 0.0f;
        }
        this.v(yRot % 360.0f);
        this.w(xRot % 360.0f);
    }

    public final void b(Vec3D pos) {
        this.a_(pos.a(), pos.b(), pos.c());
    }

    public void a_(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, true);
    }

    protected final AxisAlignedBB ax() {
        return this.c(this.t);
    }

    protected AxisAlignedBB c(Vec3D position) {
        return this.bb.a(position);
    }

    protected void ay() {
        this.a_(this.t.d, this.t.e, this.t.f);
    }

    public void b(double yRot, double xRot) {
        float f2 = (float)xRot * 0.15f;
        float f1 = (float)yRot * 0.15f;
        this.w(this.dN() + f2);
        this.v(this.dL() + f1);
        this.w(MathHelper.a(this.dN(), -90.0f, 90.0f));
        this.O += f2;
        this.N += f1;
        this.O = MathHelper.a(this.O, -90.0f, 90.0f);
        if (this.r != null) {
            this.r.k(this);
        }
    }

    public void h() {
        if (this.despawnTime >= 0 && this.totalEntityAge >= this.despawnTime) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
        this.az();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer) && this.bL()) {
            this.bW();
        }
    }

    public void az() {
        Object object;
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("entityBaseTick");
        if (this.ak && (object = this) instanceof IEntityAngerable) {
            IEntityAngerable neutralMob = (IEntityAngerable)object;
            neutralMob.tickInitialPersistentAnger(this.s);
        }
        this.bh = null;
        if (this.bZ() && this.dk().dQ()) {
            this.ae();
        }
        if (this.J > 0) {
            --this.J;
        }
        if (this instanceof EntityPlayer) {
            this.bW();
        }
        if (this.bv()) {
            this.bw();
        }
        this.aw = this.av;
        this.av = false;
        this.bq();
        this.G();
        this.bp();
        object = this.dV();
        if (object instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)object;
            if (this.aH > 0) {
                if (this.bi()) {
                    this.h(this.aH - 4);
                    if (this.aH < 0) {
                        this.aH();
                    }
                } else {
                    if (this.aH % 20 == 0 && !this.bx()) {
                        this.a(serverLevel, this.dW().d(), 1.0f);
                    }
                    this.h(this.aH - 1);
                }
                if (this.cu() > 0 && !this.freezeLocked) {
                    this.k(0);
                    this.dV().a(null, 1009, this.u, 1);
                }
            }
        } else {
            this.aH();
        }
        if (this.bx()) {
            this.aE();
            this.Z *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.aA();
        if (!this.dV().C) {
            this.c(this.aH > 0);
        }
        this.ak = false;
        object = this.dV();
        if (object instanceof WorldServer) {
            WorldServer serverLevelx = (WorldServer)object;
            if (this instanceof Leashable) {
                Leashable.a_(serverLevelx, (Entity)((Object)((Leashable)((Object)this))));
            }
        }
        profilerFiller.c();
    }

    public void c(boolean isOnFire) {
        this.b(0, isOnFire || this.bg);
    }

    public void aA() {
        block5: {
            block4: {
                if (!this.s.getWorld().isVoidDamageEnabled()) {
                    return;
                }
                if (this.dC() < (double)this.s.L_() + this.s.getWorld().getVoidDamageMinBuildHeightOffset()) break block4;
                if (this.s.getWorld().getEnvironment() != World.Environment.NETHER || !this.s.paperConfig().environment.netherCeilingVoidDamageHeight.test(v2 -> this.dC() >= (double)v2)) break block5;
                Entity entity = this;
                if (!(entity instanceof EntityHuman)) break block4;
                EntityHuman player = (EntityHuman)entity;
                if (player.gj().a) break block5;
            }
            this.aI();
        }
    }

    public void aB() {
        this.aV = this.bX();
    }

    public void f(int portalCooldown) {
        this.aV = portalCooldown;
    }

    public int aC() {
        return this.aV;
    }

    public boolean aD() {
        return this.aV > 0;
    }

    protected void M() {
        if (this.aD()) {
            --this.aV;
        }
    }

    public void aE() {
        if (!this.bi()) {
            WorldServer serverLevel;
            if (this instanceof EntityLiving && this.aH <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.s, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.s.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
            net.minecraft.world.level.World world = this.dV();
            if (world instanceof WorldServer && this.a(serverLevel = (WorldServer)world, this.dW().e().eventBlockDamager(this.s, this.lastLavaContact), 4.0f) && this.aF() && !this.bb()) {
                serverLevel.a(null, this.dA(), this.dC(), this.dG(), SoundEffects.kA, this.dm(), 0.4f, 2.0f + this.ae.i() * 0.4f);
            }
        }
    }

    protected boolean aF() {
        return true;
    }

    public final void d(float seconds) {
        this.igniteForSeconds(seconds, true);
    }

    public final void igniteForSeconds(float f2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), f2);
            this.s.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            f2 = event.getDuration();
        }
        this.g(MathHelper.d(f2 * 20.0f));
    }

    public void g(int ticks) {
        if (this.aH < ticks) {
            this.h(ticks);
        }
    }

    public void h(int remainingFireTicks) {
        this.aH = remainingFireTicks;
    }

    public int aG() {
        return this.aH;
    }

    public void aH() {
        this.h(0);
    }

    protected void aI() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean g(double x2, double y2, double z2) {
        return this.b(this.cR().d(x2, y2, z2));
    }

    private boolean b(AxisAlignedBB box) {
        return this.dV().a(this, box) && !this.dV().d(box);
    }

    public void d(boolean onGround) {
        this.aD = onGround;
        this.b(onGround, null);
    }

    public void a(boolean flag, Vec3D vec3) {
        this.a(flag, this.P, vec3);
    }

    public void a(boolean onGround, boolean horizontalCollision, Vec3D movement) {
        this.aD = onGround;
        this.P = horizontalCollision;
        this.b(onGround, movement);
    }

    public boolean d(BlockPosition pos) {
        return this.ax.isPresent() && this.ax.get().equals(pos);
    }

    protected void b(boolean onGround, @Nullable Vec3D movement) {
        if (onGround) {
            AxisAlignedBB boundingBox = this.cR();
            AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.a, boundingBox.b - 1.0E-6, boundingBox.c, boundingBox.d, boundingBox.b, boundingBox.f);
            Optional<BlockPosition> optional = this.s.h(this, aabb);
            if (optional.isPresent() || this.bd) {
                this.ax = optional;
            } else if (movement != null) {
                AxisAlignedBB aabb1 = aabb.d(-movement.d, 0.0, -movement.f);
                optional = this.s.h(this, aabb1);
                this.ax = optional;
            }
            this.bd = optional.isEmpty();
        } else {
            this.bd = false;
            if (this.ax.isPresent()) {
                this.ax = Optional.empty();
            }
        }
    }

    public boolean aJ() {
        return this.aD;
    }

    public final Vec3D getMoveVector() {
        return this.moveVector;
    }

    public final double getMoveStartX() {
        return this.moveStartX;
    }

    public final double getMoveStartY() {
        return this.moveStartY;
    }

    public final double getMoveStartZ() {
        return this.moveStartZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(EnumMoveType type, Vec3D movement) {
        Vec3D originalMovement = movement;
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.dA();
            this.moveStartY = this.dC();
            this.moveStartZ = this.dG();
            this.moveVector = movement;
        }
        try {
            if (this.ad) {
                this.a_(this.dA() + movement.d, this.dC() + movement.e, this.dG() + movement.f);
            } else {
                this.aG = this.bY();
                if (type == EnumMoveType.c) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.e(movement)).equals(Vec3D.c)) {
                        return;
                    }
                }
                GameProfilerFiller profilerFiller = Profiler.a();
                profilerFiller.a("move");
                if (this.U.h() > 1.0E-7) {
                    movement = movement.h(this.U);
                    this.U = Vec3D.c;
                    this.i(Vec3D.c);
                }
                if (this.isTemporarilyActive && !(this instanceof EntityItem) && movement == this.dy() && type == EnumMoveType.a) {
                    this.i(Vec3D.c);
                    profilerFiller.c();
                    return;
                }
                Vec3D vec3 = this.a(movement = this.a(movement, type));
                double d2 = vec3.h();
                if (d2 > 1.0E-7 || movement.h() - d2 < 1.0E-7) {
                    MovingObjectPositionBlock blockHitResult;
                    if (this.Z != 0.0f && d2 >= 1.0 && (blockHitResult = this.dV().a(new RayTrace(this.dt(), this.dt().e(vec3), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).d() != MovingObjectPosition.EnumMovingObjectType.a) {
                        this.k();
                    }
                    this.a_(this.dA() + vec3.d, this.dC() + vec3.e, this.dG() + vec3.f);
                }
                profilerFiller.c();
                profilerFiller.a("rest");
                boolean flag = !MathHelper.b(movement.d, vec3.d);
                boolean flag1 = !MathHelper.b(movement.f, vec3.f);
                boolean bl = this.P = flag || flag1;
                if (Math.abs(movement.e) > 0.0 || this.dg()) {
                    this.Q = movement.e != vec3.e;
                    this.R = this.Q && movement.e < 0.0;
                    this.a(this.R, this.P, vec3);
                }
                this.S = this.P ? this.d(vec3) : false;
                BlockPosition onPosLegacy = this.aP();
                IBlockData blockState = this.dV().a_(onPosLegacy);
                if (!(this.dV().B_() && !this.dh() || this.di())) {
                    this.a(vec3.e, this.aJ(), blockState, onPosLegacy);
                }
                if (this.dQ()) {
                    profilerFiller.c();
                } else {
                    MovementEmission movementEmission;
                    if (this.P) {
                        Vec3D deltaMovement = this.dy();
                        this.n(flag ? 0.0 : deltaMovement.d, deltaMovement.e, flag1 ? 0.0 : deltaMovement.f);
                    }
                    if (this.dh()) {
                        Block block = blockState.b();
                        if (movement.e != vec3.e) {
                            block.a(this.dV(), this);
                        }
                    }
                    if (this.P && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block bl2 = this.s.getWorld().getBlockAt(MathHelper.a(this.dA()), MathHelper.a(this.dC()), MathHelper.a(this.dG()));
                        if (movement.d > vec3.d) {
                            bl2 = bl2.getRelative(BlockFace.EAST);
                        } else if (movement.d < vec3.d) {
                            bl2 = bl2.getRelative(BlockFace.WEST);
                        } else if (movement.f > vec3.f) {
                            bl2 = bl2.getRelative(BlockFace.SOUTH);
                        } else if (movement.f < vec3.f) {
                            bl2 = bl2.getRelative(BlockFace.NORTH);
                        }
                        if (!bl2.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl2, CraftVector.toBukkit(originalMovement));
                            this.s.getCraftServer().getPluginManager().callEvent((Event)event);
                        }
                    }
                    if ((!this.dV().B_() || this.dh()) && (movementEmission = this.bg()).a() && !this.bZ()) {
                        this.a(movementEmission, vec3, onPosLegacy, blockState);
                    }
                    float blockSpeedFactor = this.aT();
                    this.i(this.dy().d(blockSpeedFactor, 1.0, blockSpeedFactor));
                    profilerFiller.c();
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    private void a(MovementEmission movementEmission, Vec3D movement, BlockPosition pos, IBlockData state) {
        float f2 = 0.6f;
        float f1 = (float)(movement.g() * (double)0.6f);
        float f22 = (float)(movement.i() * (double)0.6f);
        BlockPosition onPos = this.aR();
        IBlockData blockState = this.dV().a_(onPos);
        boolean isStateClimbable = this.c(blockState);
        this.X += isStateClimbable ? f1 : f22;
        this.Y += f1;
        if (this.X > this.aF && !blockState.l()) {
            boolean flag = onPos.equals(pos);
            boolean flag1 = this.a(pos, state, movementEmission.c(), flag, movement);
            if (!flag) {
                flag1 |= this.a(onPos, blockState, false, movementEmission.b(), movement);
            }
            if (flag1) {
                this.aF = this.aU();
            } else if (this.bj()) {
                this.aF = this.aU();
                if (movementEmission.c()) {
                    this.aY();
                }
                if (movementEmission.b()) {
                    this.a(GameEvent.Q);
                }
            }
        } else if (blockState.l()) {
            this.aO();
        }
    }

    public void aK() {
        this.a(this.bC(), this.t);
    }

    public void a(Vec3D oldPosition, Vec3D position) {
        if (this.aL()) {
            if (this.aJ()) {
                BlockPosition onPosLegacy = this.aP();
                IBlockData blockState = this.dV().a_(onPosLegacy);
                blockState.b().a(this.dV(), onPosLegacy, blockState, this);
            }
            this.bi.add(new b(oldPosition, position));
            List<b> list = List.copyOf(this.bi);
            this.bi.clear();
            this.a(list, this.bj);
            boolean flag = Iterables.any(this.bj, state -> state.a(TagsBlock.aN) || state.a(Blocks.K));
            this.bj.clear();
            if (!flag && this.bL()) {
                if (this.aH <= 0) {
                    this.h(-this.dn());
                }
                if (this.aG && (this.av || this.bl())) {
                    this.aM();
                }
            }
            if (this.bY() && (this.av || this.bl())) {
                this.h(-this.dn());
            }
        }
    }

    public boolean aL() {
        return !this.dQ() && !this.ad;
    }

    private boolean c(IBlockData state) {
        return state.a(TagsBlock.aS) || state.a(Blocks.rr);
    }

    private boolean a(BlockPosition pos, IBlockData state, boolean playStepSound, boolean broadcastGameEvent, Vec3D entityPos) {
        if (state.l()) {
            return false;
        }
        boolean isStateClimbable = this.c(state);
        if ((this.aJ() || isStateClimbable || this.ci() && entityPos.e == 0.0 || this.cq()) && !this.ck()) {
            if (playStepSound) {
                this.c(pos, state);
            }
            if (broadcastGameEvent) {
                this.dV().a(GameEvent.P, this.dt(), GameEvent.a.a(this, state));
            }
            return true;
        }
        return false;
    }

    protected boolean d(Vec3D deltaMovement) {
        return false;
    }

    protected void aM() {
        this.a(SoundEffects.kF, 0.7f, 1.6f + (this.ae.i() - this.ae.i()) * 0.4f);
    }

    public void aN() {
        if (!this.dV().C && this.aG) {
            this.aM();
        }
        this.aH();
    }

    protected void aO() {
        if (this.ba()) {
            this.aZ();
            if (this.bg().b()) {
                this.a(GameEvent.x);
            }
        }
    }

    @Deprecated
    public BlockPosition aP() {
        return this.e(0.2f);
    }

    public BlockPosition aQ() {
        return this.e(0.500001f);
    }

    public BlockPosition aR() {
        return this.e(1.0E-5f);
    }

    protected BlockPosition e(float yOffset) {
        if (this.ax.isPresent() && this.dV().getChunkIfLoadedImmediately(this.ax.get()) != null) {
            BlockPosition blockPos = this.ax.get();
            if (!(yOffset > 1.0E-5f)) {
                return blockPos;
            }
            IBlockData blockState = this.dV().a_(blockPos);
            return !((double)yOffset <= 0.5 && blockState.a(TagsBlock.U) || blockState.a(TagsBlock.N) || blockState.b() instanceof BlockFenceGate) ? blockPos.h(MathHelper.a(this.t.e - (double)yOffset)) : blockPos;
        }
        int floor = MathHelper.a(this.t.d);
        int floor1 = MathHelper.a(this.t.e - (double)yOffset);
        int floor2 = MathHelper.a(this.t.f);
        return new BlockPosition(floor, floor1, floor2);
    }

    protected float aS() {
        float jumpFactor = this.dV().a_(this.dv()).b().k();
        float jumpFactor1 = this.dV().a_(this.aQ()).b().k();
        return (double)jumpFactor == 1.0 ? jumpFactor1 : jumpFactor;
    }

    protected float aT() {
        IBlockData blockState = this.dV().a_(this.dv());
        float speedFactor = blockState.b().h();
        if (!blockState.a(Blocks.J) && !blockState.a(Blocks.nF)) {
            return (double)speedFactor == 1.0 ? this.dV().a_(this.aQ()).b().h() : speedFactor;
        }
        return speedFactor;
    }

    protected Vec3D a(Vec3D vec, EnumMoveType mover) {
        return vec;
    }

    protected Vec3D e(Vec3D pos) {
        if (pos.h() <= 1.0E-7) {
            return pos;
        }
        long gameTime = this.dV().ad();
        if (gameTime != this.ba) {
            Arrays.fill(this.aZ, 0.0);
            this.ba = gameTime;
        }
        if (pos.d != 0.0) {
            double d2 = this.a(EnumDirection.EnumAxis.a, pos.d);
            return Math.abs(d2) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(d2, 0.0, 0.0);
        }
        if (pos.e != 0.0) {
            double d3 = this.a(EnumDirection.EnumAxis.b, pos.e);
            return Math.abs(d3) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, d3, 0.0);
        }
        if (pos.f != 0.0) {
            double d4 = this.a(EnumDirection.EnumAxis.c, pos.f);
            return Math.abs(d4) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, 0.0, d4);
        }
        return Vec3D.c;
    }

    private double a(EnumDirection.EnumAxis axis, double distance) {
        int ordinal = axis.ordinal();
        double d2 = MathHelper.a(distance + this.aZ[ordinal], -0.51, 0.51);
        distance = d2 - this.aZ[ordinal];
        this.aZ[ordinal] = d2;
        return distance;
    }

    private Vec3D a(Vec3D movement) {
        double stepHeight;
        boolean collidedDownwards;
        Vec3D collided;
        ArrayList<AxisAlignedBB> entityAABBs;
        AxisAlignedBB currentBox;
        block7: {
            block6: {
                double d2;
                boolean zZero;
                boolean xZero = movement.d == 0.0;
                boolean yZero = movement.e == 0.0;
                boolean bl = zZero = movement.f == 0.0;
                if (xZero & yZero & zZero) {
                    return movement;
                }
                currentBox = this.cR();
                ArrayList<VoxelShape> potentialCollisionsVoxel = new ArrayList<VoxelShape>();
                ArrayList<AxisAlignedBB> potentialCollisionsBB = new ArrayList<AxisAlignedBB>();
                AxisAlignedBB initialCollisionBox = xZero & zZero ? (movement.e < 0.0 ? CollisionUtil.cutDownwards(currentBox, movement.e) : CollisionUtil.cutUpwards(currentBox, movement.e)) : currentBox.b(movement);
                entityAABBs = new ArrayList<AxisAlignedBB>();
                CollisionUtil.getEntityHardCollisions(this.s, this, initialCollisionBox, entityAABBs, 0, null);
                CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.s, this, initialCollisionBox, potentialCollisionsVoxel, potentialCollisionsBB, 4, null);
                potentialCollisionsBB.addAll(entityAABBs);
                collided = CollisionUtil.performCollisions(movement, currentBox, potentialCollisionsVoxel, potentialCollisionsBB);
                boolean collidedX = collided.d != movement.d;
                boolean collidedY = collided.e != movement.e;
                boolean collidedZ = collided.f != movement.f;
                boolean bl2 = collidedDownwards = collidedY && movement.e < 0.0;
                if (!collidedDownwards && !this.aD || !collidedX && !collidedZ) break block6;
                stepHeight = this.dP();
                if (!(d2 <= 0.0)) break block7;
            }
            return collided;
        }
        AxisAlignedBB collidedYBox = collidedDownwards ? currentBox.d(0.0, collided.e, 0.0) : currentBox;
        AxisAlignedBB stepRetrievalBox = collidedYBox.b(movement.d, stepHeight, movement.f);
        if (!collidedDownwards) {
            stepRetrievalBox = stepRetrievalBox.b(0.0, -1.0E-5f, 0.0);
        }
        ArrayList<VoxelShape> stepVoxels = new ArrayList<VoxelShape>();
        ArrayList<AxisAlignedBB> stepAABBs = entityAABBs;
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.s, this, stepRetrievalBox, stepVoxels, stepAABBs, 4, null);
        for (float step : Entity.calculateStepHeights(collidedYBox, stepVoxels, stepAABBs, (float)stepHeight, (float)collided.e)) {
            Vec3D stepResult = CollisionUtil.performCollisions(new Vec3D(movement.d, step, movement.f), collidedYBox, stepVoxels, stepAABBs);
            if (!(stepResult.j() > collided.j())) continue;
            return stepResult.b(0.0, collidedYBox.b - currentBox.b, 0.0);
        }
        return collided;
    }

    private static float[] a(AxisAlignedBB box, List<VoxelShape> colliders, float deltaY, float maxUpStep) {
        FloatArraySet set = new FloatArraySet(4);
        block0: for (VoxelShape voxelShape : colliders) {
            DoubleListIterator doubleListIterator = voxelShape.a(EnumDirection.EnumAxis.b).iterator();
            while (doubleListIterator.hasNext()) {
                double d2 = (Double)doubleListIterator.next();
                float f2 = (float)(d2 - box.b);
                if (f2 < 0.0f || f2 == maxUpStep) continue;
                if (f2 > deltaY) continue block0;
                set.add(f2);
            }
        }
        float[] floats = set.toFloatArray();
        FloatArrays.unstableSort((float[])floats);
        return floats;
    }

    public static Vec3D a(@Nullable Entity entity, Vec3D vec, AxisAlignedBB collisionBox, net.minecraft.world.level.World level, List<VoxelShape> potentialHits) {
        List<VoxelShape> list = Entity.a(entity, level, potentialHits, collisionBox.b(vec));
        return Entity.a(vec, collisionBox, list);
    }

    private static List<VoxelShape> a(@Nullable Entity entity, net.minecraft.world.level.World level, List<VoxelShape> collisions, AxisAlignedBB boundingBox) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        WorldBorder worldBorder = level.F_();
        boolean bl = flag = entity != null && worldBorder.a(entity, boundingBox);
        if (flag) {
            builder.add((Object)worldBorder.c());
        }
        builder.addAll(level.e(entity, boundingBox));
        return builder.build();
    }

    private static Vec3D a(Vec3D deltaMovement, AxisAlignedBB entityBB, List<VoxelShape> shapes) {
        boolean flag;
        if (shapes.isEmpty()) {
            return deltaMovement;
        }
        double d2 = deltaMovement.d;
        double d1 = deltaMovement.e;
        double d22 = deltaMovement.f;
        if (d1 != 0.0 && (d1 = VoxelShapes.a(EnumDirection.EnumAxis.b, entityBB, shapes, d1)) != 0.0) {
            entityBB = entityBB.d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d2) < Math.abs(d22);
        if (flag && d22 != 0.0 && (d22 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBB, shapes, d22)) != 0.0) {
            entityBB = entityBB.d(0.0, 0.0, d22);
        }
        if (d2 != 0.0) {
            d2 = VoxelShapes.a(EnumDirection.EnumAxis.a, entityBB, shapes, d2);
            if (!flag && d2 != 0.0) {
                entityBB = entityBB.d(d2, 0.0, 0.0);
            }
        }
        if (!flag && d22 != 0.0) {
            d22 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBB, shapes, d22);
        }
        return new Vec3D(d2, d1, d22);
    }

    protected float aU() {
        return (int)this.X + 1;
    }

    protected SoundEffect aV() {
        return SoundEffects.kJ;
    }

    protected SoundEffect aW() {
        return SoundEffects.kI;
    }

    protected SoundEffect aX() {
        return SoundEffects.kI;
    }

    public SoundEffect getSwimSound0() {
        return this.aV();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.aW();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.aX();
    }

    public void b(Vec3D oldPosition, Vec3D position) {
        this.bi.add(new b(oldPosition, position));
    }

    private void a(List<b> movements, Set<IBlockData> blocksInside) {
        if (this.aL()) {
            LongSet set = this.bk;
            for (b movement : movements) {
                Vec3D vec3 = movement.a();
                Vec3D vec31 = movement.b();
                AxisAlignedBB aabb = this.c(vec31).h(1.0E-5f);
                for (BlockPosition blockPos : IBlockAccess.a(vec3, vec31, aabb)) {
                    if (!this.bL()) {
                        return;
                    }
                    IBlockData blockState = this.dV().a_(blockPos);
                    if (blockState.l() || !set.add(blockPos.a())) continue;
                    try {
                        VoxelShape entityInsideCollisionShape = blockState.b(this.dV(), blockPos);
                        if (entityInsideCollisionShape != VoxelShapes.b() && !this.a(vec3, vec31, blockPos, entityInsideCollisionShape)) continue;
                        blockState.a(this.dV(), blockPos, this);
                        this.a(blockState);
                    }
                    catch (Throwable var16) {
                        CrashReport crashReport = CrashReport.a(var16, "Colliding entity with block");
                        CrashReportSystemDetails crashReportCategory = crashReport.a("Block being collided with");
                        CrashReportSystemDetails.a(crashReportCategory, this.dV(), blockPos, blockState);
                        CrashReportSystemDetails crashReportCategory1 = crashReport.a("Entity being checked for collision");
                        this.a(crashReportCategory1);
                        throw new ReportedException(crashReport);
                    }
                    blocksInside.add(blockState);
                }
            }
            set.clear();
        }
    }

    private boolean a(Vec3D oldPosition, Vec3D position, BlockPosition pos, VoxelShape shape) {
        AxisAlignedBB aabb = this.c(oldPosition);
        Vec3D vec3 = position.d(oldPosition);
        return aabb.a(vec3, shape.a(new Vec3D(pos)).e());
    }

    protected void a(IBlockData state) {
    }

    public BlockPosition a(WorldServer level, BlockPosition pos) {
        BlockPosition sharedSpawnPos = level.Z();
        Vec3D center = sharedSpawnPos.b();
        int i2 = level.m(sharedSpawnPos).a(HeightMap.Type.f, sharedSpawnPos.u(), sharedSpawnPos.w()) + 1;
        return BlockPosition.a(center.d, (double)i2, center.f);
    }

    public void a(Holder<GameEvent> gameEvent, @Nullable Entity entity) {
        this.dV().a(entity, gameEvent, this.t);
    }

    public void a(Holder<GameEvent> gameEvent) {
        this.a(gameEvent, this);
    }

    private void c(BlockPosition pos, IBlockData state) {
        this.b(pos, state);
        if (this.d(state)) {
            this.m();
        }
    }

    protected void aY() {
        Entity entity = Objects.requireNonNullElse(this.cW(), this);
        float f2 = entity == this ? 0.35f : 0.4f;
        Vec3D deltaMovement = entity.dy();
        float min = Math.min(1.0f, (float)Math.sqrt(deltaMovement.d * deltaMovement.d * (double)0.2f + deltaMovement.e * deltaMovement.e + deltaMovement.f * deltaMovement.f * (double)0.2f) * f2);
        this.f(min);
    }

    protected BlockPosition e(BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        IBlockData blockState = this.dV().a_(blockPos);
        return !blockState.a(TagsBlock.bp) && !blockState.a(TagsBlock.bq) ? pos : blockPos;
    }

    protected void a(IBlockData primaryState, IBlockData secondaryState) {
        SoundEffectType soundType = primaryState.A();
        this.a(soundType.d(), soundType.a() * 0.15f, soundType.b());
        this.b(secondaryState);
    }

    protected void b(IBlockData state) {
        SoundEffectType soundType = state.A();
        this.a(soundType.d(), soundType.a() * 0.05f, soundType.b() * 0.8f);
    }

    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffectType soundType = state.A();
        this.a(soundType.d(), soundType.a() * 0.15f, soundType.b());
    }

    private boolean d(IBlockData state) {
        return state.a(TagsBlock.bo) && this.af >= this.bf + 20;
    }

    private void m() {
        this.be *= (float)Math.pow(0.997, this.af - this.bf);
        this.be = Math.min(1.0f, this.be + 0.07f);
        float f2 = 0.5f + this.be * this.ae.i() * 1.2f;
        float f1 = 0.1f + this.be * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bf = this.af;
    }

    protected void f(float volume) {
        this.a(this.aV(), volume, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
    }

    protected void aZ() {
    }

    protected boolean ba() {
        return false;
    }

    public void a(SoundEffect sound, float volume, float pitch) {
        if (!this.bb()) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), sound, this.dm(), volume, pitch);
        }
    }

    public void a(SoundEffect sound) {
        if (!this.bb()) {
            this.a(sound, 1.0f, 1.0f);
        }
    }

    public boolean bb() {
        return this.al.a(aQ);
    }

    public void e(boolean isSilent) {
        this.al.a(aQ, isSilent);
    }

    public boolean bc() {
        return this.al.a(aR);
    }

    public void f(boolean noGravity) {
        this.al.a(aR, noGravity);
    }

    protected double bd() {
        return 0.0;
    }

    public final double be() {
        return this.bc() ? 0.0 : this.bd();
    }

    protected void bf() {
        double gravity = this.be();
        if (gravity != 0.0) {
            this.i(this.dy().b(0.0, -gravity, 0.0));
        }
    }

    protected MovementEmission bg() {
        return MovementEmission.d;
    }

    public boolean bh() {
        return false;
    }

    public final void a(double x2, double y2, double z2, boolean onGround) {
        if (!this.do()) {
            this.b(onGround, new Vec3D(x2, y2, z2));
            BlockPosition onPosLegacy = this.aP();
            IBlockData blockState = this.dV().a_(onPosLegacy);
            this.a(y2, onGround, blockState, onPosLegacy);
        }
    }

    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (onGround) {
            if (this.Z > 0.0f) {
                state.b().a(this.dV(), state, pos, this, this.Z);
                this.dV().a(GameEvent.A, this.t, GameEvent.a.a(this, this.ax.map(supportingPos -> this.dV().a_((BlockPosition)supportingPos)).orElse(state)));
            }
            this.k();
        } else if (y2 < 0.0) {
            this.Z -= (float)y2;
        }
    }

    public boolean bi() {
        return this.aq().d();
    }

    public boolean a(float fallDistance, float multiplier, DamageSource source) {
        if (this.o.a(TagsEntity.o)) {
            return false;
        }
        if (this.ca()) {
            for (Entity entity : this.cY()) {
                entity.a(fallDistance, multiplier, source);
            }
        }
        return false;
    }

    public boolean bj() {
        return this.ag;
    }

    public boolean isInRain0() {
        BlockPosition blockPos = this.dv();
        return this.dV().r(blockPos) || this.dV().r(BlockPosition.a((double)blockPos.u(), this.cR().e, (double)blockPos.w()));
    }

    public boolean u() {
        return this.dw().a(Blocks.nF);
    }

    public boolean bk() {
        return this.bj() || this.isInRain0();
    }

    public boolean bl() {
        return this.bj() || this.isInRain0() || this.u();
    }

    public boolean bm() {
        return this.bj() || this.u();
    }

    public boolean bn() {
        return this.bm() || this.bx();
    }

    public boolean bo() {
        return this.ai && this.bj();
    }

    public void bp() {
        if (this.ck()) {
            this.i(this.cj() && this.bj() && !this.bZ());
        } else {
            this.i(this.cj() && this.bo() && !this.bZ() && this.dV().b_(this.u).a(TagsFluid.a));
        }
    }

    protected boolean bq() {
        this.ah.clear();
        this.br();
        double d2 = this.dV().G_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d2);
        return this.bj() || flag;
    }

    void br() {
        AbstractBoat abstractBoat;
        Entity entity = this.dk();
        if (entity instanceof AbstractBoat && !(abstractBoat = (AbstractBoat)entity).bo()) {
            this.ag = false;
        } else if (this.a(TagsFluid.a, 0.014)) {
            if (!this.ag && !this.ak) {
                this.bs();
            }
            this.k();
            this.ag = true;
            this.aH();
        } else {
            this.ag = false;
        }
    }

    private void G() {
        AbstractBoat abstractBoat;
        this.ai = this.a(TagsFluid.a);
        this.aI.clear();
        double eyeY = this.dE();
        Entity entity = this.dk();
        if (!(entity instanceof AbstractBoat) || (abstractBoat = (AbstractBoat)entity).bo() || !(abstractBoat.cR().e >= eyeY) || !(abstractBoat.cR().b <= eyeY)) {
            BlockPosition blockPos = BlockPosition.a(this.dA(), eyeY, this.dG());
            Fluid fluidState = this.dV().b_(blockPos);
            double d2 = (float)blockPos.v() + fluidState.a(this.dV(), blockPos);
            if (d2 > eyeY) {
                fluidState.k().forEach(this.aI::add);
            }
        }
    }

    protected void bs() {
        double d1;
        double d2;
        Entity entity = Objects.requireNonNullElse(this.cW(), this);
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D deltaMovement = entity.dy();
        float min = Math.min(1.0f, (float)Math.sqrt(deltaMovement.d * deltaMovement.d * (double)0.2f + deltaMovement.e * deltaMovement.e + deltaMovement.f * deltaMovement.f * (double)0.2f) * f2);
        if (min < 0.25f) {
            this.a(this.aW(), min, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
        } else {
            this.a(this.aX(), min, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
        }
        float f1 = MathHelper.a(this.dC());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.bb.a() * 20.0f) {
            d2 = (this.ae.j() * 2.0 - 1.0) * (double)this.bb.a();
            d1 = (this.ae.j() * 2.0 - 1.0) * (double)this.bb.a();
            this.dV().a(Particles.d, this.dA() + d2, (double)(f1 + 1.0f), this.dG() + d1, deltaMovement.d, deltaMovement.e - this.ae.j() * (double)0.2f, deltaMovement.f);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.bb.a() * 20.0f) {
            d2 = (this.ae.j() * 2.0 - 1.0) * (double)this.bb.a();
            d1 = (this.ae.j() * 2.0 - 1.0) * (double)this.bb.a();
            this.dV().a(Particles.ao, this.dA() + d2, (double)(f1 + 1.0f), this.dG() + d1, deltaMovement.d, deltaMovement.e, deltaMovement.f);
            ++i2;
        }
        this.a(GameEvent.O);
    }

    @Deprecated
    protected IBlockData bt() {
        return this.dV().a_(this.aP());
    }

    public IBlockData bu() {
        return this.dV().a_(this.aR());
    }

    public boolean bv() {
        return this.cj() && !this.bj() && !this.Z_() && !this.ci() && !this.bx() && this.bL();
    }

    protected void bw() {
        BlockPosition onPosLegacy = this.aP();
        IBlockData blockState = this.dV().a_(onPosLegacy);
        if (blockState.o() != EnumRenderType.a) {
            Vec3D deltaMovement = this.dy();
            BlockPosition blockPos = this.dv();
            double d2 = this.dA() + (this.ae.j() - 0.5) * (double)this.bb.a();
            double d1 = this.dG() + (this.ae.j() - 0.5) * (double)this.bb.a();
            if (blockPos.u() != onPosLegacy.u()) {
                d2 = MathHelper.a(d2, (double)onPosLegacy.u(), (double)onPosLegacy.u() + 1.0);
            }
            if (blockPos.w() != onPosLegacy.w()) {
                d1 = MathHelper.a(d1, (double)onPosLegacy.w(), (double)onPosLegacy.w() + 1.0);
            }
            this.dV().a(new ParticleParamBlock(Particles.b, blockState), d2, this.dC() + 0.1, d1, deltaMovement.d * -4.0, 1.5, deltaMovement.f * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> fluidTag) {
        return this.aI.contains(fluidTag);
    }

    public boolean bx() {
        return !this.ak && this.ah.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float amount, Vec3D relative) {
        Vec3D inputVector = Entity.a(relative, amount, this.dL());
        this.i(this.dy().e(inputVector));
    }

    protected static Vec3D a(Vec3D relative, float motionScaler, float facing) {
        double d2 = relative.h();
        if (d2 < 1.0E-7) {
            return Vec3D.c;
        }
        Vec3D vec3 = (d2 > 1.0 ? relative.d() : relative).c((double)motionScaler);
        float sin = MathHelper.a(facing * ((float)Math.PI / 180));
        float cos = MathHelper.b(facing * ((float)Math.PI / 180));
        return new Vec3D(vec3.d * (double)cos - vec3.f * (double)sin, vec3.e, vec3.f * (double)cos + vec3.d * (double)sin);
    }

    @Deprecated
    public float by() {
        return this.dV().f(this.dz(), this.dF()) ? this.dV().x(BlockPosition.a(this.dA(), this.dE(), this.dG())) : 0.0f;
    }

    public void a(double x2, double y2, double z2, float yRot, float xRot) {
        this.h(x2, y2, z2);
        this.c(yRot, xRot);
    }

    public void c(float yRot, float xRot) {
        this.v(yRot % 360.0f);
        this.w(MathHelper.a(xRot, -90.0f, 90.0f) % 360.0f);
        this.N = this.dL();
        this.O = this.dN();
        this.q(yRot);
    }

    public void h(double x2, double y2, double z2) {
        double d2 = MathHelper.a(x2, -3.0E7, 3.0E7);
        double d1 = MathHelper.a(z2, -3.0E7, 3.0E7);
        this.K = d2;
        this.L = y2;
        this.M = d1;
        this.a_(d2, y2, d1);
        if (this.valid) {
            this.s.d((int)Math.floor(this.dA()) >> 4, (int)Math.floor(this.dG()) >> 4);
        }
    }

    public void f(Vec3D vec) {
        this.e(vec.d, vec.e, vec.f);
    }

    public void e(double x2, double y2, double z2) {
        this.b(x2, y2, z2, this.dL(), this.dN());
    }

    public void a(BlockPosition pos, float yRot, float xRot) {
        this.b(pos.c(), yRot, xRot);
    }

    public void b(Vec3D pos, float yRot, float xRot) {
        this.b(pos.d, pos.e, pos.f, yRot, xRot);
    }

    public void b(double x2, double y2, double z2, float yRot, float xRot) {
        if (!this.preserveMotion) {
            this.az = Vec3D.c;
        } else {
            this.preserveMotion = false;
        }
        this.o(x2, y2, z2);
        this.v(yRot);
        this.w(xRot);
        this.bz();
        this.ay();
        this.q(yRot);
    }

    public final void bz() {
        this.bA();
        this.bB();
    }

    public final void c(Vec3D pos, float yRot, float xRot) {
        this.k(pos);
        this.f(yRot, xRot);
    }

    protected void bA() {
        this.k(this.t);
    }

    public void bB() {
        this.f(this.dL(), this.dN());
    }

    private void k(Vec3D pos) {
        this.K = this.aa = pos.d;
        this.L = this.ab = pos.e;
        this.M = this.ac = pos.f;
    }

    private void f(float yRot, float xRot) {
        this.N = yRot;
        this.O = xRot;
    }

    public final Vec3D bC() {
        return new Vec3D(this.aa, this.ab, this.ac);
    }

    public float f(Entity entity) {
        float f2 = (float)(this.dA() - entity.dA());
        float f1 = (float)(this.dC() - entity.dC());
        float f22 = (float)(this.dG() - entity.dG());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double i(double x2, double y2, double z2) {
        double d2 = this.dA() - x2;
        double d1 = this.dC() - y2;
        double d22 = this.dG() - z2;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public double g(Entity entity) {
        return this.g(entity.dt());
    }

    public double g(Vec3D vec) {
        double d2 = this.dA() - vec.d;
        double d1 = this.dC() - vec.e;
        double d22 = this.dG() - vec.f;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public void a_(EntityHuman player) {
    }

    public void h(Entity entity) {
        if (!(this.z(entity) || entity.ad || this.ad)) {
            double d1;
            if (this.s.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityPlayer) && !(this instanceof EntityPlayer)) {
                return;
            }
            double d2 = entity.dA() - this.dA();
            double max = MathHelper.a(d2, d1 = entity.dG() - this.dG());
            if (max >= (double)0.01f) {
                max = Math.sqrt(max);
                d2 /= max;
                d1 /= max;
                double d22 = 1.0 / max;
                if (d22 > 1.0) {
                    d22 = 1.0;
                }
                d2 *= d22;
                d1 *= d22;
                d2 *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.ca() && this.bI()) {
                    this.j(-d2, 0.0, -d1);
                }
                if (!entity.ca() && entity.bI()) {
                    entity.j(d2, 0.0, d1);
                }
            }
        }
    }

    public void h(Vec3D vector) {
        this.j(vector.d, vector.e, vector.f);
    }

    public void j(double x2, double y2, double z2) {
        this.push(x2, y2, z2, null);
    }

    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        Vector delta = new Vector(x2, y2, z2);
        if (pushingEntity != null) {
            EntityPushedByEntityAttackEvent event = new EntityPushedByEntityAttackEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityKnockbackEvent.Cause.PUSH, (org.bukkit.entity.Entity)pushingEntity.getBukkitEntity(), delta);
            if (!event.callEvent()) {
                return;
            }
            delta = event.getKnockback();
        }
        this.i(this.dy().b(delta.getX(), delta.getY(), delta.getZ()));
        this.ar = true;
    }

    protected void bD() {
        this.T = true;
    }

    @Deprecated
    public final void a(DamageSource damageSource, float amount) {
        net.minecraft.world.level.World world = this.s;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, damageSource, amount);
        }
    }

    @Deprecated
    public final boolean b(DamageSource damageSource, float amount) {
        boolean bl;
        net.minecraft.world.level.World world = this.s;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            bl = this.a(serverLevel, damageSource, amount);
        } else {
            bl = this.b(damageSource);
        }
        return bl;
    }

    public abstract boolean a(WorldServer var1, DamageSource var2, float var3);

    public boolean b(DamageSource damageSource) {
        return false;
    }

    public final Vec3D g(float partialTicks) {
        return this.d(this.h(partialTicks), this.i(partialTicks));
    }

    public EnumDirection bE() {
        return EnumDirection.a(this.g(1.0f));
    }

    public float h(float partialTicks) {
        return this.j(partialTicks);
    }

    public float i(float partialTick) {
        return this.k(partialTick);
    }

    public float j(float partialTick) {
        return partialTick == 1.0f ? this.dN() : MathHelper.h(partialTick, this.O, this.dN());
    }

    public float k(float partialTick) {
        return partialTick == 1.0f ? this.dL() : MathHelper.i(partialTick, this.N, this.dL());
    }

    public final Vec3D d(float xRot, float yRot) {
        float f2 = xRot * ((float)Math.PI / 180);
        float f1 = -yRot * ((float)Math.PI / 180);
        float cos = MathHelper.b(f1);
        float sin = MathHelper.a(f1);
        float cos1 = MathHelper.b(f2);
        float sin1 = MathHelper.a(f2);
        return new Vec3D(sin * cos1, -sin1, cos * cos1);
    }

    public final Vec3D l(float partialTick) {
        return this.e(this.h(partialTick), this.i(partialTick));
    }

    protected final Vec3D e(float xRot, float yRot) {
        return this.d(xRot - 90.0f, yRot);
    }

    public final Vec3D bF() {
        return new Vec3D(this.dA(), this.dE(), this.dG());
    }

    public final Vec3D m(float partialTick) {
        double d2 = MathHelper.d((double)partialTick, this.K, this.dA());
        double d1 = MathHelper.d((double)partialTick, this.L, this.dC()) + (double)this.cS();
        double d22 = MathHelper.d((double)partialTick, this.M, this.dG());
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D n(float partialTicks) {
        return this.m(partialTicks);
    }

    public final Vec3D o(float partialTicks) {
        double d2 = MathHelper.d((double)partialTicks, this.K, this.dA());
        double d1 = MathHelper.d((double)partialTicks, this.L, this.dC());
        double d22 = MathHelper.d((double)partialTicks, this.M, this.dG());
        return new Vec3D(d2, d1, d22);
    }

    public MovingObjectPosition a(double hitDistance, float partialTicks, boolean hitFluids) {
        Vec3D eyePosition = this.m(partialTicks);
        Vec3D viewVector = this.g(partialTicks);
        Vec3D vec3 = eyePosition.b(viewVector.d * hitDistance, viewVector.e * hitDistance, viewVector.f * hitDistance);
        return this.dV().a(new RayTrace(eyePosition, vec3, RayTrace.BlockCollisionOption.b, hitFluids ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bG() {
        return this.bL() && this.bH();
    }

    public boolean bH() {
        return false;
    }

    public boolean bI() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bI();
    }

    public void a(Entity entity, DamageSource damageSource) {
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.d.a((EntityPlayer)entity, this, damageSource);
        }
    }

    public boolean k(double x2, double y2, double z2) {
        double d2 = this.dA() - x2;
        double d1 = this.dC() - y2;
        double d22 = this.dG() - z2;
        double d3 = d2 * d2 + d1 * d1 + d22 * d22;
        return this.a(d3);
    }

    public boolean a(double distance) {
        double size = this.cR().a();
        if (Double.isNaN(size)) {
            size = 1.0;
        }
        return distance < (size *= 64.0 * n) * size;
    }

    public boolean d(NBTTagCompound compound) {
        return this.saveAsPassenger(compound, true, false, false);
    }

    public boolean saveAsPassenger(NBTTagCompound compound, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        if (this.aE != null && !this.aE.b() && !forceSerialization) {
            return false;
        }
        String encodeId = this.getEncodeId(includeNonSaveable);
        if (!this.persist && !forceSerialization || encodeId == null) {
            return false;
        }
        compound.a(v, encodeId);
        this.saveWithoutId(compound, includeAll, includeNonSaveable, forceSerialization);
        return true;
    }

    public boolean e(NBTTagCompound compound) {
        return !this.bZ() && this.d(compound);
    }

    public NBTTagCompound f(NBTTagCompound compound) {
        return this.saveWithoutId(compound, true, false, false);
    }

    public NBTTagCompound saveWithoutId(NBTTagCompound compound, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        try {
            NBTTagList listTag;
            int ticksFrozen;
            if (includeAll) {
                if (this.r != null) {
                    compound.a("Pos", this.a(new double[]{this.r.dA(), this.dC(), this.r.dG()}));
                } else {
                    compound.a("Pos", this.a(new double[]{this.dA(), this.dC(), this.dG()}));
                }
            }
            Vec3D deltaMovement = this.dy();
            compound.a("Motion", this.a(new double[]{deltaMovement.d, deltaMovement.e, deltaMovement.f}));
            if (Float.isNaN(this.aA)) {
                this.aA = 0.0f;
            }
            if (Float.isNaN(this.aB)) {
                this.aB = 0.0f;
            }
            compound.a("Rotation", this.a(new float[]{this.dL(), this.dN()}));
            compound.a("FallDistance", this.Z);
            compound.a("Fire", (short)this.aH);
            compound.a("Air", (short)this.ct());
            compound.a("OnGround", this.aJ());
            compound.a("Invulnerable", this.aW);
            compound.a("PortalCooldown", this.aV);
            if (includeAll) {
                compound.a(H, this.cG());
                compound.a("WorldUUIDLeast", this.s.getWorld().getUID().getLeastSignificantBits());
                compound.a("WorldUUIDMost", this.s.getWorld().getUID().getMostSignificantBits());
            }
            compound.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                compound.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                compound.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                compound.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                compound.a("Bukkit.MaxAirSupply", this.cs());
            }
            compound.a("Spigot.ticksLived", this.totalEntityAge);
            IChatBaseComponent customName = this.an();
            if (customName != null) {
                compound.a("CustomName", IChatBaseComponent.ChatSerializer.a(customName, (HolderLookup.a)this.dX()));
            }
            if (this.cL()) {
                compound.a("CustomNameVisible", this.cL());
            }
            if (this.bb()) {
                compound.a("Silent", this.bb());
            }
            if (this.bc()) {
                compound.a("NoGravity", this.bc());
            }
            if (this.aX) {
                compound.a("Glowing", true);
            }
            if ((ticksFrozen = this.cu()) > 0) {
                compound.a("TicksFrozen", this.cu());
            }
            if (this.bg) {
                compound.a("HasVisualFire", this.bg);
            }
            if (!this.aY.isEmpty()) {
                listTag = new NBTTagList();
                for (String string : this.aY) {
                    listTag.add(NBTTagString.a(string));
                }
                compound.a("Tags", listTag);
            }
            this.addAdditionalSaveData(compound, includeAll);
            if (this.ca()) {
                listTag = new NBTTagList();
                for (Entity entity : this.cY()) {
                    NBTTagCompound compoundTag;
                    if (!entity.saveAsPassenger(compoundTag = new NBTTagCompound(), includeAll, includeNonSaveable, forceSerialization)) continue;
                    listTag.add(compoundTag);
                }
                if (!listTag.isEmpty()) {
                    compound.a(w, listTag);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(compound);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.s != null ? this.s.getWorld().getUID() : null);
                if (originWorld != null) {
                    compound.a("Paper.OriginWorld", originWorld);
                }
                compound.a("Paper.Origin", this.a(new double[]{this.origin.getX(), this.origin.getY(), this.origin.getZ()}));
            }
            if (this.spawnReason != null) {
                compound.a("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                compound.a("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                compound.a("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                compound.a("Paper.FreezeLock", true);
            }
            return compound;
        }
        catch (Throwable var9) {
            CrashReport crashReport = CrashReport.a(var9, "Saving entity NBT");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Entity being saved");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    public void g(NBTTagCompound compound) {
        try {
            NBTTagList originTag;
            NBTTagList list = compound.c("Pos", 6);
            NBTTagList list1 = compound.c("Motion", 6);
            NBTTagList list2 = compound.c("Rotation", 5);
            double _double = list1.h(0);
            double _double1 = list1.h(1);
            double _double2 = list1.h(2);
            this.n(Math.abs(_double) > 10.0 ? 0.0 : _double, Math.abs(_double1) > 10.0 ? 0.0 : _double1, Math.abs(_double2) > 10.0 ? 0.0 : _double2);
            this.ar = true;
            double d2 = 3.0000512E7;
            this.o(MathHelper.a(list.h(0), -3.0000512E7, 3.0000512E7), MathHelper.a(list.h(1), -2.0E7, 2.0E7), MathHelper.a(list.h(2), -3.0000512E7, 3.0000512E7));
            this.v(list2.i(0));
            this.w(list2.i(1));
            this.bz();
            this.q(this.dL());
            this.r(this.dL());
            this.Z = compound.j("FallDistance");
            this.aH = compound.g("Fire");
            if (compound.e("Air")) {
                this.j(compound.g("Air"));
            }
            this.aD = compound.q("OnGround");
            this.aW = compound.q("Invulnerable");
            this.aV = compound.h("PortalCooldown");
            if (compound.b(H)) {
                this.at = compound.a(H);
                this.au = this.at.toString();
            }
            if (!(Double.isFinite(this.dA()) && Double.isFinite(this.dC()) && Double.isFinite(this.dG()))) {
                throw new IllegalStateException("Entity has invalid position");
            }
            if (Double.isFinite(this.dL()) && Double.isFinite(this.dN())) {
                this.ay();
                this.b(this.dL(), this.dN());
                if (compound.b("CustomName", 8)) {
                    String string = compound.l("CustomName");
                    try {
                        this.b(IChatBaseComponent.ChatSerializer.a(string, (HolderLookup.a)this.dX()));
                    }
                    catch (Exception var16) {
                        b.warn("Failed to parse entity custom name {}", (Object)string, (Object)var16);
                    }
                } else {
                    this.al.a(aO, Optional.empty());
                }
                this.p(compound.q("CustomNameVisible"));
                this.e(compound.q("Silent"));
                this.f(compound.q("NoGravity"));
                this.j(compound.q("Glowing"));
                this.k(compound.h("TicksFrozen"));
                this.bg = compound.q("HasVisualFire");
                if (compound.b("Tags", 9)) {
                    this.aY.clear();
                    NBTTagList list3 = compound.c("Tags", 8);
                    int min = Math.min(list3.size(), 1024);
                    for (int i2 = 0; i2 < min; ++i2) {
                        this.aY.add(list3.j(i2));
                    }
                }
                this.a(compound);
                if (this.bJ()) {
                    this.ay();
                }
            } else {
                throw new IllegalStateException("Entity has invalid rotation");
            }
            if (this instanceof EntityLiving) {
                this.totalEntityAge = compound.h("Spigot.ticksLived");
            }
            this.persist = !compound.e("Bukkit.persist") || compound.q("Bukkit.persist");
            boolean bl = this.visibleByDefault = !compound.e("Bukkit.visibleByDefault") || compound.q("Bukkit.visibleByDefault");
            if (compound.e("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = compound.h("Bukkit.MaxAirSupply");
            }
            this.getBukkitEntity().readBukkitValues(compound);
            if (compound.e("Bukkit.invisible")) {
                boolean bukkitInvisible = compound.q("Bukkit.invisible");
                this.k(bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            }
            if (!(originTag = compound.c("Paper.Origin", 6)).isEmpty()) {
                UUID originWorld = null;
                if (compound.e("Paper.OriginWorld")) {
                    originWorld = compound.a("Paper.OriginWorld");
                } else if (this.s != null) {
                    originWorld = this.s.getWorld().getUID();
                }
                this.originWorld = originWorld;
                this.origin = new Vector(originTag.h(0), originTag.h(1), originTag.h(2));
            }
            this.spawnedViaMobSpawner = compound.q("Paper.FromMobSpawner");
            this.fromNetherPortal = compound.q("Paper.FromNetherPortal");
            if (compound.e("Paper.SpawnReason")) {
                String spawnReasonName = compound.l("Paper.SpawnReason");
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    b.error("Unknown SpawnReason " + spawnReasonName + " for " + String.valueOf(this));
                }
            }
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof EntityInsentient && (this instanceof EntityAnimal || this instanceof EntityFish) && !((EntityInsentient)this).h(0.0) && !compound.q("PersistenceRequired")) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            if (compound.e("Paper.FreezeLock")) {
                this.freezeLocked = compound.q("Paper.FreezeLock");
            }
        }
        catch (Throwable var17) {
            CrashReport crashReport = CrashReport.a(var17, "Loading entity NBT");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Entity being loaded");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    protected boolean bJ() {
        return true;
    }

    @Nullable
    public final String bK() {
        return this.getEncodeId(false);
    }

    @Nullable
    public final String getEncodeId(boolean includeNonSaveable) {
        EntityTypes<?> type = this.aq();
        MinecraftKey key = EntityTypes.a(type);
        return (type.b() || includeNonSaveable) && key != null ? key.toString() : null;
    }

    protected void addAdditionalSaveData(NBTTagCompound tag, boolean includeAll) {
        this.b(tag);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... numbers) {
        NBTTagList listTag = new NBTTagList();
        for (double d2 : numbers) {
            listTag.add(NBTTagDouble.a(d2));
        }
        return listTag;
    }

    protected NBTTagList a(float ... numbers) {
        NBTTagList listTag = new NBTTagList();
        for (float f2 : numbers) {
            listTag.add(NBTTagFloat.a(f2));
        }
        return listTag;
    }

    @Nullable
    public EntityItem a(WorldServer level, IMaterial item) {
        return this.a(level, item, 0);
    }

    @Nullable
    public EntityItem a(WorldServer level, IMaterial item, int yOffset) {
        return this.a(level, new ItemStack(item), (float)yOffset);
    }

    @Nullable
    public EntityItem a(WorldServer level, ItemStack stack) {
        return this.a(level, stack, 0.0f);
    }

    @Nullable
    public EntityItem a(WorldServer level, ItemStack stack, float yOffset) {
        return this.spawnAtLocation(level, stack, yOffset, null);
    }

    @Nullable
    public EntityItem spawnAtLocation(WorldServer level, ItemStack stack, float yOffset, @Nullable Consumer<? super EntityItem> delayedAddConsumer) {
        if (stack.f()) {
            return null;
        }
        if (this instanceof EntityLiving && !this.forceDrops) {
            ((EntityLiving)this).drops.add(new DefaultDrop(stack, itemStack -> {
                EntityItem itemEntity = new EntityItem(this.s, this.dA(), this.dC() + (double)yOffset, this.dG(), (ItemStack)itemStack);
                itemEntity.s();
                this.s.b(itemEntity);
                if (delayedAddConsumer != null) {
                    delayedAddConsumer.accept(itemEntity);
                }
            }));
            return null;
        }
        EntityItem itemEntity = new EntityItem(level, this.dA(), this.dC() + (double)yOffset, this.dG(), stack.v());
        stack.e(0);
        itemEntity.s();
        itemEntity.s();
        return this.spawnAtLocation(level, itemEntity);
    }

    @Nullable
    public EntityItem spawnAtLocation(WorldServer level, EntityItem itemEntity) {
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        level.b(itemEntity);
        return itemEntity;
    }

    public boolean bL() {
        return !this.dQ();
    }

    public boolean bM() {
        if (this.ad) {
            return false;
        }
        double reducedWith = this.bb.a() * 0.8f;
        AxisAlignedBB boundingBox = AxisAlignedBB.a(this.bF(), reducedWith, 1.0E-6, reducedWith);
        net.minecraft.world.level.World world = this.s;
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        int minBlockX = MathHelper.a(boundingBox.a);
        int minBlockY = MathHelper.a(boundingBox.b);
        int minBlockZ = MathHelper.a(boundingBox.c);
        int maxBlockX = MathHelper.a(boundingBox.d);
        int maxBlockY = MathHelper.a(boundingBox.e);
        int maxBlockZ = MathHelper.a(boundingBox.f);
        int minChunkX = minBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkY = maxBlockY >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minSection = WorldUtil.getMinSection(world);
        IChunkProvider chunkSource = world.S();
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkSection[] sections = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, true).d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).c()) continue;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.q(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.r(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                VoxelShape collisionShape;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.p(blockX);
                                IBlockData blockState = blocks.a(currX | currZ << 4 | currY << 8);
                                if (blockState.moonrise$emptyCollisionShape() || !blockState.j(world, mutablePos) || (collisionShape = blockState.g(world, mutablePos)).c()) continue;
                                AxisAlignedBB toCollide = boundingBox.d(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AxisAlignedBB singleAABB = collisionShape.moonrise$getSingleAABBRepresentation();
                                if (!(singleAABB != null ? CollisionUtil.voxelShapeIntersect(singleAABB, toCollide) : CollisionUtil.voxelShapeIntersectNoEmpty(collisionShape, toCollide))) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        Entity entity;
        if (this.bL() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.D() == player) {
                if (!this.dV().B_()) {
                    PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(this, player, hand, !player.fV());
                    if (event.isCancelled()) {
                        ((EntityPlayer)player).f.b(new PacketPlayOutAttachEntity(this, leashable.D()));
                        return EnumInteractionResult.e;
                    }
                    if (!event.isDropLeash()) {
                        leashable.A();
                    } else {
                        leashable.z();
                    }
                    this.a(GameEvent.r, (Entity)player);
                }
                return EnumInteractionResult.a.b();
            }
            ItemStack itemInHand = player.b(hand);
            if (itemInHand.a(Items.vK) && leashable.Q_()) {
                if (!this.dV().B_()) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, player, player, hand).isCancelled()) {
                        ((EntityPlayer)player).f.b(new PacketPlayOutAttachEntity(this, leashable.D()));
                        player.cd.b();
                        return EnumInteractionResult.e;
                    }
                    leashable.b((Entity)player, true);
                }
                itemInHand.h(1);
                return EnumInteractionResult.a;
            }
        }
        return EnumInteractionResult.e;
    }

    public boolean i(Entity entity) {
        return entity.bN() && !this.z(entity);
    }

    public boolean bN() {
        return false;
    }

    public void r() {
        this.i(Vec3D.c);
        this.h();
        if (this.bZ()) {
            this.dk().j(this);
        }
    }

    public final void j(Entity passenger) {
        if (this.y(passenger)) {
            this.a(passenger, Entity::a_);
        }
    }

    protected void a(Entity passenger, MoveFunction callback) {
        Vec3D passengerRidingPosition = this.m(passenger);
        Vec3D vehicleAttachmentPoint = passenger.l(this);
        callback.accept(passenger, passengerRidingPosition.d - vehicleAttachmentPoint.d, passengerRidingPosition.e - vehicleAttachmentPoint.e, passengerRidingPosition.f - vehicleAttachmentPoint.f);
    }

    public void k(Entity entityToUpdate) {
    }

    public Vec3D l(Entity entity) {
        return this.ds().b(EntityAttachment.b, 0, this.aA);
    }

    public Vec3D m(Entity entity) {
        return this.dt().e(this.a(entity, this.bb, 1.0f));
    }

    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return Entity.a(this, entity, dimensions.d());
    }

    protected static Vec3D a(Entity vehicle, Entity passenger, EntityAttachments attachments) {
        int index = vehicle.cY().indexOf(passenger);
        return attachments.c(EntityAttachment.a, index, vehicle.aA);
    }

    public boolean n(Entity vehicle) {
        return this.a(vehicle, false);
    }

    public boolean bO() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity vehicle, boolean force) {
        if (vehicle == this.r || vehicle.s != this.s) {
            return false;
        }
        if (!vehicle.bR()) {
            return false;
        }
        if (!(force || this.dV().B_() || vehicle.o.b())) {
            return false;
        }
        Entity entity = vehicle;
        while (entity.r != null) {
            if (entity.r == this) {
                return false;
            }
            entity = entity.r;
        }
        if (force || this.o(vehicle) && vehicle.r(this)) {
            EntityMountEvent event;
            if (vehicle.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
                event = new VehicleEnterEvent((Vehicle)vehicle.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
                if (this.valid) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return false;
                }
            }
            event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)vehicle.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
            if (this.bZ()) {
                this.ae();
            }
            this.b(EntityPose.a);
            this.r = vehicle;
            this.r.p(this);
            vehicle.I().filter(entity1 -> entity1 instanceof EntityPlayer).forEach(entity1 -> CriterionTriggers.U.a((EntityPlayer)entity1));
            return true;
        }
        return false;
    }

    protected boolean o(Entity vehicle) {
        return !this.cd() && this.J <= 0;
    }

    public void bP() {
        for (int i2 = this.q.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.q.get(i2)).ae();
        }
    }

    public void bQ() {
        this.removeVehicle(false);
    }

    public void removeVehicle(boolean suppressCancellation) {
        if (this.r != null) {
            Entity entity = this.r;
            this.r = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.r = entity;
            }
        }
    }

    public void ae() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        this.removeVehicle(suppressCancellation);
    }

    protected void p(Entity passenger) {
        if (passenger.dk() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.q.isEmpty()) {
            this.q = ImmutableList.of((Object)passenger);
        } else {
            ArrayList list = Lists.newArrayList(this.q);
            if (!this.dV().C && passenger instanceof EntityHuman && !(this.cZ() instanceof EntityHuman)) {
                list.add(0, passenger);
            } else {
                list.add(passenger);
            }
            this.q = ImmutableList.copyOf((Collection)list);
        }
        this.a(GameEvent.s, passenger);
    }

    protected boolean removePassenger(Entity passenger) {
        return this.removePassenger(passenger, false);
    }

    protected boolean removePassenger(Entity passenger, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (passenger.dk() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)passenger.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && passenger.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)passenger.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)passenger.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)passenger.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.q = this.q.size() == 1 && this.q.get(0) == passenger ? ImmutableList.of() : (ImmutableList)this.q.stream().filter(entity -> entity != passenger).collect(ImmutableList.toImmutableList());
        passenger.J = 60;
        this.a(GameEvent.q, passenger);
        return true;
    }

    protected boolean r(Entity passenger) {
        return this.q.isEmpty();
    }

    protected boolean bR() {
        return true;
    }

    public void f_() {
    }

    public void a(double x2, double y2, double z2, float yRot, float xRot, int steps) {
        this.a_(x2, y2, z2);
        this.b(yRot, xRot);
    }

    public double R_() {
        return this.dA();
    }

    public double S_() {
        return this.dC();
    }

    public double g_() {
        return this.dG();
    }

    public float r_() {
        return this.dN();
    }

    public float h_() {
        return this.dL();
    }

    public void a(float yaw, int pitch) {
        this.q(yaw);
    }

    public float bS() {
        return 0.0f;
    }

    public Vec3D bT() {
        return this.d(this.dN(), this.dL());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof EntityHuman)) {
            return Vec3D.c;
        }
        EntityHuman player = (EntityHuman)entity;
        boolean flag = player.fa().a(item) && !player.eZ().a(item);
        EnumMainHand humanoidArm = flag ? player.fy().e() : player.fy();
        return this.d(0.0f, this.dL() + (float)(humanoidArm == EnumMainHand.b ? 80 : -80)).c(0.5);
    }

    public Vec2F bU() {
        return new Vec2F(this.dN(), this.dL());
    }

    public Vec3D bV() {
        return Vec3D.a(this.bU());
    }

    public void a(Portal portal, BlockPosition pos) {
        if (this.aD()) {
            this.aB();
        } else if (this.as == null || !this.as.a(portal)) {
            this.as = new PortalProcessor(portal, pos.j());
        } else if (!this.as.e()) {
            this.as.a(pos.j());
            this.as.a(true);
        }
    }

    protected void bW() {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.M();
            if (this.as != null) {
                if (this.as.a(serverLevel, this, this.o(false))) {
                    GameProfilerFiller profilerFiller = Profiler.a();
                    profilerFiller.a("portal");
                    this.aB();
                    TeleportTransition portalDestination = this.as.a(serverLevel, this);
                    if (portalDestination != null) {
                        WorldServer level = portalDestination.b();
                        if (this instanceof EntityPlayer || level != null && (level.ai() == serverLevel.ai() || this.a((net.minecraft.world.level.World)serverLevel, level))) {
                            this.b(portalDestination);
                        }
                    }
                    profilerFiller.c();
                } else if (this.as.b()) {
                    this.as = null;
                }
            }
        }
    }

    public int bX() {
        Entity firstPassenger = this.cZ();
        return firstPassenger instanceof EntityPlayer ? firstPassenger.bX() : 300;
    }

    public void l(double x2, double y2, double z2) {
        this.n(x2, y2, z2);
    }

    public void c(DamageSource damageSource) {
    }

    public void b(byte id) {
        switch (id) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void p(float yaw) {
    }

    public boolean bY() {
        boolean flag = this.dV() != null && this.dV().C;
        return !this.bi() && (this.aH > 0 || flag && this.i(0));
    }

    public boolean bZ() {
        return this.dk() != null;
    }

    public boolean ca() {
        return !this.q.isEmpty();
    }

    public boolean cb() {
        return this.aq().a(TagsEntity.p);
    }

    public boolean cc() {
        return !this.aq().a(TagsEntity.q);
    }

    public void g(boolean keyDown) {
        this.b(1, keyDown);
    }

    public boolean cd() {
        return this.i(1);
    }

    public boolean ce() {
        return this.cd();
    }

    public boolean cf() {
        return this.cd();
    }

    public boolean cg() {
        return this.cd();
    }

    public boolean ch() {
        return this.cd();
    }

    public boolean ci() {
        return this.c(EntityPose.f);
    }

    public boolean cj() {
        return this.i(3);
    }

    public void h(boolean sprinting) {
        this.b(3, sprinting);
    }

    public boolean ck() {
        return this.i(4);
    }

    public boolean cl() {
        return this.c(EntityPose.d);
    }

    public boolean cm() {
        return this.cl() && !this.bj();
    }

    public void i(boolean swimming) {
        if (this.valid && this.ck() != swimming && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, swimming).isCancelled()) {
            return;
        }
        this.b(4, swimming);
    }

    public final boolean cn() {
        return this.aX;
    }

    public final void j(boolean hasGlowingTag) {
        this.aX = hasGlowingTag;
        this.b(6, this.co());
    }

    public boolean co() {
        return this.dV().B_() ? this.i(6) : this.aX;
    }

    public boolean cp() {
        return this.i(5);
    }

    public boolean d(EntityHuman player) {
        if (player.Z_()) {
            return false;
        }
        ScoreboardTeam team = this.cr();
        return (team == null || player == null || player.cr() != team || !((ScoreboardTeamBase)team).i()) && this.cp();
    }

    public boolean cq() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> listenerConsumer) {
    }

    @Nullable
    public ScoreboardTeam cr() {
        if (!this.dV().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
            return null;
        }
        return this.dV().R().e(this.cI());
    }

    public final boolean s(@Nullable Entity entity) {
        return entity != null && (this == entity || this.t(entity) || entity.t(this));
    }

    protected boolean t(Entity entity) {
        return this.a(entity.cr());
    }

    public boolean a(@Nullable ScoreboardTeamBase team) {
        return this.cr() != null && this.cr().a(team);
    }

    public void k(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.b(5, invisible);
        }
    }

    public boolean i(int flag) {
        return (this.al.a(am) & 1 << flag) != 0;
    }

    public void b(int flag, boolean set) {
        byte b2 = this.al.a(am);
        if (set) {
            this.al.a(am, (byte)(b2 | 1 << flag));
        } else {
            this.al.a(am, (byte)(b2 & ~(1 << flag)));
        }
    }

    public int cs() {
        return this.maxAirTicks;
    }

    public int ct() {
        return this.al.a(aN);
    }

    public void j(int air) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.ct() != air) {
            this.al.markDirty(aN);
            return;
        }
        this.al.a(aN, event.getAmount());
    }

    public int cu() {
        return this.al.a(aS);
    }

    public void k(int ticksFrozen) {
        this.al.a(aS, ticksFrozen);
    }

    public float cv() {
        int ticksRequiredToFreeze = this.cx();
        return (float)Math.min(this.cu(), ticksRequiredToFreeze) / (float)ticksRequiredToFreeze;
    }

    public boolean cw() {
        return this.cu() >= this.cx();
    }

    public int cx() {
        return 140;
    }

    public void a(WorldServer level, EntityLightning lightning) {
        this.h(this.aH + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aH == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            } else {
                this.h(this.aH - 1);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.bi()) {
            return;
        }
        if (!this.a(level, this.dW().c().eventEntityDamager(lightning), 5.0f)) {
            return;
        }
    }

    public void l(boolean downwards) {
        Vec3D deltaMovement = this.dy();
        double max = downwards ? Math.max(-0.9, deltaMovement.e - 0.03) : Math.min(1.8, deltaMovement.e + 0.1);
        this.n(deltaMovement.d, max, deltaMovement.f);
    }

    public void m(boolean downwards) {
        Vec3D deltaMovement = this.dy();
        double max = downwards ? Math.max(-0.3, deltaMovement.e - 0.03) : Math.min(0.7, deltaMovement.e + 0.06);
        this.n(deltaMovement.d, max, deltaMovement.f);
        this.k();
    }

    public boolean a(WorldServer level, EntityLiving entity) {
        return true;
    }

    public void cy() {
        if (this.dy().b() > -0.5 && this.Z > 1.0f) {
            this.Z = 1.0f;
        }
    }

    public void k() {
        this.Z = 0.0f;
    }

    protected void m(double x2, double y2, double z2) {
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        Vec3D vec3 = new Vec3D(x2 - (double)blockPos.u(), y2 - (double)blockPos.v(), z2 - (double)blockPos.w());
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        EnumDirection direction = EnumDirection.b;
        double d2 = Double.MAX_VALUE;
        for (EnumDirection direction1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d22;
            mutableBlockPos.a((BaseBlockPosition)blockPos, direction1);
            if (this.dV().a_(mutableBlockPos).m(this.dV(), mutableBlockPos)) continue;
            double d1 = vec3.a(direction1.o());
            double d3 = d22 = direction1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d1 : d1;
            if (!(d22 < d2)) continue;
            d2 = d22;
            direction = direction1;
        }
        float f2 = this.ae.i() * 0.2f + 0.1f;
        float f1 = direction.f().a();
        Vec3D vec31 = this.dy().c(0.75);
        if (direction.o() == EnumDirection.EnumAxis.a) {
            this.n(f1 * f2, vec31.e, vec31.f);
        } else if (direction.o() == EnumDirection.EnumAxis.b) {
            this.n(vec31.d, f1 * f2, vec31.f);
        } else if (direction.o() == EnumDirection.EnumAxis.c) {
            this.n(vec31.d, vec31.e, f1 * f2);
        }
    }

    public void a(IBlockData state, Vec3D motionMultiplier) {
        this.k();
        this.U = motionMultiplier;
    }

    private static IChatBaseComponent a(IChatBaseComponent name) {
        IChatMutableComponent mutableComponent = name.e().b(name.a().a((ChatClickable)null));
        for (IChatBaseComponent component : name.c()) {
            mutableComponent.b(Entity.a(component));
        }
        return mutableComponent;
    }

    @Override
    public IChatBaseComponent al() {
        IChatBaseComponent customName = this.an();
        return customName != null ? Entity.a(customName) : this.cz();
    }

    protected IChatBaseComponent cz() {
        return this.o.h();
    }

    public boolean u(Entity entity) {
        return this == entity;
    }

    public float cA() {
        return 0.0f;
    }

    public void q(float yHeadRot) {
    }

    public void r(float yBodyRot) {
    }

    public boolean cB() {
        return true;
    }

    public boolean v(Entity entity) {
        return false;
    }

    public String toString() {
        String string = this.dV() == null ? "~NULL~" : this.dV().toString();
        return this.aE != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.al().getString(), this.p, this.at, string, this.dA(), this.dC(), this.dG(), this.dx(), this.af, this.valid, this.aE}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.al().getString(), this.p, this.at, string, this.dA(), this.dC(), this.dG(), this.dx(), this.af, this.valid);
    }

    public final boolean d(DamageSource damageSource) {
        return this.dQ() || this.aW && !damageSource.a(DamageTypeTags.d) && !damageSource.h() || damageSource.a(DamageTypeTags.i) && this.bi() || damageSource.a(DamageTypeTags.m) && this.aq().a(TagsEntity.o);
    }

    public boolean cC() {
        return this.aW;
    }

    public void n(boolean isInvulnerable) {
        this.aW = isInvulnerable;
    }

    public void w(Entity entity) {
        this.b(entity.dA(), entity.dC(), entity.dG(), entity.dL(), entity.dN());
    }

    public void x(Entity entity) {
        CraftEntity bukkitEntity = entity.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        NBTTagCompound compoundTag = entity.f(new NBTTagCompound());
        compoundTag.r("Dimension");
        this.g(compoundTag);
        this.aV = entity.aV;
        this.as = entity.as;
    }

    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        if (!(this.bL() && this.valid || teleportTransition.b() == this.s)) {
            b.warn("Illegal Entity Teleport " + String.valueOf(this) + " to " + String.valueOf(teleportTransition.b()) + ":" + String.valueOf(teleportTransition.c()), new Throwable());
            return null;
        }
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (!this.dQ()) {
                boolean flag;
                EntityTeleportEvent teleEvent;
                TileEntity tileEntity;
                PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTransition), teleportTransition.i());
                Vec3D velocity = absolutePosition.b();
                Location to = CraftLocation.toBukkit(absolutePosition.a(), (World)teleportTransition.b().getWorld(), absolutePosition.c(), absolutePosition.d());
                if (this.as != null && this.as.a((BlockEndGateway)Blocks.lh) && (tileEntity = this.s.c_(this.as.c())) instanceof TileEntityEndGateway) {
                    TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
                    teleEvent = new EntityTeleportEndGatewayEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), this.getBukkitEntity().getLocation(), to, (EndGateway)new CraftEndGateway(to.getWorld(), theEndGatewayBlockEntity));
                    teleEvent.callEvent();
                } else {
                    teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                }
                if (teleEvent.isCancelled() || teleEvent.getTo() == null) {
                    return null;
                }
                if (!to.equals((Object)teleEvent.getTo())) {
                    to = teleEvent.getTo();
                    teleportTransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), Vec3D.c, to.getYaw(), to.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
                    velocity = Vec3D.c;
                }
                if (this.as != null) {
                    CraftEntity bukkitEntity = this.getBukkitEntity();
                    EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), to.clone(), bukkitEntity.getVelocity(), CraftVector.toBukkit(velocity));
                    event.callEvent();
                    if (!(event.isCancelled() || event.getTo() == null || event.getTo().equals((Object)event.getFrom()) && event.getAfter().equals((Object)event.getBefore()))) {
                        to = event.getTo().clone();
                        velocity = CraftVector.toNMS(event.getAfter());
                        teleportTransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), velocity, to.getYaw(), to.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
                    }
                }
                if (this.dQ()) {
                    return null;
                }
                WorldServer level = teleportTransition.b();
                boolean bl = flag = level.ai() != serverLevel.ai();
                if (!teleportTransition.h()) {
                    this.ae();
                }
                return flag ? this.b(level, teleportTransition) : this.a(serverLevel, teleportTransition);
            }
        }
        return null;
    }

    private Entity a(WorldServer level, TeleportTransition teleportTransition) {
        for (Entity entity : this.cY()) {
            entity.b(this.a(teleportTransition, entity));
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("teleportSameDimension");
        this.a(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        if (!teleportTransition.h()) {
            this.a(teleportTransition);
        }
        teleportTransition.j().onTransition(this);
        profilerFiller.c();
        return this;
    }

    private Entity b(WorldServer level, TeleportTransition teleportTransition) {
        List<Entity> passengers = this.cY();
        ArrayList<Entity> list = new ArrayList<Entity>(passengers.size());
        this.bP();
        for (Entity entity : passengers) {
            Entity entity1 = entity.b(this.a(teleportTransition, entity));
            if (entity1 == null) continue;
            list.add(entity1);
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("teleportCrossDimension");
        Object entityx = this.aq().a(level, EntitySpawnReason.s);
        if (entityx == null) {
            profilerFiller.c();
            return null;
        }
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            leashable.z();
        }
        ((Entity)entityx).x(this);
        this.cD();
        ((Entity)entityx).a(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        if (this.inWorld) {
            level.d((Entity)entityx);
        }
        for (Entity entity2 : list) {
            entity2.a((Entity)entityx, true);
        }
        level.i();
        teleportTransition.j().onTransition((Entity)entityx);
        profilerFiller.c();
        return entityx;
    }

    private TeleportTransition a(TeleportTransition teleportTransition, Entity entity) {
        float f2 = teleportTransition.e() + (teleportTransition.i().contains((Object)Relative.d) ? 0.0f : entity.dL() - this.dL());
        float f1 = teleportTransition.f() + (teleportTransition.i().contains((Object)Relative.e) ? 0.0f : entity.dN() - this.dN());
        Vec3D vec3 = entity.dt().d(this.dt());
        Vec3D vec31 = teleportTransition.c().b(teleportTransition.i().contains((Object)Relative.a) ? 0.0 : vec3.a(), teleportTransition.i().contains((Object)Relative.b) ? 0.0 : vec3.b(), teleportTransition.i().contains((Object)Relative.c) ? 0.0 : vec3.c());
        return teleportTransition.a(vec31).a(f2, f1).a();
    }

    private void a(TeleportTransition teleportTransition) {
        EntityLiving controllingPassenger = this.cW();
        for (Entity entity : this.dc()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (controllingPassenger != null && serverPlayer.ar() == controllingPassenger.ar()) {
                serverPlayer.f.b(PacketPlayOutEntityTeleport.a(this.ar(), PositionMoveRotation.a(teleportTransition), teleportTransition.i(), this.aD));
                continue;
            }
            serverPlayer.f.b(PacketPlayOutEntityTeleport.a(this.ar(), PositionMoveRotation.a(this), Set.of(), this.aD));
        }
    }

    public void a(PositionMoveRotation positionMovementRotation, Set<Relative> relatives) {
        PositionMoveRotation positionMoveRotation = PositionMoveRotation.a(this);
        PositionMoveRotation positionMoveRotation1 = PositionMoveRotation.a(positionMoveRotation, positionMovementRotation, relatives);
        this.o(positionMoveRotation1.a().d, positionMoveRotation1.a().e, positionMoveRotation1.a().f);
        this.v(positionMoveRotation1.c());
        this.q(positionMoveRotation1.c());
        this.w(positionMoveRotation1.d());
        this.ay();
        this.bz();
        this.i(positionMoveRotation1.b());
        this.bi.clear();
    }

    public void a(float yRot, float xRot) {
        this.v(yRot);
        this.q(yRot);
        this.w(xRot);
        this.bB();
    }

    public void f(BlockPosition pos) {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.m().a(TicketType.e, new ChunkCoordIntPair(pos), 3, pos);
        }
    }

    protected void cD() {
        Leashable leashable;
        this.setRemoved(RemovalReason.e, null);
        Entity entity = this;
        if (entity instanceof Leashable && (leashable = (Leashable)((Object)entity)).P_()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
            event.callEvent();
            if (!event.isDropLeash()) {
                leashable.A();
            } else {
                leashable.z();
            }
        }
    }

    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return BlockPortalShape.a(portal, axis, this.dt(), this.a(this.aw()));
    }

    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        PortalType portalType = switch (cause) {
            case PlayerTeleportEvent.TeleportCause.END_PORTAL -> PortalType.ENDER;
            case PlayerTeleportEvent.TeleportCause.NETHER_PORTAL -> PortalType.NETHER;
            case PlayerTeleportEvent.TeleportCause.END_GATEWAY -> PortalType.END_GATEWAY;
            default -> PortalType.CUSTOM;
        };
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius, portalType);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bL()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean o(boolean allowPassengers) {
        return (allowPassengers || !this.bZ()) && this.bL();
    }

    public boolean a(net.minecraft.world.level.World fromLevel, net.minecraft.world.level.World toLevel) {
        if (!this.bL() || !this.valid) {
            return false;
        }
        if (fromLevel.ai() == net.minecraft.world.level.World.k && toLevel.ai() == net.minecraft.world.level.World.i) {
            for (Entity entity : this.cY()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                if (serverPlayer.i) continue;
                return false;
            }
        }
        return true;
    }

    public float a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData blockState, Fluid fluidState, float explosionPower) {
        return explosionPower;
    }

    public boolean a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData blockState, float explosionPower) {
        return true;
    }

    public int cE() {
        return 3;
    }

    public boolean s_() {
        return false;
    }

    public void a(CrashReportSystemDetails category) {
        category.a("Entity Type", () -> String.valueOf(EntityTypes.a(this.aq())) + " (" + this.getClass().getCanonicalName() + ")");
        category.a("Entity ID", this.p);
        category.a("Entity Name", () -> this.al().getString());
        category.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dA(), this.dC(), this.dG()));
        category.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.dV(), MathHelper.a(this.dA()), MathHelper.a(this.dC()), MathHelper.a(this.dG())));
        Vec3D deltaMovement = this.dy();
        category.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", deltaMovement.d, deltaMovement.e, deltaMovement.f));
        category.a("Entity's Passengers", () -> this.cY().toString());
        category.a("Entity's Vehicle", () -> String.valueOf(this.dk()));
    }

    public boolean cF() {
        return this.bY() && !this.Z_();
    }

    public void a_(UUID uniqueId) {
        this.at = uniqueId;
        this.au = this.at.toString();
    }

    @Override
    public UUID cG() {
        return this.at;
    }

    public String cH() {
        return this.au;
    }

    @Override
    public String cI() {
        return this.au;
    }

    public boolean cJ() {
        return true;
    }

    public static double cK() {
        return n;
    }

    public static void b(double renderDistWeight) {
        n = renderDistWeight;
    }

    @Override
    public IChatBaseComponent p_() {
        return ScoreboardTeam.a(this.cr(), this.al()).a(style -> style.a(this.cQ()).a(this.cH()));
    }

    public void b(@Nullable IChatBaseComponent name) {
        this.al.a(aO, Optional.ofNullable(name));
    }

    @Override
    @Nullable
    public IChatBaseComponent an() {
        return this.al.a(aO).orElse(null);
    }

    @Override
    public boolean l_() {
        return this.al.a(aO).isPresent();
    }

    public void p(boolean alwaysRenderNameTag) {
        this.al.a(aP, alwaysRenderNameTag);
    }

    public boolean cL() {
        return this.al.a(aP);
    }

    public final boolean a(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera) {
        return this.teleportTo(level, x2, y2, z2, relativeMovements, yaw, pitch, setCamera, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleportTo(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera, PlayerTeleportEvent.TeleportCause cause) {
        float f2 = MathHelper.a(pitch, -90.0f, 90.0f);
        Entity entity = this.b(new TeleportTransition(level, new Vec3D(x2, y2, z2), Vec3D.c, yaw, f2, relativeMovements, TeleportTransition.a, cause));
        return entity != null;
    }

    public void a(double x2, double y2, double z2) {
        this.c(x2, y2, z2);
    }

    public void c(double x2, double y2, double z2) {
        if (this.dV() instanceof WorldServer) {
            this.b(x2, y2, z2, this.dL(), this.dN());
            this.H();
        }
    }

    public void H() {
        this.da().forEach(entity -> {
            for (Entity entity1 : entity.q) {
                entity.a(entity1, Entity::e);
            }
        });
    }

    public void d(double dx, double dy, double dz) {
        this.c(this.dA() + dx, this.dC() + dy, this.dG() + dz);
    }

    public boolean cM() {
        return this.cL();
    }

    @Override
    public void a(List<DataWatcher.c<?>> dataValues) {
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (aq.equals(key)) {
            this.m_();
        }
    }

    @Deprecated
    protected void cN() {
        EntitySize dimensions;
        EntityPose pose = this.aw();
        this.bb = dimensions = this.a(pose);
        this.bc = dimensions.c();
    }

    public void m_() {
        boolean flag;
        EntitySize dimensions;
        EntitySize entityDimensions = this.bb;
        EntityPose pose = this.aw();
        this.bb = dimensions = this.a(pose);
        this.bc = dimensions.c();
        this.ay();
        boolean bl = flag = dimensions.a() <= 4.0f && dimensions.b() <= 4.0f;
        if (!(this.s.C || this.ak || this.ad || !flag || !(dimensions.a() > entityDimensions.a()) && !(dimensions.b() > entityDimensions.b()) || this instanceof EntityHuman)) {
            this.a(entityDimensions);
        }
    }

    public boolean a(EntitySize dimensions) {
        VoxelShape voxelShape1;
        Optional<Vec3D> optional1;
        double d1;
        double d2;
        EntitySize dimensions1 = this.a(this.aw());
        Vec3D vec3 = this.dt().b(0.0, (double)dimensions.b() / 2.0, 0.0);
        VoxelShape voxelShape = VoxelShapes.a(AxisAlignedBB.a(vec3, d2 = (double)Math.max(0.0f, dimensions1.a() - dimensions.a()) + 1.0E-6, d1 = (double)Math.max(0.0f, dimensions1.b() - dimensions.b()) + 1.0E-6, d2));
        Optional<Vec3D> optional = this.s.a(this, voxelShape, vec3, (double)dimensions1.a(), (double)dimensions1.b(), (double)dimensions1.a());
        if (optional.isPresent()) {
            this.b(optional.get().b(0.0, (double)(-dimensions1.b()) / 2.0, 0.0));
            return true;
        }
        if (dimensions1.a() > dimensions.a() && dimensions1.b() > dimensions.b() && (optional1 = this.s.a(this, voxelShape1 = VoxelShapes.a(AxisAlignedBB.a(vec3, d2, 1.0E-6, d2)), vec3, (double)dimensions1.a(), (double)dimensions.b(), (double)dimensions1.a())).isPresent()) {
            this.b(optional1.get().b(0.0, (double)(-dimensions.b()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public EnumDirection cO() {
        return EnumDirection.a(this.dL());
    }

    public EnumDirection cP() {
        return this.cO();
    }

    protected ChatHoverable cQ() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.c, new ChatHoverable.b(this.aq(), this.cG(), this.al()));
    }

    public boolean a(EntityPlayer player) {
        return true;
    }

    @Override
    public final AxisAlignedBB cR() {
        return this.aC;
    }

    public final void a(AxisAlignedBB bb) {
        double minX = bb.a;
        double minY = bb.b;
        double minZ = bb.c;
        double maxX = bb.d;
        double maxY = bb.e;
        double maxZ = bb.f;
        double len = bb.d - bb.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = bb.e - bb.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = bb.f - bb.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aC = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float d(EntityPose pose) {
        return this.a(pose).c();
    }

    public final float cS() {
        return this.bc;
    }

    public Vec3D s(float partialTick) {
        return this.cT();
    }

    protected Vec3D cT() {
        return new Vec3D(0.0, this.cS(), this.dq() * 0.4f);
    }

    public SlotAccess a_(int slot) {
        return SlotAccess.a;
    }

    public net.minecraft.world.level.World cU() {
        return this.dV();
    }

    @Nullable
    public MinecraftServer cV() {
        return this.dV().p();
    }

    public EnumInteractionResult a(EntityHuman player, Vec3D vec, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    public boolean a(Explosion explosion) {
        return false;
    }

    public void d(EntityPlayer serverPlayer) {
    }

    public void e(EntityPlayer serverPlayer) {
        if (PlayerUntrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerUntrackEntityEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity()).callEvent();
        }
    }

    public float a(EnumBlockRotation transformRotation) {
        float f2 = MathHelper.h(this.dL());
        switch (transformRotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror transformMirror) {
        float f2 = MathHelper.h(this.dL());
        switch (transformMirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public ProjectileDeflection a(IProjectile projectile) {
        return this.aq().a(TagsEntity.r) ? ProjectileDeflection.b : ProjectileDeflection.a;
    }

    @Nullable
    public EntityLiving cW() {
        return null;
    }

    public final boolean cX() {
        return this.cW() != null;
    }

    public final List<Entity> cY() {
        return this.q;
    }

    @Nullable
    public Entity cZ() {
        return this.q.isEmpty() ? null : (Entity)this.q.get(0);
    }

    public boolean y(Entity entity) {
        return this.q.contains((Object)entity);
    }

    public boolean a(Predicate<Entity> predicate) {
        for (Entity entity : this.q) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> I() {
        if (this.q.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.q.stream().flatMap(Entity::da);
    }

    public Stream<Entity> da() {
        if (this.q.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.I());
    }

    public Stream<Entity> db() {
        if (this.q.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.q.stream().flatMap(Entity::db), Stream.of(this));
    }

    public Iterable<Entity> dc() {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        if (this.q.isEmpty()) {
            return ret;
        }
        Entity.collectIndirectPassengers(ret, this.q);
        return ret;
    }

    public int dd() {
        return (int)this.I().filter(entity -> entity instanceof EntityHuman).count();
    }

    public boolean de() {
        if (this.q.isEmpty()) {
            return false;
        }
        return this.dd() == 1;
    }

    public Entity df() {
        Entity entity = this;
        while (entity.bZ()) {
            entity = entity.dk();
        }
        return entity;
    }

    public boolean z(Entity entity) {
        return this.df() == entity.df();
    }

    public boolean A(Entity entity) {
        if (!entity.bZ()) {
            return false;
        }
        Entity vehicle = entity.dk();
        return vehicle == this || this.A(vehicle);
    }

    public boolean dg() {
        boolean bl;
        Entity entity = this;
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            bl = player.c();
        } else {
            bl = this.dh();
        }
        return bl;
    }

    public boolean dh() {
        boolean bl;
        EntityLiving entityLiving = this.cW();
        if (entityLiving instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entityLiving;
            bl = player.c();
        } else {
            bl = this.dj();
        }
        return bl;
    }

    public boolean di() {
        EntityLiving controllingPassenger = this.cW();
        return controllingPassenger != null && controllingPassenger.di();
    }

    public boolean dj() {
        return !this.dV().C;
    }

    protected static Vec3D a(double vehicleWidth, double passengerWidth, float yRot) {
        double d2 = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f2 = -MathHelper.a(yRot * ((float)Math.PI / 180));
        float cos = MathHelper.b(yRot * ((float)Math.PI / 180));
        float max = Math.max(Math.abs(f2), Math.abs(cos));
        return new Vec3D((double)f2 * d2 / (double)max, 0.0, (double)cos * d2 / (double)max);
    }

    public Vec3D b(EntityLiving passenger) {
        return new Vec3D(this.dA(), this.cR().e, this.dG());
    }

    @Nullable
    public Entity dk() {
        return this.r;
    }

    @Nullable
    public Entity dl() {
        return this.r != null && this.r.cW() == this ? this.r : null;
    }

    public EnumPistonReaction n_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory dm() {
        return SoundCategory.g;
    }

    public int dn() {
        return 1;
    }

    public CommandListenerWrapper d(WorldServer level) {
        return new CommandListenerWrapper(this.commandSource, this.dt(), this.bU(), level, 0, this.al().getString(), this.p_(), level.p(), this);
    }

    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        Vec3D vec3 = anchor.a(this);
        double d2 = target.d - vec3.d;
        double d1 = target.e - vec3.e;
        double d22 = target.f - vec3.f;
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        this.w(MathHelper.h((float)(-(MathHelper.d(d1, squareRoot) * 180.0 / 3.1415927410125732))));
        this.v(MathHelper.h((float)(MathHelper.d(d22, d2) * 180.0 / 3.1415927410125732) - 90.0f));
        this.q(this.dL());
        this.O = this.dN();
        this.N = this.dL();
    }

    public float t(float partialTick) {
        return MathHelper.h(partialTick, this.N, this.aA);
    }

    public boolean a(TagKey<FluidType> fluid, double flowScale) {
        if (this.do()) {
            return false;
        }
        AxisAlignedBB boundingBox = this.cR().h(0.001);
        net.minecraft.world.level.World world = this.s;
        int minSection = WorldUtil.getMinSection(world);
        int minBlockX = MathHelper.a(boundingBox.a);
        int minBlockY = Math.max(minSection << 4, MathHelper.a(boundingBox.b));
        int minBlockZ = MathHelper.a(boundingBox.c);
        int maxBlockX = MathHelper.c(boundingBox.d) - 1;
        int maxBlockY = Math.min(WorldUtil.getMaxSection(world) << 4 | 0xF, MathHelper.c(boundingBox.e) - 1);
        int maxBlockZ = MathHelper.c(boundingBox.f) - 1;
        boolean isPushable = this.cJ();
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        Vec3D pushVector = Vec3D.c;
        double totalPushes = 0.0;
        double maxHeightDiff = 0.0;
        boolean inFluid = false;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        IChunkProvider chunkSource = world.S();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkSection[] sections = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, false).d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).c()) continue;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                Fluid fluidState = blocks.a(currX | currZ << 4 | currY << 8).y();
                                if (fluidState.c() || !fluidState.a(fluid)) continue;
                                mutablePos.d(currX | currChunkX << 4, currY | currChunkY << 4, currZ | currChunkZ << 4);
                                double height = (float)mutablePos.v() + fluidState.a(world, mutablePos);
                                double diff = height - boundingBox.b;
                                if (diff < 0.0) continue;
                                inFluid = true;
                                maxHeightDiff = Math.max(maxHeightDiff, diff);
                                if (!isPushable) continue;
                                totalPushes += 1.0;
                                Vec3D flow = fluidState.c(world, mutablePos);
                                pushVector = diff < 0.4 ? pushVector.e(flow.c(diff)) : pushVector.e(flow);
                            }
                        }
                    }
                }
            }
        }
        this.ah.put(fluid, maxHeightDiff);
        if (pushVector.h() == 0.0) {
            return inFluid;
        }
        pushVector = pushVector.c(1.0 / totalPushes);
        Vec3D currMovement = this.dy();
        if (!(this instanceof EntityHuman)) {
            pushVector = pushVector.d();
        }
        pushVector = pushVector.c(flowScale);
        if (Math.abs(currMovement.d) < 0.003 && Math.abs(currMovement.f) < 0.003 && pushVector.g() < 0.0045000000000000005) {
            pushVector = pushVector.d().c(0.0045000000000000005);
        }
        this.i(currMovement.e(pushVector));
        return true;
    }

    public boolean do() {
        AxisAlignedBB aabb = this.cR().g(1.0);
        int floor = MathHelper.a(aabb.a);
        int ceil = MathHelper.c(aabb.d);
        int floor1 = MathHelper.a(aabb.c);
        int ceil1 = MathHelper.c(aabb.f);
        return !this.dV().b(floor, floor1, ceil, ceil1);
    }

    public double b(TagKey<FluidType> fluidTag) {
        return this.ah.getDouble(fluidTag);
    }

    public double dp() {
        return (double)this.cS() < 0.4 ? 0.0 : 0.4;
    }

    public final float dq() {
        return this.bb.a();
    }

    public final float dr() {
        return this.bb.b();
    }

    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity(this, entity);
    }

    public EntitySize a(EntityPose pose) {
        return this.o.n();
    }

    public final EntityAttachments ds() {
        return this.bb.d();
    }

    public Vec3D dt() {
        return this.t;
    }

    public Vec3D du() {
        return this.dt();
    }

    @Override
    public BlockPosition dv() {
        return this.u;
    }

    public IBlockData dw() {
        if (this.bh == null) {
            this.bh = this.dV().a_(this.dv());
        }
        return this.bh;
    }

    public ChunkCoordIntPair dx() {
        return this.ay;
    }

    public Vec3D dy() {
        return this.az;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void i(Vec3D deltaMovement) {
        Object object = this.posLock;
        synchronized (object) {
            this.az = deltaMovement;
        }
    }

    public void j(Vec3D addend) {
        this.i(this.dy().e(addend));
    }

    public void n(double x2, double y2, double z2) {
        this.i(new Vec3D(x2, y2, z2));
    }

    public final int dz() {
        return this.u.u();
    }

    public final double dA() {
        return this.t.d;
    }

    public double c(double scale) {
        return this.t.d + (double)this.dq() * scale;
    }

    public double d(double scale) {
        return this.c((2.0 * this.ae.j() - 1.0) * scale);
    }

    public final int dB() {
        return this.u.v();
    }

    public final double dC() {
        return this.t.e;
    }

    public double e(double scale) {
        return this.t.e + (double)this.dr() * scale;
    }

    public double dD() {
        return this.e(this.ae.j());
    }

    public double dE() {
        return this.t.e + (double)this.bc;
    }

    public final int dF() {
        return this.u.w();
    }

    public final double dG() {
        return this.t.f;
    }

    public double f(double scale) {
        return this.t.f + (double)this.dq() * scale;
    }

    public double g(double scale) {
        return this.f((2.0 * this.ae.j() - 1.0) * scale);
    }

    public static boolean checkPosition(Entity entity, double newX, double newY, double newZ) {
        String entityInfo;
        if (Double.isFinite(newX) && Double.isFinite(newY) && Double.isFinite(newZ)) {
            return true;
        }
        try {
            entityInfo = entity.toString();
        }
        catch (Exception ex) {
            entityInfo = "[Entity info unavailable] ";
        }
        b.error("New entity position is invalid! Tried to set invalid position ({},{},{}) for entity {} located at {}, entity info: {}", new Object[]{newX, newY, newZ, entity.getClass().getName(), entity.t, entityInfo, new Throwable()});
        return false;
    }

    public final void o(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x2, double y2, double z2, boolean forceBoundingBoxUpdate) {
        if (this.updatingSectionStatus) {
            b.error("Refusing to update position for entity " + String.valueOf(this) + " to position " + String.valueOf(new Vec3D(x2, y2, z2)) + " since it is processing a section status update", new Throwable());
            return;
        }
        if (!Entity.checkPosition(this, x2, y2, z2)) {
            return;
        }
        if (this instanceof EntityItem && GlobalConfiguration.get().misc.fixEntityPositionDesync) {
            x2 = (double)MathHelper.b(x2 * 4096.0) * 2.44140625E-4;
            y2 = (double)MathHelper.b(y2 * 4096.0) * 2.44140625E-4;
            z2 = (double)MathHelper.b(z2 * 4096.0) * 2.44140625E-4;
        }
        if (this.t.d != x2 || this.t.e != y2 || this.t.f != z2) {
            Object object = this.posLock;
            synchronized (object) {
                this.t = new Vec3D(x2, y2, z2);
            }
            int floor = MathHelper.a(x2);
            int floor1 = MathHelper.a(y2);
            int floor2 = MathHelper.a(z2);
            if (floor != this.u.u() || floor1 != this.u.v() || floor2 != this.u.w()) {
                this.u = new BlockPosition(floor, floor1, floor2);
                this.bh = null;
                if (SectionPosition.a(floor) != this.ay.h || SectionPosition.a(floor2) != this.ay.i) {
                    this.ay = new ChunkCoordIntPair(this.u);
                }
            }
            this.aT.a();
        }
        if (!(this instanceof EntityHanging) && (forceBoundingBoxUpdate || this.t.d != x2 || this.t.e != y2 || this.t.f != z2)) {
            this.a(this.ax());
        }
    }

    public void dH() {
    }

    public Vec3D u(float partialTicks) {
        return this.o(partialTicks).b(0.0, (double)this.bc * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packet) {
        int id = packet.b();
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        this.f(x2, y2, z2);
        this.b(x2, y2, z2, packet.n(), packet.m());
        this.e(id);
        this.a_(packet.e());
    }

    @Nullable
    public ItemStack dI() {
        return null;
    }

    public void q(boolean isInPowderSnow) {
        this.av = isInPowderSnow;
    }

    public boolean dJ() {
        return !this.aq().a(TagsEntity.k);
    }

    public boolean dK() {
        return (this.av || this.aw) && this.dJ();
    }

    public float dL() {
        return this.aA;
    }

    public float dM() {
        return this.dL();
    }

    public void v(float yRot) {
        if (!Float.isFinite(yRot)) {
            SystemUtils.b("Invalid entity rotation: " + yRot + ", discarding.");
        } else {
            this.aA = yRot;
        }
    }

    public float dN() {
        return this.aB;
    }

    public void w(float xRot) {
        if (!Float.isFinite(xRot)) {
            SystemUtils.b("Invalid entity rotation: " + xRot + ", discarding.");
        } else {
            this.aB = Math.clamp(xRot % 360.0f, -90.0f, 90.0f);
        }
    }

    public boolean dO() {
        return false;
    }

    public float dP() {
        return 0.0f;
    }

    public void b_(@Nullable Entity entity) {
    }

    public final boolean dQ() {
        return this.aE != null;
    }

    @Nullable
    public RemovalReason dR() {
        return this.aE;
    }

    @Override
    public final void c(RemovalReason removalReason) {
        this.setRemoved(removalReason, null);
    }

    @Override
    public final void setRemoved(RemovalReason removalReason, EntityRemoveEvent.Cause cause) {
        boolean alreadyRemoved;
        if (!this.s.moonrise$getEntityLookup().canRemoveEntity(this)) {
            b.warn("Entity " + String.valueOf(this) + " is currently prevented from being removed from the world since it is processing section status updates", new Throwable());
            return;
        }
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        boolean bl = alreadyRemoved = this.aE != null;
        if (this.aE == null) {
            this.aE = removalReason;
        }
        if (this.aE.a()) {
            this.ae();
        }
        if (this.aE != RemovalReason.c) {
            this.cY().forEach(Entity::ae);
        }
        this.aT.a(removalReason);
        this.b(removalReason);
        if (!(this instanceof EntityPlayer) && removalReason != RemovalReason.e && !alreadyRemoved) {
            this.retireScheduler();
        }
    }

    public void dS() {
        this.aE = null;
    }

    public final void retireScheduler() {
        this.getBukkitEntity().taskScheduler.retire();
    }

    @Override
    public void a(EntityInLevelCallback levelCallback) {
        this.aT = levelCallback;
    }

    @Override
    public boolean dT() {
        return !(this.aE != null && !this.aE.b() || this.bZ() || this.ca() && this.moonrise$hasAnyPlayerPassengers());
    }

    @Override
    public boolean dU() {
        return false;
    }

    public boolean c(WorldServer level, BlockPosition pos) {
        return true;
    }

    public net.minecraft.world.level.World dV() {
        return this.s;
    }

    public void a(net.minecraft.world.level.World level) {
        this.s = level;
    }

    public DamageSources dW() {
        return this.dV().ak();
    }

    public IRegistryCustom dX() {
        return this.dV().K_();
    }

    protected void a(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
        double d2 = 1.0 / (double)steps;
        double d1 = MathHelper.d(d2, this.dA(), targetX);
        double d22 = MathHelper.d(d2, this.dC(), targetY);
        double d3 = MathHelper.d(d2, this.dG(), targetZ);
        float f2 = (float)MathHelper.e(d2, (double)this.dL(), targetYRot);
        float f1 = (float)MathHelper.d(d2, (double)this.dN(), targetXRot);
        this.a_(d1, d22, d3);
        this.b(f2, f1);
    }

    public RandomSource dY() {
        return this.ae;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vec3D ah() {
        Vec3D vec3D;
        EntityLiving entityLiving = this.cW();
        if (entityLiving instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entityLiving;
            if (this.bL()) {
                vec3D = player.ah();
                return vec3D;
            }
        }
        vec3D = this.dy();
        return vec3D;
    }

    @Nullable
    public ItemStack dZ() {
        return null;
    }

    public Optional<ResourceKey<LootTable>> ea() {
        return this.o.k();
    }

    public static int nextEntityId() {
        return c.incrementAndGet();
    }

    public boolean isTicking() {
        return ((WorldServer)this.s).f(this.dv());
    }

    public static final class RemovalReason
    extends Enum<RemovalReason> {
        public static final /* enum */ RemovalReason a = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason b = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason c = new RemovalReason(false, true);
        public static final /* enum */ RemovalReason d = new RemovalReason(false, false);
        public static final /* enum */ RemovalReason e = new RemovalReason(false, false);
        private final boolean f;
        private final boolean g;
        private static final /* synthetic */ RemovalReason[] h;

        public static RemovalReason[] values() {
            return (RemovalReason[])h.clone();
        }

        public static RemovalReason valueOf(String name) {
            return Enum.valueOf(RemovalReason.class, name);
        }

        private RemovalReason(boolean destroy, boolean save) {
            this.f = destroy;
            this.g = save;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }

        private static /* synthetic */ RemovalReason[] c() {
            return new RemovalReason[]{a, b, c, d, e};
        }

        static {
            h = RemovalReason.c();
        }
    }

    public static final class MovementEmission
    extends Enum<MovementEmission> {
        public static final /* enum */ MovementEmission a = new MovementEmission(false, false);
        public static final /* enum */ MovementEmission b = new MovementEmission(true, false);
        public static final /* enum */ MovementEmission c = new MovementEmission(false, true);
        public static final /* enum */ MovementEmission d = new MovementEmission(true, true);
        final boolean e;
        final boolean f;
        private static final /* synthetic */ MovementEmission[] g;

        public static MovementEmission[] values() {
            return (MovementEmission[])g.clone();
        }

        public static MovementEmission valueOf(String name) {
            return Enum.valueOf(MovementEmission.class, name);
        }

        private MovementEmission(boolean sounds, boolean events) {
            this.e = sounds;
            this.f = events;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }

        private static /* synthetic */ MovementEmission[] d() {
            return new MovementEmission[]{a, b, c, d};
        }

        static {
            g = MovementEmission.d();
        }
    }

    record b(Vec3D a, Vec3D b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "from;to", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "from;to", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "from;to", "a", "b"}, this, o2);
        }
    }

    public record DefaultDrop(net.minecraft.world.item.Item item, org.bukkit.inventory.ItemStack stack, @Nullable Consumer<ItemStack> dropConsumer) {
        public DefaultDrop(ItemStack stack, Consumer<ItemStack> dropConsumer) {
            this(stack.h(), CraftItemStack.asCraftMirror(stack), dropConsumer);
        }

        public void runConsumer(Consumer<org.bukkit.inventory.ItemStack> fallback) {
            if (this.dropConsumer == null || CraftItemType.bukkitToMinecraft(this.stack.getType()) != this.item) {
                fallback.accept(this.stack);
            } else {
                this.dropConsumer.accept(CraftItemStack.asNMSCopy(this.stack));
            }
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private static final class RandomRandomSource
    extends ThreadUnsafeRandom {
        private boolean locked = false;

        public RandomRandomSource() {
            this(RandomSupport.a());
        }

        public RandomRandomSource(long seed) {
            super(seed);
        }

        @Override
        public synchronized void b(long seed) {
            if (this.locked) {
                b.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.b(seed);
                this.locked = true;
            }
        }
    }
}

