/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FormattedString;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger o = LogUtils.getLogger();
    public static final int a = -1;
    private static final DataWatcherObject<Integer> p = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> q = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Integer> r = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Vector3f> s = DataWatcher.a(Display.class, DataWatcherRegistry.D);
    private static final DataWatcherObject<Vector3f> t = DataWatcher.a(Display.class, DataWatcherRegistry.D);
    private static final DataWatcherObject<Quaternionf> u = DataWatcher.a(Display.class, DataWatcherRegistry.E);
    private static final DataWatcherObject<Quaternionf> ay = DataWatcher.a(Display.class, DataWatcherRegistry.E);
    private static final DataWatcherObject<Byte> az = DataWatcher.a(Display.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> aA = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> aB = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aC = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aD = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aE = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aF = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> aG = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final IntSet aH = IntSet.of((int[])new int[]{s.a(), t.a(), u.a(), ay.a(), az.a(), aA.a(), aC.a(), aD.a()});
    private static final float aI = 0.0f;
    private static final float aJ = 1.0f;
    private static final int aK = -1;
    public static final String b = "teleport_duration";
    public static final String c = "interpolation_duration";
    public static final String d = "start_interpolation";
    public static final String e = "transformation";
    public static final String f = "billboard";
    public static final String g = "brightness";
    public static final String h = "view_range";
    public static final String i = "shadow_radius";
    public static final String j = "shadow_strength";
    public static final String k = "width";
    public static final String l = "height";
    public static final String m = "glow_color_override";
    private long aL = Integer.MIN_VALUE;
    private int aM;
    private float aN;
    private AxisAlignedBB aO;
    private boolean aP = true;
    protected boolean n;
    private boolean aQ;
    private boolean aR;
    @Nullable
    private k aS;
    @Nullable
    private j aT;

    public Display(EntityTypes<?> entityType, World level) {
        super(entityType, level);
        this.ad = true;
        this.aO = this.cR();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (aF.equals(key) || aE.equals(key)) {
            this.E();
        }
        if (p.equals(key)) {
            this.aQ = true;
        }
        if (q.equals(key)) {
            this.aR = true;
        }
        if (aH.contains(key.a())) {
            this.n = true;
        }
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }

    public static Transformation a(DataWatcher synchedEntityData) {
        Vector3f vector3f = synchedEntityData.a(s);
        Quaternionf quaternionf = synchedEntityData.a(u);
        Vector3f vector3f1 = synchedEntityData.a(t);
        Quaternionf quaternionf1 = synchedEntityData.a(ay);
        return new Transformation(vector3f, quaternionf, vector3f1, quaternionf1);
    }

    @Override
    public void h() {
        Entity vehicle = this.dk();
        if (vehicle != null && vehicle.dQ()) {
            this.ae();
        }
        if (this.dV().C) {
            if (this.aQ) {
                this.aQ = false;
                int transformationInterpolationDelay = this.t();
                this.aL = this.af + transformationInterpolationDelay;
            }
            if (this.aR) {
                this.aR = false;
                this.aM = this.s();
            }
            if (this.n) {
                this.n = false;
                boolean flag = this.aM != 0;
                this.aS = flag && this.aS != null ? this.a(this.aS, this.aN) : this.F();
                this.a(flag, this.aN);
            }
            if (this.aT != null) {
                if (this.aT.a == 0) {
                    this.aT.a(this);
                    this.bz();
                    this.aT = null;
                } else {
                    this.aT.b(this);
                    --this.aT.a;
                    if (this.aT.a == 0) {
                        this.aT = null;
                    }
                }
            }
        }
    }

    protected abstract void a(boolean var1, float var2);

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(r, 0);
        builder.a(p, 0);
        builder.a(q, 0);
        builder.a(s, new Vector3f());
        builder.a(t, new Vector3f(1.0f, 1.0f, 1.0f));
        builder.a(ay, new Quaternionf());
        builder.a(u, new Quaternionf());
        builder.a(az, BillboardConstraints.a.a());
        builder.a(aA, -1);
        builder.a(aB, Float.valueOf(1.0f));
        builder.a(aC, Float.valueOf(0.0f));
        builder.a(aD, Float.valueOf(1.0f));
        builder.a(aE, Float.valueOf(0.0f));
        builder.a(aF, Float.valueOf(0.0f));
        builder.a(aG, -1);
    }

    @Override
    protected void a(NBTTagCompound tag) {
        int _int;
        if (tag.e(e)) {
            Transformation.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)tag.c(e)).result().ifPresent(pair -> this.a((Transformation)pair.getFirst()));
        }
        if (tag.b(c, 99)) {
            _int = tag.h(c);
            this.b(_int);
        }
        if (tag.b(d, 99)) {
            _int = tag.h(d);
            this.c(_int);
        }
        if (tag.b(b, 99)) {
            _int = tag.h(b);
            this.d(MathHelper.a(_int, 0, 59));
        }
        if (tag.b(f, 8)) {
            BillboardConstraints.e.decode((DynamicOps)DynamicOpsNBT.a, (Object)tag.c(f)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(pair -> this.a((BillboardConstraints)pair.getFirst()));
        }
        if (tag.b(h, 99)) {
            this.b(tag.j(h));
        }
        if (tag.b(i, 99)) {
            this.c(tag.j(i));
        }
        if (tag.b(j, 99)) {
            this.x(tag.j(j));
        }
        if (tag.b(k, 99)) {
            this.y(tag.j(k));
        }
        if (tag.b(l, 99)) {
            this.z(tag.j(l));
        }
        if (tag.b(m, 99)) {
            this.l(tag.h(m));
        }
        if (tag.b(g, 10)) {
            Brightness.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)tag.c(g)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(pair -> this.a((Brightness)pair.getFirst()));
        } else {
            this.a((Brightness)null);
        }
    }

    public void a(Transformation transformation) {
        this.al.a(s, transformation.d());
        this.al.a(u, transformation.e());
        this.al.a(t, transformation.f());
        this.al.a(ay, transformation.g());
    }

    @Override
    protected void b(NBTTagCompound tag) {
        Transformation.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)Display.a(this.al)).ifSuccess(tag1 -> tag.a(e, (NBTBase)tag1));
        BillboardConstraints.e.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.v()).ifSuccess(tag1 -> tag.a(f, (NBTBase)tag1));
        tag.a(c, this.s());
        tag.a(b, this.u());
        tag.a(h, this.y());
        tag.a(i, this.z());
        tag.a(j, this.A());
        tag.a(k, this.B());
        tag.a(l, this.D());
        tag.a(m, this.C());
        Brightness brightnessOverride = this.w();
        if (brightnessOverride != null) {
            Brightness.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)brightnessOverride).ifSuccess(tag1 -> tag.a(g, (NBTBase)tag1));
        }
    }

    @Override
    public void f_() {
        this.aT = null;
    }

    @Override
    public void a(double x2, double y2, double z2, float yRot, float xRot, int steps) {
        int posRotInterpolationDuration = this.u();
        this.aT = new j(posRotInterpolationDuration, x2, y2, z2, yRot, xRot);
    }

    @Override
    public double R_() {
        return this.aT != null ? this.aT.b : this.dA();
    }

    @Override
    public double S_() {
        return this.aT != null ? this.aT.c : this.dC();
    }

    @Override
    public double g_() {
        return this.aT != null ? this.aT.d : this.dG();
    }

    @Override
    public float r_() {
        return this.aT != null ? (float)this.aT.f : this.dN();
    }

    @Override
    public float h_() {
        return this.aT != null ? (float)this.aT.e : this.dL();
    }

    public AxisAlignedBB l() {
        return this.aO;
    }

    public boolean m() {
        return !this.aP;
    }

    @Override
    public EnumPistonReaction n_() {
        return EnumPistonReaction.d;
    }

    @Override
    public boolean s_() {
        return true;
    }

    @Nullable
    public k p() {
        return this.aS;
    }

    public void b(int transformationInterpolationDuration) {
        this.al.a(q, transformationInterpolationDuration);
    }

    public int s() {
        return this.al.a(q);
    }

    public void c(int transformationInterpolationDelay) {
        this.al.a(p, transformationInterpolationDelay, true);
    }

    public int t() {
        return this.al.a(p);
    }

    private void d(int posRotInterpolationDuration) {
        this.al.a(r, posRotInterpolationDuration);
    }

    private int u() {
        return this.al.a(r);
    }

    public void a(BillboardConstraints billboardConstraints) {
        this.al.a(az, billboardConstraints.a());
    }

    public BillboardConstraints v() {
        return BillboardConstraints.f.apply(this.al.a(az).byteValue());
    }

    public void a(@Nullable Brightness brightnessOverride) {
        this.al.a(aA, brightnessOverride != null ? brightnessOverride.a() : -1);
    }

    @Nullable
    public Brightness w() {
        int i2 = this.al.a(aA);
        return i2 != -1 ? Brightness.a(i2) : null;
    }

    private int x() {
        return this.al.a(aA);
    }

    public void b(float viewRange) {
        this.al.a(aB, Float.valueOf(viewRange));
    }

    public float y() {
        return this.al.a(aB).floatValue();
    }

    public void c(float shadowRadius) {
        this.al.a(aC, Float.valueOf(shadowRadius));
    }

    public float z() {
        return this.al.a(aC).floatValue();
    }

    public void x(float shadowStrength) {
        this.al.a(aD, Float.valueOf(shadowStrength));
    }

    public float A() {
        return this.al.a(aD).floatValue();
    }

    public void y(float width) {
        this.al.a(aE, Float.valueOf(width));
    }

    public float B() {
        return this.al.a(aE).floatValue();
    }

    public void z(float height) {
        this.al.a(aF, Float.valueOf(height));
    }

    public int C() {
        return this.al.a(aG);
    }

    public void l(int glowColorOverride) {
        this.al.a(aG, glowColorOverride);
    }

    public float a(float partialTick) {
        float f2;
        int i2 = this.aM;
        if (i2 <= 0) {
            return 1.0f;
        }
        float f3 = (long)this.af - this.aL;
        float f1 = f3 + partialTick;
        this.aN = f2 = MathHelper.a(MathHelper.f(f1, 0.0f, i2), 0.0f, 1.0f);
        return f2;
    }

    public float D() {
        return this.al.a(aF).floatValue();
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        super.a_(x2, y2, z2);
        this.E();
    }

    private void E() {
        float width = this.B();
        float height = this.D();
        this.aP = width == 0.0f || height == 0.0f;
        float f2 = width / 2.0f;
        double x2 = this.dA();
        double y2 = this.dC();
        double z2 = this.dG();
        this.aO = new AxisAlignedBB(x2 - (double)f2, y2, z2 - (double)f2, x2 + (double)f2, y2 + (double)height, z2 + (double)f2);
    }

    @Override
    public boolean a(double distance) {
        return distance < MathHelper.k((double)this.y() * 64.0 * Display.cK());
    }

    @Override
    public int k_() {
        int glowColorOverride = this.C();
        return glowColorOverride != -1 ? glowColorOverride : super.k_();
    }

    private k F() {
        return new k(GenericInterpolator.constant(Display.a(this.al)), this.v(), this.x(), FloatInterpolator.constant(this.z()), FloatInterpolator.constant(this.A()), this.C());
    }

    private k a(k renderState, float partialTick) {
        Transformation transformation = renderState.a.get(partialTick);
        float f2 = renderState.d.get(partialTick);
        float f1 = renderState.e.get(partialTick);
        return new k(new m(transformation, Display.a(this.al)), this.v(), this.x(), new h(f2, this.z()), new h(f1, this.A()), this.C());
    }

    public record k(GenericInterpolator<Transformation> a, BillboardConstraints b, int c, FloatInterpolator d, FloatInterpolator e, int f) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{k.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{k.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{k.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this, o2);
        }
    }

    static class j {
        int a;
        final double b;
        final double c;
        final double d;
        final double e;
        final double f;

        j(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
            this.a = steps;
            this.b = targetX;
            this.c = targetY;
            this.d = targetZ;
            this.e = targetYRot;
            this.f = targetXRot;
        }

        void a(Entity entity) {
            entity.a_(this.b, this.c, this.d);
            entity.b((float)this.e, (float)this.f);
        }

        void b(Entity entity) {
            entity.a(this.a, this.b, this.c, this.d, this.e, this.f);
        }
    }

    public static final class BillboardConstraints
    extends Enum<BillboardConstraints>
    implements INamable {
        public static final /* enum */ BillboardConstraints a = new BillboardConstraints(0, "fixed");
        public static final /* enum */ BillboardConstraints b = new BillboardConstraints(1, "vertical");
        public static final /* enum */ BillboardConstraints c = new BillboardConstraints(2, "horizontal");
        public static final /* enum */ BillboardConstraints d = new BillboardConstraints(3, "center");
        public static final Codec<BillboardConstraints> e;
        public static final IntFunction<BillboardConstraints> f;
        private final byte g;
        private final String h;
        private static final /* synthetic */ BillboardConstraints[] i;

        public static BillboardConstraints[] values() {
            return (BillboardConstraints[])i.clone();
        }

        public static BillboardConstraints valueOf(String name) {
            return Enum.valueOf(BillboardConstraints.class, name);
        }

        private BillboardConstraints(byte id, String name) {
            this.h = name;
            this.g = id;
        }

        @Override
        public String c() {
            return this.h;
        }

        byte a() {
            return this.g;
        }

        private static /* synthetic */ BillboardConstraints[] b() {
            return new BillboardConstraints[]{a, b, c, d};
        }

        static {
            i = BillboardConstraints.b();
            e = INamable.a(BillboardConstraints::values);
            f = ByIdMap.a(BillboardConstraints::a, BillboardConstraints.values(), ByIdMap.a.a);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T value) {
            return partialTick -> value;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float value) {
            return partialTick -> value;
        }

        public float get(float var1);
    }

    record m(Transformation a, Transformation b) implements GenericInterpolator<Transformation>
    {
        public Transformation a(float partialTick) {
            return (double)partialTick >= 1.0 ? this.b : this.a.a(this.b, partialTick);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{m.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{m.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{m.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    record h(float a, float b) implements FloatInterpolator
    {
        @Override
        public float get(float partialTick) {
            return MathHelper.h(partialTick, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String o = "text";
        private static final String ay = "line_width";
        private static final String az = "text_opacity";
        private static final String aA = "background";
        private static final String aB = "shadow";
        private static final String aC = "see_through";
        private static final String aD = "default_background";
        private static final String aE = "alignment";
        public static final byte p = 1;
        public static final byte q = 2;
        public static final byte r = 4;
        public static final byte s = 8;
        public static final byte t = 16;
        private static final byte aF = -1;
        public static final int u = 0x40000000;
        private static final DataWatcherObject<IChatBaseComponent> aG = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.f);
        public static final DataWatcherObject<Integer> aH = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        public static final DataWatcherObject<Integer> aI = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        private static final DataWatcherObject<Byte> aJ = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final DataWatcherObject<Byte> aK = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final IntSet aL = IntSet.of((int[])new int[]{aG.a(), aH.a(), aI.a(), aJ.a(), aK.a()});
        @Nullable
        private CachedInfo aM;
        @Nullable
        private e aN;

        public TextDisplay(EntityTypes<?> entityType, World level) {
            super(entityType, level);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(aG, IChatBaseComponent.i());
            builder.a(aH, 200);
            builder.a(aI, 0x40000000);
            builder.a(aJ, (byte)-1);
            builder.a(aK, (byte)0);
        }

        @Override
        public void a(DataWatcherObject<?> key) {
            super.a(key);
            if (aL.contains(key.a())) {
                this.n = true;
            }
        }

        public IChatBaseComponent t() {
            return this.al.a(aG);
        }

        public void a(IChatBaseComponent text) {
            this.al.a(aG, text);
        }

        @Override
        public int u() {
            return this.al.a(aH);
        }

        @Override
        private void b(int lineWidth) {
            this.al.a(aH, lineWidth);
        }

        public byte v() {
            return this.al.a(aJ);
        }

        public void c(byte textOpacity) {
            this.al.a(aJ, textOpacity);
        }

        public int w() {
            return this.al.a(aI);
        }

        @Override
        private void c(int backgroundColor) {
            this.al.a(aI, backgroundColor);
        }

        public byte x() {
            return this.al.a(aK);
        }

        public void d(byte flags) {
            this.al.a(aK, flags);
        }

        private static byte a(byte currentValue, NBTTagCompound tag, String flag, byte mask) {
            return tag.q(flag) ? (byte)(currentValue | mask) : currentValue;
        }

        @Override
        protected void a(NBTTagCompound tag) {
            super.a(tag);
            if (tag.b(ay, 99)) {
                this.b(tag.h(ay));
            }
            if (tag.b(az, 99)) {
                this.c(tag.f(az));
            }
            if (tag.b(aA, 99)) {
                this.c(tag.h(aA));
            }
            byte b2 = TextDisplay.a((byte)0, tag, aB, (byte)1);
            b2 = TextDisplay.a(b2, tag, aC, (byte)2);
            b2 = TextDisplay.a(b2, tag, aD, (byte)4);
            Optional<Align> optional = Align.d.decode((DynamicOps)DynamicOpsNBT.a, (Object)tag.c(aE)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).map(Pair::getFirst);
            if (optional.isPresent()) {
                b2 = switch (optional.get().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> b2;
                    case 1 -> (byte)(b2 | 8);
                    case 2 -> (byte)(b2 | 0x10);
                };
            }
            this.d(b2);
            if (tag.b(o, 8)) {
                String string = tag.l(o);
                try {
                    World world;
                    IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(string, (HolderLookup.a)this.dX());
                    if (component != null && (world = this.dV()) instanceof WorldServer) {
                        WorldServer serverLevel = (WorldServer)world;
                        CommandListenerWrapper commandSourceStack = this.d(serverLevel).a(2);
                        IChatMutableComponent component1 = ChatComponentUtils.a(commandSourceStack, component, (Entity)this, 0);
                        this.a(component1);
                    } else {
                        this.a(IChatBaseComponent.i());
                    }
                }
                catch (Exception var9) {
                    o.warn("Failed to parse display entity text {}", (Object)string, (Object)var9);
                }
            }
        }

        private static void b(byte currentValue, NBTTagCompound tag, String flag, byte mask) {
            tag.a(flag, (currentValue & mask) != 0);
        }

        @Override
        protected void b(NBTTagCompound tag) {
            super.b(tag);
            tag.a(o, IChatBaseComponent.ChatSerializer.a(this.t(), (HolderLookup.a)this.dX()));
            tag.a(ay, this.u());
            tag.a(aA, this.w());
            tag.a(az, this.v());
            byte flags = this.x();
            TextDisplay.b(flags, tag, aB, (byte)1);
            TextDisplay.b(flags, tag, aC, (byte)2);
            TextDisplay.b(flags, tag, aD, (byte)4);
            Align.d.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)TextDisplay.a(flags)).ifSuccess(tag1 -> tag.a(aE, (NBTBase)tag1));
        }

        @Override
        protected void a(boolean interpolate, float partialTick) {
            this.aN = interpolate && this.aN != null ? this.a(this.aN, partialTick) : this.y();
            this.aM = null;
        }

        @Nullable
        public e s() {
            return this.aN;
        }

        private e y() {
            return new e(this.t(), this.u(), IntInterpolator.constant(this.v()), IntInterpolator.constant(this.w()), this.x());
        }

        private e a(e renderState, float partialTick) {
            int i2 = renderState.d.get(partialTick);
            int i1 = renderState.c.get(partialTick);
            return new e(this.t(), this.u(), new i(i1, this.v()), new ColorInterpolator(i2, this.w()), this.x());
        }

        public CachedInfo a(LineSplitter splitter) {
            if (this.aM == null) {
                this.aM = this.aN != null ? splitter.split(this.aN.a(), this.aN.b()) : new CachedInfo(List.of(), 0);
            }
            return this.aM;
        }

        public static Align a(byte flags) {
            if ((flags & 8) != 0) {
                return Align.b;
            }
            return (flags & 0x10) != 0 ? Align.c : Align.a;
        }

        public static final class Align
        extends Enum<Align>
        implements INamable {
            public static final /* enum */ Align a = new Align("center");
            public static final /* enum */ Align b = new Align("left");
            public static final /* enum */ Align c = new Align("right");
            public static final Codec<Align> d;
            private final String e;
            private static final /* synthetic */ Align[] f;

            public static Align[] values() {
                return (Align[])f.clone();
            }

            public static Align valueOf(String name) {
                return Enum.valueOf(Align.class, name);
            }

            private Align(String name) {
                this.e = name;
            }

            @Override
            public String c() {
                return this.e;
            }

            private static /* synthetic */ Align[] a() {
                return new Align[]{a, b, c};
            }

            static {
                f = Align.a();
                d = INamable.a(Align::values);
            }
        }

        public record e(IChatBaseComponent a, int b, IntInterpolator c, IntInterpolator d, byte e) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this, o2);
            }
        }

        public record CachedInfo(List<CachedLine> a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this, o2);
            }
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(IChatBaseComponent var1, int var2);
        }

        public record CachedLine(FormattedString a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this, o2);
            }
        }
    }

    record i(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float partialTick) {
            return MathHelper.a(partialTick, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String o = "item";
        private static final String p = "item_display";
        private static final DataWatcherObject<ItemStack> q = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.h);
        private static final DataWatcherObject<Byte> r = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.a);
        private final SlotAccess s = SlotAccess.a(this::t, this::a);
        @Nullable
        private a t;

        public ItemDisplay(EntityTypes<?> entityType, World level) {
            super(entityType, level);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(q, ItemStack.j);
            builder.a(r, ItemDisplayContext.a.a());
        }

        @Override
        public void a(DataWatcherObject<?> key) {
            super.a(key);
            if (q.equals(key) || r.equals(key)) {
                this.n = true;
            }
        }

        public ItemStack t() {
            return this.al.a(q);
        }

        public void a(ItemStack itemStack) {
            this.al.a(q, itemStack);
        }

        public void a(ItemDisplayContext itemTransform) {
            this.al.a(r, itemTransform.a());
        }

        public ItemDisplayContext u() {
            return ItemDisplayContext.k.apply(this.al.a(r).byteValue());
        }

        @Override
        protected void a(NBTTagCompound tag) {
            super.a(tag);
            if (tag.e(o)) {
                this.a(ItemStack.a((HolderLookup.a)this.dX(), (NBTBase)tag.p(o)).orElse(ItemStack.j));
            } else {
                this.a(ItemStack.j);
            }
            if (tag.b(p, 8)) {
                ItemDisplayContext.j.decode((DynamicOps)DynamicOpsNBT.a, (Object)tag.c(p)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(pair -> this.a((ItemDisplayContext)pair.getFirst()));
            }
        }

        @Override
        protected void b(NBTTagCompound tag) {
            super.b(tag);
            if (!this.t().f()) {
                tag.a(o, this.t().a(this.dX()));
            }
            ItemDisplayContext.j.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.u()).ifSuccess(tag1 -> tag.a(p, (NBTBase)tag1));
        }

        @Override
        public SlotAccess a_(int slot) {
            return slot == 0 ? this.s : SlotAccess.a;
        }

        @Nullable
        public a s() {
            return this.t;
        }

        @Override
        protected void a(boolean interpolate, float partialTick) {
            ItemStack itemStack = this.t();
            itemStack.a(this);
            this.t = new a(itemStack, this.u());
        }

        public record a(ItemStack a, ItemDisplayContext b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this, o2);
            }
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int value) {
            return partialTick -> value;
        }

        public int get(float var1);
    }

    record ColorInterpolator(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float partialTick) {
            return ARGB.a(partialTick, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String o = "block_state";
        private static final DataWatcherObject<IBlockData> p = DataWatcher.a(BlockDisplay.class, DataWatcherRegistry.i);
        @Nullable
        private a q;

        public BlockDisplay(EntityTypes<?> entityType, World level) {
            super(entityType, level);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(p, Blocks.a.m());
        }

        @Override
        public void a(DataWatcherObject<?> key) {
            super.a(key);
            if (key.equals(p)) {
                this.n = true;
            }
        }

        public IBlockData t() {
            return this.al.a(p);
        }

        public void c(IBlockData blockState) {
            this.al.a(p, blockState);
        }

        @Override
        protected void a(NBTTagCompound tag) {
            super.a(tag);
            this.c(GameProfileSerializer.a(this.dV().a(Registries.f), tag.p(o)));
        }

        @Override
        protected void b(NBTTagCompound tag) {
            super.b(tag);
            tag.a(o, GameProfileSerializer.a(this.t()));
        }

        @Nullable
        public a s() {
            return this.q;
        }

        @Override
        protected void a(boolean interpolate, float partialTick) {
            this.q = new a(this.t());
        }

        public record a(IBlockData a) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockState", "a"}, this, o2);
            }
        }
    }
}

