/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.mojang.serialization.Codec;
import io.papermc.paper.event.entity.EntityEffectTickEvent;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.craftbukkit.v1_21_R3.potion.CraftPotionEffectType;
import org.bukkit.entity.LivingEntity;

public class MobEffectList
implements FeatureElement {
    public static final Codec<Holder<MobEffectList>> a = BuiltInRegistries.d.r();
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<MobEffectList>> b = ByteBufCodecs.b(Registries.W);
    private static final int c = MathHelper.d(38.25f);
    public final Map<Holder<AttributeBase>, a> d = new Object2ObjectOpenHashMap();
    private final MobEffectInfo e;
    private final int f;
    private final Function<MobEffect, ParticleParam> g;
    @Nullable
    private String h;
    private int i;
    private Optional<SoundEffect> j = Optional.empty();
    private FeatureFlagSet k = FeatureFlags.g;

    protected MobEffectList(MobEffectInfo category, int color) {
        this.e = category;
        this.f = color;
        this.g = effect -> {
            int i2 = effect.f() ? c : 255;
            return ColorParticleOption.a(Particles.u, ARGB.c(i2, color));
        };
    }

    protected MobEffectList(MobEffectInfo category, int color, ParticleParam particle) {
        this.e = category;
        this.f = color;
        this.g = effect -> particle;
    }

    public int b() {
        return this.i;
    }

    public boolean a(WorldServer level, EntityLiving entity, int amplifier) {
        return true;
    }

    public void a(WorldServer level, @Nullable Entity source, @Nullable Entity indirectSource, EntityLiving entity, int amplifier, double health) {
        if (!new EntityEffectTickEvent((LivingEntity)entity.getBukkitLivingEntity(), CraftPotionEffectType.minecraftToBukkit(this), amplifier).callEvent()) {
            return;
        }
        this.a(level, entity, amplifier);
    }

    public boolean a(int duration, int amplifier) {
        return false;
    }

    public void a(EntityLiving entity, int amplifier) {
    }

    public void b(EntityLiving entity, int amplifier) {
        this.j.ifPresent(sound -> entity.dV().a(null, entity.dA(), entity.dC(), entity.dG(), (SoundEffect)sound, entity.dm(), 1.0f, 1.0f));
    }

    public void a(WorldServer level, EntityLiving entity, int amplifier, Entity.RemovalReason reason) {
    }

    public void a(WorldServer level, EntityLiving entity, int amplifier, DamageSource damageSource, float amount) {
    }

    public boolean a() {
        return false;
    }

    protected String c() {
        if (this.h == null) {
            this.h = SystemUtils.a("effect", BuiltInRegistries.d.b(this));
        }
        return this.h;
    }

    public String d() {
        return this.c();
    }

    public IChatBaseComponent e() {
        return IChatBaseComponent.c(this.d());
    }

    public MobEffectInfo f() {
        return this.e;
    }

    public int g() {
        return this.f;
    }

    public MobEffectList a(Holder<AttributeBase> attribute, MinecraftKey id, double amount, AttributeModifier.Operation operation) {
        this.d.put(attribute, new a(id, amount, operation));
        return this;
    }

    public MobEffectList a(int blendDuration) {
        this.i = blendDuration;
        return this;
    }

    public void a(int amplifier, BiConsumer<Holder<AttributeBase>, AttributeModifier> output) {
        this.d.forEach((holder, attributeTemplate) -> output.accept((Holder<AttributeBase>)holder, attributeTemplate.a(amplifier)));
    }

    public void a(AttributeMapBase attributeMap) {
        for (Map.Entry<Holder<AttributeBase>, a> entry : this.d.entrySet()) {
            AttributeModifiable instance = attributeMap.a(entry.getKey());
            if (instance == null) continue;
            instance.c(entry.getValue().a());
        }
    }

    public void a(AttributeMapBase attributeMap, int amplifier) {
        for (Map.Entry<Holder<AttributeBase>, a> entry : this.d.entrySet()) {
            AttributeModifiable instance = attributeMap.a(entry.getKey());
            if (instance == null) continue;
            instance.c(entry.getValue().a());
            instance.d(entry.getValue().a(amplifier));
        }
    }

    public boolean h() {
        return this.e == MobEffectInfo.a;
    }

    public ParticleParam a(MobEffect effect) {
        return this.g.apply(effect);
    }

    public MobEffectList a(SoundEffect sound) {
        this.j = Optional.of(sound);
        return this;
    }

    public MobEffectList a(FeatureFlag ... requiredFeatures) {
        this.k = FeatureFlags.e.a(requiredFeatures);
        return this;
    }

    @Override
    public FeatureFlagSet i() {
        return this.k;
    }

    public record a(MinecraftKey a, double b, AttributeModifier.Operation c) {
        public AttributeModifier a(int level) {
            return new AttributeModifier(this.a, this.b * (double)(level + 1), this.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;amount;operation", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;amount;operation", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;amount;operation", "a", "b", "c"}, this, o2);
        }
    }
}

