/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class RandomSequences
extends PersistentBase {
    private static final Logger a = LogUtils.getLogger();
    private final long b;
    private int c;
    private boolean d = true;
    private boolean e = true;
    private final Map<MinecraftKey, RandomSequence> f = new Object2ObjectOpenHashMap();

    public static PersistentBase.a<RandomSequences> a(long seed) {
        return new PersistentBase.a<RandomSequences>(() -> new RandomSequences(seed), (compoundTag, provider) -> RandomSequences.a(seed, compoundTag), DataFixTypes.m);
    }

    public RandomSequences(long seed) {
        this.b = seed;
    }

    public RandomSource a(MinecraftKey location) {
        RandomSource randomSource = this.f.computeIfAbsent(location, this::c).a();
        return new a(randomSource);
    }

    private RandomSequence c(MinecraftKey location) {
        return this.b(location, this.c, this.d, this.e);
    }

    private RandomSequence b(MinecraftKey location, int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        long l2 = (includeWorldSeed ? this.b : 0L) ^ (long)salt;
        return new RandomSequence(l2, includeSequenceId ? Optional.of(location) : Optional.empty());
    }

    public void a(BiConsumer<MinecraftKey, RandomSequence> action) {
        this.f.forEach(action);
    }

    public void a(int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        this.c = salt;
        this.d = includeWorldSeed;
        this.e = includeSequenceId;
    }

    @Override
    public NBTTagCompound a(NBTTagCompound tag, HolderLookup.a registries) {
        tag.a("salt", this.c);
        tag.a("include_world_seed", this.d);
        tag.a("include_sequence_id", this.e);
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.f.forEach((resourceLocation, randomSequence) -> compoundTag.a(resourceLocation.toString(), (NBTBase)RandomSequence.a.encodeStart((DynamicOps)DynamicOpsNBT.a, randomSequence).result().orElseThrow()));
        tag.a("sequences", compoundTag);
        return tag;
    }

    private static boolean a(NBTTagCompound tag, String key, boolean defaultValue) {
        return tag.b(key, 1) ? tag.q(key) : defaultValue;
    }

    public static RandomSequences a(long seed, NBTTagCompound tag) {
        RandomSequences randomSequences = new RandomSequences(seed);
        randomSequences.a(tag.h("salt"), RandomSequences.a(tag, "include_world_seed", true), RandomSequences.a(tag, "include_sequence_id", true));
        NBTTagCompound compound = tag.p("sequences");
        for (String string : compound.e()) {
            try {
                RandomSequence randomSequence = (RandomSequence)((Pair)RandomSequence.a.decode((DynamicOps)DynamicOpsNBT.a, (Object)compound.c(string)).result().get()).getFirst();
                randomSequences.f.put(MinecraftKey.a(string), randomSequence);
            }
            catch (Exception var9) {
                a.error("Failed to load random sequence {}", (Object)string, (Object)var9);
            }
        }
        return randomSequences;
    }

    public int a() {
        int size = this.f.size();
        this.f.clear();
        return size;
    }

    public void b(MinecraftKey sequence) {
        this.f.put(sequence, this.c(sequence));
    }

    public void a(MinecraftKey sequence, int seed, boolean includeWorldSeed, boolean includeSequenceId) {
        this.f.put(sequence, this.b(sequence, seed, includeWorldSeed, includeSequenceId));
    }

    class a
    implements RandomSource {
        private final RandomSource c;

        a(RandomSource random) {
            this.c = random;
        }

        @Override
        public RandomSource d() {
            RandomSequences.this.c();
            return this.c.d();
        }

        @Override
        public PositionalRandomFactory e() {
            RandomSequences.this.c();
            return this.c.e();
        }

        @Override
        public void b(long seed) {
            RandomSequences.this.c();
            this.c.b(seed);
        }

        @Override
        public int f() {
            RandomSequences.this.c();
            return this.c.f();
        }

        @Override
        public int a(int bound) {
            RandomSequences.this.c();
            return this.c.a(bound);
        }

        @Override
        public long g() {
            RandomSequences.this.c();
            return this.c.g();
        }

        @Override
        public boolean h() {
            RandomSequences.this.c();
            return this.c.h();
        }

        @Override
        public float i() {
            RandomSequences.this.c();
            return this.c.i();
        }

        @Override
        public double j() {
            RandomSequences.this.c();
            return this.c.j();
        }

        @Override
        public double k() {
            RandomSequences.this.c();
            return this.c.k();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof a)) return false;
            a dirtyMarkingRandomSource = (a)other;
            if (!this.c.equals(dirtyMarkingRandomSource.c)) return false;
            return true;
        }
    }
}

