/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class ClampedNormalInt
extends IntProvider {
    public static final MapCodec<ClampedNormalInt> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("mean").forGetter(clampedNormalInt -> Float.valueOf(clampedNormalInt.b)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(clampedNormalInt -> Float.valueOf(clampedNormalInt.f)), (App)Codec.INT.fieldOf("min_inclusive").forGetter(clampedNormalInt -> clampedNormalInt.g), (App)Codec.INT.fieldOf("max_inclusive").forGetter(clampedNormalInt -> clampedNormalInt.h)).apply((Applicative)instance, ClampedNormalInt::new)).validate(clampedNormalInt -> clampedNormalInt.h < clampedNormalInt.g ? DataResult.error(() -> "Max must be larger than min: [" + clampedNormalInt.g + ", " + clampedNormalInt.h + "]") : DataResult.success((Object)clampedNormalInt));
    private final float b;
    private final float f;
    private final int g;
    private final int h;

    public static ClampedNormalInt a(float mean, float deviation, int minInclusive, int maxInclusive) {
        return new ClampedNormalInt(mean, deviation, minInclusive, maxInclusive);
    }

    private ClampedNormalInt(float mean, float deviation, int minInclusive, int maxInclusive) {
        this.b = mean;
        this.f = deviation;
        this.g = minInclusive;
        this.h = maxInclusive;
    }

    @Override
    public int a(RandomSource random) {
        return ClampedNormalInt.a(random, this.b, this.f, this.g, this.h);
    }

    public static int a(RandomSource random, float mean, float deviation, float minInclusive, float maxInclusive) {
        return (int)MathHelper.a(MathHelper.c(random, mean, deviation), minInclusive, maxInclusive);
    }

    @Override
    public int a() {
        return this.g;
    }

    @Override
    public int b() {
        return this.h;
    }

    @Override
    public IntProviderType<?> c() {
        return IntProviderType.f;
    }

    public String toString() {
        return "normal(" + this.b + ", " + this.f + ") in [" + this.g + "-" + this.h + "]";
    }
}

