/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.TaskScheduler;
import org.slf4j.Logger;

public abstract class IAsyncTaskHandler<R extends Runnable>
implements ProfilerMeasured,
TaskScheduler<R>,
Executor {
    public static final long k = 100000L;
    private final String b;
    private static final Logger c = LogUtils.getLogger();
    private final Queue<R> d = Queues.newConcurrentLinkedQueue();
    private int e;

    protected IAsyncTaskHandler(String name) {
        this.b = name;
        MetricsRegistry.a.a(this);
    }

    protected abstract boolean e(R var1);

    public boolean bx() {
        return Thread.currentThread() == this.ay();
    }

    protected abstract Thread ay();

    protected boolean ax() {
        return !this.bx();
    }

    public int by() {
        return this.d.size();
    }

    @Override
    public String A_() {
        return this.b;
    }

    public <V> CompletableFuture<V> a(Supplier<V> supplier) {
        return this.ax() ? CompletableFuture.supplyAsync(supplier, this) : CompletableFuture.completedFuture(supplier.get());
    }

    private CompletableFuture<Void> b(Runnable task) {
        return CompletableFuture.supplyAsync(() -> {
            task.run();
            return null;
        }, this);
    }

    @CheckReturnValue
    public CompletableFuture<Void> g(Runnable task) {
        if (this.ax()) {
            return this.b(task);
        }
        task.run();
        return CompletableFuture.completedFuture(null);
    }

    public void h(Runnable task) {
        if (!this.bx()) {
            this.b(task).join();
        } else {
            task.run();
        }
    }

    public void scheduleOnMain(Runnable runnable) {
        this.a_(this.f(runnable));
    }

    @Override
    public void a_(R task) {
        this.d.add(task);
        LockSupport.unpark(this.ay());
    }

    @Override
    public void execute(Runnable task) {
        if (this.ax()) {
            this.a_(this.f(task));
        } else {
            task.run();
        }
    }

    public void c(Runnable task) {
        this.execute(task);
    }

    protected void bz() {
        this.d.clear();
    }

    protected void bA() {
        while (this.B()) {
        }
    }

    public boolean B() {
        Runnable runnable = (Runnable)this.d.peek();
        if (runnable == null) {
            return false;
        }
        if (this.e == 0 && !this.e(runnable)) {
            return false;
        }
        this.d((Runnable)this.d.remove());
        return true;
    }

    public void b(BooleanSupplier isDone) {
        ++this.e;
        try {
            while (!isDone.getAsBoolean()) {
                if (this.B()) continue;
                this.A();
            }
        }
        finally {
            --this.e;
        }
    }

    protected void A() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void d(R task) {
        block8: {
            try (Zone zone = TracyClient.beginZone((String)"Task", (boolean)SharedConstants.aU);){
                task.run();
            }
            catch (Exception var7) {
                c.error(LogUtils.FATAL_MARKER, "Error executing task on {}", (Object)this.A_(), (Object)var7);
                if (!IAsyncTaskHandler.a(var7)) break block8;
                throw var7;
            }
        }
    }

    @Override
    public List<MetricSampler> bw() {
        return ImmutableList.of((Object)MetricSampler.a(this.b + "-pending-tasks", MetricCategory.b, this::by));
    }

    public static boolean a(Throwable error) {
        boolean bl;
        if (error instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)error;
            bl = IAsyncTaskHandler.a(reportedException.getCause());
        } else {
            bl = error instanceof OutOfMemoryError || error instanceof StackOverflowError;
        }
        return bl;
    }
}

