/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;

public class WeightedRandom2 {
    private WeightedRandom2() {
    }

    public static int a(List<? extends WeightedEntry> entries) {
        long l2 = 0L;
        for (WeightedEntry weightedEntry : entries) {
            l2 += (long)weightedEntry.a().a();
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l2;
    }

    public static <T extends WeightedEntry> Optional<T> a(RandomSource random, List<T> entries, int totalWeight) {
        if (totalWeight < 0) {
            throw SystemUtils.b(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (totalWeight == 0) {
            return Optional.empty();
        }
        int randomInt = random.a(totalWeight);
        return WeightedRandom2.a(entries, randomInt);
    }

    public static <T extends WeightedEntry> Optional<T> a(List<T> entries, int weightedIndex) {
        for (WeightedEntry weightedEntry : entries) {
            if ((weightedIndex -= weightedEntry.a().a()) >= 0) continue;
            return Optional.of(weightedEntry);
        }
        return Optional.empty();
    }

    public static <T extends WeightedEntry> Optional<T> a(RandomSource random, List<T> entries) {
        return WeightedRandom2.a(random, entries, WeightedRandom2.a(entries));
    }
}

