/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.parse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.ChunkIdentification;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.IoSummary;
import net.minecraft.util.profiling.jfr.stats.PacketIdentification;
import net.minecraft.util.profiling.jfr.stats.StructureGenStat;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;

public class JfrStatsParser {
    private Instant a = Instant.EPOCH;
    private Instant b = Instant.EPOCH;
    private final List<ChunkGenStat> c = Lists.newArrayList();
    private final List<StructureGenStat> d = Lists.newArrayList();
    private final List<CpuLoadStat> e = Lists.newArrayList();
    private final Map<PacketIdentification, a> f = Maps.newHashMap();
    private final Map<PacketIdentification, a> g = Maps.newHashMap();
    private final Map<ChunkIdentification, a> h = Maps.newHashMap();
    private final Map<ChunkIdentification, a> i = Maps.newHashMap();
    private final List<FileIOStat> j = Lists.newArrayList();
    private final List<FileIOStat> k = Lists.newArrayList();
    private int l;
    private Duration m = Duration.ZERO;
    private final List<GcHeapStat> n = Lists.newArrayList();
    private final List<ThreadAllocationStat> o = Lists.newArrayList();
    private final List<TickTimeStat> p = Lists.newArrayList();
    @Nullable
    private Duration q = null;

    private JfrStatsParser(Stream<RecordedEvent> events) {
        this.a(events);
    }

    public static JfrStatsResult a(Path file) {
        try {
            JfrStatsResult var4;
            try (final RecordingFile recordingFile = new RecordingFile(file);){
                Iterator<RecordedEvent> iterator = new Iterator<RecordedEvent>(){

                    @Override
                    public boolean hasNext() {
                        return recordingFile.hasMoreEvents();
                    }

                    public RecordedEvent a() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        try {
                            return recordingFile.readEvent();
                        }
                        catch (IOException var2) {
                            throw new UncheckedIOException(var2);
                        }
                    }
                };
                Stream<RecordedEvent> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1297), false);
                var4 = new JfrStatsParser(stream).a();
            }
            return var4;
        }
        catch (IOException var7) {
            throw new UncheckedIOException(var7);
        }
    }

    private JfrStatsResult a() {
        Duration duration = Duration.between(this.a, this.b);
        return new JfrStatsResult(this.a, this.b, duration, this.q, this.p, this.e, GcHeapStat.a(duration, this.n, this.m, this.l), ThreadAllocationStat.a(this.o), JfrStatsParser.a(duration, this.f), JfrStatsParser.a(duration, this.g), JfrStatsParser.a(duration, this.i), JfrStatsParser.a(duration, this.h), FileIOStat.a(duration, this.j), FileIOStat.a(duration, this.k), this.c, this.d);
    }

    private void a(Stream<RecordedEvent> events) {
        events.forEach(recordedEvent -> {
            String var2;
            if (recordedEvent.getEndTime().isAfter(this.b) || this.b.equals(Instant.EPOCH)) {
                this.b = recordedEvent.getEndTime();
            }
            if (recordedEvent.getStartTime().isBefore(this.a) || this.a.equals(Instant.EPOCH)) {
                this.a = recordedEvent.getStartTime();
            }
            switch (var2 = recordedEvent.getEventType().getName()) {
                case "minecraft.ChunkGeneration": {
                    this.c.add(ChunkGenStat.a(recordedEvent));
                    break;
                }
                case "minecraft.StructureGeneration": {
                    this.d.add(StructureGenStat.a(recordedEvent));
                    break;
                }
                case "minecraft.LoadWorld": {
                    this.q = recordedEvent.getDuration();
                    break;
                }
                case "minecraft.ServerTickTime": {
                    this.p.add(TickTimeStat.a(recordedEvent));
                    break;
                }
                case "minecraft.PacketReceived": {
                    this.a((RecordedEvent)recordedEvent, recordedEvent.getInt("bytes"), this.f);
                    break;
                }
                case "minecraft.PacketSent": {
                    this.a((RecordedEvent)recordedEvent, recordedEvent.getInt("bytes"), this.g);
                    break;
                }
                case "minecraft.ChunkRegionRead": {
                    this.b((RecordedEvent)recordedEvent, recordedEvent.getInt("bytes"), this.h);
                    break;
                }
                case "minecraft.ChunkRegionWrite": {
                    this.b((RecordedEvent)recordedEvent, recordedEvent.getInt("bytes"), this.i);
                    break;
                }
                case "jdk.ThreadAllocationStatistics": {
                    this.o.add(ThreadAllocationStat.a(recordedEvent));
                    break;
                }
                case "jdk.GCHeapSummary": {
                    this.n.add(GcHeapStat.a(recordedEvent));
                    break;
                }
                case "jdk.CPULoad": {
                    this.e.add(CpuLoadStat.a(recordedEvent));
                    break;
                }
                case "jdk.FileWrite": {
                    this.a((RecordedEvent)recordedEvent, this.j, "bytesWritten");
                    break;
                }
                case "jdk.FileRead": {
                    this.a((RecordedEvent)recordedEvent, this.k, "bytesRead");
                    break;
                }
                case "jdk.GarbageCollection": {
                    ++this.l;
                    this.m = this.m.plus(recordedEvent.getDuration());
                }
            }
        });
    }

    private void a(RecordedEvent event, int increment, Map<PacketIdentification, a> packets) {
        packets.computeIfAbsent(PacketIdentification.a(event), packetIdentification -> new a()).a(increment);
    }

    private void b(RecordedEvent event, int increment, Map<ChunkIdentification, a> chunks) {
        chunks.computeIfAbsent(ChunkIdentification.a(event), chunkIdentification -> new a()).a(increment);
    }

    private void a(RecordedEvent event, List<FileIOStat> stats, String id) {
        stats.add(new FileIOStat(event.getDuration(), event.getString("path"), event.getLong(id)));
    }

    private static <T> IoSummary<T> a(Duration recordingDuration, Map<T, a> entries) {
        List list = entries.entrySet().stream().map(entry -> Pair.of(entry.getKey(), (Object)((a)entry.getValue()).a())).toList();
        return new IoSummary(recordingDuration, list);
    }

    public static final class a {
        private long a;
        private long b;

        public void a(int increment) {
            this.b += (long)increment;
            ++this.a;
        }

        public IoSummary.a a() {
            return new IoSummary.a(this.a, this.b);
        }
    }
}

