/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.eventlog;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nullable;

public interface JsonEventLogReader<T>
extends Closeable {
    public static <T> JsonEventLogReader<T> a(final Codec<T> codec, Reader reader) {
        final JsonReader jsonReader = new JsonReader(reader);
        jsonReader.setLenient(true);
        return new JsonEventLogReader<T>(){

            @Override
            @Nullable
            public T a() throws IOException {
                try {
                    if (!jsonReader.hasNext()) {
                        return null;
                    }
                    JsonElement jsonElement = JsonParser.parseReader((JsonReader)jsonReader);
                    return codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(IOException::new);
                }
                catch (JsonParseException var2) {
                    throw new IOException(var2);
                }
                catch (EOFException var3) {
                    return null;
                }
            }

            @Override
            public void close() throws IOException {
                jsonReader.close();
            }
        };
    }

    @Nullable
    public T a() throws IOException;
}

