/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.schemas;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.Hook;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV99;

public class DataConverterSchemaV704
extends Schema {
    protected static final Map<String, String> a = (Map)DataFixUtils.make(() -> {
        HashMap map = Maps.newHashMap();
        map.put("minecraft:furnace", "minecraft:furnace");
        map.put("minecraft:lit_furnace", "minecraft:furnace");
        map.put("minecraft:chest", "minecraft:chest");
        map.put("minecraft:trapped_chest", "minecraft:chest");
        map.put("minecraft:ender_chest", "minecraft:ender_chest");
        map.put("minecraft:jukebox", "minecraft:jukebox");
        map.put("minecraft:dispenser", "minecraft:dispenser");
        map.put("minecraft:dropper", "minecraft:dropper");
        map.put("minecraft:sign", "minecraft:sign");
        map.put("minecraft:mob_spawner", "minecraft:mob_spawner");
        map.put("minecraft:spawner", "minecraft:mob_spawner");
        map.put("minecraft:noteblock", "minecraft:noteblock");
        map.put("minecraft:brewing_stand", "minecraft:brewing_stand");
        map.put("minecraft:enhanting_table", "minecraft:enchanting_table");
        map.put("minecraft:command_block", "minecraft:command_block");
        map.put("minecraft:beacon", "minecraft:beacon");
        map.put("minecraft:skull", "minecraft:skull");
        map.put("minecraft:daylight_detector", "minecraft:daylight_detector");
        map.put("minecraft:hopper", "minecraft:hopper");
        map.put("minecraft:banner", "minecraft:banner");
        map.put("minecraft:flower_pot", "minecraft:flower_pot");
        map.put("minecraft:repeating_command_block", "minecraft:command_block");
        map.put("minecraft:chain_command_block", "minecraft:command_block");
        map.put("minecraft:shulker_box", "minecraft:shulker_box");
        map.put("minecraft:white_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:orange_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:magenta_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:light_blue_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:yellow_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:lime_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:pink_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:gray_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:silver_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:cyan_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:purple_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:blue_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:brown_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:green_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:red_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:black_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:bed", "minecraft:bed");
        map.put("minecraft:light_gray_shulker_box", "minecraft:shulker_box");
        map.put("minecraft:banner", "minecraft:banner");
        map.put("minecraft:white_banner", "minecraft:banner");
        map.put("minecraft:orange_banner", "minecraft:banner");
        map.put("minecraft:magenta_banner", "minecraft:banner");
        map.put("minecraft:light_blue_banner", "minecraft:banner");
        map.put("minecraft:yellow_banner", "minecraft:banner");
        map.put("minecraft:lime_banner", "minecraft:banner");
        map.put("minecraft:pink_banner", "minecraft:banner");
        map.put("minecraft:gray_banner", "minecraft:banner");
        map.put("minecraft:silver_banner", "minecraft:banner");
        map.put("minecraft:light_gray_banner", "minecraft:banner");
        map.put("minecraft:cyan_banner", "minecraft:banner");
        map.put("minecraft:purple_banner", "minecraft:banner");
        map.put("minecraft:blue_banner", "minecraft:banner");
        map.put("minecraft:brown_banner", "minecraft:banner");
        map.put("minecraft:green_banner", "minecraft:banner");
        map.put("minecraft:red_banner", "minecraft:banner");
        map.put("minecraft:black_banner", "minecraft:banner");
        map.put("minecraft:standing_sign", "minecraft:sign");
        map.put("minecraft:wall_sign", "minecraft:sign");
        map.put("minecraft:piston_head", "minecraft:piston");
        map.put("minecraft:daylight_detector_inverted", "minecraft:daylight_detector");
        map.put("minecraft:unpowered_comparator", "minecraft:comparator");
        map.put("minecraft:powered_comparator", "minecraft:comparator");
        map.put("minecraft:wall_banner", "minecraft:banner");
        map.put("minecraft:standing_banner", "minecraft:banner");
        map.put("minecraft:structure_block", "minecraft:structure_block");
        map.put("minecraft:end_portal", "minecraft:end_portal");
        map.put("minecraft:end_gateway", "minecraft:end_gateway");
        map.put("minecraft:sign", "minecraft:sign");
        map.put("minecraft:shield", "minecraft:banner");
        map.put("minecraft:white_bed", "minecraft:bed");
        map.put("minecraft:orange_bed", "minecraft:bed");
        map.put("minecraft:magenta_bed", "minecraft:bed");
        map.put("minecraft:light_blue_bed", "minecraft:bed");
        map.put("minecraft:yellow_bed", "minecraft:bed");
        map.put("minecraft:lime_bed", "minecraft:bed");
        map.put("minecraft:pink_bed", "minecraft:bed");
        map.put("minecraft:gray_bed", "minecraft:bed");
        map.put("minecraft:silver_bed", "minecraft:bed");
        map.put("minecraft:light_gray_bed", "minecraft:bed");
        map.put("minecraft:cyan_bed", "minecraft:bed");
        map.put("minecraft:purple_bed", "minecraft:bed");
        map.put("minecraft:blue_bed", "minecraft:bed");
        map.put("minecraft:brown_bed", "minecraft:bed");
        map.put("minecraft:green_bed", "minecraft:bed");
        map.put("minecraft:red_bed", "minecraft:bed");
        map.put("minecraft:black_bed", "minecraft:bed");
        map.put("minecraft:oak_sign", "minecraft:sign");
        map.put("minecraft:spruce_sign", "minecraft:sign");
        map.put("minecraft:birch_sign", "minecraft:sign");
        map.put("minecraft:jungle_sign", "minecraft:sign");
        map.put("minecraft:acacia_sign", "minecraft:sign");
        map.put("minecraft:dark_oak_sign", "minecraft:sign");
        map.put("minecraft:crimson_sign", "minecraft:sign");
        map.put("minecraft:warped_sign", "minecraft:sign");
        map.put("minecraft:skeleton_skull", "minecraft:skull");
        map.put("minecraft:wither_skeleton_skull", "minecraft:skull");
        map.put("minecraft:zombie_head", "minecraft:skull");
        map.put("minecraft:player_head", "minecraft:skull");
        map.put("minecraft:creeper_head", "minecraft:skull");
        map.put("minecraft:dragon_head", "minecraft:skull");
        map.put("minecraft:barrel", "minecraft:barrel");
        map.put("minecraft:conduit", "minecraft:conduit");
        map.put("minecraft:smoker", "minecraft:smoker");
        map.put("minecraft:blast_furnace", "minecraft:blast_furnace");
        map.put("minecraft:lectern", "minecraft:lectern");
        map.put("minecraft:bell", "minecraft:bell");
        map.put("minecraft:jigsaw", "minecraft:jigsaw");
        map.put("minecraft:campfire", "minecraft:campfire");
        map.put("minecraft:bee_nest", "minecraft:beehive");
        map.put("minecraft:beehive", "minecraft:beehive");
        map.put("minecraft:sculk_sensor", "minecraft:sculk_sensor");
        map.put("minecraft:decorated_pot", "minecraft:decorated_pot");
        map.put("minecraft:crafter", "minecraft:crafter");
        return ImmutableMap.copyOf((Map)map);
    });
    protected static final Hook.HookFunction b = new Hook.HookFunction(){

        public <T> T apply(DynamicOps<T> ops, T value) {
            return DataConverterSchemaV99.a(new Dynamic<T>(ops, value), a, DataConverterSchemaV99.a);
        }
    };

    public DataConverterSchemaV704(int versionKey, Schema parent) {
        super(versionKey, parent);
    }

    protected static void a(Schema schema, Map<String, Supplier<TypeTemplate>> map, String name) {
        schema.register(map, name, () -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema))));
    }

    public Type<?> getChoiceType(DSL.TypeReference type, String choiceName) {
        return Objects.equals(type.typeName(), DataConverterTypes.s.typeName()) ? super.getChoiceType(type, DataConverterSchemaNamed.a(choiceName)) : super.getChoiceType(type, choiceName);
    }

    public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema schema) {
        HashMap map = Maps.newHashMap();
        DataConverterSchemaV704.a(schema, map, "minecraft:furnace");
        DataConverterSchemaV704.a(schema, map, "minecraft:chest");
        schema.registerSimple((Map)map, "minecraft:ender_chest");
        schema.register((Map)map, "minecraft:jukebox", string -> DSL.optionalFields((String)"RecordItem", (TypeTemplate)DataConverterTypes.t.in(schema)));
        DataConverterSchemaV704.a(schema, map, "minecraft:dispenser");
        DataConverterSchemaV704.a(schema, map, "minecraft:dropper");
        schema.registerSimple((Map)map, "minecraft:sign");
        schema.register((Map)map, "minecraft:mob_spawner", string -> DataConverterTypes.F.in(schema));
        schema.registerSimple((Map)map, "minecraft:noteblock");
        schema.registerSimple((Map)map, "minecraft:piston");
        DataConverterSchemaV704.a(schema, map, "minecraft:brewing_stand");
        schema.registerSimple((Map)map, "minecraft:enchanting_table");
        schema.registerSimple((Map)map, "minecraft:end_portal");
        schema.registerSimple((Map)map, "minecraft:beacon");
        schema.registerSimple((Map)map, "minecraft:skull");
        schema.registerSimple((Map)map, "minecraft:daylight_detector");
        DataConverterSchemaV704.a(schema, map, "minecraft:hopper");
        schema.registerSimple((Map)map, "minecraft:comparator");
        schema.register((Map)map, "minecraft:flower_pot", string -> DSL.optionalFields((String)"Item", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DataConverterTypes.D.in(schema))));
        schema.registerSimple((Map)map, "minecraft:banner");
        schema.registerSimple((Map)map, "minecraft:structure_block");
        schema.registerSimple((Map)map, "minecraft:end_gateway");
        schema.registerSimple((Map)map, "minecraft:command_block");
        return map;
    }

    public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
        super.registerTypes(schema, entityTypes, blockEntityTypes);
        schema.registerType(true, DataConverterTypes.s, () -> DSL.optionalFields((String)"components", (TypeTemplate)DataConverterTypes.w.in(schema), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", DataConverterSchemaNamed.a(), (Map)blockEntityTypes)));
        schema.registerType(true, DataConverterTypes.t, () -> DSL.hook((TypeTemplate)DSL.optionalFields((String)"id", (TypeTemplate)DataConverterTypes.D.in(schema), (String)"tag", (TypeTemplate)DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"EntityTag", (Object)DataConverterTypes.A.in(schema)), Pair.of((Object)"BlockEntityTag", (Object)DataConverterTypes.s.in(schema)), Pair.of((Object)"CanDestroy", (Object)DSL.list((TypeTemplate)DataConverterTypes.C.in(schema))), Pair.of((Object)"CanPlaceOn", (Object)DSL.list((TypeTemplate)DataConverterTypes.C.in(schema))), Pair.of((Object)"Items", (Object)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema))), Pair.of((Object)"ChargedProjectiles", (Object)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema)))})), (Hook.HookFunction)b, (Hook.HookFunction)Hook.HookFunction.IDENTITY));
    }
}

