/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class TrialSpawnerConfigInRegistryFix
extends DataConverterNamedEntity {
    private static final Logger a = LogUtils.getLogger();

    public TrialSpawnerConfigInRegistryFix(Schema outputSchema) {
        super(outputSchema, false, "TrialSpawnerConfigInRegistryFix", DataConverterTypes.s, "minecraft:trial_spawner");
    }

    public Dynamic<?> a(Dynamic<NBTBase> tag) {
        Optional optional = tag.get("normal_config").result();
        if (optional.isEmpty()) {
            return tag;
        }
        Optional optional1 = tag.get("ominous_config").result();
        if (optional1.isEmpty()) {
            return tag;
        }
        MinecraftKey resourceLocation = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a.get(Pair.of((Object)((Object)((Dynamic)((Object)optional.get()))), (Object)((Object)((Dynamic)((Object)optional1.get())))));
        return resourceLocation == null ? tag : tag.set("normal_config", tag.createString(resourceLocation.g("/normal").toString())).set("ominous_config", tag.createString(resourceLocation.g("/ominous").toString()));
    }

    @Override
    protected Typed<?> a(Typed<?> typed) {
        return typed.update(DSL.remainderFinder(), dynamic -> {
            DynamicOps ops = dynamic.getOps();
            Dynamic<?> dynamic1 = this.a(dynamic.convert(DynamicOpsNBT.a));
            return dynamic1.convert(ops);
        });
    }

    static final class a {
        public static final Map<Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>, MinecraftKey> a = new HashMap<Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>, MinecraftKey>();

        private a() {
        }

        private static void a(MinecraftKey name, String normal, String ominous) {
            try {
                NBTTagCompound compoundTag = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(normal);
                NBTTagCompound compoundTag1 = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(ominous);
                NBTTagCompound compoundTag2 = compoundTag.i().a(compoundTag1);
                NBTTagCompound compoundTag3 = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.b(compoundTag2.i());
                Dynamic<NBTBase> dynamic = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(compoundTag);
                a.put((Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>)Pair.of(dynamic, net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(compoundTag1)), name);
                a.put((Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>)Pair.of(dynamic, net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(compoundTag2)), name);
                a.put((Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>)Pair.of(dynamic, net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(compoundTag3)), name);
            }
            catch (RuntimeException var8) {
                throw new IllegalStateException("Failed to parse NBT for " + String.valueOf(name), var8);
            }
        }

        private static Dynamic<NBTBase> a(NBTTagCompound tag) {
            return new Dynamic<NBTBase>(DynamicOpsNBT.a, tag);
        }

        private static NBTTagCompound a(String config) {
            try {
                return MojangsonParser.a(config);
            }
            catch (CommandSyntaxException var2) {
                throw new IllegalArgumentException("Failed to parse Trial Spawner NBT config: " + config, var2);
            }
        }

        private static NBTTagCompound b(NBTTagCompound tag) {
            if (tag.h("spawn_range") == 4) {
                tag.r("spawn_range");
            }
            if (tag.j("total_mobs") == 6.0f) {
                tag.r("total_mobs");
            }
            if (tag.j("simultaneous_mobs") == 2.0f) {
                tag.r("simultaneous_mobs");
            }
            if (tag.j("total_mobs_added_per_player") == 2.0f) {
                tag.r("total_mobs_added_per_player");
            }
            if (tag.j("simultaneous_mobs_added_per_player") == 1.0f) {
                tag.r("simultaneous_mobs_added_per_player");
            }
            if (tag.h("ticks_between_spawn") == 40) {
                tag.r("ticks_between_spawn");
            }
            return tag;
        }

        static {
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/breeze"), "{simultaneous_mobs: 1.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:breeze\"}}, weight: 1}], ticks_between_spawn: 20, total_mobs: 2.0f, total_mobs_added_per_player: 1.0f}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], simultaneous_mobs: 2.0f, total_mobs: 4.0f}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/melee/husk"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:husk\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:husk\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_melee\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/melee/spider"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:spider\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}],simultaneous_mobs: 4.0f, total_mobs: 12.0f}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/melee/zombie"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:zombie\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}],spawn_potentials: [{data: {entity: {id: \"minecraft:zombie\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_melee\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/ranged/poison_skeleton"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:bogged\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}],spawn_potentials: [{data: {entity: {id: \"minecraft:bogged\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/ranged/skeleton"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:skeleton\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:skeleton\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/ranged/stray"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:stray\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:stray\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/slow_ranged/poison_skeleton"), "{simultaneous_mobs: 4.0f, simultaneous_mobs_added_per_player: 2.0f, spawn_potentials: [{data: {entity: {id: \"minecraft:bogged\"}}, weight: 1}], ticks_between_spawn: 160}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:bogged\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/slow_ranged/skeleton"), "{simultaneous_mobs: 4.0f, simultaneous_mobs_added_per_player: 2.0f, spawn_potentials: [{data: {entity: {id: \"minecraft:skeleton\"}}, weight: 1}], ticks_between_spawn: 160}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:skeleton\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/slow_ranged/stray"), "{simultaneous_mobs: 4.0f, simultaneous_mobs_added_per_player: 2.0f, spawn_potentials: [{data: {entity: {id: \"minecraft:stray\"}}, weight: 1}], ticks_between_spawn: 160}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}],spawn_potentials: [{data: {entity: {id: \"minecraft:stray\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/small_melee/baby_zombie"), "{simultaneous_mobs: 2.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {IsBaby: 1b, id: \"minecraft:zombie\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {IsBaby: 1b, id: \"minecraft:zombie\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_melee\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/small_melee/cave_spider"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:cave_spider\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], simultaneous_mobs: 4.0f, total_mobs: 12.0f}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/small_melee/silverfish"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:silverfish\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], simultaneous_mobs: 4.0f, total_mobs: 12.0f}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/small_melee/slime"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {Size: 1, id: \"minecraft:slime\"}}, weight: 3}, {data: {entity: {Size: 2, id: \"minecraft:slime\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], simultaneous_mobs: 4.0f, total_mobs: 12.0f}");
        }
    }
}

