/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class OminousBannerRarityFix
extends DataFix {
    public OminousBannerRarityFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.s);
        Type type1 = this.getInputSchema().getType(DataConverterTypes.t);
        TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(DataConverterTypes.s);
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.D.typeName(), DataConverterSchemaNamed.a()));
        OpticFinder opticFinder1 = type.findField("components");
        OpticFinder opticFinder2 = type1.findField("components");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner block entity common rarity to uncommon rarity fix", type, typed -> {
            Object first = ((Pair)typed.get(taggedChoiceType.finder())).getFirst();
            return first.equals("minecraft:banner") ? this.a((Typed<?>)typed, (OpticFinder<?>)opticFinder1) : typed;
        }), (TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner item stack common rarity to uncommon rarity fix", type1, typed -> {
            String string = typed.getOptional(opticFinder).map(Pair::getSecond).orElse("");
            return string.equals("minecraft:white_banner") ? this.a((Typed<?>)typed, (OpticFinder<?>)opticFinder2) : typed;
        }));
    }

    private Typed<?> a(Typed<?> data, OpticFinder<?> componentField) {
        return data.updateTyped(componentField, typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            boolean isPresent = dynamic.get("minecraft:item_name").asString().result().flatMap(ComponentDataFixUtils::a).filter(string -> string.equals("block.minecraft.ominous_banner")).isPresent();
            return isPresent ? dynamic.set("minecraft:rarity", dynamic.createString("uncommon")).set("minecraft:item_name", ComponentDataFixUtils.b(dynamic.getOps(), "block.minecraft.ominous_banner")) : dynamic;
        }));
    }
}

