/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DropInvalidSignDataFix
extends DataConverterNamedEntity {
    private static final String[] a = new String[]{"Text1", "Text2", "Text3", "Text4", "FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4", "Color", "GlowingText"};

    public DropInvalidSignDataFix(Schema outputSchema, String name, String entityName) {
        super(outputSchema, false, name, DataConverterTypes.s, entityName);
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic) {
        dynamic = dynamic.update("front_text", DropInvalidSignDataFix::b);
        dynamic = dynamic.update("back_text", DropInvalidSignDataFix::b);
        for (String string : a) {
            dynamic = dynamic.remove(string);
        }
        return dynamic;
    }

    private static <T> Dynamic<T> b(Dynamic<T> textDynamic) {
        boolean _boolean = textDynamic.get("_filtered_correct").asBoolean(false);
        if (_boolean) {
            return textDynamic.remove("_filtered_correct");
        }
        Optional optional = textDynamic.get("filtered_messages").asStreamOpt().result();
        if (optional.isEmpty()) {
            return textDynamic;
        }
        Dynamic dynamic = ComponentDataFixUtils.a(textDynamic.getOps());
        List<Dynamic> list = textDynamic.get("messages").asStreamOpt().result().orElse(Stream.of(new Dynamic[0])).toList();
        List list1 = Streams.mapWithIndex((Stream)((Stream)optional.get()), (dynamic1, l2) -> {
            Dynamic dynamic2 = l2 < (long)list.size() ? (Dynamic)((Object)((Object)list.get((int)l2))) : dynamic;
            return dynamic1.equals((Object)dynamic) ? dynamic2 : dynamic1;
        }).toList();
        return list1.stream().allMatch(dynamic1 -> dynamic1.equals((Object)dynamic)) ? textDynamic.remove("filtered_messages") : textDynamic.set("filtered_messages", textDynamic.createList(list1.stream()));
    }

    @Override
    protected Typed<?> a(Typed<?> typed) {
        return typed.update(DSL.remainderFinder(), DropInvalidSignDataFix::a);
    }
}

