/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterVillagerProfession
extends DataConverterNamedEntity {
    public DataConverterVillagerProfession(Schema outputSchema, String entityName) {
        super(outputSchema, false, "Villager profession data fix (" + entityName + ")", DataConverterTypes.B, entityName);
    }

    @Override
    protected Typed<?> a(Typed<?> typed) {
        Dynamic dynamic = (Dynamic)((Object)typed.get(DSL.remainderFinder()));
        return typed.set(DSL.remainderFinder(), dynamic.remove("Profession").remove("Career").remove("CareerLevel").set("VillagerData", dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("type")), (Object)((Object)dynamic.createString("minecraft:plains")), (Object)((Object)dynamic.createString("profession")), (Object)((Object)dynamic.createString(DataConverterVillagerProfession.a(dynamic.get("Profession").asInt(0), dynamic.get("Career").asInt(0)))), (Object)((Object)dynamic.createString("level")), (Object)((Object)((Dynamic)((Object)DataFixUtils.orElse((Optional)dynamic.get("CareerLevel").result(), (Object)((Object)dynamic.createInt(1))))))))));
    }

    private static String a(int profession, int career) {
        if (profession == 0) {
            if (career == 2) {
                return "minecraft:fisherman";
            }
            if (career == 3) {
                return "minecraft:shepherd";
            }
            return career == 4 ? "minecraft:fletcher" : "minecraft:farmer";
        }
        if (profession == 1) {
            return career == 2 ? "minecraft:cartographer" : "minecraft:librarian";
        }
        if (profession == 2) {
            return "minecraft:cleric";
        }
        if (profession == 3) {
            if (career == 2) {
                return "minecraft:weaponsmith";
            }
            return career == 3 ? "minecraft:toolsmith" : "minecraft:armorer";
        }
        if (profession == 4) {
            return career == 2 ? "minecraft:leatherworker" : "minecraft:butcher";
        }
        return profession == 5 ? "minecraft:nitwit" : "minecraft:none";
    }
}

