/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterLeavesBiome
extends DataFix {
    public DataConverterLeavesBiome(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("Level");
        return this.fixTypeEverywhereTyped("Leaves fix", type, typed -> typed.updateTyped(opticFinder, typed1 -> typed1.update(DSL.remainderFinder(), dynamic -> {
            int i2;
            Optional optional = dynamic.get("Biomes").asIntStreamOpt().result();
            if (optional.isEmpty()) {
                return dynamic;
            }
            int[] ints = ((IntStream)optional.get()).toArray();
            if (ints.length != 256) {
                return dynamic;
            }
            int[] ints1 = new int[1024];
            for (i2 = 0; i2 < 4; ++i2) {
                for (int i1 = 0; i1 < 4; ++i1) {
                    int i22 = (i1 << 2) + 2;
                    int i3 = (i2 << 2) + 2;
                    int i4 = i3 << 4 | i22;
                    ints1[i2 << 2 | i1] = ints[i4];
                }
            }
            for (i2 = 1; i2 < 64; ++i2) {
                System.arraycopy(ints1, 0, ints1, i2 * 16, 16);
            }
            return dynamic.set("Biomes", dynamic.createIntList(Arrays.stream(ints1)));
        })));
    }
}

