/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.DataBitsPacked;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterLeaves
extends DataFix {
    private static final int a = 128;
    private static final int b = 64;
    private static final int c = 32;
    private static final int d = 16;
    private static final int e = 8;
    private static final int f = 4;
    private static final int g = 2;
    private static final int h = 1;
    private static final int[][] i = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}};
    private static final int j = 7;
    private static final int k = 12;
    private static final int l = 4096;
    static final Object2IntMap<String> m = (Object2IntMap)DataFixUtils.make((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"minecraft:acacia_leaves", 0);
        map.put((Object)"minecraft:birch_leaves", 1);
        map.put((Object)"minecraft:dark_oak_leaves", 2);
        map.put((Object)"minecraft:jungle_leaves", 3);
        map.put((Object)"minecraft:oak_leaves", 4);
        map.put((Object)"minecraft:spruce_leaves", 5);
    });
    static final Set<String> n = ImmutableSet.of((Object)"minecraft:acacia_bark", (Object)"minecraft:birch_bark", (Object)"minecraft:dark_oak_bark", (Object)"minecraft:jungle_bark", (Object)"minecraft:oak_bark", (Object)"minecraft:spruce_bark", (Object[])new String[]{"minecraft:acacia_log", "minecraft:birch_log", "minecraft:dark_oak_log", "minecraft:jungle_log", "minecraft:oak_log", "minecraft:spruce_log", "minecraft:stripped_acacia_log", "minecraft:stripped_birch_log", "minecraft:stripped_dark_oak_log", "minecraft:stripped_jungle_log", "minecraft:stripped_oak_log", "minecraft:stripped_spruce_log"});

    public DataConverterLeaves(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder1 = opticFinder.type().findField("Sections");
        Type type1 = opticFinder1.type();
        if (!(type1 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        Type element = ((List.ListType)type1).getElement();
        OpticFinder opticFinder2 = DSL.typeFinder((Type)element);
        return this.fixTypeEverywhereTyped("Leaves fix", type, typed -> typed.updateTyped(opticFinder, typed1 -> {
            int[] ints = new int[]{0};
            Typed typed2 = typed1.updateTyped(opticFinder1, typed3 -> {
                int z2;
                int x2;
                Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap(typed3.getAllTyped(opticFinder2).stream().map(typed4 -> new a((Typed<?>)typed4, this.getInputSchema())).collect(Collectors.toMap(b::c, leavesSection2 -> leavesSection2)));
                if (map.values().stream().allMatch(b::b)) {
                    return typed3;
                }
                ArrayList list = Lists.newArrayList();
                for (int i2 = 0; i2 < 7; ++i2) {
                    list.add(new IntOpenHashSet());
                }
                for (a leavesSection : map.values()) {
                    if (leavesSection.b()) continue;
                    for (int i1 = 0; i1 < 4096; ++i1) {
                        int block = leavesSection.c(i1);
                        if (leavesSection.a(block)) {
                            ((IntSet)list.get(0)).add(leavesSection.c() << 12 | i1);
                            continue;
                        }
                        if (!leavesSection.b(block)) continue;
                        x2 = this.a(i1);
                        z2 = this.c(i1);
                        ints[0] = ints[0] | DataConverterLeaves.a(x2 == 0, x2 == 15, z2 == 0, z2 == 15);
                    }
                }
                for (int i3 = 1; i3 < 7; ++i3) {
                    IntSet set = (IntSet)list.get(i3 - 1);
                    IntSet set1 = (IntSet)list.get(i3);
                    IntIterator intIterator = set.iterator();
                    while (intIterator.hasNext()) {
                        x2 = intIterator.nextInt();
                        z2 = this.a(x2);
                        int y2 = this.b(x2);
                        int z1 = this.c(x2);
                        for (int[] ints1 : i) {
                            int distance;
                            int index;
                            int block1;
                            a leavesSection1;
                            int i2 = z2 + ints1[0];
                            int i32 = y2 + ints1[1];
                            int i4 = z1 + ints1[2];
                            if (i2 < 0 || i2 > 15 || i4 < 0 || i4 > 15 || i32 < 0 || i32 > 255 || (leavesSection1 = (a)map.get(i32 >> 4)) == null || leavesSection1.b() || !leavesSection1.b(block1 = leavesSection1.c(index = DataConverterLeaves.a(i2, i32 & 0xF, i4))) || (distance = leavesSection1.d(block1)) <= i3) continue;
                            leavesSection1.a(index, block1, i3);
                            set1.add(DataConverterLeaves.a(i2, i32, i4));
                        }
                    }
                }
                return typed3.updateTyped(opticFinder2, arg_0 -> DataConverterLeaves.a((Int2ObjectMap)map, arg_0));
            });
            if (ints[0] != 0) {
                typed2 = typed2.update(DSL.remainderFinder(), dynamic -> {
                    Dynamic dynamic1 = (Dynamic)((Object)((Object)((Object)((Object)DataFixUtils.orElse((Optional)dynamic.get("UpgradeData").result(), (Object)((Object)dynamic.emptyMap()))))));
                    return dynamic.set("UpgradeData", dynamic1.set("Sides", dynamic.createByte((byte)(dynamic1.get("Sides").asByte((byte)0) | ints[0]))));
                });
            }
            return typed2;
        }));
    }

    public static int a(int x2, int y2, int z2) {
        return y2 << 8 | z2 << 4 | x2;
    }

    private int a(int index) {
        return index & 0xF;
    }

    private int b(int index) {
        return index >> 8 & 0xFF;
    }

    private int c(int index) {
        return index >> 4 & 0xF;
    }

    public static int a(boolean west, boolean east, boolean north, boolean south) {
        int i2 = 0;
        if (north) {
            i2 = east ? (i2 |= 2) : (west ? (i2 |= 0x80) : (i2 |= 1));
        } else if (south) {
            i2 = west ? (i2 |= 0x20) : (east ? (i2 |= 8) : (i2 |= 0x10));
        } else if (east) {
            i2 |= 4;
        } else if (west) {
            i2 |= 0x40;
        }
        return i2;
    }

    private static /* synthetic */ Typed a(Int2ObjectMap map, Typed typed4) {
        return ((a)map.get(((Dynamic)((Object)typed4.get(DSL.remainderFinder()))).get("Y").asInt(0))).a(typed4);
    }

    public static final class a
    extends b {
        private static final String h = "persistent";
        private static final String i = "decayable";
        private static final String j = "distance";
        @Nullable
        private IntSet k;
        @Nullable
        private IntSet l;
        @Nullable
        private Int2IntMap m;

        public a(Typed<?> data, Schema schema) {
            super(data, schema);
        }

        @Override
        protected boolean a() {
            this.k = new IntOpenHashSet();
            this.l = new IntOpenHashSet();
            this.m = new Int2IntOpenHashMap();
            for (int i2 = 0; i2 < this.e.size(); ++i2) {
                Dynamic<?> dynamic = this.e.get(i2);
                String string = dynamic.get("Name").asString("");
                if (m.containsKey((Object)string)) {
                    boolean flag = Objects.equals(dynamic.get("Properties").get(i).asString(""), "false");
                    this.k.add(i2);
                    this.m.put(this.a(string, flag, 7), i2);
                    this.e.set(i2, this.a(dynamic, string, flag, 7));
                }
                if (!n.contains(string)) continue;
                this.l.add(i2);
            }
            return this.k.isEmpty() && this.l.isEmpty();
        }

        private Dynamic<?> a(Dynamic<?> dynamic, String name, boolean persistent, int distance) {
            Dynamic dynamic1 = dynamic.emptyMap();
            dynamic1 = dynamic1.set(h, dynamic1.createString(persistent ? "true" : "false"));
            dynamic1 = dynamic1.set(j, dynamic1.createString(Integer.toString(distance)));
            Dynamic dynamic2 = dynamic.emptyMap();
            dynamic2 = dynamic2.set("Properties", dynamic1);
            return dynamic2.set("Name", dynamic2.createString(name));
        }

        public boolean a(int id) {
            return this.l.contains(id);
        }

        public boolean b(int id) {
            return this.k.contains(id);
        }

        int d(int index) {
            return this.a(index) ? 0 : Integer.parseInt(this.e.get(index).get("Properties").get(j).asString(""));
        }

        void a(int index, int block, int distance) {
            int size;
            boolean flag;
            Dynamic<?> dynamic = this.e.get(block);
            String string = dynamic.get("Name").asString("");
            int stateId = this.a(string, flag = Objects.equals(dynamic.get("Properties").get(h).asString(""), "true"), distance);
            if (!this.m.containsKey(stateId)) {
                size = this.e.size();
                this.k.add(size);
                this.m.put(stateId, size);
                this.e.add(this.a(dynamic, string, flag, distance));
            }
            size = this.m.get(stateId);
            if (1 << this.g.b() <= size) {
                DataBitsPacked packedBitStorage = new DataBitsPacked(this.g.b() + 1, 4096);
                for (int i2 = 0; i2 < 4096; ++i2) {
                    packedBitStorage.a(i2, this.g.a(i2));
                }
                this.g = packedBitStorage;
            }
            this.g.a(index, size);
        }
    }

    public static abstract class b {
        protected static final String a = "BlockStates";
        protected static final String b = "Name";
        protected static final String c = "Properties";
        private final Type<Pair<String, Dynamic<?>>> h = DSL.named((String)DataConverterTypes.u.typeName(), (Type)DSL.remainderType());
        protected final OpticFinder<List<Pair<String, Dynamic<?>>>> d = DSL.fieldFinder((String)"Palette", (Type)DSL.list(this.h));
        protected final List<Dynamic<?>> e;
        protected final int f;
        @Nullable
        protected DataBitsPacked g;

        public b(Typed<?> data, Schema schema) {
            if (!Objects.equals(schema.getType(DataConverterTypes.u), this.h)) {
                throw new IllegalStateException("Block state type is not what was expected.");
            }
            Optional optional = data.getOptional(this.d);
            this.e = optional.map(list -> list.stream().map(Pair::getSecond).collect(Collectors.toList())).orElse((List)ImmutableList.of());
            Dynamic dynamic = (Dynamic)((Object)data.get(DSL.remainderFinder()));
            this.f = dynamic.get("Y").asInt(0);
            this.a(dynamic);
        }

        protected void a(Dynamic<?> data) {
            if (this.a()) {
                this.g = null;
            } else {
                long[] longs = data.get(a).asLongStream().toArray();
                int max = Math.max(4, DataFixUtils.ceillog2((int)this.e.size()));
                this.g = new DataBitsPacked(max, 4096, longs);
            }
        }

        public Typed<?> a(Typed<?> data) {
            return this.b() ? data : data.update(DSL.remainderFinder(), dynamic -> dynamic.set(a, dynamic.createLongList(Arrays.stream(this.g.a())))).set(this.d, this.e.stream().map(dynamic -> Pair.of((Object)DataConverterTypes.u.typeName(), (Object)dynamic)).collect(Collectors.toList()));
        }

        public boolean b() {
            return this.g == null;
        }

        public int c(int index) {
            return this.g.a(index);
        }

        protected int a(String name, boolean persistent, int distance) {
            return m.get((Object)name) << 5 | (persistent ? 16 : 0) | distance;
        }

        int c() {
            return this.f;
        }

        protected abstract boolean a();
    }
}

