/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterEntityProjectileOwner
extends DataFix {
    public DataConverterEntityProjectileOwner(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema inputSchema = this.getInputSchema();
        return this.fixTypeEverywhereTyped("EntityProjectileOwner", inputSchema.getType(DataConverterTypes.B), this::a);
    }

    private Typed<?> a(Typed<?> typed) {
        typed = this.a(typed, "minecraft:egg", this::d);
        typed = this.a(typed, "minecraft:ender_pearl", this::d);
        typed = this.a(typed, "minecraft:experience_bottle", this::d);
        typed = this.a(typed, "minecraft:snowball", this::d);
        typed = this.a(typed, "minecraft:potion", this::d);
        typed = this.a(typed, "minecraft:potion", this::c);
        typed = this.a(typed, "minecraft:llama_spit", this::b);
        typed = this.a(typed, "minecraft:arrow", this::a);
        typed = this.a(typed, "minecraft:spectral_arrow", this::a);
        return this.a(typed, "minecraft:trident", this::a);
    }

    private Dynamic<?> a(Dynamic<?> arrowTag) {
        long _long = arrowTag.get("OwnerUUIDMost").asLong(0L);
        long _long1 = arrowTag.get("OwnerUUIDLeast").asLong(0L);
        return this.a(arrowTag, _long, _long1).remove("OwnerUUIDMost").remove("OwnerUUIDLeast");
    }

    private Dynamic<?> b(Dynamic<?> llamaSpitTag) {
        OptionalDynamic<?> optionalDynamic = llamaSpitTag.get("Owner");
        long _long = optionalDynamic.get("OwnerUUIDMost").asLong(0L);
        long _long1 = optionalDynamic.get("OwnerUUIDLeast").asLong(0L);
        return this.a(llamaSpitTag, _long, _long1).remove("Owner");
    }

    private Dynamic<?> c(Dynamic<?> itemPotionTag) {
        OptionalDynamic<?> optionalDynamic = itemPotionTag.get("Potion");
        return itemPotionTag.set("Item", optionalDynamic.orElseEmptyMap()).remove("Potion");
    }

    private Dynamic<?> d(Dynamic<?> throwableTag) {
        String string = "owner";
        OptionalDynamic<?> optionalDynamic = throwableTag.get("owner");
        long _long = optionalDynamic.get("M").asLong(0L);
        long _long1 = optionalDynamic.get("L").asLong(0L);
        return this.a(throwableTag, _long, _long1).remove("owner");
    }

    private Dynamic<?> a(Dynamic<?> dynamic, long uuidMost, long uuidLeast) {
        String string = "OwnerUUID";
        return uuidMost != 0L && uuidLeast != 0L ? dynamic.set("OwnerUUID", dynamic.createIntList(Arrays.stream(DataConverterEntityProjectileOwner.a(uuidMost, uuidLeast)))) : dynamic;
    }

    private static int[] a(long uuidMost, long uuidLeast) {
        return new int[]{(int)(uuidMost >> 32), (int)uuidMost, (int)(uuidLeast >> 32), (int)uuidLeast};
    }

    private Typed<?> a(Typed<?> typed, String choiceName, Function<Dynamic<?>, Dynamic<?>> updater) {
        Type choiceType = this.getInputSchema().getChoiceType(DataConverterTypes.B, choiceName);
        Type choiceType1 = this.getOutputSchema().getChoiceType(DataConverterTypes.B, choiceName);
        return typed.updateTyped(DSL.namedChoice((String)choiceName, (Type)choiceType), choiceType1, typed1 -> typed1.update(DSL.remainderFinder(), updater));
    }
}

