/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class ChunkHeightAndBiomeFix
extends DataFix {
    public static final String a = "__context";
    private static final String d = "ChunkHeightAndBiomeFix";
    private static final int e = 16;
    private static final int f = 24;
    private static final int g = -4;
    public static final int b = 4096;
    private static final int h = 64;
    private static final int i = 9;
    private static final long j = 511L;
    private static final int k = 64;
    private static final String[] l = new String[]{"WORLD_SURFACE_WG", "WORLD_SURFACE", "WORLD_SURFACE_IGNORE_SNOW", "OCEAN_FLOOR_WG", "OCEAN_FLOOR", "MOTION_BLOCKING", "MOTION_BLOCKING_NO_LEAVES"};
    private static final Set<String> m = Set.of("surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> n = Set.of("noise", "surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> o = Set.of("minecraft:air", "minecraft:basalt", "minecraft:bedrock", "minecraft:blackstone", "minecraft:calcite", "minecraft:cave_air", "minecraft:coarse_dirt", "minecraft:crimson_nylium", "minecraft:dirt", "minecraft:end_stone", "minecraft:grass_block", "minecraft:gravel", "minecraft:ice", "minecraft:lava", "minecraft:mycelium", "minecraft:nether_wart_block", "minecraft:netherrack", "minecraft:orange_terracotta", "minecraft:packed_ice", "minecraft:podzol", "minecraft:powder_snow", "minecraft:red_sand", "minecraft:red_sandstone", "minecraft:sand", "minecraft:sandstone", "minecraft:snow_block", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:stone", "minecraft:terracotta", "minecraft:warped_nylium", "minecraft:warped_wart_block", "minecraft:water", "minecraft:white_terracotta");
    private static final int p = 16;
    private static final int q = 64;
    private static final int r = 1008;
    public static final String c = "minecraft:plains";
    private static final Int2ObjectMap<String> s = new Int2ObjectOpenHashMap();

    public ChunkHeightAndBiomeFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder1 = opticFinder.type().findField("Sections");
        Schema outputSchema = this.getOutputSchema();
        Type type1 = outputSchema.getType(DataConverterTypes.c);
        Type type2 = type1.findField("Level").type();
        Type type3 = type2.findField("Sections").type();
        return this.fixTypeEverywhereTyped(d, type, type1, typed -> typed.updateTyped(opticFinder, type2, typed1 -> {
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)typed1.get(DSL.remainderFinder()))));
            OptionalDynamic optionalDynamic = ((Dynamic)((Object)((Object)((Object)typed.get(DSL.remainderFinder()))))).get(a);
            String string = optionalDynamic.get("dimension").asString().result().orElse("");
            String string1 = optionalDynamic.get("generator").asString().result().orElse("");
            boolean flag = "minecraft:overworld".equals(string);
            MutableBoolean mutableBoolean = new MutableBoolean();
            int i2 = flag ? -4 : 0;
            Dynamic[] biomeContainers = ChunkHeightAndBiomeFix.a(dynamic, flag, i2, mutableBoolean);
            Dynamic<?> dynamic1 = ChunkHeightAndBiomeFix.d(dynamic.createList(Stream.of(dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("Name")), (Object)((Object)dynamic.createString("minecraft:air")))))));
            HashSet set = Sets.newHashSet();
            MutableObject mutableObject = new MutableObject(() -> null);
            typed1 = typed1.updateTyped(opticFinder1, type3, typed2 -> {
                IntOpenHashSet set1 = new IntOpenHashSet();
                Dynamic dynamic2 = (Dynamic)((Object)((Object)((Object)((Object)typed2.write().result().orElseThrow(() -> new IllegalStateException("Malformed Chunk.Level.Sections"))))));
                List list = dynamic2.asStream().map(arg_0 -> ChunkHeightAndBiomeFix.a(set, dynamic1, i2, biomeContainers, (IntSet)set1, mutableObject, arg_0)).collect(Collectors.toCollection(ArrayList::new));
                for (int i1 = 0; i1 < biomeContainers.length; ++i1) {
                    int i22 = i1 + i2;
                    if (!set1.add(i22)) continue;
                    Dynamic dynamic3 = dynamic.createMap(Map.of(dynamic.createString("Y"), dynamic.createInt(i22)));
                    dynamic3 = dynamic3.set("block_states", dynamic1);
                    dynamic3 = dynamic3.set("biomes", biomeContainers[i1]);
                    list.add(dynamic3);
                }
                return SystemUtils.a(type3, dynamic.createList(list.stream()));
            });
            return typed1.update(DSL.remainderFinder(), dynamic2 -> {
                if (flag) {
                    dynamic2 = this.a((Dynamic<?>)((Object)((Object)((Object)dynamic2))), set);
                }
                return ChunkHeightAndBiomeFix.a(dynamic2, flag, mutableBoolean.booleanValue(), "minecraft:noise".equals(string1), (Supplier)mutableObject.getValue());
            });
        }));
    }

    private Dynamic<?> a(Dynamic<?> data, Set<String> blockPalette) {
        return data.update("Status", dynamic -> {
            boolean flag1;
            String string = dynamic.asString("empty");
            if (m.contains(string)) {
                return dynamic;
            }
            blockPalette.remove("minecraft:air");
            boolean flag = !blockPalette.isEmpty();
            blockPalette.removeAll(o);
            boolean bl = flag1 = !blockPalette.isEmpty();
            if (flag1) {
                return dynamic.createString("liquid_carvers");
            }
            if ("noise".equals(string) || flag) {
                return dynamic.createString("noise");
            }
            return "biomes".equals(string) ? dynamic.createString("structure_references") : dynamic;
        });
    }

    private static Dynamic<?>[] a(Dynamic<?> data, boolean overworld, int lowestY, MutableBoolean isTallChunk) {
        Dynamic[] dynamics = new Dynamic[overworld ? 24 : 16];
        int[] ints = data.get("Biomes").asIntStreamOpt().result().map(IntStream::toArray).orElse(null);
        if (ints != null && ints.length == 1536) {
            isTallChunk.setValue(true);
            for (int i2 = 0; i2 < 24; ++i2) {
                int i1 = i2;
                dynamics[i2] = ChunkHeightAndBiomeFix.a(data, i3 -> ChunkHeightAndBiomeFix.a(ints, i1 * 64 + i3));
            }
        } else if (ints != null && ints.length == 1024) {
            int i4 = 0;
            while (i4 < 16) {
                int i1 = i4 - lowestY;
                int f_i = i4++;
                dynamics[i1] = ChunkHeightAndBiomeFix.a(data, i3 -> ChunkHeightAndBiomeFix.a(ints, f_i * 64 + i3));
            }
            if (overworld) {
                int i2;
                Dynamic<?> dynamic = ChunkHeightAndBiomeFix.a(data, i3 -> ChunkHeightAndBiomeFix.a(ints, i3 % 16));
                Dynamic<?> dynamic1 = ChunkHeightAndBiomeFix.a(data, i3 -> ChunkHeightAndBiomeFix.a(ints, i3 % 16 + 1008));
                for (i2 = 0; i2 < 4; ++i2) {
                    dynamics[i2] = dynamic;
                }
                for (i2 = 20; i2 < 24; ++i2) {
                    dynamics[i2] = dynamic1;
                }
            }
        } else {
            Arrays.fill((Object[])dynamics, ChunkHeightAndBiomeFix.d(data.createList(Stream.of(data.createString(c)))));
        }
        return dynamics;
    }

    private static int a(int[] biomes, int index) {
        return biomes[index] & 0xFF;
    }

    private static Dynamic<?> a(Dynamic<?> chunkTag, boolean overworld, boolean isTallChunk, boolean isNoiseGenerator, Supplier<ChunkProtoTickListFix.a> paletteSupplier) {
        Dynamic dynamic;
        String string;
        chunkTag = chunkTag.remove("Biomes");
        if (!overworld) {
            return ChunkHeightAndBiomeFix.a(chunkTag, 16, 0);
        }
        if (isTallChunk) {
            return ChunkHeightAndBiomeFix.a(chunkTag, 24, 0);
        }
        chunkTag = ChunkHeightAndBiomeFix.b(chunkTag);
        chunkTag = ChunkHeightAndBiomeFix.a(chunkTag, "LiquidsToBeTicked");
        chunkTag = ChunkHeightAndBiomeFix.a(chunkTag, "PostProcessing");
        chunkTag = ChunkHeightAndBiomeFix.a(chunkTag, "ToBeTicked");
        chunkTag = ChunkHeightAndBiomeFix.a(chunkTag, 24, 4);
        chunkTag = chunkTag.update("UpgradeData", ChunkHeightAndBiomeFix::a);
        if (!isNoiseGenerator) {
            return chunkTag;
        }
        Optional optional = chunkTag.get("Status").result();
        if (optional.isPresent() && !"empty".equals(string = (dynamic = (Dynamic)((Object)optional.get())).asString(""))) {
            chunkTag = chunkTag.set("blending_data", chunkTag.createMap((Map)ImmutableMap.of((Object)((Object)chunkTag.createString("old_noise")), (Object)((Object)chunkTag.createBoolean(n.contains(string))))));
            ChunkProtoTickListFix.a poorMansPalettedContainer = paletteSupplier.get();
            if (poorMansPalettedContainer != null) {
                BitSet bitSet = new BitSet(256);
                boolean flag = string.equals("noise");
                for (int i2 = 0; i2 < 16; ++i2) {
                    for (int i1 = 0; i1 < 16; ++i1) {
                        boolean flag2;
                        Dynamic<?> dynamic1 = poorMansPalettedContainer.a(i1, 0, i2);
                        boolean flag1 = dynamic1 != null && "minecraft:bedrock".equals(dynamic1.get("Name").asString(""));
                        boolean bl = flag2 = dynamic1 != null && "minecraft:air".equals(dynamic1.get("Name").asString(""));
                        if (flag2) {
                            bitSet.set(i2 * 16 + i1);
                        }
                        flag |= flag1;
                    }
                }
                if (flag && bitSet.cardinality() != bitSet.size()) {
                    Dynamic dynamic2 = "full".equals(string) ? chunkTag.createString("heightmaps") : dynamic;
                    chunkTag = chunkTag.set("below_zero_retrogen", chunkTag.createMap((Map)ImmutableMap.of((Object)((Object)chunkTag.createString("target_status")), (Object)((Object)dynamic2), (Object)((Object)chunkTag.createString("missing_bedrock")), (Object)((Object)chunkTag.createLongList(LongStream.of(bitSet.toLongArray()))))));
                    chunkTag = chunkTag.set("Status", chunkTag.createString("empty"));
                }
                chunkTag = chunkTag.set("isLightOn", chunkTag.createBoolean(false));
            }
        }
        return chunkTag;
    }

    private static <T> Dynamic<T> a(Dynamic<T> data) {
        return data.update("Indices", dynamic -> {
            HashMap map = new HashMap();
            dynamic.getMapValues().ifSuccess(map1 -> map1.forEach((dynamic1, dynamic2) -> {
                try {
                    dynamic1.asString().result().map(Integer::parseInt).ifPresent(integer -> {
                        int i2 = integer - -4;
                        map.put(dynamic1.createString(Integer.toString(i2)), dynamic2);
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }));
            return dynamic.createMap(map);
        });
    }

    private static Dynamic<?> a(Dynamic<?> data, int sectionCount, int offset) {
        Dynamic dynamic = data.get("CarvingMasks").orElseEmptyMap();
        dynamic = dynamic.updateMapValues(pair -> {
            long[] longs = BitSet.valueOf(((Dynamic)((Object)((Object)pair.getSecond()))).asByteBuffer().array()).toLongArray();
            long[] longs1 = new long[64 * sectionCount];
            System.arraycopy(longs, 0, longs1, 64 * offset, longs.length);
            return Pair.of((Object)((Object)((Dynamic)((Object)((Object)pair.getFirst())))), (Object)((Object)data.createLongList(LongStream.of(longs1))));
        });
        return data.set("CarvingMasks", dynamic);
    }

    private static Dynamic<?> a(Dynamic<?> data, String key) {
        List list = data.get(key).orElseEmptyList().asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 24) {
            return data;
        }
        Dynamic dynamic = data.emptyList();
        for (int i2 = 0; i2 < 4; ++i2) {
            list.add(0, dynamic);
            list.add(dynamic);
        }
        return data.set(key, data.createList(list.stream()));
    }

    private static Dynamic<?> b(Dynamic<?> data) {
        return data.update("Heightmaps", dynamic -> {
            for (String string : l) {
                dynamic = dynamic.update(string, ChunkHeightAndBiomeFix::c);
            }
            return dynamic;
        });
    }

    private static Dynamic<?> c(Dynamic<?> dynamic) {
        return dynamic.createLongList(dynamic.asLongStream().map(l2 -> {
            long l1 = 0L;
            int i2 = 0;
            while (i2 + 9 <= 64) {
                long l22 = l2 >> i2 & 0x1FFL;
                long l3 = l22 == 0L ? 0L : Math.min(l22 + 64L, 511L);
                l1 |= l3 << i2;
                i2 += 9;
            }
            return l1;
        }));
    }

    private static Dynamic<?> a(Dynamic<?> data, Int2IntFunction oldBiomeGetter) {
        int i1;
        Int2IntLinkedOpenHashMap map = new Int2IntLinkedOpenHashMap();
        for (int i2 = 0; i2 < 64; ++i2) {
            i1 = oldBiomeGetter.applyAsInt(i2);
            if (map.containsKey(i1)) continue;
            map.put(i1, map.size());
        }
        Dynamic dynamic = data.createList(map.keySet().stream().map(integer -> data.createString((String)s.getOrDefault(integer.intValue(), (Object)c))));
        i1 = ChunkHeightAndBiomeFix.a(map.size());
        if (i1 == 0) {
            return ChunkHeightAndBiomeFix.d(dynamic);
        }
        int i2 = 64 / i1;
        int i3 = (64 + i2 - 1) / i2;
        long[] longs = new long[i3];
        int i4 = 0;
        int i5 = 0;
        for (int i6 = 0; i6 < 64; ++i6) {
            int i7 = oldBiomeGetter.applyAsInt(i6);
            int n2 = i4++;
            longs[n2] = longs[n2] | (long)map.get(i7) << i5;
            if ((i5 += i1) + i1 <= 64) continue;
            i5 = 0;
        }
        Dynamic dynamic1 = data.createLongList(Arrays.stream(longs));
        return ChunkHeightAndBiomeFix.a(dynamic, dynamic1);
    }

    private static Dynamic<?> d(Dynamic<?> palette) {
        return palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("palette")), palette));
    }

    private static Dynamic<?> a(Dynamic<?> palette, Dynamic<?> blockStates) {
        return palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("palette")), palette, (Object)((Object)palette.createString("data")), blockStates));
    }

    private static Dynamic<?> b(Dynamic<?> palette, Dynamic<?> blockStates) {
        List list = palette.asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 1) {
            return ChunkHeightAndBiomeFix.d(palette);
        }
        palette = ChunkHeightAndBiomeFix.a(palette, blockStates, list);
        return ChunkHeightAndBiomeFix.a(palette, blockStates);
    }

    private static Dynamic<?> a(Dynamic<?> palette, Dynamic<?> blockStates, List<Dynamic<?>> paletteEntries) {
        int size;
        int i2;
        long l2 = blockStates.asLongStream().count() * 64L;
        long l1 = l2 / 4096L;
        if (l1 <= (long)(i2 = ChunkHeightAndBiomeFix.a(size = paletteEntries.size()))) {
            return palette;
        }
        Dynamic dynamic = palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("Name")), (Object)((Object)palette.createString("minecraft:air"))));
        int i1 = (1 << (int)(l1 - 1L)) + 1;
        int i22 = i1 - size;
        for (int i3 = 0; i3 < i22; ++i3) {
            paletteEntries.add(dynamic);
        }
        return palette.createList(paletteEntries.stream());
    }

    public static int a(int value) {
        return value == 0 ? 0 : (int)Math.ceil(Math.log(value) / Math.log(2.0));
    }

    private static /* synthetic */ Dynamic a(Set set, Dynamic dynamic1, int i2, Dynamic[] biomeContainers, IntSet set1, MutableObject mutableObject, Dynamic dynamic4) {
        int _int = dynamic4.get("Y").asInt(0);
        Dynamic dynamic5 = (Dynamic)((Object)DataFixUtils.orElse(dynamic4.get("Palette").result().flatMap(dynamic7 -> {
            dynamic7.asStream().map(dynamic8 -> dynamic8.get("Name").asString("minecraft:air")).forEach(set::add);
            return dynamic4.get("BlockStates").result().map(dynamic8 -> ChunkHeightAndBiomeFix.b(dynamic7, dynamic8));
        }), (Object)((Object)dynamic1)));
        Dynamic dynamic6 = dynamic4;
        int i3 = _int - i2;
        if (i3 >= 0 && i3 < biomeContainers.length) {
            dynamic6 = dynamic4.set("biomes", biomeContainers[i3]);
        }
        set1.add(_int);
        if (dynamic4.get("Y").asInt(Integer.MAX_VALUE) == 0) {
            mutableObject.setValue(() -> {
                List list1 = dynamic5.get("palette").asList(Function.identity());
                long[] longs = dynamic5.get("data").asLongStream().toArray();
                return new ChunkProtoTickListFix.a(list1, longs);
            });
        }
        return dynamic6.set("block_states", dynamic5).remove("Palette").remove("BlockStates");
    }

    static {
        s.put(0, (Object)"minecraft:ocean");
        s.put(1, (Object)c);
        s.put(2, (Object)"minecraft:desert");
        s.put(3, (Object)"minecraft:mountains");
        s.put(4, (Object)"minecraft:forest");
        s.put(5, (Object)"minecraft:taiga");
        s.put(6, (Object)"minecraft:swamp");
        s.put(7, (Object)"minecraft:river");
        s.put(8, (Object)"minecraft:nether_wastes");
        s.put(9, (Object)"minecraft:the_end");
        s.put(10, (Object)"minecraft:frozen_ocean");
        s.put(11, (Object)"minecraft:frozen_river");
        s.put(12, (Object)"minecraft:snowy_tundra");
        s.put(13, (Object)"minecraft:snowy_mountains");
        s.put(14, (Object)"minecraft:mushroom_fields");
        s.put(15, (Object)"minecraft:mushroom_field_shore");
        s.put(16, (Object)"minecraft:beach");
        s.put(17, (Object)"minecraft:desert_hills");
        s.put(18, (Object)"minecraft:wooded_hills");
        s.put(19, (Object)"minecraft:taiga_hills");
        s.put(20, (Object)"minecraft:mountain_edge");
        s.put(21, (Object)"minecraft:jungle");
        s.put(22, (Object)"minecraft:jungle_hills");
        s.put(23, (Object)"minecraft:jungle_edge");
        s.put(24, (Object)"minecraft:deep_ocean");
        s.put(25, (Object)"minecraft:stone_shore");
        s.put(26, (Object)"minecraft:snowy_beach");
        s.put(27, (Object)"minecraft:birch_forest");
        s.put(28, (Object)"minecraft:birch_forest_hills");
        s.put(29, (Object)"minecraft:dark_forest");
        s.put(30, (Object)"minecraft:snowy_taiga");
        s.put(31, (Object)"minecraft:snowy_taiga_hills");
        s.put(32, (Object)"minecraft:giant_tree_taiga");
        s.put(33, (Object)"minecraft:giant_tree_taiga_hills");
        s.put(34, (Object)"minecraft:wooded_mountains");
        s.put(35, (Object)"minecraft:savanna");
        s.put(36, (Object)"minecraft:savanna_plateau");
        s.put(37, (Object)"minecraft:badlands");
        s.put(38, (Object)"minecraft:wooded_badlands_plateau");
        s.put(39, (Object)"minecraft:badlands_plateau");
        s.put(40, (Object)"minecraft:small_end_islands");
        s.put(41, (Object)"minecraft:end_midlands");
        s.put(42, (Object)"minecraft:end_highlands");
        s.put(43, (Object)"minecraft:end_barrens");
        s.put(44, (Object)"minecraft:warm_ocean");
        s.put(45, (Object)"minecraft:lukewarm_ocean");
        s.put(46, (Object)"minecraft:cold_ocean");
        s.put(47, (Object)"minecraft:deep_warm_ocean");
        s.put(48, (Object)"minecraft:deep_lukewarm_ocean");
        s.put(49, (Object)"minecraft:deep_cold_ocean");
        s.put(50, (Object)"minecraft:deep_frozen_ocean");
        s.put(127, (Object)"minecraft:the_void");
        s.put(129, (Object)"minecraft:sunflower_plains");
        s.put(130, (Object)"minecraft:desert_lakes");
        s.put(131, (Object)"minecraft:gravelly_mountains");
        s.put(132, (Object)"minecraft:flower_forest");
        s.put(133, (Object)"minecraft:taiga_mountains");
        s.put(134, (Object)"minecraft:swamp_hills");
        s.put(140, (Object)"minecraft:ice_spikes");
        s.put(149, (Object)"minecraft:modified_jungle");
        s.put(151, (Object)"minecraft:modified_jungle_edge");
        s.put(155, (Object)"minecraft:tall_birch_forest");
        s.put(156, (Object)"minecraft:tall_birch_hills");
        s.put(157, (Object)"minecraft:dark_forest_hills");
        s.put(158, (Object)"minecraft:snowy_taiga_mountains");
        s.put(160, (Object)"minecraft:giant_spruce_taiga");
        s.put(161, (Object)"minecraft:giant_spruce_taiga_hills");
        s.put(162, (Object)"minecraft:modified_gravelly_mountains");
        s.put(163, (Object)"minecraft:shattered_savanna");
        s.put(164, (Object)"minecraft:shattered_savanna_plateau");
        s.put(165, (Object)"minecraft:eroded_badlands");
        s.put(166, (Object)"minecraft:modified_wooded_badlands_plateau");
        s.put(167, (Object)"minecraft:modified_badlands_plateau");
        s.put(168, (Object)"minecraft:bamboo_jungle");
        s.put(169, (Object)"minecraft:bamboo_jungle_hills");
        s.put(170, (Object)"minecraft:soul_sand_valley");
        s.put(171, (Object)"minecraft:crimson_forest");
        s.put(172, (Object)"minecraft:warped_forest");
        s.put(173, (Object)"minecraft:basalt_deltas");
        s.put(174, (Object)"minecraft:dripstone_caves");
        s.put(175, (Object)"minecraft:lush_caves");
        s.put(177, (Object)"minecraft:meadow");
        s.put(178, (Object)"minecraft:grove");
        s.put(179, (Object)"minecraft:snowy_slopes");
        s.put(180, (Object)"minecraft:snowcapped_peaks");
        s.put(181, (Object)"minecraft:lofty_peaks");
        s.put(182, (Object)"minecraft:stony_peaks");
    }
}

