/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class BoatSplitFix
extends DataFix {
    public BoatSplitFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    private static boolean a(String id) {
        return id.equals("minecraft:boat");
    }

    private static boolean b(String id) {
        return id.equals("minecraft:chest_boat");
    }

    private static boolean c(String id) {
        return BoatSplitFix.a(id) || BoatSplitFix.b(id);
    }

    private static String d(String variant) {
        return switch (variant) {
            case "spruce" -> "minecraft:spruce_boat";
            case "birch" -> "minecraft:birch_boat";
            case "jungle" -> "minecraft:jungle_boat";
            case "acacia" -> "minecraft:acacia_boat";
            case "cherry" -> "minecraft:cherry_boat";
            case "dark_oak" -> "minecraft:dark_oak_boat";
            case "mangrove" -> "minecraft:mangrove_boat";
            case "bamboo" -> "minecraft:bamboo_raft";
            default -> "minecraft:oak_boat";
        };
    }

    private static String e(String variant) {
        return switch (variant) {
            case "spruce" -> "minecraft:spruce_chest_boat";
            case "birch" -> "minecraft:birch_chest_boat";
            case "jungle" -> "minecraft:jungle_chest_boat";
            case "acacia" -> "minecraft:acacia_chest_boat";
            case "cherry" -> "minecraft:cherry_chest_boat";
            case "dark_oak" -> "minecraft:dark_oak_chest_boat";
            case "mangrove" -> "minecraft:mangrove_chest_boat";
            case "bamboo" -> "minecraft:bamboo_chest_raft";
            default -> "minecraft:oak_chest_boat";
        };
    }

    public TypeRewriteRule makeRule() {
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.a());
        Type type = this.getInputSchema().getType(DataConverterTypes.B);
        Type type1 = this.getOutputSchema().getType(DataConverterTypes.B);
        return this.fixTypeEverywhereTyped("BoatSplitFix", type, type1, typed -> {
            Optional optional = typed.getOptional(opticFinder);
            if (optional.isPresent() && BoatSplitFix.c((String)optional.get())) {
                Dynamic dynamic = (Dynamic)((Object)((Object)typed.getOrCreate(DSL.remainderFinder())));
                Optional optional1 = dynamic.get("Type").asString().result();
                String string = BoatSplitFix.b((String)optional.get()) ? optional1.map(BoatSplitFix::e).orElse("minecraft:oak_chest_boat") : optional1.map(BoatSplitFix::d).orElse("minecraft:oak_boat");
                return ExtraDataFixUtils.a(type1, typed).update(DSL.remainderFinder(), data -> data.remove("Type")).set(opticFinder, (Object)string);
            }
            return ExtraDataFixUtils.a(type1, typed);
        });
    }
}

