/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class BlendingDataFix
extends DataFix {
    private final String a;
    private static final Set<String> b = Set.of("minecraft:empty", "minecraft:structure_starts", "minecraft:structure_references", "minecraft:biomes");

    public BlendingDataFix(Schema outputSchema) {
        super(outputSchema, false);
        this.a = "Blending Data Fix v" + outputSchema.getVersionKey();
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.c);
        return this.fixTypeEverywhereTyped(this.a, type, typed -> typed.update(DSL.remainderFinder(), dynamic -> BlendingDataFix.a(dynamic, dynamic.get("__context"))));
    }

    private static Dynamic<?> a(Dynamic<?> chunkTag, OptionalDynamic<?> context) {
        chunkTag = chunkTag.remove("blending_data");
        boolean flag = "minecraft:overworld".equals(context.get("dimension").asString().result().orElse(""));
        Optional optional = chunkTag.get("Status").result();
        if (flag && optional.isPresent()) {
            Dynamic dynamic;
            String string1;
            String string = DataConverterSchemaNamed.a(((Dynamic)((Object)optional.get())).asString("empty"));
            Optional optional1 = chunkTag.get("below_zero_retrogen").result();
            if (!b.contains(string)) {
                chunkTag = BlendingDataFix.a(chunkTag, 384, -64);
            } else if (optional1.isPresent() && !b.contains(string1 = DataConverterSchemaNamed.a((dynamic = (Dynamic)((Object)optional1.get())).get("target_status").asString("empty")))) {
                chunkTag = BlendingDataFix.a(chunkTag, 256, 0);
            }
        }
        return chunkTag;
    }

    private static Dynamic<?> a(Dynamic<?> chunkTag, int maxY, int minY) {
        return chunkTag.set("blending_data", chunkTag.createMap(Map.of(chunkTag.createString("min_section"), chunkTag.createInt(SectionPosition.a(minY)), chunkTag.createString("max_section"), chunkTag.createInt(SectionPosition.a(minY + maxY)))));
    }
}

