/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.PointFreeRule;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.BitSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;

public class ExtraDataFixUtils {
    public static Dynamic<?> a(Dynamic<?> data) {
        Optional optional = data.get("X").asNumber().result();
        Optional optional1 = data.get("Y").asNumber().result();
        Optional optional2 = data.get("Z").asNumber().result();
        return !optional.isEmpty() && !optional1.isEmpty() && !optional2.isEmpty() ? data.createIntList(IntStream.of(((Number)optional.get()).intValue(), ((Number)optional1.get()).intValue(), ((Number)optional2.get()).intValue())) : data;
    }

    public static <T, R> Typed<R> a(Type<R> type, Typed<T> data) {
        return new Typed(type, data.getOps(), data.getValue());
    }

    public static Type<?> a(Type<?> type, Type<?> oldSubType, Type<?> newSubType) {
        return type.all(ExtraDataFixUtils.a(oldSubType, newSubType), true, false).view().newType();
    }

    private static <A, B> TypeRewriteRule a(Type<A> oldType, Type<B> newType) {
        RewriteResult rewriteResult = RewriteResult.create((View)View.create((String)"Patcher", oldType, newType, dynamicOps -> object -> {
            throw new UnsupportedOperationException();
        }), (BitSet)new BitSet());
        return TypeRewriteRule.everywhere((TypeRewriteRule)TypeRewriteRule.ifSame(oldType, (RewriteResult)rewriteResult), (PointFreeRule)PointFreeRule.nop(), (boolean)true, (boolean)true);
    }

    @SafeVarargs
    public static <T> Function<Typed<?>, Typed<?>> a(Function<Typed<?>, Typed<?>> ... filters) {
        return typed -> {
            for (Function function : filters) {
                typed = (Typed)function.apply(typed);
            }
            return typed;
        };
    }

    public static Dynamic<?> a(String blockId, Map<String, String> properties) {
        Dynamic<NBTTagCompound> dynamic = new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, new NBTTagCompound());
        Dynamic<NBTTagCompound> dynamic1 = dynamic.set("Name", dynamic.createString(blockId));
        if (!properties.isEmpty()) {
            dynamic1 = dynamic1.set("Properties", dynamic.createMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> dynamic.createString((String)entry.getKey()), entry -> dynamic.createString((String)entry.getValue())))));
        }
        return dynamic1;
    }

    public static Dynamic<?> a(String blockId) {
        return ExtraDataFixUtils.a(blockId, Map.of());
    }

    public static Dynamic<?> a(Dynamic<?> data, String fieldName, UnaryOperator<String> fixer) {
        return data.update(fieldName, dynamic -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)dynamic.asString().map((Function)fixer).map(arg_0 -> ((Dynamic)data).createString(arg_0)).result(), (Object)dynamic))));
    }
}

