/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import io.papermc.paper.util.MCUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockStainedGlass;
import net.minecraft.world.level.block.BlockStainedGlassPane;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SpawnUtil {
    public static <T extends EntityInsentient> Optional<T> a(EntityTypes<T> entityType, EntitySpawnReason spawnReason, WorldServer level, BlockPosition pos, int attempts, int range, int yOffset, a strategy, boolean checkCollision) {
        return SpawnUtil.trySpawnMob(entityType, spawnReason, level, pos, attempts, range, yOffset, strategy, checkCollision, CreatureSpawnEvent.SpawnReason.DEFAULT, null);
    }

    public static <T extends EntityInsentient> Optional<T> trySpawnMob(EntityTypes<T> entityType, EntitySpawnReason spawnReason, WorldServer level, BlockPosition pos, int attempts, int range, int yOffset, a strategy, boolean checkCollision, CreatureSpawnEvent.SpawnReason reason, @Nullable Runnable onAbort) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (int i2 = 0; i2 < attempts; ++i2) {
            int i1 = MathHelper.b(level.A, -range, range);
            int i22 = MathHelper.b(level.A, -range, range);
            mutableBlockPos.a(pos, i1, yOffset, i22);
            if (!level.F_().a(mutableBlockPos) || !SpawnUtil.a(level, yOffset, mutableBlockPos, strategy) || checkCollision && !level.b(entityType.a((double)mutableBlockPos.u() + 0.5, mutableBlockPos.v(), (double)mutableBlockPos.w() + 0.5))) continue;
            PreCreatureSpawnEvent event = new PreCreatureSpawnEvent(MCUtil.toLocation(level, pos), CraftEntityType.minecraftToBukkit(entityType), reason);
            if (!event.callEvent()) {
                if (!event.shouldAbortSpawn()) break;
                if (onAbort != null) {
                    onAbort.run();
                }
                return Optional.empty();
            }
            EntityInsentient mob = (EntityInsentient)entityType.b(level, null, mutableBlockPos, spawnReason, false, false);
            if (mob == null) continue;
            if (mob.a((GeneratorAccess)level, spawnReason) && mob.a((IWorldReader)level)) {
                level.addFreshEntityWithPassengers(mob, reason);
                if (mob.dQ()) {
                    return Optional.empty();
                }
                mob.U();
                return Optional.of(mob);
            }
            mob.discard(null);
        }
        return Optional.empty();
    }

    private static boolean a(WorldServer level, int yOffset, BlockPosition.MutableBlockPosition pos, a strategy) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition().g(pos);
        IBlockData blockState = level.a_(mutableBlockPos);
        for (int i2 = yOffset; i2 >= -yOffset; --i2) {
            pos.c(EnumDirection.a);
            mutableBlockPos.a((BaseBlockPosition)pos, EnumDirection.b);
            IBlockData blockState1 = level.a_(pos);
            if (strategy.canSpawnOn(level, pos, blockState1, mutableBlockPos, blockState)) {
                pos.c(EnumDirection.b);
                return true;
            }
            blockState = blockState1;
        }
        return false;
    }

    public static interface a {
        @Deprecated
        public static final a a = (level, targetPos, targetState, attemptedPos, attemptedState) -> !(targetState.a(Blocks.bz) || targetState.a(Blocks.ed) || targetState.a(Blocks.fm) || targetState.b() instanceof BlockStainedGlassPane || targetState.b() instanceof BlockStainedGlass || targetState.b() instanceof BlockLeaves || targetState.a(Blocks.nz) || targetState.a(Blocks.eb) || targetState.a(Blocks.cr) || targetState.a(Blocks.ep) || targetState.a(Blocks.gj) || targetState.a(Blocks.iG) || targetState.a(Blocks.lk) || targetState.a(Blocks.rq) || targetState.a(Blocks.aX) || !attemptedState.l() && !attemptedState.n() || !targetState.e() && !targetState.a(Blocks.rr));
        public static final a b = (level, targetPos, targetState, attemptedPos, attemptedState) -> attemptedState.g(level, attemptedPos).c() && Block.a(targetState.g(level, targetPos), EnumDirection.b);
        public static final a c = (level, targetPos, targetState, attemptedPos, attemptedState) -> attemptedState.g(level, attemptedPos).c() && !targetState.a(TagsBlock.Q) && Block.a(targetState.g(level, targetPos), EnumDirection.b);

        public boolean canSpawnOn(WorldServer var1, BlockPosition var2, IBlockData var3, BlockPosition var4, IBlockData var5);
    }
}

