/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HexFormat;

public record PngInfo(int a, int b) {
    private static final HexFormat c = HexFormat.of().withUpperCase().withPrefix("0x");
    private static final long d = -8552249625308161526L;
    private static final int e = 1229472850;
    private static final int f = 13;

    public static PngInfo a(InputStream stream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(stream);
        long _long = dataInputStream.readLong();
        if (_long != -8552249625308161526L) {
            throw new IOException("Bad PNG Signature: " + c.toHexDigits(_long));
        }
        int _int = dataInputStream.readInt();
        if (_int != 13) {
            throw new IOException("Bad length for IHDR chunk: " + _int);
        }
        int _int1 = dataInputStream.readInt();
        if (_int1 != 1229472850) {
            throw new IOException("Bad type for IHDR chunk: " + c.toHexDigits(_int1));
        }
        int _int2 = dataInputStream.readInt();
        int _int3 = dataInputStream.readInt();
        return new PngInfo(_int2, _int3);
    }

    public static PngInfo a(byte[] bytes) throws IOException {
        return PngInfo.a(new ByteArrayInputStream(bytes));
    }

    public static void a(ByteBuffer buffer) throws IOException {
        ByteOrder byteOrder = buffer.order();
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (buffer.getLong(0) != -8552249625308161526L) {
            throw new IOException("Bad PNG Signature");
        }
        if (buffer.getInt(8) != 13) {
            throw new IOException("Bad length for IHDR chunk!");
        }
        if (buffer.getInt(12) != 1229472850) {
            throw new IOException("Bad type for IHDR chunk!");
        }
        buffer.order(byteOrder);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PngInfo.class, "width;height", "a", "b"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PngInfo.class, "width;height", "a", "b"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PngInfo.class, "width;height", "a", "b"}, this, o2);
    }
}

