/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.util.FormattedStringEmpty;
import net.minecraft.util.StringDecomposer;

@FunctionalInterface
public interface FormattedString {
    public static final FormattedString a = sink -> true;

    public boolean accept(FormattedStringEmpty var1);

    public static FormattedString codepoint(int codePoint, ChatModifier style) {
        return sink -> sink.accept(0, style, codePoint);
    }

    public static FormattedString forward(String text, ChatModifier style) {
        return text.isEmpty() ? a : sink -> StringDecomposer.a(text, style, sink);
    }

    public static FormattedString forward(String text, ChatModifier style, Int2IntFunction codePointMapper) {
        return text.isEmpty() ? a : sink -> StringDecomposer.a(text, style, FormattedString.decorateOutput(sink, codePointMapper));
    }

    public static FormattedString backward(String text, ChatModifier style) {
        return text.isEmpty() ? a : sink -> StringDecomposer.b(text, style, sink);
    }

    public static FormattedString backward(String text, ChatModifier style, Int2IntFunction codePointMapper) {
        return text.isEmpty() ? a : sink -> StringDecomposer.b(text, style, FormattedString.decorateOutput(sink, codePointMapper));
    }

    public static FormattedStringEmpty decorateOutput(FormattedStringEmpty sink, Int2IntFunction codePointMapper) {
        return (index, style, codePoint) -> sink.accept(index, style, (Integer)codePointMapper.apply((Object)codePoint));
    }

    public static FormattedString composite() {
        return a;
    }

    public static FormattedString composite(FormattedString sequence) {
        return sequence;
    }

    public static FormattedString composite(FormattedString first, FormattedString second) {
        return FormattedString.fromPair(first, second);
    }

    public static FormattedString composite(FormattedString ... parts) {
        return FormattedString.fromList((List<FormattedString>)ImmutableList.copyOf((Object[])parts));
    }

    public static FormattedString composite(List<FormattedString> parts) {
        int size = parts.size();
        switch (size) {
            case 0: {
                return a;
            }
            case 1: {
                return parts.get(0);
            }
            case 2: {
                return FormattedString.fromPair(parts.get(0), parts.get(1));
            }
        }
        return FormattedString.fromList((List<FormattedString>)ImmutableList.copyOf(parts));
    }

    public static FormattedString fromPair(FormattedString first, FormattedString second) {
        return sink -> first.accept(sink) && second.accept(sink);
    }

    public static FormattedString fromList(List<FormattedString> parts) {
        return sink -> {
            for (FormattedString formattedCharSequence : parts) {
                if (formattedCharSequence.accept(sink)) continue;
                return false;
            }
            return true;
        };
    }
}

