/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutStatistic;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatisticManager
extends StatisticManager {
    private static final Logger b = LogUtils.getLogger();
    private final MinecraftServer c;
    private final File d;
    private final Set<Statistic<?>> e = Sets.newHashSet();

    public ServerStatisticManager(MinecraftServer server, File file) {
        this.c = server;
        this.d = file;
        if (file.isFile()) {
            try {
                this.a(server.aC(), FileUtils.readFileToString((File)file));
            }
            catch (IOException var4) {
                b.error("Couldn't read statistics file {}", (Object)file, (Object)var4);
            }
            catch (JsonParseException var5) {
                b.error("Couldn't parse statistics file {}", (Object)file, (Object)var5);
            }
        }
        for (Map.Entry<MinecraftKey, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Statistic<MinecraftKey> wrapper = StatisticList.i.b(Objects.requireNonNull(BuiltInRegistries.k.a(entry.getKey())));
            this.a.put(wrapper, entry.getValue().intValue());
        }
    }

    public void a() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.d, (String)this.b());
        }
        catch (IOException var2) {
            b.error("Couldn't save stats", (Throwable)var2);
        }
    }

    @Override
    public void a(EntityHuman player, Statistic<?> stat, int i2) {
        MinecraftKey resourceLocation;
        Object obj;
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        if (stat.a() == StatisticList.i && (obj = stat.b()) instanceof MinecraftKey && SpigotConfig.forcedStats.get(resourceLocation = (MinecraftKey)obj) != null) {
            return;
        }
        super.a(player, stat, i2);
        this.e.add(stat);
    }

    private Set<Statistic<?>> d() {
        HashSet set = Sets.newHashSet(this.e);
        this.e.clear();
        return set;
    }

    public void a(DataFixer fixerUpper, String json) {
        try (JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));){
            jsonReader.setLenient(false);
            JsonElement jsonElement = Streams.parse((JsonReader)jsonReader);
            if (!jsonElement.isJsonNull()) {
                NBTTagCompound compoundTag = ServerStatisticManager.a(jsonElement.getAsJsonObject());
                if (!(compoundTag = DataFixTypes.g.a(fixerUpper, compoundTag, GameProfileSerializer.b(compoundTag, 1343))).b("stats", 10)) {
                    return;
                }
                NBTTagCompound compound = compoundTag.p("stats");
                for (String string : compound.e()) {
                    if (!compound.b(string, 10)) continue;
                    SystemUtils.a(BuiltInRegistries.v.b(MinecraftKey.a(string)), type -> {
                        NBTTagCompound compound1 = compound.p(string);
                        for (String string1 : compound1.e()) {
                            if (compound1.b(string1, 99)) {
                                SystemUtils.a(this.a((StatisticWrapper)type, string1), stat -> this.a.put(stat, compound1.h(string1)), () -> b.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.d, (Object)string1));
                                continue;
                            }
                            b.warn("Invalid statistic value in {}: Don't know what {} is for key {}", new Object[]{this.d, compound1.c(string1), string1});
                        }
                    }, () -> b.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.d, (Object)string));
                }
                return;
            }
            b.error("Unable to parse Stat data from {}", (Object)this.d);
        }
        catch (JsonParseException | IOException var11) {
            b.error("Unable to parse Stat data from {}", (Object)this.d, (Object)var11);
        }
    }

    private <T> Optional<Statistic<T>> a(StatisticWrapper<T> type, String location) {
        return Optional.ofNullable(MinecraftKey.c(location)).flatMap(type.b()::b).map(type::b);
    }

    private static NBTTagCompound a(JsonObject json) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        for (Map.Entry entry : json.entrySet()) {
            JsonPrimitive asJsonPrimitive;
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (jsonElement.isJsonObject()) {
                compoundTag.a((String)entry.getKey(), ServerStatisticManager.a(jsonElement.getAsJsonObject()));
                continue;
            }
            if (!jsonElement.isJsonPrimitive() || !(asJsonPrimitive = jsonElement.getAsJsonPrimitive()).isNumber()) continue;
            compoundTag.a((String)entry.getKey(), asJsonPrimitive.getAsInt());
        }
        return compoundTag;
    }

    protected String b() {
        HashMap map = Maps.newHashMap();
        for (Object entry : this.a.object2IntEntrySet()) {
            Statistic statistic = (Statistic)entry.getKey();
            map.computeIfAbsent(statistic.a(), type -> new JsonObject()).addProperty(ServerStatisticManager.b(statistic).toString(), (Number)entry.getIntValue());
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            jsonObject.add(BuiltInRegistries.v.b((StatisticWrapper)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonObject1 = new JsonObject();
        jsonObject1.add("stats", (JsonElement)jsonObject);
        jsonObject1.addProperty("DataVersion", (Number)SharedConstants.b().d().c());
        return jsonObject1.toString();
    }

    private static <T> MinecraftKey b(Statistic<T> stat) {
        return stat.a().b().b(stat.b());
    }

    public void c() {
        this.e.addAll((Collection<Statistic<?>>)this.a.keySet());
    }

    public void a(EntityPlayer player) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Statistic<?> stat : this.d()) {
            map.put(stat, this.a(stat));
        }
        player.f.b(new PacketPlayOutStatistic((Object2IntMap<Statistic<?>>)map));
    }
}

