/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.slf4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    public static final String b = "recipeBook";
    private static final Logger e = LogUtils.getLogger();
    private final a f;
    @VisibleForTesting
    public final Set<ResourceKey<IRecipe<?>>> c = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<IRecipe<?>>> d = Sets.newIdentityHashSet();

    public RecipeBookServer(a displayResolver) {
        this.f = displayResolver;
    }

    public void a(ResourceKey<IRecipe<?>> recipe) {
        this.c.add(recipe);
    }

    public boolean b(ResourceKey<IRecipe<?>> recipe) {
        return this.c.contains(recipe);
    }

    public void c(ResourceKey<IRecipe<?>> recipe) {
        this.c.remove(recipe);
        this.d.remove(recipe);
    }

    public void d(ResourceKey<IRecipe<?>> recipe) {
        this.d.remove(recipe);
    }

    private void e(ResourceKey<IRecipe<?>> recipe) {
        this.d.add(recipe);
    }

    public int a(Collection<RecipeHolder<?>> recipes, EntityPlayer player) {
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>();
        for (RecipeHolder<?> recipeHolder : recipes) {
            ResourceKey<IRecipe<?>> resourceKey = recipeHolder.a();
            if (this.c.contains(resourceKey) || recipeHolder.b().ap_() || !CraftEventFactory.handlePlayerRecipeListUpdateEvent(player, resourceKey.a())) continue;
            this.a(resourceKey);
            this.e(resourceKey);
            this.f.displaysForRecipe(resourceKey, entry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)entry, recipeHolder.b().i(), true)));
            CriterionTriggers.g.a(player, recipeHolder);
        }
        if (!list.isEmpty() && player.f != null) {
            player.f.b(new ClientboundRecipeBookAddPacket(list, false));
        }
        return list.size();
    }

    public int b(Collection<RecipeHolder<?>> recipes, EntityPlayer player) {
        ArrayList list = Lists.newArrayList();
        for (RecipeHolder<?> recipeHolder : recipes) {
            ResourceKey<IRecipe<?>> resourceKey = recipeHolder.a();
            if (!this.c.contains(resourceKey)) continue;
            this.c(resourceKey);
            this.f.displaysForRecipe(resourceKey, entry -> list.add(entry.a()));
        }
        if (!list.isEmpty() && player.f != null) {
            player.f.b(new ClientboundRecipeBookRemovePacket(list));
        }
        return list.size();
    }

    public NBTTagCompound b() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.a().b(compoundTag);
        NBTTagList listTag = new NBTTagList();
        for (ResourceKey<IRecipe<?>> resourceKey : this.c) {
            listTag.add(NBTTagString.a(resourceKey.a().toString()));
        }
        compoundTag.a("recipes", listTag);
        NBTTagList listTag1 = new NBTTagList();
        for (ResourceKey<IRecipe<?>> resourceKey1 : this.d) {
            listTag1.add(NBTTagString.a(resourceKey1.a().toString()));
        }
        compoundTag.a("toBeDisplayed", listTag1);
        return compoundTag;
    }

    public void a(NBTTagCompound tag, Predicate<ResourceKey<IRecipe<?>>> isRecognized) {
        this.a(RecipeBookSettings.a(tag));
        NBTTagList list = tag.c("recipes", 8);
        this.a(list, this::a, isRecognized);
        NBTTagList list1 = tag.c("toBeDisplayed", 8);
        this.a(list1, this::e, isRecognized);
    }

    private void a(NBTTagList tag, Consumer<ResourceKey<IRecipe<?>>> output, Predicate<ResourceKey<IRecipe<?>>> isRecognized) {
        for (int i2 = 0; i2 < tag.size(); ++i2) {
            String string = tag.j(i2);
            try {
                ResourceKey<IRecipe<?>> resourceKey = ResourceKey.a(Registries.bk, MinecraftKey.a(string));
                if (!isRecognized.test(resourceKey)) {
                    e.error("Tried to load unrecognized recipe: {} removed now.", resourceKey);
                    continue;
                }
                output.accept(resourceKey);
                continue;
            }
            catch (ResourceKeyInvalidException var7) {
                e.error("Tried to load improperly formatted recipe: {} removed now.", (Object)string);
            }
        }
    }

    public void a(EntityPlayer player) {
        player.f.b(new ClientboundRecipeBookSettingsPacket(this.a()));
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>(this.c.size());
        for (ResourceKey<IRecipe<?>> resourceKey : this.c) {
            this.f.displaysForRecipe(resourceKey, entry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)entry, false, this.d.contains(resourceKey))));
        }
        player.f.b(new ClientboundRecipeBookAddPacket(list, true));
    }

    public void a(RecipeBookServer other) {
        this.c.clear();
        this.d.clear();
        this.a.a(other.a);
        this.c.addAll(other.c);
        this.d.addAll(other.d);
    }

    @FunctionalInterface
    public static interface a {
        public void displaysForRecipe(ResourceKey<IRecipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }
}

