/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.SystemUtils;

public interface Counter {
    public static final DecimalFormat a = SystemUtils.a(new DecimalFormat("########0.00"), format -> format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final Counter b = NumberFormat.getIntegerInstance(Locale.US)::format;
    public static final Counter c = decimal -> a.format((double)decimal * 0.1);
    public static final Counter d = distance -> {
        double d2 = (double)distance / 100.0;
        double d1 = d2 / 1000.0;
        if (d1 > 0.5) {
            return a.format(d1) + " km";
        }
        return d2 > 0.5 ? a.format(d2) + " m" : distance + " cm";
    };
    public static final Counter e = time -> {
        double d2 = (double)time / 20.0;
        double d1 = d2 / 60.0;
        double d22 = d1 / 60.0;
        double d3 = d22 / 24.0;
        double d4 = d3 / 365.0;
        if (d4 > 0.5) {
            return a.format(d4) + " y";
        }
        if (d3 > 0.5) {
            return a.format(d3) + " d";
        }
        if (d22 > 0.5) {
            return a.format(d22) + " h";
        }
        return d1 > 0.5 ? a.format(d1) + " min" : d2 + " s";
    };

    public String format(int var1);
}

