/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.destroystokyo.paper.event.server.GS4QueryEvent;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.rcon.RemoteStatusReply;
import net.minecraft.server.rcon.StatusChallengeUtils;
import net.minecraft.server.rcon.thread.RemoteConnectionThread;
import net.minecraft.util.RandomSource;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public class RemoteStatusListener
extends RemoteConnectionThread {
    private static final Logger d = LogUtils.getLogger();
    private static final String e = "SMP";
    private static final String f = "MINECRAFT";
    private static final long g = 30000L;
    private static final long h = 5000L;
    private long i;
    private final int j;
    private final int k;
    private final int l;
    private final String m;
    private final String n;
    private DatagramSocket o;
    private final byte[] p = new byte[1460];
    private String q;
    private String r;
    private final Map<SocketAddress, RemoteStatusChallenge> s;
    private final RemoteStatusReply t;
    private long u;
    private final IMinecraftServer v;

    private RemoteStatusListener(IMinecraftServer serverInterface, int port) {
        super("Query Listener");
        this.v = serverInterface;
        this.j = port;
        this.r = serverInterface.b();
        this.k = serverInterface.d();
        this.m = serverInterface.h();
        this.l = serverInterface.O();
        this.n = serverInterface.j();
        this.u = 0L;
        this.q = "0.0.0.0";
        if (!this.r.isEmpty() && !this.q.equals(this.r)) {
            this.q = this.r;
        } else {
            this.r = "0.0.0.0";
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                this.q = localHost.getHostAddress();
            }
            catch (UnknownHostException var4) {
                d.warn("Unable to determine local host IP, please set server-ip in server.properties", (Throwable)var4);
            }
        }
        this.t = new RemoteStatusReply(1460);
        this.s = Maps.newHashMap();
    }

    @Nullable
    public static RemoteStatusListener a(IMinecraftServer serverInterface) {
        int i2 = serverInterface.a().p;
        if (0 < i2 && 65535 >= i2) {
            RemoteStatusListener queryThreadGs4 = new RemoteStatusListener(serverInterface, i2);
            return !queryThreadGs4.a() ? null : queryThreadGs4;
        }
        d.warn("Invalid query port {} found in server.properties (queries disabled)", (Object)i2);
        return null;
    }

    private void a(byte[] data, DatagramPacket requestPacket) throws IOException {
        this.o.send(new DatagramPacket(data, data.length, requestPacket.getSocketAddress()));
    }

    private boolean a(DatagramPacket requestPacket) throws IOException {
        byte[] data = requestPacket.getData();
        int length = requestPacket.getLength();
        SocketAddress socketAddress = requestPacket.getSocketAddress();
        d.debug("Packet len {} [{}]", (Object)length, (Object)socketAddress);
        if (3 <= length && -2 == data[0] && -3 == data[1]) {
            d.debug("Packet '{}' [{}]", (Object)StatusChallengeUtils.a(data[2]), (Object)socketAddress);
            switch (data[2]) {
                case 0: {
                    if (!this.c(requestPacket).booleanValue()) {
                        d.debug("Invalid challenge [{}]", (Object)socketAddress);
                        return false;
                    }
                    if (15 == length) {
                        this.a(this.b(requestPacket), requestPacket);
                        d.debug("Rules [{}]", (Object)socketAddress);
                    } else {
                        RemoteStatusReply networkDataOutputStream = new RemoteStatusReply(1460);
                        networkDataOutputStream.a(0);
                        networkDataOutputStream.a(this.a(requestPacket.getSocketAddress()));
                        GS4QueryEvent.QueryType queryType = GS4QueryEvent.QueryType.BASIC;
                        GS4QueryEvent.QueryResponse queryResponse = GS4QueryEvent.QueryResponse.builder().motd(this.m).map(this.n).currentPlayers(this.v.N()).maxPlayers(this.l).port(this.k).hostname(this.q).gameVersion(this.v.M()).serverVersion(Bukkit.getServer().getName() + " on " + Bukkit.getServer().getBukkitVersion()).build();
                        GS4QueryEvent queryEvent = new GS4QueryEvent(queryType, requestPacket.getAddress(), queryResponse);
                        queryEvent.callEvent();
                        queryResponse = queryEvent.getResponse();
                        networkDataOutputStream.a(queryResponse.getMotd());
                        networkDataOutputStream.a(e);
                        networkDataOutputStream.a(queryResponse.getMap());
                        networkDataOutputStream.a(Integer.toString(queryResponse.getCurrentPlayers()));
                        networkDataOutputStream.a(Integer.toString(queryResponse.getMaxPlayers()));
                        networkDataOutputStream.a((short)queryResponse.getPort());
                        networkDataOutputStream.a(queryResponse.getHostname());
                        this.a(networkDataOutputStream.a(), requestPacket);
                        d.debug("Status [{}]", (Object)socketAddress);
                    }
                }
                default: {
                    return true;
                }
                case 9: 
            }
            this.d(requestPacket);
            d.debug("Challenge [{}]", (Object)socketAddress);
            return true;
        }
        d.debug("Invalid packet [{}]", (Object)socketAddress);
        return false;
    }

    private byte[] b(DatagramPacket requestPacket) throws IOException {
        String[] playerNames;
        Plugin[] bukkitPlugins;
        long millis = SystemUtils.c();
        if (millis < this.u + 5000L) {
            byte[] bytes = this.t.a();
            byte[] identBytes = this.a(requestPacket.getSocketAddress());
            bytes[1] = identBytes[0];
            bytes[2] = identBytes[1];
            bytes[3] = identBytes[2];
            bytes[4] = identBytes[3];
            return bytes;
        }
        this.u = millis;
        this.t.b();
        this.t.a(0);
        this.t.a(this.a(requestPacket.getSocketAddress()));
        this.t.a("splitnum");
        this.t.a(128);
        this.t.a(0);
        List plugins = Collections.emptyList();
        if (((DedicatedServer)this.v).server.getQueryPlugins() && (bukkitPlugins = Bukkit.getPluginManager().getPlugins()).length > 0) {
            plugins = Stream.of(bukkitPlugins).map(plugin -> GS4QueryEvent.QueryResponse.PluginInformation.of((String)plugin.getName(), (String)plugin.getDescription().getVersion())).collect(Collectors.toList());
        }
        GS4QueryEvent.QueryResponse queryResponse = GS4QueryEvent.QueryResponse.builder().motd(this.m).map(this.n).currentPlayers(this.v.N()).maxPlayers(this.l).port(this.k).hostname(this.q).plugins(plugins).players(this.v.P()).gameVersion(this.v.M()).serverVersion(Bukkit.getServer().getName() + " on " + Bukkit.getServer().getBukkitVersion()).build();
        GS4QueryEvent.QueryType queryType = GS4QueryEvent.QueryType.FULL;
        GS4QueryEvent queryEvent = new GS4QueryEvent(queryType, requestPacket.getAddress(), queryResponse);
        queryEvent.callEvent();
        queryResponse = queryEvent.getResponse();
        this.t.a("hostname");
        this.t.a(queryResponse.getMotd());
        this.t.a("gametype");
        this.t.a(e);
        this.t.a("game_id");
        this.t.a(f);
        this.t.a("version");
        this.t.a(queryResponse.getGameVersion());
        this.t.a("plugins");
        StringBuilder pluginsString = new StringBuilder();
        pluginsString.append(queryResponse.getServerVersion());
        if (!queryResponse.getPlugins().isEmpty()) {
            pluginsString.append(": ");
            Iterator iter = queryResponse.getPlugins().iterator();
            while (iter.hasNext()) {
                GS4QueryEvent.QueryResponse.PluginInformation info = (GS4QueryEvent.QueryResponse.PluginInformation)iter.next();
                pluginsString.append(info.getName());
                if (info.getVersion() != null) {
                    pluginsString.append(' ').append(info.getVersion().replace(";", ","));
                }
                if (!iter.hasNext()) continue;
                pluginsString.append(';').append(' ');
            }
        }
        this.t.a(pluginsString.toString());
        this.t.a("map");
        this.t.a(queryResponse.getMap());
        this.t.a("numplayers");
        this.t.a(Integer.toString(queryResponse.getCurrentPlayers()));
        this.t.a("maxplayers");
        this.t.a(Integer.toString(queryResponse.getMaxPlayers()));
        this.t.a("hostport");
        this.t.a(Integer.toString(queryResponse.getPort()));
        this.t.a("hostip");
        this.t.a(queryResponse.getHostname());
        this.t.a(0);
        this.t.a(1);
        this.t.a("player_");
        this.t.a(0);
        for (String string : playerNames = (String[])queryResponse.getPlayers().toArray(String[]::new)) {
            this.t.a(string);
        }
        this.t.a(0);
        return this.t.a();
    }

    private byte[] a(SocketAddress address) {
        return this.s.get(address).c();
    }

    private Boolean c(DatagramPacket requestPacket) {
        SocketAddress socketAddress = requestPacket.getSocketAddress();
        if (!this.s.containsKey(socketAddress)) {
            return false;
        }
        byte[] data = requestPacket.getData();
        return this.s.get(socketAddress).a() == StatusChallengeUtils.c(data, 7, requestPacket.getLength());
    }

    private void d(DatagramPacket requestPacket) throws IOException {
        RemoteStatusChallenge requestChallenge = new RemoteStatusChallenge(requestPacket);
        this.s.put(requestPacket.getSocketAddress(), requestChallenge);
        this.a(requestChallenge.b(), requestPacket);
    }

    private void d() {
        long millis;
        if (this.a && (millis = SystemUtils.c()) >= this.i + 30000L) {
            this.i = millis;
            this.s.values().removeIf(challenge -> challenge.a(millis));
        }
    }

    @Override
    public void run() {
        d.info("Query running on {}:{}", (Object)this.r, (Object)this.j);
        this.i = SystemUtils.c();
        DatagramPacket datagramPacket = new DatagramPacket(this.p, this.p.length);
        try {
            while (this.a) {
                try {
                    this.o.receive(datagramPacket);
                    this.d();
                    this.a(datagramPacket);
                }
                catch (SocketTimeoutException var8) {
                    this.d();
                }
                catch (PortUnreachableException var8) {
                }
                catch (IOException var10) {
                    this.a(var10);
                }
            }
        }
        finally {
            d.debug("closeSocket: {}:{}", (Object)this.r, (Object)this.j);
            this.o.close();
        }
    }

    @Override
    public boolean a() {
        return this.a || this.e() && super.a();
    }

    private void a(Exception exception) {
        if (this.a) {
            d.warn("Unexpected exception", (Throwable)exception);
            if (!this.e()) {
                d.error("Failed to recover from exception, shutting down!");
                this.a = false;
            }
        }
    }

    private boolean e() {
        try {
            this.o = new DatagramSocket(this.j, InetAddress.getByName(this.r));
            this.o.setSoTimeout(500);
            return true;
        }
        catch (Exception var2) {
            d.warn("Unable to initialise query system on {}:{}", new Object[]{this.r, this.j, var2});
            return false;
        }
    }

    static class RemoteStatusChallenge {
        private final long a = new Date().getTime();
        private final int b;
        private final byte[] c;
        private final byte[] d;
        private final String e;

        public RemoteStatusChallenge(DatagramPacket datagramPacket) {
            byte[] data = datagramPacket.getData();
            this.c = new byte[4];
            this.c[0] = data[3];
            this.c[1] = data[4];
            this.c[2] = data[5];
            this.c[3] = data[6];
            this.e = new String(this.c, StandardCharsets.UTF_8);
            this.b = RandomSource.a().a(0x1000000);
            this.d = String.format(Locale.ROOT, "\t%s%d\u0000", this.e, this.b).getBytes(StandardCharsets.UTF_8);
        }

        public Boolean a(long currentTime) {
            return this.a < currentTime;
        }

        public int a() {
            return this.b;
        }

        public byte[] b() {
            return this.d;
        }

        public byte[] c() {
            return this.c;
        }

        public String d() {
            return this.e;
        }
    }
}

