/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.console.TerminalConsoleCommandSender;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public abstract class PlayerList {
    public static final File a = new File("banned-players.json");
    public static final File b = new File("banned-ips.json");
    public static final File c = new File("ops.json");
    public static final File d = new File("whitelist.json");
    public static final IChatBaseComponent e = IChatBaseComponent.c("chat.filtered_full");
    public static final IChatBaseComponent f = IChatBaseComponent.c("multiplayer.disconnect.duplicate_login");
    private static final Logger h = LogUtils.getLogger();
    private static final int i = 600;
    private static final SimpleDateFormat j = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer k;
    public final List<EntityPlayer> l = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> m = Maps.newHashMap();
    private final GameProfileBanList n = new GameProfileBanList(a);
    private final IpBanList o = new IpBanList(b);
    private final OpList p = new OpList(c);
    private final WhiteList q = new WhiteList(d);
    public final WorldNBTStorage t;
    private boolean u;
    private final LayeredRegistryAccess<RegistryLayer> v;
    public int g;
    private int w;
    private int x;
    private boolean y;
    private static final boolean z = false;
    private int A;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();
    @Nullable
    public String collideRuleTeamName;

    public PlayerList(MinecraftServer server, LayeredRegistryAccess<RegistryLayer> registries, WorldNBTStorage playerIo, int maxPlayers) {
        this.cserver = server.server = new CraftServer((DedicatedServer)server, this);
        server.console = new TerminalConsoleCommandSender();
        this.k = server;
        this.v = registries;
        this.g = maxPlayers;
        this.t = playerIo;
    }

    public abstract void loadAndSaveFiles();

    public void a(NetworkManager connection, EntityPlayer player, CommonListenerCookie cookie) {
        WorldServer serverLevel;
        WorldServer level;
        boolean[] invalidPlayerWorld;
        ResourceKey<net.minecraft.world.level.World> resourceKey;
        String string;
        Optional<Object> optional;
        block24: {
            World bWorld;
            block26: {
                block25: {
                    NBTTagCompound nbttagcompound;
                    player.isRealPlayer = true;
                    player.loginTime = System.currentTimeMillis();
                    GameProfile gameProfile = player.gh();
                    UserCache profileCache = this.k.at();
                    if (profileCache != null) {
                        optional = profileCache.a(gameProfile.getId());
                        string = optional.map(GameProfile::getName).orElse(gameProfile.getName());
                        profileCache.a(gameProfile);
                    } else {
                        string = gameProfile.getName();
                    }
                    optional = this.a(player);
                    if (optional.isPresent() && (nbttagcompound = (NBTTagCompound)optional.get()).e("bukkit")) {
                        NBTTagCompound bukkit = nbttagcompound.p("bukkit");
                        string = bukkit.b("lastKnownName", 8) ? bukkit.l("lastKnownName") : string;
                    }
                    resourceKey = null;
                    invalidPlayerWorld = new boolean[]{false};
                    if (!optional.isPresent()) break block24;
                    if (!((NBTTagCompound)optional.get()).e("WorldUUIDMost") || !((NBTTagCompound)optional.get()).e("WorldUUIDLeast")) break block25;
                    bWorld = Bukkit.getServer().getWorld(new UUID(((NBTTagCompound)optional.get()).i("WorldUUIDMost"), ((NBTTagCompound)optional.get()).i("WorldUUIDLeast")));
                    break block26;
                }
                if (!((NBTTagCompound)optional.get()).b("world", 8)) break block24;
                bWorld = Bukkit.getServer().getWorld(((NBTTagCompound)optional.get()).l("world"));
            }
            if (bWorld != null) {
                resourceKey = ((CraftWorld)bWorld).getHandle().ai();
            } else {
                resourceKey = net.minecraft.world.level.World.i;
                invalidPlayerWorld[0] = true;
            }
        }
        if (resourceKey == null) {
            resourceKey = optional.flatMap(compoundTag -> {
                DataResult<ResourceKey<net.minecraft.world.level.World>> dataResult = DimensionManager.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, compoundTag.c("Dimension")));
                Optional result = dataResult.resultOrPartial(arg_0 -> ((Logger)h).error(arg_0));
                invalidPlayerWorld[0] = result.isEmpty();
                return result;
            }).orElse(net.minecraft.world.level.World.i);
        }
        if ((level = this.k.a(resourceKey)) == null) {
            h.warn("Unknown respawn dimension {}, defaulting to overworld", resourceKey);
            serverLevel = this.k.J();
            invalidPlayerWorld[0] = true;
        } else {
            serverLevel = level;
        }
        if (optional.isEmpty()) {
            player.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
        }
        if (optional.isEmpty() || invalidPlayerWorld[0]) {
            player.b(player.a(serverLevel, serverLevel.Z()).c(), serverLevel.aa(), 0.0f);
        }
        player.a(serverLevel);
        String loggableAddress = connection.a(this.k.bl());
        CraftPlayer spawnPlayer = player.getBukkitEntity();
        PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)spawnPlayer, spawnPlayer.getLocation());
        this.cserver.getPluginManager().callEvent((Event)ev);
        Location loc = ev.getSpawnLocation();
        serverLevel = ((CraftWorld)loc.getWorld()).getHandle();
        player.spawnIn(serverLevel);
        player.o(loc.getX(), loc.getY(), loc.getZ());
        player.b(loc.getYaw(), loc.getPitch());
        WorldData levelData = serverLevel.D_();
        player.c((NBTTagCompound)optional.orElse(null));
        PlayerConnection serverGamePacketListenerImpl = new PlayerConnection(this.k, connection, player, cookie);
        connection.a(GameProtocols.a.a(RegistryFriendlyByteBuf.a(this.k.ba())), serverGamePacketListenerImpl);
        GameRules gameRules = serverLevel.O();
        boolean _boolean = gameRules.b(GameRules.E);
        boolean _boolean1 = gameRules.b(GameRules.q);
        boolean _boolean2 = gameRules.b(GameRules.x);
        serverGamePacketListenerImpl.b(new PacketPlayOutLogin(player.ar(), levelData.l(), this.k.K(), this.n(), serverLevel.spigotConfig.viewDistance, serverLevel.spigotConfig.simulationDistance, _boolean1, !_boolean, _boolean2, player.b(serverLevel), this.k.aA()));
        player.getBukkitEntity().sendSupportedChannels();
        serverGamePacketListenerImpl.b(new PacketPlayOutServerDifficulty(levelData.q(), levelData.r()));
        serverGamePacketListenerImpl.b(new PacketPlayOutAbilities(player.gj()));
        serverGamePacketListenerImpl.b(new PacketPlayOutHeldItemSlot(player.gi().j));
        CraftingManager recipeManager = this.k.aI();
        serverGamePacketListenerImpl.b(new PacketPlayOutRecipeUpdate(recipeManager.b(), recipeManager.d()));
        this.e(player);
        player.I().c();
        player.J().a(player);
        this.a(serverLevel.g(), player);
        this.k.av();
        IChatMutableComponent mutableComponent = player.gh().getName().equalsIgnoreCase(string) ? IChatBaseComponent.a("multiplayer.player.joined", player.p_()) : IChatBaseComponent.a("multiplayer.player.joined.renamed", player.p_(), string);
        mutableComponent.a(EnumChatFormat.o);
        IChatBaseComponent joinMessage = mutableComponent;
        serverGamePacketListenerImpl.a(player.dA(), player.dC(), player.dG(), player.dL(), player.dN());
        ServerPing status = this.k.au();
        if (status != null && !cookie.d()) {
            player.a(status);
        }
        this.l.add(player);
        this.playersByName.put(player.cI().toLowerCase(Locale.ROOT), player);
        this.m.put(player.cG(), player);
        player.supressTrackerForLogin = true;
        serverLevel.a(player);
        this.k.aM().a(player);
        player.b(optional);
        player.a(optional);
        CraftPlayer bukkitPlayer = player.getBukkitEntity();
        player.cd.transferTo(player.cd, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, PaperAdventure.asAdventure(mutableComponent));
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!player.f.c()) {
            return;
        }
        Component jm = playerJoinEvent.joinMessage();
        if (jm != null && !jm.equals((Object)Component.empty())) {
            joinMessage = PaperAdventure.asVanilla(jm);
            this.k.ag().a(joinMessage, false);
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(List.of(player));
        ArrayList onlinePlayers = Lists.newArrayListWithExpectedSize((int)(this.l.size() - 1));
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer1 = this.l.get(i2);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                if (entityplayer1.getBukkitEntity().isListed(bukkitPlayer)) {
                    entityplayer1.f.b(packet);
                } else {
                    entityplayer1.f.b(ClientboundPlayerInfoUpdatePacket.createSinglePlayerInitializing(player, false));
                }
            }
            if (entityplayer1 == player || !bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            onlinePlayers.add(entityplayer1);
        }
        if (!onlinePlayers.isEmpty()) {
            player.f.b(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(onlinePlayers, player));
        }
        player.sentListPacket = true;
        player.supressTrackerForLogin = false;
        ((WorldServer)player.dV()).m().a.a((Entity)player);
        this.a(player, serverLevel);
        if (player.dV() == serverLevel && !serverLevel.z().contains(player)) {
            serverLevel.a(player);
            this.k.aM().a(player);
        }
        serverLevel = player.y();
        this.d(player);
        player.d();
        ScoreboardServer scoreboard = this.c().a(net.minecraft.world.level.World.i).g();
        ScoreboardTeam collideRuleTeam = scoreboard.b(this.collideRuleTeamName);
        if (this.collideRuleTeamName != null && collideRuleTeam != null && player.cr() == null) {
            ((Scoreboard)scoreboard).a(player.cI(), collideRuleTeam);
        }
        h.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{player.al().getString(), loggableAddress, player.ar(), serverLevel.L.e(), player.dA(), player.dC(), player.dG()});
        if (player.eE()) {
            Holder.c plains = serverLevel.K_().e(Registries.aI).b(Biomes.b);
            player.f.b(new ClientboundLevelChunkWithLightPacket(new ChunkEmpty((net.minecraft.world.level.World)serverLevel, player.dx(), plains), serverLevel.C_(), null, null, true));
        }
    }

    public void a(ScoreboardServer scoreboard, EntityPlayer player) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam playerTeam : scoreboard.g()) {
            player.f.b(PacketPlayOutScoreboardTeam.a(playerTeam, true));
        }
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            ScoreboardObjective displayObjective = scoreboard.a(displaySlot);
            if (displayObjective == null || set.contains(displayObjective)) continue;
            for (Packet<?> packet : scoreboard.d(displayObjective)) {
                player.f.b(packet);
            }
            set.add(displayObjective);
        }
    }

    public void a(WorldServer level) {
        if (this.t != null) {
            return;
        }
        level.F_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder border, double size) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double oldSize, double newSize, long time) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double x2, double z2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderCenterPacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, int warningTime) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, int warningBlocks) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(WorldBorder border, double damageSafeZone) {
            }
        });
    }

    public Optional<NBTTagCompound> a(EntityPlayer player) {
        Optional<NBTTagCompound> optional;
        NBTTagCompound loadedPlayerTag = this.k.aZ().w();
        if (this.k.a(player.gh()) && loadedPlayerTag != null) {
            optional = Optional.of(loadedPlayerTag);
            player.g(loadedPlayerTag);
            h.debug("loading single player");
        } else {
            optional = this.t.b(player);
        }
        return optional;
    }

    protected void b(EntityPlayer player) {
        AdvancementDataPlayer playerAdvancements;
        if (!player.getBukkitEntity().isPersistent()) {
            return;
        }
        player.lastSave = MinecraftServer.currentTick;
        this.t.a(player);
        ServerStatisticManager serverStatsCounter = player.I();
        if (serverStatsCounter != null) {
            serverStatsCounter.a();
        }
        if ((playerAdvancements = player.S()) != null) {
            playerAdvancements.b();
        }
    }

    public Component remove(EntityPlayer player) {
        return this.remove(player, (Component)Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? player.getBukkitEntity().displayName() : PaperAdventure.asAdventure(player.p_())}));
    }

    public Component remove(EntityPlayer player, Component leaveMessage) {
        Object rootVehicle;
        WorldServer serverLevel = player.y();
        player.a(StatisticList.j);
        if (player.cd != player.cc) {
            player.closeContainer(InventoryCloseEvent.Reason.DISCONNECT);
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)player.getBukkitEntity(), leaveMessage, player.quitReason);
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        player.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        if (this.k.bx()) {
            player.i();
        }
        if (this.collideRuleTeamName != null) {
            ScoreboardServer scoreBoard = this.k.a(net.minecraft.world.level.World.i).g();
            ScoreboardTeam team = scoreBoard.e(this.collideRuleTeamName);
            if (player.cr() == team && team != null) {
                ((Scoreboard)scoreBoard).b(player.cI(), team);
            }
        }
        if (!player.cd.g().f()) {
            ItemStack carried = player.cd.g();
            player.cd.b(ItemStack.j);
            player.a(carried, false);
        }
        this.b(player);
        if (player.bZ() && ((Entity)(rootVehicle = player.df())).de()) {
            h.debug("Removing player mount");
            player.ae();
            ((Entity)rootVehicle).db().forEach(entity -> {
                EntityVillagerAbstract villager;
                EntityHuman human;
                if (entity instanceof EntityVillagerAbstract && (human = (villager = (EntityVillagerAbstract)entity).gs()) != null) {
                    villager.a((EntityHuman)null);
                }
                entity.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT);
            });
        }
        player.ao();
        for (EntityEnderPearl thrownEnderpearl : player.ak()) {
            if (!thrownEnderpearl.dV().paperConfig().misc.legacyEnderPearlBehavior) {
                thrownEnderpearl.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT);
                continue;
            }
            thrownEnderpearl.b = null;
        }
        serverLevel.a(player, Entity.RemovalReason.d);
        player.retireScheduler();
        player.S().a();
        this.l.remove(player);
        this.playersByName.remove(player.cI().toLowerCase(Locale.ROOT));
        this.k.aM().b(player);
        UUID uuid = player.cG();
        EntityPlayer serverPlayer = this.m.get(uuid);
        if (serverPlayer == player) {
            this.m.remove(uuid);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(player.cG()));
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer otherPlayer = this.l.get(i2);
            if (otherPlayer.getBukkitEntity().canSee(player.getBukkitEntity())) {
                otherPlayer.f.b(packet);
                continue;
            }
            otherPlayer.getBukkitEntity().onEntityRemove(player);
        }
        this.cserver.getScoreboardManager().removePlayer(player.getBukkitEntity());
        return playerQuitEvent.quitMessage();
    }

    public EntityPlayer canPlayerLogin(LoginListener loginlistener, GameProfile gameProfile) {
        GameProfileBanEntry userBanListEntry;
        UUID uuid = gameProfile.getId();
        ArrayList list = Lists.newArrayList();
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer = this.l.get(i2);
            if (!entityplayer.cG().equals(uuid) && (!GlobalConfiguration.get().proxies.isProxyOnlineMode() || !entityplayer.gh().getName().equalsIgnoreCase(gameProfile.getName()))) continue;
            list.add(entityplayer);
        }
        for (EntityPlayer entityplayer : list) {
            this.b(entityplayer);
            entityplayer.f.disconnect(IChatBaseComponent.c("multiplayer.disconnect.duplicate_login"), PlayerKickEvent.Cause.DUPLICATE_LOGIN);
        }
        SocketAddress socketAddress = loginlistener.g.d();
        EntityPlayer entity = new EntityPlayer(this.k, this.k.a(net.minecraft.world.level.World.i), gameProfile, ClientInformation.a());
        entity.transferCookieConnection = loginlistener;
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)player, loginlistener.g.hostname, ((InetSocketAddress)socketAddress).getAddress(), ((InetSocketAddress)loginlistener.g.n.remoteAddress()).getAddress());
        if (this.n.a(gameProfile) && (userBanListEntry = (GameProfileBanEntry)this.n.b(gameProfile)) != null) {
            IChatMutableComponent mutableComponent = IChatBaseComponent.a("multiplayer.disconnect.banned.reason", new Object[]{userBanListEntry.d()});
            if (userBanListEntry.c() != null) {
                mutableComponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned.expiration", new Object[]{j.format(userBanListEntry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(mutableComponent));
        } else if (this.isWhiteListed(gameProfile, event)) {
            if (this.o.a(socketAddress) && this.g().b(socketAddress) != null && !this.g().b(socketAddress).f()) {
                IpBanEntry ipBanListEntry = this.o.b(socketAddress);
                IChatMutableComponent mutableComponent = IChatBaseComponent.a("multiplayer.disconnect.banned_ip.reason", new Object[]{ipBanListEntry.d()});
                if (ipBanListEntry.c() != null) {
                    mutableComponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned_ip.expiration", new Object[]{j.format(ipBanListEntry.c())}));
                }
                event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(mutableComponent));
            } else if (this.l.size() >= this.g && !this.d(gameProfile)) {
                event.disallow(PlayerLoginEvent.Result.KICK_FULL, (Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.serverFullMessage));
            }
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.a(PaperAdventure.asVanilla(event.kickMessage()));
            return null;
        }
        return entity;
    }

    public EntityPlayer getPlayerForLogin(GameProfile gameProfile, ClientInformation clientInformation, EntityPlayer player) {
        player.a(clientInformation);
        return player;
    }

    public boolean disconnectAllPlayersWithProfile(GameProfile gameProfile, EntityPlayer player) {
        return player == null;
    }

    public EntityPlayer respawn(EntityPlayer player, boolean keepInventory, Entity.RemovalReason reason, PlayerRespawnEvent.RespawnReason eventReason) {
        return this.respawn(player, keepInventory, reason, eventReason, null);
    }

    public EntityPlayer respawn(EntityPlayer player, boolean keepInventory, Entity.RemovalReason reason, PlayerRespawnEvent.RespawnReason eventReason, Location location) {
        TeleportTransition teleportTransition;
        player.ae();
        this.l.remove(player);
        this.playersByName.remove(player.cI().toLowerCase(Locale.ROOT));
        player.y().a(player, reason);
        EntityPlayer serverPlayer = player;
        net.minecraft.world.level.World fromWorld = player.dV();
        player.k = false;
        serverPlayer.f = player.f;
        serverPlayer.a(player, keepInventory);
        serverPlayer.e(player.ar());
        serverPlayer.b(player.fy());
        for (String string : player.as()) {
            serverPlayer.a(string);
        }
        boolean isBedSpawn = false;
        boolean isRespawn = false;
        if (location == null) {
            teleportTransition = player.findRespawnPositionAndUseSpawnBlock(!keepInventory, TeleportTransition.a, eventReason);
            if (!keepInventory) {
                player.reset();
            }
            if (teleportTransition == null) {
                return player;
            }
            isRespawn = true;
            location = CraftLocation.toBukkit(teleportTransition.c(), (World)teleportTransition.b().getWorld(), teleportTransition.e(), teleportTransition.f());
        } else {
            teleportTransition = new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), Vec3D.c, location.getYaw(), location.getPitch(), TeleportTransition.a);
        }
        if (teleportTransition == null) {
            return player;
        }
        WorldServer level = teleportTransition.b();
        serverPlayer.spawnIn(level);
        serverPlayer.dS();
        serverPlayer.g(false);
        Vec3D vec3 = teleportTransition.c();
        serverPlayer.forceSetPositionRotation(vec3.d, vec3.e, vec3.f, teleportTransition.e(), teleportTransition.f());
        level.m().a(TicketType.POST_TELEPORT, new ChunkCoordIntPair(MathHelper.a(vec3.a()) >> 4, MathHelper.a(vec3.c()) >> 4), 1, player.ar());
        if (teleportTransition.g()) {
            serverPlayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
            serverPlayer.setRespawnPosition(null, null, 0.0f, false, false, PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN);
        }
        byte b2 = (byte)(keepInventory ? 1 : 0);
        WorldServer serverLevel = serverPlayer.y();
        WorldData levelData = serverLevel.D_();
        serverPlayer.f.b(new PacketPlayOutRespawn(serverPlayer.b(serverLevel), b2));
        serverPlayer.f.b(new PacketPlayOutViewDistance(serverLevel.spigotConfig.viewDistance));
        serverPlayer.f.b(new ClientboundSetSimulationDistancePacket(serverLevel.spigotConfig.simulationDistance));
        serverPlayer.f.teleport(CraftLocation.toBukkit(serverPlayer.dt(), (World)serverLevel.getWorld(), serverPlayer.dL(), serverPlayer.dN()));
        serverPlayer.f.b(new PacketPlayOutSpawnPosition(level.Z(), level.aa()));
        serverPlayer.f.b(new PacketPlayOutServerDifficulty(levelData.q(), levelData.r()));
        serverPlayer.f.b(new PacketPlayOutExperience(serverPlayer.ct, serverPlayer.cs, serverPlayer.cr));
        this.d(serverPlayer);
        this.a(serverPlayer, level);
        this.e(serverPlayer);
        if (!serverPlayer.f.isDisconnected()) {
            level.b(serverPlayer);
            this.l.add(serverPlayer);
            this.playersByName.put(serverPlayer.cI().toLowerCase(Locale.ROOT), serverPlayer);
            this.m.put(serverPlayer.cG(), serverPlayer);
        }
        serverPlayer.x(serverPlayer.eD());
        BlockPosition respawnPosition = serverPlayer.T();
        WorldServer level1 = this.k.a(serverPlayer.V());
        if (!keepInventory && respawnPosition != null && level1 != null) {
            IBlockData blockState = level1.a_(respawnPosition);
            if (blockState.a(Blocks.pN)) {
                serverPlayer.f.b(new PacketPlayOutNamedSoundEffect(SoundEffects.vY, SoundCategory.e, respawnPosition.u(), respawnPosition.v(), respawnPosition.w(), 1.0f, 1.0f, level.H_().g()));
            }
            if (blockState.a(TagsBlock.T) && !teleportTransition.g()) {
                isBedSpawn = true;
            }
        }
        this.f(player);
        player.x();
        for (MobEffect mobEffect : player.eA()) {
            player.f.b(new PacketPlayOutEntityEffect(player.ar(), mobEffect, false));
        }
        player.g(level);
        if (fromWorld != level) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)player.getBukkitEntity(), (World)fromWorld.getWorld());
            this.k.server.getPluginManager().callEvent((Event)event);
        }
        if (player.f.isDisconnected()) {
            this.b(player);
        }
        if (isRespawn) {
            this.cserver.getPluginManager().callEvent((Event)new PlayerPostRespawnEvent((Player)player.getBukkitEntity(), location, isBedSpawn));
        }
        return serverPlayer;
    }

    public void d(EntityPlayer player) {
        this.a((EntityLiving)player, player.f);
    }

    public void a(EntityLiving entity, PlayerConnection connection) {
        this.sendActiveEffects(entity, connection::b);
    }

    public void sendActiveEffects(EntityLiving entity, Consumer<Packet<? super PacketListenerPlayOut>> packetConsumer) {
        for (MobEffect mobEffectInstance : entity.eA()) {
            packetConsumer.accept(new PacketPlayOutEntityEffect(entity.ar(), mobEffectInstance, false));
        }
    }

    public void e(EntityPlayer player) {
        this.sendPlayerPermissionLevel(player, true);
    }

    public void sendPlayerPermissionLevel(EntityPlayer player, boolean recalculatePermissions) {
        GameProfile gameProfile = player.gh();
        int profilePermissions = this.k.c(gameProfile);
        this.sendPlayerPermissionLevel(player, profilePermissions, recalculatePermissions);
    }

    public void d() {
        if (++this.A > 600) {
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                EntityPlayer target = this.l.get(i2);
                target.f.b(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.e), Collections2.filter(this.l, t2 -> target.getBukkitEntity().canSee(t2.getBukkitEntity()))));
            }
            this.A = 0;
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer = this.l.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.l.get((int)i2).f.b(packet);
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        for (int i2 = 0; i2 < world.z().size(); ++i2) {
            ((EntityPlayer)world.z().get((int)i2)).f.b(packet);
        }
    }

    public void a(Packet<?> packet) {
        for (EntityPlayer serverPlayer : this.l) {
            serverPlayer.f.b(packet);
        }
    }

    public void a(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> dimension) {
        for (EntityPlayer serverPlayer : this.l) {
            if (serverPlayer.dV().ai() != dimension) continue;
            serverPlayer.f.b(packet);
        }
    }

    public void a(EntityHuman player, IChatBaseComponent message) {
        ScoreboardTeam team = player.cr();
        if (team != null) {
            for (String string : ((ScoreboardTeamBase)team).g()) {
                EntityPlayer playerByName = this.a(string);
                if (playerByName == null || playerByName == player) continue;
                playerByName.a(message);
            }
        }
    }

    public void b(EntityHuman player, IChatBaseComponent message) {
        ScoreboardTeam team = player.cr();
        if (team == null) {
            this.a(message, false);
        } else {
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                EntityPlayer serverPlayer = this.l.get(i2);
                if (serverPlayer.cr() == team) continue;
                serverPlayer.a(message);
            }
        }
    }

    public String[] e() {
        String[] strings = new String[this.l.size()];
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            strings[i2] = this.l.get(i2).gh().getName();
        }
        return strings;
    }

    public GameProfileBanList f() {
        return this.n;
    }

    public IpBanList g() {
        return this.o;
    }

    public void a(GameProfile profile) {
        this.p.a(new OpListEntry(profile, this.k.k(), this.p.a(profile)));
        EntityPlayer player = this.a(profile.getId());
        if (player != null) {
            this.e(player);
        }
    }

    public void b(GameProfile profile) {
        this.p.c(profile);
        EntityPlayer player = this.a(profile.getId());
        if (player != null) {
            this.e(player);
        }
    }

    private void a(EntityPlayer player, int permLevel) {
        this.sendPlayerPermissionLevel(player, permLevel, true);
    }

    public void sendPlayerPermissionLevel(EntityPlayer player, int permLevel, boolean recalculatePermissions) {
        if (player.f != null) {
            byte b2 = permLevel <= 0 ? (byte)24 : (permLevel >= 4 ? (byte)28 : (byte)((byte)(24 + permLevel)));
            player.f.b(new PacketPlayOutEntityStatus(player, b2));
        }
        if (recalculatePermissions) {
            player.getBukkitEntity().recalculatePermissions();
            this.k.aG().a(player);
        }
    }

    public boolean c(GameProfile profile) {
        return this.isWhiteListed(profile, null);
    }

    public boolean isWhiteListed(GameProfile gameprofile, @Nullable PlayerLoginEvent loginEvent) {
        boolean isOp = this.p.d(gameprofile);
        boolean isWhitelisted = !this.u || isOp || this.q.d(gameprofile);
        TextComponent configuredMessage = LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.whitelistMessage);
        ProfileWhitelistVerifyEvent event = new ProfileWhitelistVerifyEvent(CraftPlayerProfile.asBukkitMirror(gameprofile), this.u, isWhitelisted, isOp, (Component)configuredMessage);
        event.callEvent();
        if (!event.isWhitelisted()) {
            if (loginEvent != null) {
                loginEvent.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, (Component)(event.kickMessage() == null ? configuredMessage : event.kickMessage()));
            }
            return false;
        }
        return true;
    }

    public boolean f(GameProfile profile) {
        return this.p.d(profile) || this.k.a(profile) && this.k.aZ().m() || this.y;
    }

    @Nullable
    public EntityPlayer a(String username) {
        return this.playersByName.get(username.toLowerCase(Locale.ROOT));
    }

    public void a(@Nullable EntityHuman except, double x2, double y2, double z2, double radius, ResourceKey<net.minecraft.world.level.World> dimension, Packet<?> packet) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            double d2;
            double d1;
            double d3;
            EntityPlayer serverPlayer = this.l.get(i2);
            if (except != null && !serverPlayer.getBukkitEntity().canSee(except.getBukkitEntity()) || serverPlayer == except || serverPlayer.dV().ai() != dimension || !((d3 = x2 - serverPlayer.dA()) * d3 + (d1 = y2 - serverPlayer.dC()) * d1 + (d2 = z2 - serverPlayer.dG()) * d2 < radius * radius)) continue;
            serverPlayer.f.b(packet);
        }
    }

    public void h() {
        this.saveAll(-1);
    }

    public void saveAll(int interval) {
        MCUtil.ensureMain("Save Players", () -> {
            int numSaved = 0;
            long now = MinecraftServer.currentTick;
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                EntityPlayer player = this.l.get(i2);
                if (interval != -1 && now - player.lastSave < (long)interval) continue;
                this.b(player);
                if (interval != -1 && ++numSaved >= GlobalConfiguration.get().playerAutoSave.maxPerTick()) break;
            }
            return null;
        });
    }

    public WhiteList i() {
        return this.q;
    }

    public String[] j() {
        return this.q.a();
    }

    public OpList k() {
        return this.p;
    }

    public String[] l() {
        return this.p.a();
    }

    public void a() {
    }

    public void a(EntityPlayer player, WorldServer level) {
        WorldBorder worldBorder = player.dV().F_();
        player.f.b(new ClientboundInitializeBorderPacket(worldBorder));
        player.f.b(new PacketPlayOutUpdateTime(level.ad(), level.ae(), level.O().b(GameRules.l)));
        player.f.b(new PacketPlayOutSpawnPosition(level.Z(), level.aa()));
        if (level.ag()) {
            player.setPlayerWeather(WeatherType.DOWNFALL, false);
            player.updateWeather(-level.x, level.x, -level.z, level.z);
        }
        player.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.o, 0.0f));
        this.k.aP().a(player);
    }

    public void f(EntityPlayer player) {
        player.cc.b();
        player.getBukkitEntity().updateScaledHealth();
        player.refreshEntityData(player);
        player.f.b(new PacketPlayOutHeldItemSlot(player.gi().j));
        int i2 = player.y().O().b(GameRules.q) ? 22 : 23;
        player.f.b(new PacketPlayOutEntityStatus(player, (byte)i2));
        float immediateRespawn = player.y().O().b(GameRules.E) ? 1.0f : 0.0f;
        player.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.m, immediateRespawn));
    }

    public int m() {
        return this.l.size();
    }

    public int n() {
        return this.g;
    }

    public boolean o() {
        return this.u;
    }

    public void a(boolean whitelistEnabled) {
        new WhitelistToggleEvent(whitelistEnabled).callEvent();
        this.u = whitelistEnabled;
    }

    public List<EntityPlayer> b(String address) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer serverPlayer : this.l) {
            if (!serverPlayer.B().equals(address)) continue;
            list.add(serverPlayer);
        }
        return list;
    }

    public int p() {
        return this.w;
    }

    public int q() {
        return this.x;
    }

    public MinecraftServer c() {
        return this.k;
    }

    @Nullable
    public NBTTagCompound r() {
        return null;
    }

    public void b(boolean allowCommandsForAllPlayers) {
        this.y = allowCommandsForAllPlayers;
    }

    public void s() {
        this.removeAll(false);
    }

    public void removeAll(boolean isRestarting) {
        ScoreboardServer scoreboard;
        ScoreboardTeam team;
        for (EntityPlayer player : this.l) {
            if (isRestarting) {
                player.f.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.restartMessage), PlayerKickEvent.Cause.UNKNOWN);
                continue;
            }
            player.f.disconnect(Objects.requireNonNullElseGet(this.k.server.shutdownMessage(), Component::empty));
        }
        if (this.collideRuleTeamName != null && (team = (scoreboard = this.c().a(net.minecraft.world.level.World.i).g()).e(this.collideRuleTeamName)) != null) {
            scoreboard.d(team);
        }
    }

    public void broadcastMessage(IChatBaseComponent[] iChatBaseComponents) {
        for (IChatBaseComponent component : iChatBaseComponents) {
            this.a(component, false);
        }
    }

    public void a(IChatBaseComponent message, boolean bypassHiddenChat) {
        this.a(message, (EntityPlayer serverPlayer) -> message, bypassHiddenChat);
    }

    public void a(IChatBaseComponent serverMessage, Function<EntityPlayer, IChatBaseComponent> playerMessageFactory, boolean bypassHiddenChat) {
        this.k.a(serverMessage);
        for (EntityPlayer serverPlayer : this.l) {
            IChatBaseComponent component = playerMessageFactory.apply(serverPlayer);
            if (component == null) continue;
            serverPlayer.b(component, bypassHiddenChat);
        }
    }

    public void a(PlayerChatMessage message, CommandListenerWrapper sender, ChatMessageType.a boundChatType) {
        this.a(message, sender::a, sender.i(), boundChatType);
    }

    public void a(PlayerChatMessage message, EntityPlayer sender, ChatMessageType.a boundChatType) {
        this.broadcastChatMessage(message, sender, boundChatType, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, EntityPlayer sender, ChatMessageType.a boundChatType, @Nullable Function<Audience, IChatBaseComponent> unsignedFunction) {
        this.broadcastChatMessage(message, sender::c, sender, boundChatType, unsignedFunction);
    }

    private void a(PlayerChatMessage message, Predicate<EntityPlayer> shouldFilterMessageTo, @Nullable EntityPlayer sender, ChatMessageType.a boundChatType) {
        this.broadcastChatMessage(message, shouldFilterMessageTo, sender, boundChatType, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, Predicate<EntityPlayer> shouldFilterMessageTo, @Nullable EntityPlayer sender, ChatMessageType.a boundChatType, @Nullable Function<Audience, IChatBaseComponent> unsignedFunction) {
        boolean flag = this.a(message);
        this.k.a(unsignedFunction == null ? message.d() : unsignedFunction.apply((Audience)this.k.console), boundChatType, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.a(message);
        boolean flag1 = false;
        ClientboundDisguisedChatPacket disguised = sender != null && unsignedFunction == null ? new ClientboundDisguisedChatPacket(outgoingChatMessage.a(), boundChatType) : null;
        for (EntityPlayer serverPlayer : this.l) {
            boolean flag2 = shouldFilterMessageTo.test(serverPlayer);
            if (sender != null && !serverPlayer.getBukkitEntity().canSee(sender.getBukkitEntity())) {
                serverPlayer.f.b(unsignedFunction != null ? new ClientboundDisguisedChatPacket(unsignedFunction.apply((Audience)serverPlayer.getBukkitEntity()), boundChatType) : disguised);
                continue;
            }
            serverPlayer.sendChatMessage(outgoingChatMessage, flag2, boundChatType, unsignedFunction == null ? null : unsignedFunction.apply((Audience)serverPlayer.getBukkitEntity()));
            flag1 |= flag2 && message.j();
        }
        if (flag1 && sender != null) {
            sender.a(e);
        }
    }

    public boolean a(PlayerChatMessage message) {
        return message.i() && !message.a(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer player) {
        ServerStatisticManager serverstatisticmanager = player.I();
        return serverstatisticmanager == null ? this.getPlayerStats(player.cG(), player.gh().getName()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverStatsCounter;
        EntityPlayer player = this.a(uuid);
        ServerStatisticManager serverStatisticManager = serverStatsCounter = player == null ? null : player.I();
        if (serverStatsCounter == null) {
            File file2;
            Path path;
            File file = this.k.a(SavedFile.b).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtils.a(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtils.b(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverStatsCounter = new ServerStatisticManager(this.k, file1);
        }
        return serverStatsCounter;
    }

    public AdvancementDataPlayer g(EntityPlayer player) {
        UUID uuid = player.cG();
        AdvancementDataPlayer playerAdvancements = player.S();
        if (playerAdvancements == null) {
            Path path = this.k.a(SavedFile.a).resolve(String.valueOf(uuid) + ".json");
            playerAdvancements = new AdvancementDataPlayer(this.k.aC(), this, this.k.aD(), path, player);
        }
        playerAdvancements.a(player);
        return playerAdvancements;
    }

    public void a(int viewDistance) {
        this.w = viewDistance;
        for (WorldServer serverLevel : this.k.L()) {
            if (serverLevel == null) continue;
            serverLevel.m().a(viewDistance);
        }
    }

    public void b(int simulationDistance) {
        this.x = simulationDistance;
        for (WorldServer serverLevel : this.k.L()) {
            if (serverLevel == null) continue;
            serverLevel.m().b(simulationDistance);
        }
    }

    public List<EntityPlayer> t() {
        return this.l;
    }

    @Nullable
    public EntityPlayer a(UUID playerUUID) {
        return this.m.get(playerUUID);
    }

    public boolean d(GameProfile profile) {
        return false;
    }

    public void u() {
        this.reloadAdvancementData();
        this.reloadTagData();
        this.reloadRecipes();
    }

    public void reloadAdvancementData() {
        for (EntityPlayer player : this.l) {
            player.S().a(this.k.aD());
            player.S().b(player);
        }
    }

    public void reloadTagData() {
        this.a(new ClientboundUpdateTagsPacket(TagNetworkSerialization.a(this.v)));
    }

    public void reloadRecipes() {
        CraftingManager recipeManager = this.k.aI();
        PacketPlayOutRecipeUpdate clientboundUpdateRecipesPacket = new PacketPlayOutRecipeUpdate(recipeManager.b(), recipeManager.d());
        for (EntityPlayer serverPlayer : this.l) {
            serverPlayer.f.b(clientboundUpdateRecipesPacket);
            serverPlayer.J().a(serverPlayer);
        }
    }

    public boolean v() {
        return this.y;
    }
}

