/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;

@FunctionalInterface
public interface ResourceProvider {
    public static final ResourceProvider b = location -> Optional.empty();

    public Optional<IResource> getResource(MinecraftKey var1);

    default public IResource getResourceOrThrow(MinecraftKey location) throws FileNotFoundException {
        return this.getResource(location).orElseThrow(() -> new FileNotFoundException(location.toString()));
    }

    default public InputStream open(MinecraftKey location) throws IOException {
        return this.getResourceOrThrow(location).d();
    }

    default public BufferedReader openAsReader(MinecraftKey location) throws IOException {
        return this.getResourceOrThrow(location).e();
    }

    public static ResourceProvider fromMap(Map<MinecraftKey, IResource> resources) {
        return location -> Optional.ofNullable((IResource)resources.get(location));
    }
}

