/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import org.slf4j.Logger;

public class ReloadableProfiled
extends Reloadable<a> {
    private static final Logger c = LogUtils.getLogger();
    private final Stopwatch d = Stopwatch.createUnstarted();

    public ReloadableProfiled(IResourceManager resourceManager, List<IReloadListener> listeners, Executor backgroundExecutor, Executor gameExecutor, CompletableFuture<Unit> alsoWaitedFor) {
        super(backgroundExecutor, gameExecutor, resourceManager, listeners, (barrier, manager, preparableReloadListener, executor, executor1) -> {
            AtomicLong atomicLong = new AtomicLong();
            AtomicLong atomicLong1 = new AtomicLong();
            CompletableFuture<Void> completableFuture = preparableReloadListener.a(barrier, manager, ReloadableProfiled.a(executor, atomicLong, preparableReloadListener.c()), ReloadableProfiled.a(executor1, atomicLong1, preparableReloadListener.c()));
            return completableFuture.thenApplyAsync(_void -> {
                c.debug("Finished reloading {}", (Object)preparableReloadListener.c());
                return new a(preparableReloadListener.c(), atomicLong, atomicLong1);
            }, gameExecutor);
        }, alsoWaitedFor);
        this.d.start();
        this.b = this.b.thenApplyAsync(this::a, gameExecutor);
    }

    private static Executor a(Executor executor, AtomicLong timeTaken, String name) {
        return runnable -> executor.execute(() -> {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a(name);
            long nanos = SystemUtils.d();
            runnable.run();
            timeTaken.addAndGet(SystemUtils.d() - nanos);
            profilerFiller.c();
        });
    }

    private List<a> a(List<a> datapoints) {
        this.d.stop();
        long l2 = 0L;
        c.info("Resource reload finished after {} ms", (Object)this.d.elapsed(TimeUnit.MILLISECONDS));
        for (a state : datapoints) {
            long l1 = TimeUnit.NANOSECONDS.toMillis(state.b.get());
            long l22 = TimeUnit.NANOSECONDS.toMillis(state.c.get());
            long l3 = l1 + l22;
            String string = state.a;
            c.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", new Object[]{string, l3, l1, l22});
            l2 += l22;
        }
        c.info("Total blocking time: {} ms", (Object)l2);
        return datapoints;
    }

    public record a(String a, AtomicLong b, AtomicLong c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;preparationNanos;reloadNanos", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;preparationNanos;reloadNanos", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;preparationNanos;reloadNanos", "a", "b", "c"}, this, o2);
        }
    }
}

